/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivesdk4cloud;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import com.yy.yylivesdk4cloud.helper.ThunderLog;

public class ThunderDeviceInfo {
    public String osVersion = "Android-" + Build.VERSION.SDK_INT;
    public String manufacturer = Build.MANUFACTURER;
    public String model = Build.MODEL;
    public String deviceID = "";
    public String appInfo;
    public long imsi = 0L;

    private String getAppName(Context context) {
        try {
            ApplicationInfo info = context.getApplicationInfo();
            return context.getResources().getString(info.labelRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "null";
        }
    }

    private String getAppVersion(Context context) {
        try {
            PackageManager manager = context.getPackageManager();
            PackageInfo packageInfo = manager.getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionName;
        }
        catch (Exception e) {
            String msg = e == null ? "null" : e.getMessage();
            ThunderLog.warn("ysdk-Java", "read app version exception %s", msg);
            return "null";
        }
    }

    private static boolean isDebug(Context context) {
        ApplicationInfo info = context.getApplicationInfo();
        return info != null && (info.flags & 2) != 0;
    }

    @SuppressLint(value={"HardwareIds"})
    ThunderDeviceInfo(Context context) {
        this.appInfo = this.getAppName(context);
        this.appInfo = this.appInfo + "-" + this.getAppVersion(context);
        if (ThunderDeviceInfo.isDebug(context)) {
            this.appInfo = this.appInfo + "-Debug";
        }
        ThunderLog.release("ysdk-Java", "Device info: %s %s %s, %s, %d, %s", this.manufacturer, this.model, this.osVersion, this.deviceID, this.imsi, this.appInfo);
    }
}

