/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivesdk4cloud;

import com.yy.yylivesdk4cloud.helper.ThunderLog;
import com.yy.yylivesdk4cloud.helper.ThunderNative;

public class ThunderAudioFilePlayer
implements Comparable<ThunderAudioFilePlayer> {
    private IThunderAudioFilePlayerCallback mCallback = null;
    private long nativeCtx = ThunderNative.createAudioFilePlayer(this);
    private boolean mIsDestroy = false;
    private final int PLAY_EVENT_END = 1;
    private final int FILE_PLAY_VOLUME = 2;

    public synchronized void setPlayerNotify(IThunderAudioFilePlayerCallback callback) {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer setPlayerNotify");
        if (this.mIsDestroy) {
            return;
        }
        this.mCallback = callback;
    }

    public synchronized void enableVolumeIndication(boolean enable, int interval) {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer enableVolumeNotify enable = %b, interval=%d ", enable, interval);
        if (this.mIsDestroy) {
            return;
        }
        if (interval <= 0) {
            interval = 200;
        }
        ThunderNative.enableAudioFileVolumeCallback(this.nativeCtx, enable, interval);
    }

    public boolean open(String path) {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer open path = %s", path);
        if (this.mIsDestroy) {
            return false;
        }
        int ret = (int)ThunderNative.audioFileOpen(this.nativeCtx, path);
        return ret == 1;
    }

    public void close() {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer close");
        if (this.mIsDestroy) {
            return;
        }
        ThunderNative.audioFileClose(this.nativeCtx);
    }

    public void play() {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer play");
        if (this.mIsDestroy) {
            return;
        }
        ThunderNative.audioFilePlay(this.nativeCtx);
    }

    public void stop() {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer stop");
        if (this.mIsDestroy) {
            return;
        }
        ThunderNative.audioFileStop(this.nativeCtx);
    }

    public void pause() {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer pause");
        if (this.mIsDestroy) {
            return;
        }
        ThunderNative.audioFilePause(this.nativeCtx);
    }

    public void resume() {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer resume");
        if (this.mIsDestroy) {
            return;
        }
        ThunderNative.audioFileResume(this.nativeCtx);
    }

    public void seek(long timeMS) {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer seek timems = %d ", timeMS);
        if (this.mIsDestroy) {
            return;
        }
        ThunderNative.audioFileSeek(this.nativeCtx, timeMS);
    }

    public long getTotalPlayTimeMS() {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer getTotalPlayTimeMS ");
        if (this.mIsDestroy) {
            return 0L;
        }
        return ThunderNative.audioFileGetTotalTime(this.nativeCtx);
    }

    public long getCurrentPlayTimeMS() {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer getCurrentPlayTimeMS ");
        if (this.mIsDestroy) {
            return 0L;
        }
        return ThunderNative.audioFileGetCurrentPlayTime(this.nativeCtx);
    }

    public void setPlayVolume(int volume) {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer setPlayVolume volume = %d", volume);
        if (this.mIsDestroy) {
            return;
        }
        if (volume < 0) {
            volume = 0;
        } else if (volume > 100) {
            volume = 100;
        }
        ThunderNative.audioFileSetPlayVolume(this.nativeCtx, volume);
    }

    public void setSemitone(int val) {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer setSemitone val = %d", val);
        if (this.mIsDestroy) {
            return;
        }
        float tone = val;
        ThunderNative.audioFileSetSemitone(this.nativeCtx, tone);
    }

    public void enablePublish(boolean enable) {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer enablePublish: enable=%b", enable);
        if (this.mIsDestroy) {
            return;
        }
        ThunderNative.audioFileEnablePublish(this.nativeCtx, enable);
    }

    public void setKaraokeCompensateValue(int value) {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer setKaraokeCompensateValue value = %d ", value);
        ThunderNative.audioFileSetCompensateValue(this.nativeCtx, value);
    }

    public void onPlayEvent(int event) {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer onPlayEvent event = %d", event);
        if (this.mIsDestroy) {
            return;
        }
        if (this.mCallback == null) {
            return;
        }
        switch (event) {
            case 1: {
                this.mCallback.onAudioFilePlayEnd();
            }
        }
    }

    public synchronized void onAudioFileVolume(long volume, long currentMs, long totalMs) {
        if (this.mIsDestroy) {
            return;
        }
        if (this.mCallback == null) {
            return;
        }
        this.mCallback.onAudioFileVolume(volume, currentMs, totalMs);
    }

    void destroyAudioFilePlayer() {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer destroyAudioFilePlayer");
        this.setPlayerNotify(null);
        ThunderNative.destroyAudioFilePlayer(this.nativeCtx);
        this.mIsDestroy = true;
        this.nativeCtx = 0L;
    }

    protected void finalize() {
        this.destroyAudioFilePlayer();
    }

    @Override
    public int compareTo(ThunderAudioFilePlayer audioFilePlayer) {
        if (audioFilePlayer == null) {
            throw new NullPointerException();
        }
        if (this == audioFilePlayer) {
            return 0;
        }
        return 1;
    }

    public static interface IThunderAudioFilePlayerCallback {
        public void onAudioFilePlayEnd();

        public void onAudioFileVolume(long var1, long var3, long var5);
    }
}

