/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivesdk4cloud;

import com.yy.yylivesdk4cloud.ThunderCustomVideoSource;
import com.yy.yylivesdk4cloud.ThunderPublisher;
import com.yy.yylivesdk4cloud.ThunderVideoCapture;
import com.yy.yylivesdk4cloud.ThunderVideoCaptureConfig;
import com.yy.yylivesdk4cloud.ThunderVideoFrameConsumer;
import com.yy.yylivesdk4cloud.helper.ThunderLog;

public class ExternalVideoSource
extends ThunderVideoCapture {
    ThunderCustomVideoSource mVideoSource = null;
    ThunderPublisher.IVideoPublisher mPublisher = null;

    public ExternalVideoSource(ThunderCustomVideoSource videoSource) {
        this.mVideoSource = videoSource;
    }

    @Override
    public void startCapture(ThunderPublisher.IVideoPublisher proxy) {
        this.mPublisher = proxy;
        if (this.mVideoSource != null) {
            this.mVideoSource.onInitialize(new ThunderVideoFrameConsumer(){

                @Override
                public void consumeByteArrayFrame(byte[] data, int format, int width, int height, int rotation, long timestamp) {
                    if (ExternalVideoSource.this.mPublisher != null) {
                        ExternalVideoSource.this.mPublisher.pushVideoData(data, format, width, height, rotation, timestamp);
                    }
                }
            });
            this.mVideoSource.onStart();
        } else {
            ThunderLog.info("yrtc", "warning,  need set videoSource...");
        }
    }

    @Override
    public void stopCapture() {
        if (this.mVideoSource != null) {
            this.mVideoSource.onStop();
            this.mVideoSource.onDispose();
        } else {
            ThunderLog.info("yrtc", "warning,  need set videoSource...");
        }
    }

    @Override
    public ThunderVideoCaptureConfig getCaptureConfig() {
        return null;
    }
}

