package com.yy.yylivesdk4cloud.video.serviceConfig;

import com.yy.yylivesdk4cloud.ThunderRtcConstant;
import com.yy.yylivesdk4cloud.helper.ThunderLog;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

public class TranscodingConfigManager {

    private final static String TAG = "cfg_transcodingCfgMgr";
    private final static String TRANSCODING_MODE = "thunderBolt_transcoding_mode";
    private final static String JSONARRAY_NAME = "transcoding";
    private final static String MODE_NAME = "id";
    private final static String CFG_DESCRIPTION = "desc";

    private Map<Integer, String> mMode2CfgDesc = new HashMap<>();

    private String mode = null;
    private String config = null;

    public final static String[] ARGO_CONFIG_KEYS = {
            TRANSCODING_MODE
    };

    private static class SingletonHolder{
        private static final TranscodingConfigManager INSTANCE = new TranscodingConfigManager();
    }

    public static TranscodingConfigManager instance() {
        return SingletonHolder.INSTANCE;
    }

    public TranscodingConfigManager() {
        makeDefaultTranscodingCfg();
    }


    public void onConfig(String key, String config) {
        if (key == null || config == null) {
            return;
        }
        if (key.equals(TRANSCODING_MODE)) {
            parseTranscodingCfg(config);
        }
    }

    public String getTranscodingCfgByMode(int mode) {
        return mMode2CfgDesc.get(mode);
    }


    private void parseTranscodingCfg(final String config) {
        try {
            JSONObject jsonObject = new JSONObject(config);
            JSONArray jsonArray = jsonObject.getJSONArray(JSONARRAY_NAME);
            mMode2CfgDesc = getTranscodingMode2Cfg(jsonArray);
        } catch (Exception e) {
            ThunderLog.error(TAG, " parseTranscodingCfg error :" + e.toString());
        }
    }

    private HashMap<Integer, String> getTranscodingMode2Cfg(JSONArray jsonArray) {
        JSONObject item;
        StringBuffer sb = new StringBuffer();
        HashMap<Integer, String> mode2Cfg = new HashMap<>();
        try {
            for (int i = 0; i < jsonArray.length(); ++ i) {
                item = jsonArray.getJSONObject(i);
                int mode = item.optInt(MODE_NAME);
                String cfgDesc = item.optJSONObject(CFG_DESCRIPTION).toString();
                mode2Cfg.put(mode, cfgDesc);
                sb.append("mode: " + String.valueOf(mode) + ", ");
                sb.append(" Cfg: " + cfgDesc + "; ");
            }
            ThunderLog.info(TAG, "getTranscodingMode2Cfg from argo size " + mode2Cfg.size() + ": " + sb.toString());
        } catch (Exception e) {
            ThunderLog.error(TAG, " parseTranscodingCfg error :" + e.toString());
        }

        return mode2Cfg;
    }

    private void makeDefaultTranscodingCfg() {

        String desc_180p = "{\"video\":{\"encode\":100,\"bitrate\":150,\"fps\":15,\"gop\":30,\"height\":180,\"width\":320},\"audio\":{\"encode\":1,\"bitrate\":128,\"sample\":44100,\"channel\":2}}";
        String desc_240p = "{\"video\":{\"encode\":100,\"bitrate\":200,\"fps\":15,\"gop\":30,\"height\":240,\"width\":320},\"audio\":{\"encode\":1,\"bitrate\":128,\"sample\":44100,\"channel\":2}}";
        String desc_360p = "{\"video\":{\"encode\":100,\"bitrate\":500,\"fps\":15,\"gop\":30,\"height\":360,\"width\":640},\"audio\":{\"encode\":1,\"bitrate\":128,\"sample\":44100,\"channel\":2}}";
        String desc_480p = "{\"video\":{\"encode\":100,\"bitrate\":500,\"fps\":15,\"gop\":30,\"height\":480,\"width\":640},\"audio\":{\"encode\":1,\"bitrate\":128,\"sample\":44100,\"channel\":2}}";
        String desc_540p = "{\"video\":{\"encode\":100,\"bitrate\":1000,\"fps\":24,\"gop\":48,\"height\":544,\"width\":960},\"audio\":{\"encode\":1,\"bitrate\":128,\"sample\":44100,\"channel\":2}}";
        String desc_720p = "{\"video\":{\"encode\":100,\"bitrate\":1600,\"fps\":24,\"gop\":48,\"height\":720,\"width\":1280},\"audio\":{\"encode\":1,\"bitrate\":128,\"sample\":44100,\"channel\":2}}";
        String desc_1080p = "{\"video\":{\"encode\":100,\"bitrate\":4500,\"fps\":24,\"gop\":48,\"height\":1080,\"width\":1920},\"audio\":{\"encode\":1,\"bitrate\":128,\"sample\":44100,\"channel\":2}}";


        mMode2CfgDesc.put(ThunderRtcConstant.LiveTranscodingMode.TRANSCODING_MODE_320X180, desc_180p);
        mMode2CfgDesc.put(ThunderRtcConstant.LiveTranscodingMode.TRANSCODING_MODE_320X240, desc_240p);
        mMode2CfgDesc.put(ThunderRtcConstant.LiveTranscodingMode.TRANSCODING_MODE_640X360, desc_360p);
        mMode2CfgDesc.put(ThunderRtcConstant.LiveTranscodingMode.TRANSCODING_MODE_640X480, desc_480p);
        mMode2CfgDesc.put(ThunderRtcConstant.LiveTranscodingMode.TRANSCODING_MODE_960X544, desc_540p);
        mMode2CfgDesc.put(ThunderRtcConstant.LiveTranscodingMode.TRANSCODING_MODE_1280X720, desc_720p);
        mMode2CfgDesc.put(ThunderRtcConstant.LiveTranscodingMode.TRANSCODING_MODE_1920X1080, desc_1080p);
    }
}
