package com.yy.yylivesdk4cloud.video;

import android.hardware.Camera;

import com.yy.mediaframework.facedetection.PreviewFrameCallback;
import com.yy.yylivesdk4cloud.ThunderBridgeLib;

import java.util.HashMap;

/*
 * camera yuv（NV21）数据回调给业务
 */

public class VideoFrameYuvCapture implements PreviewFrameCallback {

    private int mWidth = 0;
    private int mHeight = 0;
    private IVideoCaptureObserver mVideoCaptureFrameObserver = null;
    private static volatile VideoFrameYuvCapture instance;
    private static Object syncLock = new Object();

    public static VideoFrameYuvCapture getInstance() {
        if (instance == null) {
            synchronized (syncLock) {
                if (instance == null) {
                    instance = new VideoFrameYuvCapture();
                }
            }
        }
        return instance;
    }

    private VideoFrameYuvCapture() {
    }

    public void updateVideoCaptureFrameInfo(int width, int height) {
        mWidth = width;
        mHeight = height;
    }

    public void enableVideoCapture(IVideoCaptureObserver observer) {
        if (observer != null) {
            mVideoCaptureFrameObserver = observer;
            ThunderBridgeLib.getInstance().addPreviewFrameCallback(this);
        } else {
            ThunderBridgeLib.getInstance().removePreviewFrameCallback(this);
            mVideoCaptureFrameObserver = null;
        }
    }

    @Override
    public void onPreviewFrameAvailable(byte[] data, Camera camera) {

        if (mVideoCaptureFrameObserver == null) {
            return;
        }
        mVideoCaptureFrameObserver.onCaptureVideoFrame(mWidth, mHeight, data, data.length);
    }
}
