package com.yy.yylivesdk4cloud.video;

import android.content.Context;

import com.yy.videoplayer.IVideoLibInfoExt;
import com.yy.videoplayer.render.VideoRenderNotify;
import com.yy.videoplayer.videoview.IVideoInfoCallback;

import java.util.ArrayList;
import java.util.Map;

/**
 * Created by xiaojun on 2018/1/5.
 * Copyright (c) 2017 YY Inc. All rights reserved.
 */

public class ThunderVideoPlayListener implements IVideoLibInfoExt, IVideoInfoCallback {
	private Context mAppContext = null;
	private ThunderVideoEngineImp mVideoEngine = null;

	public ThunderVideoPlayListener(Context appContext, ThunderVideoEngineImp videoEngine) {
		mAppContext = appContext;
		mVideoEngine = videoEngine;
	}

	@Override
	public long getUid() {
		return 0;
	}

	@Override
	public long getTopSid() {
		return 0;
	}

	@Override
	public long getSubSid() {
		return 0;
	}

	@Override
	public String getPackageName() {
		return mAppContext.getPackageName();
	}

	@Override
	public boolean isLibraryLoaded() {
		return true;
	}

	@Override
	public int getConfig(int configKey) {
		return 0;
	}

	@Override
	public void setConfigs(int appId, Map<Integer, Integer> configs) {
	}

	@Override
	public void notifyHardwareCodecConfigured(boolean h264DecodeOn,
											  boolean h264EncodeOn,
											  boolean h265DecodeOn,
											  boolean h265EncodeOn) {
	}

	@Override
	public void onCoefficientOfVariationOfRenderInterval(long userGroupId,
														 long streamId,
														 long intervalMilliTs,
														 double coef) {
	}

	@Override
	public void onViewPlayEventNotify(long userGroupId,
									  long streamId,
									  int eventType,
									  long happenTime) {
	}

	@Override
	public void onVideoRenderNotify(final ArrayList<VideoRenderNotify> notifys) {

		mVideoEngine.onVideoRenderNotify(notifys);

	}

	@Override
	public void onFirstFrameRenderNotify(long userGroupId,
										 long streamId,
										 long currentSystemMilliSecond,
										 long firstFrameToRenderInMilliSec,
										 int eatenFrames) {
		mVideoEngine.onFirstFrameRenderNotify(userGroupId,streamId,currentSystemMilliSecond,firstFrameToRenderInMilliSec,eatenFrames);
	}
	@Override
	public void onUpdatePts(long streamId, long pts) {

	}
	@Override
	public void onUpdateVideoSizeChanged(long streamId, int width, int height) {
		mVideoEngine.onUpdateVideoSizeChanged(streamId,width,height);
	}


	@Override
	public void onFirstFrameSeeNotify(long var1, long var3, long var5) {
	}

	@Override
	public Context HWCodecConfigGetmCtx() {
		return mAppContext;
	}

	@Override
	public void HWCodecConfigSetRunTimeStamp(String key, long ts) {
	}

	@Override
	public boolean HWCodecConfigGetIsRooted() {
		return ThunderVideoConfig.isRooted();
	}

	@Override
	public void onHardwareDecodeErrorNotify(long userGroupId, long streamId, int errorType) {
		mVideoEngine.onHardwareDecodeErrorNotify(userGroupId, streamId, errorType);
	}

	@Override
	public void onHardwareDecodeWrongFrameNotify(long streamId, String name, byte[] header, byte[] data) {

	}

	@Override
	public void onDecodedFrameData(long uid, int w, int h, byte[] data,int dateLen, long renderTimeMs) {
		mVideoEngine.onDecodedFrameData(uid, w, h, data, dateLen, renderTimeMs);
	}
}