package com.yy.yylivesdk4cloud.system;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.Application;
import android.app.KeyguardManager;
import android.content.Context;
import android.os.Bundle;

import com.yy.yylivesdk4cloud.helper.ThunderLog;
import com.yy.yylivesdk4cloud.helper.ThunderNative;

import java.util.List;

/**
 * Created by xiaojun on 2018/1/12.
 * Copyright (c) 2017 YY Inc. All rights reserved.
 */

public class ThunderForeBackgroundListener implements Application.ActivityLifecycleCallbacks {

	private Context mContext;
	private boolean mIsAppOnBackground = false;

	public ThunderForeBackgroundListener(Context context) {
		this.mContext = context;
	}

	public void init() {
		((Application)mContext).registerActivityLifecycleCallbacks(this);
	}

	public void fini() {
		((Application)mContext).unregisterActivityLifecycleCallbacks(this);
	}

	private boolean isBackgroundRunning(Activity activity) {
		try {
			String processName = activity.getPackageName();
			ActivityManager activityManager = (ActivityManager) activity.getSystemService(Activity.ACTIVITY_SERVICE);
			KeyguardManager keyguardManager = (KeyguardManager) activity.getSystemService(Activity.KEYGUARD_SERVICE);

			if (activityManager == null || keyguardManager == null) {
				return false;
			}

			List<ActivityManager.RunningAppProcessInfo> processList = activityManager.getRunningAppProcesses();
			if (processList == null) {
				return false;
			}

			for (ActivityManager.RunningAppProcessInfo process : processList) {
				if (process.processName.equalsIgnoreCase(processName)) {
					boolean isBackground = false;
					if (process.importance != ActivityManager.RunningAppProcessInfo.IMPORTANCE_FOREGROUND
							&& process.importance != ActivityManager.RunningAppProcessInfo.IMPORTANCE_VISIBLE) {
						isBackground = true;
					}

					return isBackground;
				}
			}
		} catch (Exception e) {
			String msg = (e == null) ? "null" : e.getMessage();
			ThunderLog.error(ThunderLog.kLogTagSdk, "isBackgroundRunning error:%s", msg);
		}
		return false;
	}

	public void onActivityCreated(Activity activity, Bundle savedInstanceState) {

	}

	public void onActivityStarted(Activity activity) {
		tryEnterForeground(activity);
		ThunderLog.info(ThunderLog.kLogTagSdk, "%s APP started",
				activity.toString());
	}

	public void onActivityResumed(Activity activity) {
		tryEnterForeground(activity);
		ThunderLog.info(ThunderLog.kLogTagSdk, "%s APP resumed",
				activity.toString());
	}

	public void onActivityPaused(Activity activity) {

	}

	public void onActivityStopped(Activity activity) {
		tryEnterBackground(activity);
		ThunderLog.info(ThunderLog.kLogTagSdk, "%s APP stopped",
				activity.toString());
	}

	public void onActivitySaveInstanceState(Activity activity, Bundle outState) {

	}

	public void onActivityDestroyed(Activity activity) {

	}

	private void tryEnterForeground(Activity activity) {
		if (activity != null) {
			if (mIsAppOnBackground) {
				boolean flag = isBackgroundRunning(activity);
				if (!flag) {
					mIsAppOnBackground = false;
					ThunderLog.info(ThunderLog.kLogTagSdk, "%s APP background -> foreground",
							activity.toString());
					ThunderNative.enterForeground();
				}
			}
		}
	}

	private void tryEnterBackground(Activity activity) {
		if (activity != null) {
			boolean flag = isBackgroundRunning(activity);
			if (!mIsAppOnBackground && flag) {
				ThunderLog.info(ThunderLog.kLogTagSdk, "%s APP foreground -> background", activity);
				ThunderNative.enterBackground();
			}
			mIsAppOnBackground = flag;
		}
	}
}
