package com.yy.yylivesdk4cloud.audio;

import com.yy.yylivesdk4cloud.helper.ThunderLog;

import java.util.Arrays;

public class ThunderAudioEngineImp {
    private AudioEncodeConfig m_currentEncodeCofig = null;
    private AudioPrePConfig m_currentPrePConfig = null;
    private AudioSoundEffectConfig m_currentEffectConfig = null;

    public void init() {
    }

    private AudioEncodeConfig getAudioCodecConfigByType(int type) {
        AudioCodecConfig config = AudioConfigManager.instance().getAudioCodecConfigByType(type);
        if (config != null) {
            m_currentEncodeCofig = new AudioEncodeConfig(config.codecId, config.bitRate, config.sampleRate, config.channels);
            ThunderLog.info("ThunderAudioEngineImp", " getAudioCodecConfigByType :" + m_currentEncodeCofig.toString());
            return m_currentEncodeCofig;
        }
        return null;
    }

    private AudioPrePConfig getAudioPreProcConfigByType(int type) {
        AudioPreProcConfig config = AudioConfigManager.instance().getAudioPreProcConfigByType(type);
        if (config != null) {
            m_currentPrePConfig = new AudioPrePConfig(config.sceneId, config.aec, config.agc, config.vad);
            ThunderLog.info("ThunderAudioEngineImp", " getAudioPreProcConfigByType :" + m_currentPrePConfig.toString());
            return m_currentPrePConfig;
        }
        return null;
    }

    private AudioSoundEffectConfig getAudioEffectConfigByType(int type) {
        AudioEffectConfig config = AudioConfigManager.instance().getAudioEffectConfigByType(type);
        if (config != null) {
            m_currentEffectConfig = new AudioSoundEffectConfig(config.useHighProfile, config.id, config.reverbHigh, config.eqgainHigh, config.limiterHigh,
                                                                config.reverbLow, config.eqgainLow, config.limiterLow);
            ThunderLog.info("ThunderAudioEngineImp", " getAudioEffectConfigByType :" + m_currentEffectConfig.toString());
            return m_currentEffectConfig;
        }
        return null;
    }

    private static class AudioEncodeConfig {
        int codecId;
        int bitRate;
        int sampleRate;
        int channels;

        public AudioEncodeConfig(int id, int bitRate, int sampleRate, int channels) {
            this.codecId = id;
            this.bitRate = bitRate;
            this.sampleRate = sampleRate;
            this.channels = channels;
        }
        @Override
        public String toString() {
            String tmp = "AudioEncodeConfig:" + "["+"codecId:" + codecId +
                    ",bitRate:" + bitRate +
                    ",sampleRate:" + sampleRate +
                    ",channels:" + channels + "]";
            return tmp;
        }
    }

    private static class AudioPrePConfig {
        int sceneId;
        int aec;
        int agc;
        int vad;

        public AudioPrePConfig(int id, int aec, int agc, int vad) {
            this.sceneId = id;
            this.aec = aec;
            this.agc = agc;
            this.vad = vad;
        }
        @Override
        public String toString() {
            String tmp = "AudioPrePConfig:" + "["+"sceneId:" + sceneId +
                    ",aec:" + aec +
                    ",agc:" + agc +
                    ",vad:" + vad + "]";
            return tmp;
        }
    }

    private static class AudioSoundEffectConfig {
        public boolean useHighProfile;
        public int id;
        public float[] reverbHigh;
        public float[] eqgainHigh;
        public float[] limiterHigh;
        public float[] reverbLow;
        public float[] eqgainLow;
        public float[] limiterLow;

        public AudioSoundEffectConfig(boolean useHighProfile, int id, float[] reverbHigh, float[] eqgainHigh, float[] limiterHigh,
                                      float[] reverbLow, float[] eqgainLow, float[] limiterLow) {
            this.useHighProfile = useHighProfile;
            this.id = id;
            this.reverbHigh = reverbHigh;
            this.eqgainHigh = eqgainHigh;
            this.limiterHigh = limiterHigh;
            this.reverbLow = reverbLow;
            this.eqgainLow = eqgainLow;
            this.limiterLow = limiterLow;
        }

        @Override
        public String toString() {
            String tmp = "AudioEffectConfig:" + "["+ "useHighProfile: " + useHighProfile +
                    ",id: " + id +
                    ",reverbHigh:" + Arrays.toString(reverbHigh) +
                    ",eqgainHigh:" + Arrays.toString(eqgainHigh) +
                    ",limiterHigh:" + Arrays.toString(limiterHigh) +
                    ",reverbLow:" + Arrays.toString(reverbLow) +
                    ",eqgainLow:" + Arrays.toString(eqgainLow) +
                    ",limiterLow:" + Arrays.toString(limiterLow) + "]";
            return tmp;
        }
    }
}
