package com.yy.yylivesdk4cloud;

import java.util.ArrayList;
import java.util.Map;

/**
 * Created by xiongxiong on 2017/10/31.
 */

public class ThunderNotification {
	/**
	 * 开播状态通知
	 * <br>
	 * 开播后，通过此通知接收状态更新
	 * Message.obj -> {@link PublishStatusInfo}
	 */
	public static final int kThunderAPINotification_PublishStatus = 0;

	/**
	 * 开播运行时信息
	 * <br>
	 * 开播成功后，周期性发送此通知
	 * Message.obj -> {@link PublishRunTimeInfo}
	 */
	public static final int kThunderAPINotification_PublishRunTimeInfo = 1;

	/**
	 * 播放状态通知
	 * <br>
	 * 拉流播放后，通过此通知接收状态更新
	 * Message.obj -> {@link PlayStatusInfo}
	 */
	public static final int kThunderAPINotification_PlayStatus = 2;

	/**
	 * 播放运行时信息
	 * <br>
	 * 拉流播放成功后，周期性发送此通知
	 * Message.obj -> {@link PlayRunTimeInfo}
	 */
	public static final int kThunderAPINotification_PlayRunTimeInfo = 3;

	/**
	 * 开播时采集到的实时音量
	 * <br>
	 * 开播成功后，通过此通知取得实时采集音量，可用于显示波形，100ms通知一次
	 * Message.obj -> {@link AudioVolumeInfo}
	 */
	public static final int kThunderAPINotification_AudioCaptureVolume = 4;

	/**
	 * 播放的实时音量
	 * <br>
	 * 拉流播放成功后，通过此通知取得实时播放音量，可用于显示波形，100ms通知一次
	 * Message.obj -> {@link AudioVolumeInfo}
	 */
	public static final int kThunderAPINotification_AudioPlayVolume = 5;

	/**
	 * 	新系统token 业务鉴权结果返回
	 *  <br>
	 *	业务通过此通知获得开播或者订阅鉴权的结果
	 *	Message.obj -> {@link BizAuthResult}
	 */
	public static final int kThunderAPINotification_BizAuthRes = 6;

	/**
	 * 	新系统token sdk鉴权结果返回
	 *  <br>
	 *	通过此通知获sdk鉴权的结果
	 *	Message.obj -> {@link SdkAuthResult}
	 */
	public static final int kThunderAPINotification_SdkAuthRes = 7;

	/**
	 * 	新系统卸载sdk
	 *  <br>
	 *	通过此消息可以卸载sdk
	 *	Message.obj -> {@link UninstallSdk}
	 */
	public static final int kThunderAPINotification_UninstallSdk = 8;

	/**
	 * 64位uid支持回调，通过映射关系找到真实uid，映射关系保存在服务器端
	 */
	public static final int kThunderAPINotifioation_StringUid = 9;

	/**
	 * 	观众joinroom的结果
	 *  <br>
	 *
	 *	Message.obj -> {@link JoinRoomStatus}
	 */
	public static final int kThunderAPINotification_JoinRoomStatus = 10;

	/**
	 * 	观众端通过roomId获取的档位、线路、流信息结果返回
	 *  <br>
	 *	通过此通知获取直播间内所有流信息
	 *	Message.obj -> {@link StreamStatusInfo}
	 */
	public static final int kThunderAPINotification_StreamInfoStatus = 11;

	/**
	 * rtmp推流状态通知
	 * <br>
	 * 开播后，通过此通知接收状态更新
	 * Message.obj -> {@link RtmpPublishStatus}
	 */
	public static final int kThunderAPINotification_RtmpPublishStatus = 12;

	/**
	 * 	新系统视频分辨率改变通知(包括首帧)
	 *  <br>
	 *	通过此消息可以适配view
	 *	Message.obj -> {@link ResolutionChangeInfo}
	 */
	public static final int kThunderAPINotification_ResolutionChangeInfo = 13;
	public static final int kThunderAPINotification_AudioPlayData = 14;
	public static final int kThunderAPINotification_AudioPlaySpectrumData = 15;
	public static final int kThunderAPINotification_AudioCapturePcmData = 16;
	/**
 	@brief 收到透传协议回调消息
	 *	Message.obj -> {@link UserAppMsgData}
 	*/
	public static final int kThunderAPINotification_UserAppMsgData = 17;

	/**
 	@brief 透传协议发送失败状态回调
	 *	Message.obj -> {@link AppMsgDataFailedStatus}
 	*/
	public static final int kThunderAPINotification_AppMsgDataFailedStatus = 18;


	/**
	 @brief 渲染音频数据回调
	  *	Message.obj -> {@link AudioRenderPcmData}
	 */
	public static final int kThunderAPINotification_AudioRenderPcmData = 19;

	/**
	 * 主播弱网通知
	 * <br>
	 * 主播网络状态变化通知，主要当主播从弱网变成非弱网，或则从非网络变成弱网是才发该通知
	 * Message.obj -> {@link PublishLossResult}
	 */
	public static final int kThunderAPINotification_PublishLossResult = 20;
	/**
	 * 直播间开播/连麦 是否成功回调通知
	 * <br>
	 * 用于通知业务层开播/连麦状态
	 * Message.obj -> {@link PublishRoomStatus}
	 */
	public static final int kThunderAPINotification_PublishChannelStatus = 21;

	/**
	 * 直播间开播/连麦返回源流信息 （只会返回对面主播的源流  自己开播的源流不会返回）
	 * <br>
	 * Message.obj -> {@link PublishRoomStreamInfo}
	 */
	public static final int kThunderAPINotification_PublishChannelStreamInfo = 22;

	/**
	 * 传输sdk通知上层发起https请求
	 * <br>
	 * Message.obj -> {@link InitiateHttpsRequest}
	 */
	public static final int kThunderAPINotification_InitiateHttpsRequest = 23;


	public static final int kThunderAPINotification_StreamsNotify = 24;

	public static final int kThunderAPINotification_OnVideoSizeChange = 25;

	public static final int kThunderAPINotification_OnRenderFirstFrame = 26;

	/**
	 * 传输sdk通知上层主播静音状态
	 * <br>
	 * Message.obj -> {@link UserMuteAudio}
	 */
	public static final int kThunderAPINotification_UserMuteAudio = 27;

	/**
	 * 传输sdk通知上层主播静音状态
	 * <br>
	 * Message.obj -> {@link UserJoined}
	 */
	public static final int kThunderAPINotification_UserJoined = 28;

	/**
	 * 传输sdk通知上层主播静音状态
	 * <br>
	 * Message.obj -> {@link UserOffline}
	 */
	public static final int kThunderAPINotification_UserOffline = 29;

	/**
	 * 传输sdk通知上层用户上下行网络质量
	 * <br>
	 *  Message.obj -> {@link NetworkQuality}
	 */
	public static final int kThunderAPINotification_NetworkQuality = 30;

	/**
	 * 上下行流量通知
	 * <br>
	 *  Message.obj -> {@link RoomStats}
	 */
	public static final int kThunderAPINotification_RoomStats = 31;

	/**
	 * cdn推流结果
	 * <br>
	 * Message.obj -> {@link RtmpStreamNotify2Service}
	 */
	public static final int kThunderAPINotification_RtmpStreamNotify2Service = 32;

    /**
     * avp 连接状态
     * <br>
     * Message.obj -> {@link TransLinkStatus}
     */
    public static final int kThunderAPINotification_TransLinkStatus = 33;

    /**
     * service 连接状态
     * <br>
     * Message.obj -> {@link TransLinkStatus}
     */
    public static final int kThunderAPINotification_ServiceLinkStatus = 34;

    /**
     *  定时检测 service/avp 连接状态
     * <br>
     */
    public static final int kThunderAPINotification_CheckLinkConnectionStatus = 35;


	public static class PublishStatusInfo {
		/**
		 * 发布参数错误
		 */
		public static final int THUNDER_PUBLISHSTATUS_PARAM_ERROR = -1;

		/**
		 * 发布成功，服务器已经收到了流数据
		 */
		public static final int THUNDER_PUBLISHSTATUS_PUBLISH_SUCCESS = 0;

		/**
		 * 发布失败，服务器无法正常发布这条流
		 */
		public static final int THUNDER_PUBLISHSTATUS_PUBLISH_FAILED = 1;

		/**
		 * 鉴权失败，可能是token不对或者已过期
		 */
		public static final int THUNDER_PUBLISHSTATUS_PUBLISH_AUTH_FAILED = 2;

		/**
		 * 用户没有进入主播系统 {@link ThunderAPI#setUserRole(int)}
		 */
		public static final int THUNDER_PUBLISHSTATUS_USER_NOT_ANCHOR = 3;

		private String mStreamName;
		private boolean mIsVideo;
		private int mStatus;

		public PublishStatusInfo(String streamName, boolean isVideo, int status) {
			mStreamName = streamName;
			mIsVideo = isVideo;
			mStatus = status;
		}

		public String getStreamName() {
			return mStreamName;
		}

		public boolean isVideo() {
			return mIsVideo;
		}

		/**
		 * 开播状态
		 *
		 * @return {@link PublishStatusInfo#THUNDER_PUBLISHSTATUS_PUBLISH_SUCCESS} etc.
		 */
		public int getStatus() {
			return mStatus;
		}
	}

	public static class ThunderRunTimeInfo {
		public static final int THUNDER_QUALITY_UNKNOWN = 0;
		public static final int THUNDER_QUALITY_VERYGOOD = 1;
		public static final int THUNDER_QUALITY_GOOD = 2;
		public static final int THUNDER_QUALITY_NORMAL = 3;
		public static final int THUNDER_QUALITY_BAD = 4;
		public static final int THUNDER_QUALITY_VERYBAD = 5;

		/**
		 * 网络链路连接中
		 */
		public static final int THUNDER_LINKSTATUS_CONNECTING = 0;
		/**
		 * 网络链路连接上
		 */
		public static final int THUNDER_LINKSTATUS_CONNECTED = 1;
		/**
		 * 网络链路断开
		 */
		public static final int THUNDER_LINKSTATUS_DISCONNECT = 2;
		/**
		 * 服务器拒绝服务
		 */
		public static final int THUNDER_LINKSTATUS_SERVERREJECT = 3;

		private int mFps;
		private int mBitrate;
		private int mWidth;
		private int mHeight;
		private int mAudioBitrate;
		private int mQuality;
		private int mRtt;
		private int mLossRate;
		private int mLinkStatus;
		private int mRealBitrate;

		public ThunderRunTimeInfo(int fps, int bitrate, int width, int height, int audioBitrate, int quality,
								  int rtt, int lossRate, int linkStatus, int realBitrate) {
			mFps = fps;
			mBitrate = bitrate;
			mWidth = width;
			mHeight = height;
			mAudioBitrate = audioBitrate;
			mQuality = quality;
			mRtt = rtt;
			mLossRate = lossRate;
			mLinkStatus = linkStatus;
			mRealBitrate = realBitrate;
		}

		/**
		 * 当前视频编码/解码帧率
		 */
		public int getFps() {
			return mFps;
		}

		/**
		 * 当前视频播放码率，单位bps / 主播编码码率
		 */
		public int getBitrate() {
			return mBitrate;
		}

		/**
		 * 当前视频分辨率 - 宽
		 */
		public int getWidth() {
			return mWidth;
		}

		/**
		 * 当前视频分辨率 - 高
		 */
		public int getHeight() {
			return mHeight;
		}

		/**
		 * 当前音频播放/编码码率，单位bps
		 */
		public int getAudioBitrate() {
			return mAudioBitrate;
		}
		/**
		 * 当前网络（上行/下行）质量
		 * @return {@link ThunderRunTimeInfo#THUNDER_QUALITY_GOOD} etc.
		 */
		public int getQuality() {return mQuality; }
		/**
		 * 当前连接rtt时间 单位毫秒
		 */
		public int getRtt() {return mRtt;}
		/**
		 * 当前上行/下行丢包率
		 */
		public int getLossRate() {return mLossRate;}
		/**
		 * 当前开播网络连接状态 {@link ThunderRunTimeInfo#THUNDER_LINKSTATUS_CONNECTED} etc.
		 */
		public int getLinkStatus() {return mLinkStatus;}

		/**
		 * 主播实时发送码率 开播侧使用 单位bps
		 * @return
		 */
		public int getPublishRealBitrate() {
			return mRealBitrate;
		}
	}

	public static class PublishRunTimeInfo {
		private String mStreamName;
		private ThunderRunTimeInfo mInfo;

		public PublishRunTimeInfo(String streamName, ThunderRunTimeInfo info) {
			mStreamName = streamName;
			mInfo = info;
		}

		/**
		 * 音/视频流名称
		 */
		public String getStreamName() {
			return mStreamName;
		}

		/**
		 * 运行时信息
		 */
		public ThunderRunTimeInfo getInfo() {
			return mInfo;
		}
	}

	public static class PlayStatusInfo {
		/**
		 * 参数错误
		 */
		public static final int THUNDER_PLAYSTATUS_PARAM_ERROR = -1;

		/**
		 * 订阅成功，不代表有实际的音视频流，可能此时主播还没有实际推音视频数据
		 */
		public static final int THUNDER_PLAYSTATUS_SUBSCRIBE_SUCCUSS = 0;

		/**
		 * 订阅失败，可能服务器不允许用户订阅此流
		 */
		public static final int THUNDER_PLAYSTATUS_SUBSCRIBE_FAILED = 1;

		/**
		 * 取消订阅，用户主动停止拉流
		 */
		public static final int THUNDER_PLAYSTATUS_SUBSCRIBE_CANCEL = 2;

		/**
		 * 收到音视频流信息(服务器已经收到了主播音视频数据)
		 */
		public static final int THUNDER_PLAYSTATUS_STREAM_ARRIVE = 3;

		/**
		 * 渲染了第一帧视频(视频流才有此状态)
		 */
		public static final int THUNDER_PLAYSTATUS_STREAM_RENDERED = 4;

		/**
		 * 可能主播已经停播
		 */
		public static final int THUNDER_PLAYSTATUS_STREAM_STOP = 5;

		private int mStatus;
		private ThunderStream mStream;

		public PlayStatusInfo(ThunderStream stream, int status) {
			mStream = stream;
			mStatus = status;
		}

		/**
		 * 音/视频流
		 */
		public ThunderStream getStream() {
			return mStream;
		}

		/**
		 * 播放状态
		 * <br>
		 * <br>正常播放会经过：
		 * <br>{@link PlayStatusInfo#THUNDER_PLAYSTATUS_SUBSCRIBE_SUCCUSS} ->
		 * {@link PlayStatusInfo#THUNDER_PLAYSTATUS_STREAM_ARRIVE} ->
		 * <br>{@link PlayStatusInfo#THUNDER_PLAYSTATUS_STREAM_RENDERED} ->
		 * {@link PlayStatusInfo#THUNDER_PLAYSTATUS_STREAM_STOP / PlayStatusInfo#THUNDER_PLAYSTATUS_SUBSCRIBE_CANCEL}
		 */
		public int getStatus() {
			return mStatus;
		}
	}

	public static class PlayRunTimeInfo {
		private ThunderStream mStream;
		private ThunderRunTimeInfo mInfo;

		public PlayRunTimeInfo(ThunderStream stream, ThunderRunTimeInfo info) {
			mStream = stream;
			mInfo = info;
		}

		/**
		 * 音/视频流
		 */
		public ThunderStream getStream() {
			return mStream;
		}

		/**
		 * 播放运行时信息
		 */
		public ThunderRunTimeInfo getInfo() {
			return mInfo;
		}
	}

	public static class ThunderVolumeInfo {
		/**
		 * 实际音量值, 取值范围[0, 100]
		 */
		public int mVolume;
		public long mPts;

		/**
		 * 当前实际说话人的uid列表，播放的实时音量通知有效
		 * {@link ThunderNotification#kThunderAPINotification_AudioPlayVolume}
		 */
		public ArrayList<Long> mActualSpeakerUidList;

		public ThunderVolumeInfo(int volume, long pts, ArrayList<Long> actualSpeakerUidList) {
			mVolume = volume;
			mPts = pts;
			mActualSpeakerUidList = actualSpeakerUidList;
		}
	}

	public static class AudioVolumeInfo {
		private Map<Long, ThunderVolumeInfo> mVolumeInfos;

		public AudioVolumeInfo(Map<Long, ThunderVolumeInfo> volumeInfos) {
			mVolumeInfos = volumeInfos;
		}

		public Map<Long, ThunderVolumeInfo> getVolumeInfos() {
			return mVolumeInfos;
		}
	}

	public static class ThunderAudioCaptureVolume {
		/**
		 * 音频上行总音量能量值, 取值范围[0, 100]
		 */
		public int mVolume;

		/**
		 * 采集时间戳
		 */
		public long mCpt;

		/**
		 * 仅麦克风采集能量值 [0, 100]
		 */
		public int mMicVolume;

		public ThunderAudioCaptureVolume(int volulme, long cpt, int micVolume){
			mVolume = volulme;
			mCpt = cpt;
			mMicVolume = micVolume;
		}
	}

	/**
	 * app业务端的鉴权结果
	 * <br>
	 * 若group!=null则表示对群组的鉴权，否则是对stream的鉴权
	 */
	public static class BizAuthResult {
		private ThunderStream mStream;
		private ThunderGroup mGroup;
		private boolean mBPublish;
		private int mBizAuthResult;

		public BizAuthResult(ThunderStream stream, ThunderGroup group, boolean bPublish, int bizAuthResult)
		{
			mStream = stream;
			mGroup = group;
			mBPublish = bPublish;
			mBizAuthResult= bizAuthResult;
		}

		/**
		 * 鉴权的流信息
		 */
		public ThunderStream getAuthStream() {return mStream;}

		/**
		 * 鉴权的群组信息
		 */
		public ThunderGroup getAuthGroup() {
			return mGroup;
		}

		/**
		 *  开播鉴权or播放鉴权
		 */
		public boolean isPublishAuth() { return mBPublish;}

		/**
		 * sdk透传业务鉴权服务器定义的结果，0：表示成功，其他：业务自定义
		 */
		public int getBizAuthResult() { return mBizAuthResult;}
	}

	/**
	 * sdk鉴权结果，是否有权限使用此sdk
	 */
	public static class SdkAuthResult {
		/**
		 * 鉴权成功
		 */
		public static final int THUNDER_SDK_AUTHRES_SUCCUSS = 0;

		/**
		 * 服务器内部错误，可以重试
		 */
		public static final int THUNDER_SDK_AUTHRES_ERR_SERVER_INTERNAL = 10000;

		/**
		 * 没有带token，需要调用{@link ThunderAPI#updateToken(byte[])}
		 */
		public static final int THUNDER_SDK_AUTHRES_ERR_NO_TOKEN = 10001;

		/**
		 * token校验失败（数字签名不对），可能使用的appSecret不对
		 */
		public static final int THUNDER_SDK_AUTHRES_ERR_TOKEN_ERR = 10002;

		/**
		 * token中appid跟鉴权时带的appid不一致
		 */
		public static final int THUNDER_SDK_AUTHRES_ERR_APPID = 10003;

		/**
		 * token中uid跟鉴权时带的uid不一致
		 */
		public static final int THUNDER_SDK_AUTHRES_ERR_UID = 10004;

		/**
		 * token已过期
		 */
		public static final int THUNDER_SDK_AUTHRES_ERR_TOKEN_EXPIRE = 10005;

		/**
		 * app不存在，没有在管理后台注册
		 */
		public static final int THUNDER_SDK_AUTHRES_ERR_NO_APP = 10006;


		private int mAppId;
		private int mUid;
		private int mSdkAuthResult;

		public SdkAuthResult(int appId, int uid, int sdkAuthResult)
		{
			mAppId = appId;
			mUid = uid;
			mSdkAuthResult= sdkAuthResult;
		}

		/**
		 * 鉴权时带的appId，非token内的
		 */
		public int getAppId() {return mAppId;}

		/**
		 * 鉴权时带的uid，非token内的
		 */
		public int getUid() {
			return mUid;
		}

		/**
		 * 鉴权结果
		 *
		 * @return {@link SdkAuthResult#THUNDER_SDK_AUTHRES_SUCCUSS} etc.
		 */
		public int getSdkAuthResult() { return mSdkAuthResult;}
	}

	/**
	 * 卸载SDK通知，通知业务卸载此sdk
	 */
	public static class UninstallSdk
	{
		public UninstallSdk()
		{
		}
	}

	public static class UidInt2String{
		private int mUid;
		private String mStrUid;

		public UidInt2String(int iUid, String strUid){
			mUid = iUid;
			mStrUid = removeNonNumericChar(strUid);
		}

		// 移除非数字的char，如空格等，避免parse时出错导致崩溃
		private String removeNonNumericChar(String strUid) {
			StringBuffer buffer = new StringBuffer();
			int length = strUid.length();
			int codePoint;
			for (int i = 0; i < length; i++) {
				codePoint = Character.codePointAt(strUid, i);
				if (codePoint >= 48 && codePoint <= 57)    // [0,9]
				{
					buffer.append(strUid.charAt(i));
				}
			}
			return buffer.toString();
		}
		public int getUidInt() {return mUid;}
		public String getUidString() {return mStrUid;};
	}


	/**
	 * 视频分辨率改变通知
	 */
	public static class ResolutionChangeInfo {
		private ThunderStream mStream;
		private int mWidth;
		private int mHeight;

		public ResolutionChangeInfo(ThunderStream stream, int width, int height) {
			mStream = stream;
			mWidth = width;
			mHeight = height;
		}

		/**
		 * 视频流
		 */
		public ThunderStream getStream() {
			return mStream;
		}

		/**
		 * 视频宽
		 */
		public int getWidth() { return mWidth; }
		/**
		 * 视频高
		 */
		public int getHeight() {
			return mHeight;
		}
	}

	/**
	 * 加入房间结果返回
	 */
	public static class JoinRoomStatus {
		/**
		 * 加入房间成功
		 */
		public static final int THUNDER_JOINROOM_STATUS_SUCCESS = 0;
		/**
		 * 加入房间超时
		 */
		public static final int THUNDER_JOINROOM_STATUS_TIMEOUT = 1;

		private String mRoomId;
		private int mStatus;

		public JoinRoomStatus(String roomId, int status)
		{
			mRoomId = roomId;
			mStatus = status;
		}
		/**
		 * 房间号
		 */
		public String getRoomId() {return mRoomId;}

		/**
		 * 加入房间状态
		 * @return {@link JoinRoomStatus#THUNDER_JOINROOM_STATUS_SUCCESS} etc.
		 */
		public int getStatus() {return mStatus;}

	}

	/**
	 * 房间内档位/线路/流信息等状态改变回调
	 */
	public static class StreamStatusInfo {
		/**
		 * 没有流信息 直播间未开播
		 */
		public static final int THUNDER_STREAM_NO_STREAM = 0;
		/**
		 * 档位发生变化
		 */
		public static final int THUNDER_STREAM_LEVEL_CHG = 1;
		/**
		 * 线路发生变化
		 */
		public static final int THUNDER_STREAM_LINE_CHG = 2;
		/**
		 * 流名称发生变化
		 */
		public static final int THUNDER_STREAM_NAME_CHG = 4;
		/**
		 * 流属性streamConfig发生变化 可能是分辨率、码率等
		 */
		public static final int THUNDER_STREAM_CONFIG_CHG = 16;
		/**
		 * 直播间停播状态
		 */
		public static final int THUNDER_STREAM_STOP = 32;
		/**
		 * 直播间开播状态
		 */
		public static final int THUNDER_STREAM_ARRIVE = 64;

		private int mCurLine;
		private String mRoomId;
		private int mStatus;
		private Map<Integer, ThunderStreamLevelInfo> mStreamLevel;

		public StreamStatusInfo(int curLine, String roomId, int status, Map<Integer, ThunderStreamLevelInfo> streamLevel)
		{
			mCurLine = curLine;
			mRoomId = roomId;
			mStatus = status;
			mStreamLevel = streamLevel;
		}

		/**
		 * 获取channelId信息 默认推荐线路
		 */
		public int getCurLine() {return mCurLine;}

		/**
		 * 房间号
		 */
		public String getRoomId() {return mRoomId;}

		/**
		 * 通知状态
		 * @return {@link StreamStatusInfo#THUNDER_STREAM_ARRIVE} etc.
		 */
		public int getStatus() {return mStatus;}

		/**
		 * 档位信息字典 包含关系[档位]线路]流信息]
		 * key:档位 {@link ThunderConstant.ThunderVideoLevel#THUNDERVIDEO_LEVEL_NORMAL} etc.
		 * value:线路字典信息参照{@link ThunderStreamLevelInfo}.
		 */
		public Map<Integer, ThunderStreamLevelInfo> getStreamLevel() {return mStreamLevel;}

	}

	/**
	 * rtmp 推流状态
	 */
	public static class RtmpPublishStatus {

		/**
		 * tcp建立成功
		 */
		public static final int THUNDER_RTMP_PUBLISH_SUCCESS = 1;
		/**
		 * 流连接建立成功
		 */
		public static final int THUNDER_RTMP_PUBLISH_STREAM_SUCCESS = 2;
		/**
		 * 获取rtmp地址失败
		 */
		public static final int THUNDER_RTMP_PUBLISH_FETCH_RTMP_FAILED = 3;
		/**
		 * 解析地址失败
		 */
		public static final int THUNDER_RTMP_PUBLISH_PARSE_URL_FAILED = 4;
		/**
		 * tcp连接建立失败
		 */
		public static final int THUNDER_RTMP_PUBLISH_TCP_FAILED = 5;
		/**
		 * 开播鉴权失败
		 */
		public static final int THUNDER_RTMP_PUBLISH_AUTH_FAILED = 6;
		/**
		 * 流连接建立失败
		 */
		public static final int THUNDER_RTMP_PUBLISH_STREAM_FAILED = 7;
		/**
		 * 连接断开
		 */
		public static final int THUNDER_RTMP_PUBLISH_CLOSED = 8;
		/**
		 * 没有解说资源
		 */
		public static final int THUNDER_RTMP_PUBLISH_NO_RESOURCE = 9;
		/**
		 * 发送第一帧视频
		 */
		public static final int THUNDER_RTMP_PUBLISH_SEND_FIRST_FRAME = 10;
		/**
		 * 服务器关闭流连接，server正常结束推流
		 */
		public static final int THUNDER_RTMP_PUBLISH_SERVER_DELETE_STREAM = 11;
		/**
		 * 连接建立完成后的收包异常
		 */
		public static final int THUNDER_RTMP_PUBLISH_READ_PACKET_FAILED = 12;

		private int mAppid;
		private int mStatus;

		public RtmpPublishStatus(int appid, int status) {
			mAppid = appid;
			mStatus = status;
		}

		public int getAppid() {
			return mAppid;
		}

		/**
		 * 开播状态
		 *
		 * @return {@link RtmpPublishStatus#THUNDER_RTMP_PUBLISH_SUCCESS} etc.
		 */
		public int getStatus() {
			return mStatus;
		}
	}

	/**
	 * 主播弱网通知
	 */
	public static class PublishLossResult {
		/**
		 * 主播网络正常
		 */
		public static final int THUNDER_PUBLISH_NET_NORMAL = 0;
		/**
		 * 主播弱网
		 */
		public static final int THUNDER_PUBLISH_NET_WEAK = 1;

		private int mAppid;
		private int mResult;

		public PublishLossResult(int appid, int result) {
			mAppid = appid;
			mResult = result;
		}

		public int getAppid() {
			return mAppid;
		}

		/**
		 * 弱网状态
		 * @return {@link PublishLossResult#THUNDER_PUBLISH_NET_NORMAL} etc.
		 */
		public int getResult() {
			return mResult;
		}
	}

	public static class AudioDataInfo {
		private long mUid;
		private int mDuration;
		private int mCpt;
		private int mPts;
		private byte[] mData;

		public AudioDataInfo(long uid, int duration, int cpt, int pts, byte[] data) {
			mUid = uid;
			mDuration = duration;
			mCpt = cpt;
			mPts = pts;
			mData = data;
		}

		public long getUid() {
			return mUid;
		}

		public int getDuration() {
			return mDuration;
		}

		public int getCpt() {
			return mCpt;
		}

		public int getPts() {
			return mPts;
		}

		public byte[] getData() {
			return mData;
		}
	}

	public static class AudioPlaySpectrumData{
		private byte[] mData;

		public AudioPlaySpectrumData(byte[] data) {
			mData = data;
		}

		public byte[] getData() {
			return mData;
		}
	}

	public static class AudioCapturePcmData{
		private byte[] mData;
		private int mDataSize;
		private int mSampleRate;
		private int mChannel;

		public AudioCapturePcmData(byte[] data, int dataSize, int sampleRate, int channel) {
			mData = data;
			mDataSize = dataSize;
			mSampleRate = sampleRate;
			mChannel = channel;
		}

		public byte[] getData() {
			return mData;
		}

		public int getDataSize() {
			return mDataSize;
		}

		public int getSampleRate() {
			return mSampleRate;
		}

		public int getChannel() {
			return mChannel;
		}
	}

	public static class AudioRenderPcmData{
		private byte[] mData;
		private int mDataSize;
		private int mDuration;
		private int mSampleRate;
		private int mChannel;

		public AudioRenderPcmData(byte[] data, int dataSize, int duration, int sampleRate, int channel) {
			mData = data;
			mDataSize = dataSize;
			mDuration = duration;
			mSampleRate = sampleRate;
			mChannel = channel;
		}

		public byte[] getData() {
			return mData;
		}

		public int getDataSize() {
			return mDataSize;
		}

		public int getDuration() {
			return mDuration;
		}

		public int getSampleRate() {
			return mSampleRate;
		}

		public int getChannel() {
			return mChannel;
		}
	}


	public static class UserAppMsgData{
		private byte[] mData;
		private long mUid;

		public UserAppMsgData(byte[] data, long uid) {
			mData = data;
			mUid = uid;
		}

		public byte[] getData() {
			return mData;
		}

		public long getUid() {
			return mUid;
		}
	}

	public static class AppMsgDataFailedStatus{

		/**
		 * 发送频率太高，规定每秒不超过2次
		 */
		public static final int THUNDER_HIGHT_FREQUENCY = 1;
		/**
		 * 每次发送数据太大，规定每次不能超过200Byte
		 */
		public static final int THUNDER_LARGE_MSG_DATA = 2;

		private int failedStatus;

		public AppMsgDataFailedStatus(int status) {
			failedStatus = status;
		}

		public int getFailedStatus() {
			return failedStatus;
		}
	}
	/**
	 * 直播间开播/连麦状态通知回调
	 */
	public static class PublishRoomStatus {
		/**
		 * 发布成功，服务器已经收到了流数据
		 */
		public static final int THUNDER_PUBLISHSTATUS_SUCCESS = 0;
		/**
		 * 发布参数错误
		 */
		public static final int THUNDER_PUBLISHSTATUS_PARAM_ERROR = 1;

		/**
		 * 发布失败，服务器无法正常发布这条流
		 */
		public static final int THUNDER_PUBLISHSTATUS_FAILED = 2;

		/**
		 * 鉴权失败，可能是token不对或者已过期
		 */
		public static final int THUNDER_PUBLISHSTATUS_AUTH_FAILED = 3;

		/**
		 * 用户没有进入主播系统 {@link ThunderAPI#setUserRole(int)}
		 */
		public static final int THUNDER_PUBLISHSTATUS_USER_NOT_ANCHOR = 4;


		private int mStatus;
		private String mRoomId;

		public PublishRoomStatus(String roomId, int status) {
			mRoomId = roomId;
			mStatus = status;
		}

		public int getStatus() {return mStatus;}

		public String getRoomId() {return mRoomId;}
	}

	/**
	 * 直播间开播/连麦 返回源流信息
	 * {@link ThunderStream}.
	 */
	public static class PublishRoomStreamInfo {
		private String mRoomId;
		private ArrayList<ThunderStream> mStreams;

		public PublishRoomStreamInfo(String roomId, ArrayList<ThunderStream> streams) {
			mRoomId = roomId;
			mStreams = streams;

		}

		public String getRoomId() {return mRoomId;}
		public ArrayList<ThunderStream> getStreams() {return mStreams;}
	}

	public static class InitiateHttpsRequest {
		private String mReqUrl;
		private int mTarget;

		public InitiateHttpsRequest(String reqUrl, int target) {
			mReqUrl = reqUrl;
			mTarget = target;
		}

		public String getReqUrl() {return mReqUrl;}
		public int getTarget() {return mTarget;}
	}

	public static class StreamsNotify {
		private String mRoomId;
		private ArrayList<ThunderStream> mStreams;

		public StreamsNotify(String mRoomId, ArrayList<ThunderStream> streams) {
			this.mRoomId = mRoomId;
			mStreams = streams;

		}

		public String getRoomId() {return mRoomId;}
		public ArrayList<ThunderStream> getStreams() {return mStreams;}
	}

	public static class OnVideoSizeChange {
		private long uid;
		private int width;
		private int height;

		public OnVideoSizeChange(long _uid,int _width,int _height) {
			uid = _uid;
			width = _width;
			height = _height;
		}

		public long getUid() {
			return uid;
		}

		public int getWidth() {
			return width;
		}

		public int getHeight() {
			return height;
		}
	}

	public static class OnRenderVideoFirstFrame {
		private long userGroupId;
		private long streamId;
		private long currentTimeMs;
		private long firstTimeMs;
		private int eatenFrame;

		public OnRenderVideoFirstFrame(long _userGroupId, long _streamId, long _currentTimeMs, long _firstTimeMs, int _eatenFrame) {
			userGroupId = _userGroupId;
			streamId = _streamId;
			currentTimeMs = _currentTimeMs;
			firstTimeMs = _firstTimeMs;
			eatenFrame = _eatenFrame;
		}

		public long getUserGroupId(){
			return userGroupId;
		}

		public long getStreamId() {
			return streamId;
		}

		public long getCurrentTimeMs() {
			return currentTimeMs;
		}

		public long getFirstTimeMs() {
			return firstTimeMs;
		}

		public int getEatenFrame() {
			return eatenFrame;
		}
	}

	public static class UserMuteAudio {
		private long mUid;
		private boolean mIsMuted;

		public UserMuteAudio(long uid, int muted) {
			mUid = uid;
			mIsMuted = muted == 1 ? true : false;
		}

		public long getUid() {
			return mUid;
		}

		public boolean isMuted() {
			return mIsMuted;
		}
	}

	public static class UserJoined {
		private long mUid;

		public UserJoined(long uid) {
			mUid = uid;
		}

		public long getUid() {
			return mUid;
		}
	}

	public static class UserOffline {
		private long mUid;
		private int mReason;

		public UserOffline(long uid, int reason) {
			mUid = uid;
			mReason = reason;
		}

		public long getUid() {
			return mUid;
		}

		public int getReason() {
			return mReason;
		}
	}

	public static class NetworkQuality {
		private long mUid;
		private int mTxQuality;
		private int mRxQuality;

		public NetworkQuality(long uid, int txQuality, int rxQuality) {
			mUid = uid;
			mTxQuality = txQuality;
			mRxQuality = rxQuality;
		}

		public long getUid() {
			return mUid;
		}

		public int getTxQuality() {
			return mTxQuality;
		}

		public int getRxQuality() {
			return mRxQuality;
		}
	}

	public static class RoomStats {

		public int txBitrate; //链路发送码率，单位bps
		public int rxBitrate; //链路接收码率，单位bps
		public int txAudioBitrate;  //音频包的发送码率，单位bps
		public int rxAudioBitrate;  //音频包的接收码率，单位bps
		public int txVideoBitrate;  //视频包的发送码率，单位bps
		public int rxVideoBitrate;  //视频包的接收码率，单位bps

		public RoomStats(int txBitrate, int rxBitrate, int txAudioBitrate, int rxAudioBitrate, int txVideoBitrate, int rxVideoBitrate) {
			this.txBitrate = txBitrate;
			this.rxBitrate = rxBitrate;
			this.txAudioBitrate = txAudioBitrate;
			this.rxAudioBitrate = rxAudioBitrate;
			this.txVideoBitrate = txVideoBitrate;
			this.rxVideoBitrate = rxVideoBitrate;
		}
	}

	public static class RtmpStreamNotify2Service {
		private int mAction;
		private String mUrl;
		private String mTaskName;
		private String mChannelId;
		private long mUid;

		public RtmpStreamNotify2Service(int action, String url, String taskName, String channelId, long uid) {
			mAction = action;
			mUrl = url;
			mTaskName = taskName;
			mChannelId = channelId;
			mUid = uid;
		}

		public int getAction() {
			return mAction;
		}

		public String getUrl() {
			return mUrl;
		}

		public String getTaskName() {
			return mTaskName;
		}

		public String getChannelId() {
			return mChannelId;
		}

		public long getUid() {
			return mUid;
		}
	}

	public static class TransLinkStatus {
        private int mStatus;

        public TransLinkStatus(int status) {
            mStatus = status;
        }

        public int getStatus() {
            return mStatus;
        }
    }

    public static class ServiceLinkStatus {
        private int mStatus;

        public ServiceLinkStatus(int status) {
            mStatus = status;
        }

        public int getStatus() {
            return mStatus;
        }
    }
}