package com.yy.yylivesdk4cloud;

/**
 * Created by zhangfei on 2018/06/20.
 */

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.view.SurfaceView;
import android.view.ViewGroup;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.Matcher;
import java.math.BigDecimal;

import com.yy.mediaframework.facedetection.IFaceDetection;
import com.yy.mediaframework.gpuimage.custom.IGPUProcess;
import com.yy.yylivesdk4cloud.audio.IAudioFrameObserver;
import com.yy.yylivesdk4cloud.helper.ThunderHttpsRequestHandler;
import com.yy.yylivesdk4cloud.helper.ThunderLog;
import com.yy.yylivesdk4cloud.helper.ThunderNative;
import com.yy.yylivesdk4cloud.system.ThunderNetStateService;
import com.yy.yylivesdk4cloud.video.IVideoCaptureObserver;
import com.yy.yylivesdk4cloud.video.IVideoDecodeObserver;

import org.json.JSONObject;

import static com.yy.yylivesdk4cloud.ThunderConstant.ThunderCameraPosition.THUNDERCAMERA_POSITION_FRONT;
import static com.yy.yylivesdk4cloud.ThunderConstant.ThunderRtcProfile.THUNDER_PROFILE_DEFAULT;
import static com.yy.yylivesdk4cloud.ThunderConstant.ThunderRtcProfile.THUNDER_PROFILE_ONLY_AUDIO;
import static com.yy.yylivesdk4cloud.ThunderNotification.PublishStatusInfo.THUNDER_PUBLISHSTATUS_PUBLISH_SUCCESS;
import static com.yy.yylivesdk4cloud.ThunderRtcConstant.ThunderConnectionStatus.THUNDER_CONNECTION_STATUS_CONNECTING;
import static com.yy.yylivesdk4cloud.ThunderRtcConstant.ThunderConnectionStatus.THUNDER_CONNECTION_STATUS_CONNECTED;
import static com.yy.yylivesdk4cloud.ThunderRtcConstant.ThunderConnectionStatus.THUNDER_CONNECTION_STATUS_DISCONNECTED;
import static com.yy.yylivesdk4cloud.ThunderRtcConstant.ThunderVideoCaptureOrientation.THUNDER_VIDEO_CAPTURE_ORIENTATION_LANDSCAPE;
import static com.yy.yylivesdk4cloud.ThunderRtcConstant.ThunderVideoCaptureOrientation.THUNDER_VIDEO_CAPTURE_ORIENTATION_PORTRAIT;
import static com.yy.yylivesdk4cloud.ThunderRtcConstant.ThunderVideoMirrorMode.THUNDER_VIDEO_MIRROR_MODE_PREVIEW_MIRROR_PUBLISH_NO_MIRROR;
import static com.yy.yylivesdk4cloud.ThunderRtcConstant.ThunderVideoMirrorMode.THUNDER_VIDEO_MIRROR_MODE_PREVIEW_NO_MIRROR_PUBLISH_MIRROR;
import static com.yy.yylivesdk4cloud.ThunderRtcConstant.ThunderVideoMirrorMode.THUNDER_VIDEO_MIRROR_MODE_PREVIEW_PUBLISH_BOTH_MIRROR;
import static com.yy.yylivesdk4cloud.ThunderRtcConstant.ThunderVideoMirrorMode.THUNDER_VIDEO_MIRROR_MODE_PREVIEW_PUBLISH_BOTH_NO_MIRROR;

/**
 * YY音频简易接入SDK
 * 所有接口，int型返回值，未做特殊说明，0表示成功，<0 error
 */

public class ThunderEngine {
    private final static String TAG = "RtcEngine";
    private static boolean mIsInited = false;

    private static class NotificationHandler extends Handler {
        private final WeakReference<ThunderEngine> mThunderEngine;

        public NotificationHandler(ThunderEngine rtc) {
            mThunderEngine = new WeakReference<ThunderEngine>(rtc);
        }

        public NotificationHandler(ThunderEngine rtc, Looper loop) {
            super(loop);

            mThunderEngine = new WeakReference<ThunderEngine>(rtc);
        }

        @Override
        public void handleMessage(Message msg) {
    
            try{
            switch (msg.what) {
                case ThunderNotification.kThunderAPINotification_PublishStatus: {
                    ThunderNotification.PublishStatusInfo info = (ThunderNotification.PublishStatusInfo) msg.obj;
                    if (info.getStatus() == THUNDER_PUBLISHSTATUS_PUBLISH_SUCCESS) {
                        int elapsed = (int) (System.currentTimeMillis() - mThunderEngine.get().joinEnd);
                        if (mRtcEventHandler != null) {
                            if (info.isVideo()) {
                                mRtcEventHandler.onFirstLocalVideoFrameSent(elapsed);
                            } else {
                                mRtcEventHandler.onFirstLocalAudioFrameSent(elapsed);
                            }
                        }
                    }

                    ThunderLog.release(TAG, String.format("ThunderNotification.PublishStatusInfo stream=%s status=%d",
                            info.getStreamName(), info.getStatus()));
                    break;
                }
                case ThunderNotification.kThunderAPINotification_PublishRunTimeInfo: {
                    ThunderNotification.PublishRunTimeInfo info = (ThunderNotification.PublishRunTimeInfo) msg.obj;
                    ThunderLog.info(TAG, String.format("ThunderNotification.PublishRunTimeInfo stream=%s fps=%d " +
                                    "bitrate=%d audioBitrate=%d resolution=%dx%d", info.getStreamName(),
                            info.getInfo().getFps(), info.getInfo().getBitrate(), info.getInfo().getAudioBitrate(),
                            info.getInfo().getWidth(), info.getInfo().getHeight()));
                    break;
                }
                case ThunderNotification.kThunderAPINotification_PlayStatus: {
                    ThunderNotification.PlayStatusInfo info = (ThunderNotification.PlayStatusInfo) msg.obj;
                    ThunderLog.release(TAG, String.format("ThunderNotification.PlayStatusInfo stream=%s status=%d",
                            info.getStream().streamName, info.getStatus()));
                    if (mThunderEngine.get() != null) {
                        switch (info.getStatus()) {
                            case ThunderNotification.PlayStatusInfo.THUNDER_PLAYSTATUS_PARAM_ERROR: {

                            }
                            break;
                            case ThunderNotification.PlayStatusInfo.THUNDER_PLAYSTATUS_SUBSCRIBE_SUCCUSS: {
                                if (mRtcEventHandler != null && mThunderEngine.get().getIsThunder()) {
                                    mThunderEngine.get().isJoinRoom = true;
                                    mRtcEventHandler.onJoinRoomSuccess(mThunderEngine.get().getRoomName(),
                                            mThunderEngine.get().getMyUid(), 0);
                                }
                            }
                            break;
                            case ThunderNotification.PlayStatusInfo.THUNDER_PLAYSTATUS_SUBSCRIBE_FAILED: {

                            }
                            break;
                            case ThunderNotification.PlayStatusInfo.THUNDER_PLAYSTATUS_SUBSCRIBE_CANCEL: {
                                if (mRtcEventHandler != null && mThunderEngine.get().getIsThunder()) {
                                    ThunderEventHandler.RoomStats status = new ThunderEventHandler.RoomStats();
                                    mRtcEventHandler.onLeaveRoom(status);
                                }
                            }
                            break;
                            case ThunderNotification.PlayStatusInfo.THUNDER_PLAYSTATUS_STREAM_ARRIVE: {

                            }
                            break;
                            case ThunderNotification.PlayStatusInfo.THUNDER_PLAYSTATUS_STREAM_RENDERED: {
                                long renderTime = System.currentTimeMillis();
                                ThunderStream playStream = info.getStream();
                                ThunderStream findStream = ThunderAPI.sharedInstance().getPlayer().getSubscribeStreamByUid(playStream.speakerUid);

                                if (findStream != null) {
                                    int elapseTime = (int) (renderTime - findStream.startSubscribeTime);
                                    mRtcEventHandler.onRemoteVideoPlay(mThunderEngine.get().getStringUid(findStream.speakerUid), findStream.width, findStream.height, elapseTime);
                                }

                            }
                            break;
                            case ThunderNotification.PlayStatusInfo.THUNDER_PLAYSTATUS_STREAM_STOP: {

                            }
                            break;
                        }
                    }
                    ThunderLog.release(TAG, " mThunderEngine = " + mThunderEngine.get());
                    break;
                }
                case ThunderNotification.kThunderAPINotification_PlayRunTimeInfo: {
                    //                    ThunderNotification.PlayRunTimeInfo info = (ThunderNotification.PlayRunTimeInfo) msg.obj;
                    //                    ThunderLog.info(TAG, String.format("ThunderNotification.PlayRunTimeInfo stream=%s fps=%d " +
                    //                                    "bitrate=%d audioBitrate=%d resolution=%dx%d", info.getStream().streamName,
                    //                            info.getInfo().getFps(), info.getInfo().getBitrate(), info.getInfo().getAudioBitrate(),
                    //                            info.getInfo().getWidth(), info.getInfo().getHeight()));
                    break;
                }
                case ThunderNotification.kThunderAPINotification_AudioCaptureVolume: {
                    ThunderNotification.ThunderAudioCaptureVolume info = (ThunderNotification.ThunderAudioCaptureVolume) msg.obj;

                    if (mRtcEventHandler != null) {
                        mRtcEventHandler.onCaptureVolumeIndication(info.mVolume, (int) info.mCpt, info.mMicVolume);
                    }
                    break;
                }
                case ThunderNotification.kThunderAPINotification_AudioPlayVolume: {
                    ThunderNotification.AudioVolumeInfo info = (ThunderNotification.AudioVolumeInfo) msg.obj;
                    if (info.getVolumeInfos() != null) {
                        int maxVol = 0;
                        int index = 0;
                        ArrayList<ThunderEventHandler.AudioVolumeInfo> volInfos = new ArrayList<>();
                        for (Map.Entry<Long, ThunderNotification.ThunderVolumeInfo> entry : info.getVolumeInfos().entrySet()) {
                            if (entry.getValue().mActualSpeakerUidList == null || entry.getValue().mActualSpeakerUidList.isEmpty()) {
                                continue;
                            }
                            for (long uid : entry.getValue().mActualSpeakerUidList) {
                                ThunderEventHandler.AudioVolumeInfo volInfo = new ThunderEventHandler.AudioVolumeInfo();
                                volInfo.uid = mThunderEngine.get().getStringUid(uid);
                                if (!mThunderEngine.get().mIs32bitUid) {
                                    if (volInfo.uid == null || volInfo.uid.isEmpty()) {
                                        continue;
                                    }
                                }
                                volInfo.volume = entry.getValue().mVolume;
                                volInfo.pts = (int) entry.getValue().mPts;
                                if (maxVol < volInfo.volume) {
                                    maxVol = volInfo.volume;
                                }
                                ++index;
                                volInfos.add(volInfo);
                                if ((s_playVolumeNotifyCount % 200) == 0) {
                                    ThunderLog.release(TAG, String.format("ThunderNotification.AudioPlayVolume, [%d] uid %s, volume %d",
                                            index, volInfo.uid.toString(), volInfo.volume));
                                }
                            }
                        }

                        int volSize = volInfos.size();
                        if (volSize > 0) {
                            ThunderEventHandler.AudioVolumeInfo[] volList = new ThunderEventHandler.AudioVolumeInfo[volSize];
                            for (int i = 0; i < volSize; ++i) {
                                volList[i] = volInfos.get(i);
                            }
                            if (mRtcEventHandler != null) {
                                mRtcEventHandler.onPlayVolumeIndication(volList, maxVol);
                                ++s_playVolumeNotifyCount;
                            }
                        }
                    }

                    break;
                }
                case ThunderNotification.kThunderAPINotification_BizAuthRes: {
                    ThunderNotification.BizAuthResult result = (ThunderNotification.BizAuthResult) msg.obj;
                    ThunderLog.release(TAG, String.format("ThunderNotification.BizAuthResult stream=%s group=%s result=%d",
                            result.getAuthStream() != null ? result.getAuthStream().streamName : "null",
                            result.getAuthGroup() != null ? result.getAuthGroup().groupName : "null",
                            result.getBizAuthResult()));

                    if (mRtcEventHandler != null) {
                        mRtcEventHandler.onBizAuthResult(result.isPublishAuth(), result.getBizAuthResult());
                    }
                    break;
                }
                case ThunderNotification.kThunderAPINotification_SdkAuthRes: {
                    ThunderNotification.SdkAuthResult result = (ThunderNotification.SdkAuthResult) msg.obj;
                    ThunderLog.release(TAG, String.format("ThunderNotification.SdkAuthResult appId=%d uid=%d result=%d",
                            result.getAppId(), result.getUid(), result.getSdkAuthResult()));

                    if (mRtcEventHandler != null) {
                        int authResult = result.getSdkAuthResult();
                        switch (authResult) {
                            case 0: //success
                                if (mThunderEngine.get().mIsUserBanned) {
                                    mThunderEngine.get().mIsUserBanned = false;
                                    mRtcEventHandler.onUserBanned(false);
                                }
                                break;
                            case 10005: //token expire
                                mRtcEventHandler.onTokenRequested();
                                break;
                            case 10007: //token will expire
                                mRtcEventHandler.onTokenWillExpire(mThunderEngine.get().mToken);
                                break;
                            case 10008: //band
                                mThunderEngine.get().mIsUserBanned = true;
                                mRtcEventHandler.onUserBanned(true);
                                break;
                        }

                        mRtcEventHandler.onSdkAuthResult(authResult);
                    }
                    break;
                }
                case ThunderNotification.kThunderAPINotifioation_StringUid: {
                    ThunderNotification.UidInt2String result = (ThunderNotification.UidInt2String) msg.obj;
                    mThunderEngine.get().addUid2String(result.getUidInt(), result.getUidString());
                    ThunderLog.release(TAG, String.format("ThunderNotification.UidInt2String uid=%d str=%s",
                            result.getUidInt(), result.getUidString()));
                    break;
                }
                case ThunderNotification.kThunderAPINotification_AudioPlayData: {
                    ThunderNotification.AudioDataInfo result = (ThunderNotification.AudioDataInfo) msg.obj;

                    long uid = result.getUid();
                    String strUid = mThunderEngine.get().getStringUid(uid);
                    if (!mThunderEngine.get().mIs32bitUid) {
                        if (strUid == null || strUid.isEmpty()) {
                            return;
                        }
                    }

                    int duration = result.getDuration();
                    int cpt = result.getCpt();
                    int pts = result.getPts();
                    byte[] data = result.getData();
                    int len = 0;
                    if (null != data) {
                        len = data.length;
                    }

                    if ((s_playDataNotifyCount % 500) == 0) {
                        ThunderLog.release(TAG, String.format("ThunderNotification.AudioPlayData,cpt:%d,pts:%d, len:%d", cpt, pts, len));
                    }
                    ++s_playDataNotifyCount;

                    if (mRtcEventHandler != null) {
                        mRtcEventHandler.onAudioPlayData(data, cpt, pts, strUid, duration);
                    }
                    break;
                }
                case ThunderNotification.kThunderAPINotification_AudioPlaySpectrumData: {
                    ThunderNotification.AudioPlaySpectrumData result = (ThunderNotification.AudioPlaySpectrumData) msg.obj;
                    if (mRtcEventHandler != null) {
                        mRtcEventHandler.onAudioPlaySpectrumData(result.getData());
                    }
                    break;
                }
                case ThunderNotification.kThunderAPINotification_AudioCapturePcmData: {
                    ThunderNotification.AudioCapturePcmData result = (ThunderNotification.AudioCapturePcmData) msg.obj;
                    if (mRtcEventHandler != null) {
                        mRtcEventHandler.onAudioCapturePcmData(result.getData(), result.getDataSize(), result.getSampleRate(), result.getChannel());
                    }
                    break;
                }
                case ThunderNotification.kThunderAPINotification_AudioRenderPcmData: {
                    ThunderNotification.AudioRenderPcmData result = (ThunderNotification.AudioRenderPcmData) msg.obj;
                    if (mRtcEventHandler != null) {
                        //duration = (result.getDataSize() * 1000) /  (result.getSampleRate() * result.getChannel() * 2) 单位：ms
                        mRtcEventHandler.onAudioRenderPcmData(result.getData(), result.getDataSize(), result.getDuration(), result.getSampleRate(), result.getChannel());
                    }
                    break;
                }
                case ThunderNotification.kThunderAPINotification_UserAppMsgData: {
                    ThunderNotification.UserAppMsgData result = (ThunderNotification.UserAppMsgData) msg.obj;

                    long uid = result.getUid();
                    String strUid = mThunderEngine.get().getStringUid(uid);

                    //ThunderLog.info(TAG, String.format("ThunderNotification.UserAppMsgData uid %s msgSize %d",
                    //        strUid, result.getData().length));
                    if (mRtcEventHandler != null) {
                        mRtcEventHandler.onRecvUserAppMsgData(result.getData(), strUid);
                    }
                    break;
                }
                case ThunderNotification.kThunderAPINotification_AppMsgDataFailedStatus: {
                    ThunderNotification.AppMsgDataFailedStatus result = (ThunderNotification.AppMsgDataFailedStatus) msg.obj;
                    ThunderLog.info(TAG, String.format("ThunderNotification.AppMsgDataFailedStatus status=%d",
                            result.getFailedStatus()));
                    if (mRtcEventHandler != null) {
                        mRtcEventHandler.onSendAppMsgDataFailedStatus(result.getFailedStatus());
                    }
                    break;
                }
                case ThunderNotification.kThunderAPINotification_InitiateHttpsRequest: {
                    ThunderNotification.InitiateHttpsRequest result =
                            (ThunderNotification.InitiateHttpsRequest) msg.obj;
                    String reqUrl = result.getReqUrl();
                    int target = result.getTarget();
                    ThunderLog.info(TAG, String.format("ThunderNotification.InitiateHttpsRequest " +
                            "reqUrl=%s target=%d", reqUrl, target));
                    if (mHttpsRequestHandler != null) {
                        mHttpsRequestHandler.send(reqUrl, target);
                    }
                    break;
                }
                case ThunderNotification.kThunderAPINotification_PublishChannelStreamInfo: {
                    ThunderNotification.PublishRoomStreamInfo info = (ThunderNotification.PublishRoomStreamInfo) msg.obj;
                    ThunderLog.info(TAG, "*************** (Not deal in thunderbolt)PublishRoomStreamInfo ***************");
                    ThunderLog.info(TAG, "ThunderNotification.PublishRoomStreamInfo roomID:" + info.getRoomId() + " streams:" + info.getStreams().size());
                    for (ThunderStream oneStream : info.getStreams()) {
                        ThunderLog.info(TAG, String.format("ThunderNotification.PublishRoomStreamInfo stream name:%s speak id:%d appid:%d", oneStream.streamName, oneStream.speakerUid, oneStream.appId));
                    }
                    ThunderLog.info(TAG, "*************** *********************************************** ***************");
                    break;
                }
                case ThunderNotification.kThunderAPINotification_StreamsNotify: {
                    ThunderNotification.StreamsNotify info = (ThunderNotification.StreamsNotify) msg.obj;
                    ThunderLog.info(TAG, "*************** kThunderAPINotification_StreamsNotify ***************");
                    ThunderLog.info(TAG, "ThunderNotification.StreamsNotify roomID:" + info.getRoomId() + " streams:" + info.getStreams().size());
                    for (ThunderStream oneStream : info.getStreams()) {
                        ThunderLog.info(TAG, String.format("ThunderNotification.StreamsNotify stream name:%s speak id:%d appid:%d", oneStream.streamName, oneStream.speakerUid, oneStream.appId));
                    }
                    ThunderLog.info(TAG, "*************** *********************************************** ***************");
                    mThunderEngine.get().onStreamsNotify(info);
                    break;
                }
                case ThunderNotification.kThunderAPINotification_ResolutionChangeInfo: {
//                        ThunderNotification.OnVideoSizeChange info = (ThunderNotification.OnVideoSizeChange) msg.obj;
//                        mRtcEventHandler.onVideoSizeChanged(info.getUid(),info.getWidth(),info.getHeight(),0);
                    ThunderNotification.ResolutionChangeInfo info = (ThunderNotification.ResolutionChangeInfo) msg.obj;
                    ThunderAPI.sharedInstance().getPlayer().setSubscribeStreamWHByUid(info.getStream().speakerUid, info.getWidth(), info.getHeight());
                    mRtcEventHandler.onVideoSizeChanged(mThunderEngine.get().getStringUid(info.getStream().speakerUid), info.getWidth(), info.getHeight(), 0);
                    break;
                }
                case ThunderNotification.kThunderAPINotification_UserMuteAudio: {
                    ThunderNotification.UserMuteAudio result = (ThunderNotification.UserMuteAudio) msg.obj;
                    if (mRtcEventHandler != null && mThunderEngine.get().getIsThunder()) {
                        mRtcEventHandler.onRemoteAudioStopped(Long.toString(result.getUid()), result.isMuted());
                    }
                    break;
                }
                case ThunderNotification.kThunderAPINotification_UserJoined: {
                    ThunderNotification.UserJoined result = (ThunderNotification.UserJoined) msg.obj;
                    if (mRtcEventHandler != null && mThunderEngine.get().getIsThunder()) {
                        int elapsed = (int) (System.currentTimeMillis() - mThunderEngine.get().joinEnd);
                        mRtcEventHandler.onUserJoined(Long.toString(result.getUid()), elapsed);
                    }
                    break;
                }
                case ThunderNotification.kThunderAPINotification_UserOffline: {
                    ThunderNotification.UserOffline result = (ThunderNotification.UserOffline) msg.obj;
                    if (mRtcEventHandler != null && mThunderEngine.get().getIsThunder()) {
                        mRtcEventHandler.onUserOffline(Long.toString(result.getUid()), result.getReason());
                    }
                    break;
                }
                case ThunderNotification.kThunderAPINotification_NetworkQuality: {
                    ThunderNotification.NetworkQuality result = (ThunderNotification.NetworkQuality) msg.obj;
                    if (mRtcEventHandler != null) {
                        mRtcEventHandler.onNetworkQuality(Long.toString(result.getUid()),
                                result.getTxQuality(), result.getRxQuality());
                    }
                    break;
                }
                case ThunderNotification.kThunderAPINotification_RoomStats: {
                    ThunderNotification.RoomStats result = (ThunderNotification.RoomStats) msg.obj;
                    if (mRtcEventHandler != null) {
                        mRtcEventHandler.onRoomStats(result);
                    }
                    break;
                }
                case ThunderNotification.kThunderAPINotification_RtmpStreamNotify2Service: {
                    ThunderNotification.RtmpStreamNotify2Service result = (ThunderNotification.RtmpStreamNotify2Service) msg.obj;
                    if (mRtcEventHandler != null) {
                        mRtcEventHandler.onPublishStreamToCDNStatus(result.getUrl(), result.getAction());
                    }
                    break;
                }
                case ThunderNotification.kThunderAPINotification_TransLinkStatus: {
                    //joinRoom后才会收到该消息
                    ThunderNotification.TransLinkStatus result = (ThunderNotification.TransLinkStatus) msg.obj;
                    mTransLinkStatus = result.getStatus();

                    checkDisconnectedStatus();
                    if (mServiceLinkStatus == THUNDER_CONNECTION_STATUS_CONNECTED) {
                        removeMessages(ThunderNotification.kThunderAPINotification_CheckLinkConnectionStatus);
                    }

                    if (mRtcEventHandler != null) {
                        if (mThunderEngine.get().getIsThunder()) {
                            mRtcEventHandler.onConnectionStatus(result.getStatus());
                        } else {
                            if (mTransLinkStatus == THUNDER_CONNECTION_STATUS_CONNECTED) {
                                if (mServiceLinkStatus == THUNDER_CONNECTION_STATUS_CONNECTED) {
                                    mRtcEventHandler.onConnectionStatus(result.getStatus());
                                }
                            } else {
                                mRtcEventHandler.onConnectionStatus(result.getStatus());
                            }
                        }
                    }
                    break;
                }
                case ThunderNotification.kThunderAPINotification_ServiceLinkStatus: {
                    ThunderNotification.ServiceLinkStatus result = (ThunderNotification.ServiceLinkStatus) msg.obj;
                    mServiceLinkStatus = result.getStatus();

                    checkDisconnectedStatus();
                    if (mServiceLinkStatus == THUNDER_CONNECTION_STATUS_CONNECTED) {
                        removeMessages(ThunderNotification.kThunderAPINotification_CheckLinkConnectionStatus);
                    }

                    if (mRtcEventHandler != null) {
                        if (mRtcEventHandler != null) {
                            if (mThunderEngine.get().isJoinRoom) {
                                if (mServiceLinkStatus == THUNDER_CONNECTION_STATUS_CONNECTED) {
                                    if (mTransLinkStatus == THUNDER_CONNECTION_STATUS_CONNECTED) {
                                        mRtcEventHandler.onConnectionStatus(mServiceLinkStatus);
                                    }
                                } else {
                                    mRtcEventHandler.onConnectionStatus(mServiceLinkStatus);
                                }
                            } else {
                                mRtcEventHandler.onConnectionStatus(mServiceLinkStatus);
                            }
                        }
                    }
                    break;
                }
                case ThunderNotification.kThunderAPINotification_CheckLinkConnectionStatus: {
                    if (mRtcEventHandler != null) {
                        mRtcEventHandler.onConnectionLost();
                    }
                    break;
                }
                default:
                    break;
            } }catch (Exception exc) {
                ThunderLog.error(TAG, String.format("handleMessage err=%s", exc.toString()));
            }
        }

        /**
         * 检查与 service/avp 的连接是否已断开（如果已经断开，每10秒发送一次
         * ThunderNotification.kThunderAPINotification_CheckLinkConnectionStatus 消息
         *
         * @return true:连接已断开 false:连接没断开
         */
        public boolean checkDisconnectedStatus() {
            if (mServiceLinkStatus == THUNDER_CONNECTION_STATUS_DISCONNECTED ||
                    mTransLinkStatus == THUNDER_CONNECTION_STATUS_DISCONNECTED) {
                removeMessages(ThunderNotification.kThunderAPINotification_CheckLinkConnectionStatus);
                sendEmptyMessageDelayed(ThunderNotification.kThunderAPINotification_CheckLinkConnectionStatus, 10 * 1000);
                return true;
            }
            return false;
        }

    }

    // param type define

    /**
     * 混响参数
     */
    public static final class ReverbExParameter {
        /**
         * 房间大小; 范围: [0~100]
         */
        public float mRoomSize = 0;
        /**
         * 预延时; 范围: [0~200]
         */
        public float mPreDelay = 0;
        /**
         * 混响度; 范围: [0~100]
         */
        public float mReverberance = 0;
        /**
         * 高频因子; 范围: [0~100]
         */
        public float mHfDamping = 0;
        /**
         * 低频量; 范围: [0~100]
         */
        public float mToneLow = 0;
        /**
         * 高频量; 范围: [0~100]
         */
        public float mToneHigh = 0;
        /**
         * 湿增益; 范围: [-20~10]
         */
        public float mWetGain = 0;
        /**
         * 干增益; 范围: [-20~10]
         */
        public float mDryGain = 0;
        /**
         * 立体声宽度; 范围: [0~100]
         */
        public float mStereoWidth = 0;
    }

    /**
     * 压缩参数
     */
    public static final class CompressorParam {
        /**
         * 阈值; 范围: [-40~0]
         */
        public int mThreshold = 0;
        /**
         * 增益
         */
        public int mMakeupGain = 0;
        /**
         * 比例
         */
        public int mRatio = 0;
        /**
         * 斜率
         */
        public int mKnee = 0;
        /**
         * 释放时间; 范围: 大于0
         */
        public int mReleaseTime = 0;
        /**
         * 启动时间; 范围: 大于0
         */
        public int mAttackTime = 0;
    }

    /**
     * 限制器参数
     */
    public static final class LimterParam {
        /*
         *  -30 ~ 0
         */
        public float fCeiling = 0;
        /*
         *  -10 ~ 0
         */
        public float fThreshold = 0;
        /*
         *   0 ~ 30
         */
        public float fPreGain = 0;
        /*
         *  0 ~ 1000
         */
        public float fRelease = 0;
        /*
         *  0 ~ 1000
         */
        public float fAttack = 0;
        /*
         *   0 ~ 8
         */
        public float fLookahead = 0;
        /*
         * 0.5 ~ 2
         */
        public float fLookaheadRatio = 0;
        /*
         * 0 ~ 100
         */
        public float fRMS = 0;
        /*
         * 0 ~ 1
         */
        public float fStLink = 0;
    }

    //static info
    private static int sMyAppId = 0;
    private static long sMySceneId = 0;

    private static ThunderEventHandler mRtcEventHandler;

    // https request handler
    private static ThunderHttpsRequestHandler mHttpsRequestHandler;

    private static int mServiceLinkStatus = THUNDER_CONNECTION_STATUS_DISCONNECTED;   // service 连接状态
    private static int mTransLinkStatus = THUNDER_CONNECTION_STATUS_DISCONNECTED;     // avp 连接状态

    //my info
    private long mMyUid = 0;
    //uid info
    private Map<Long, String> mUidToStringMap = new HashMap<Long, String>();
    private boolean mIs32bitUid = true;
    private String mMyStrUid = "";

    //sdk auth info
    private boolean mIsUserBanned = false;
    private byte[] mToken;

    //log info
    private static String mLogPath = "";
    private static int mLogLevel = ThunderRtcConstant.LogLevel.THUNDER_LOG_LEVEL_TRACE;
    private static IThunderLogCallback mYyLogCallback = null;

    //audio srbscribe
    private boolean mBGroupSubscribe = false;
    private boolean mBAudioPublish = false;
    private boolean mBVideoPublish = false;
    private String mStringName = "";
    private String mVideoStringName = "";

    //room info
    private int mRoomAppId = 0;
    private String mRoomName = "";

    //room profile
    private int mRoomConfig = ThunderRtcConstant.RoomConfig.THUNDER_ROOMCONFIG_LIVE;
    //audio profile
    private int mAudioConfig = ThunderRtcConstant.AudioConfig.THUNDER_AUDIO_CONFIG_DEFAULT;
    private int mCommutMode = ThunderRtcConstant.CommutMode.THUNDER_COMMUT_MODE_DEFAULT;
    private int mScenarioMode = ThunderRtcConstant.ScenarioMode.THUNDER_SCENARIO_MODE_DEFAULT;

    private boolean mBEnablePlayDataIndication = false;
    private static int s_playVolumeNotifyCount = 0;
    private static int s_playDataNotifyCount = 0;
    private static NotificationHandler mHandler = null;

    // Equalizer
    private int[] mEqGains = new int[11];
    private boolean mBEnableEqualizer = false;
    private boolean mBEnableCompressor = false;
    private boolean mBEnableLimiter = false;
    private boolean mBEnableReverbEx = false;
    private ReverbExParameter mReverbExGains = new ReverbExParameter();
    private CompressorParam mCompressorGains = new CompressorParam();
    private LimterParam mLimiterGins = new LimterParam();

    //Video
    private boolean mBOnlyReleaseCamera = false;

    // audioFilePlayer
    private Set<ThunderAudioFilePlayer> mAudioFilePlayerSet = new TreeSet<ThunderAudioFilePlayer>();

    public String getRoomName() {
        return mRoomName;
    }

    public String getMyUid() {
        return mMyStrUid;
    }


    // param for thunder bolt
    private Boolean isJoinRoom = false;
    private Boolean isThunder = false;
    private Boolean isBoltJoin = false;

    private Boolean isEnableAudio = true;
    private Boolean isEnableVideo = true;
    private Boolean isStopAllVideo = false;
    private Boolean isStopAllAudio = false;
    private Boolean isStopLocalVideo = false;
    private Boolean isPreview = false;
    private Boolean isOtherSource = false;
    private Boolean needNotify = false;
    private int accompanyType = -1;

    private static Context appContext = null;
    private SurfaceView rtcSurfaceView = null;

    private long joinStart = 0;
    private long joinEnd = 0;

    private ThunderVideoCanvas localCanvas = null;
    private static ThunderPreviewView staticYYLivePreview = null;
    //    private ThunderVideoCanvas remoteCanvas = null;
    private ArrayList<ThunderVideoCanvas> remoteCanvas = new ArrayList<ThunderVideoCanvas>(0);
    private int thunderBoltProfile = THUNDER_PROFILE_DEFAULT;
    private int playType = ThunderConstant.ThunderPublishPlayType.THUNDERPUBLISH_PLAY_SINGLE;
    private int resolutionMode = -1;
    private ThunderVideoEncoderConfiguration mThunderVideoEncoderConfiguration = new ThunderVideoEncoderConfiguration();
    private ArrayList<ThunderStream> anchorStreams = new ArrayList<ThunderStream>(0);
    private ArrayList<ThunderStream> wholeStreams = new ArrayList<ThunderStream>(0);
    private Map<String, ArrayList<ThunderStream>> channelStreamsList = new HashMap<>();  // 支持跨频道
    private Map<String, Set<Long>> subscribeStreamMap = new HashMap<>(); // 跨频道的流
    private Map<String, Boolean> uidMuteVideoList = new HashMap<>();
    private Map<String, Boolean> uidMuteAudioList = new HashMap<>();
    private final Object streamLock = new Object();

    // external data
    private ExternalAudioSource mAudioSource = null;

    //ThunderBolt订阅和开播到群组
    private boolean mTbSubscribeGroup = false;
    private boolean mTbPublishGroup = false;

    //64uid
    private boolean mRecv64UidMap = false;

    private boolean mIsFrontCamera = true;

    // End of Para


    private ThunderEngine() {
    }

    private static class SingleonHolder {
        private static ThunderEngine INSTANCE = new ThunderEngine();
    }

    private static synchronized ThunderEngine createRtcEngine(Context context,
                                                              String appId,
                                                              long sceneId,
                                                              ThunderEventHandler handler) {
        if (SingleonHolder.INSTANCE == null) {
            SingleonHolder.INSTANCE = new ThunderEngine();
        }

        // 如果已经被创建过，就不再初始化x
        if (!mIsInited) {
            mRtcEventHandler = handler;
            mHttpsRequestHandler = new ThunderHttpsRequestHandler();

            sMyAppId = Integer.parseInt(appId);
            sMySceneId = sceneId;

            // 部分机型需要手动先于yyvideoplayer库加载ffmpeg 和 ittiam .
            {
                System.loadLibrary("ffmpeg-neon");
                System.loadLibrary("Ittiamhevcdec");
            }
            ThunderAPI.sharedInstance().initWithAppId(sMyAppId, sMySceneId, context);
            mIsInited = true;
        }

        return SingleonHolder.INSTANCE;
    }

    /**
     * 创建RtcEngine对象
     * <br>仅支持一个实例
     * <br>在yylivesdk.yy.com上创建app后，系统会分配唯一appId，初始化后appId不能修改
     *
     * @param context Andoird APP 的上下文
     * @param appId   接入app的唯一标识
     * @param handler ThunderEventHandler 是一个提供了缺省实现的抽象类，SDK 通过该抽象类向应用程序报告 SDK 运行时的各种事件\
     * @return YYLiveRtcEngine对象
     * @sceneId 场景Id
     */
    public static synchronized ThunderEngine createEngine(Context context,
                                                          String appId,
                                                          long sceneId,
                                                          ThunderEventHandler handler) {

        ThunderEngine rtcEngine = createRtcEngine(context, appId, sceneId, handler);

        if (mHandler == null) {
            mHandler = new NotificationHandler(rtcEngine);
        }

        appContext = context;

//        localCanvas = new ThunderVideoCanvas(yPreviewView,1,null);


        return rtcEngine;
    }

    public void onStreamsNotify(ThunderNotification.StreamsNotify streamInfo) {
        ArrayList<ThunderStream> curChannelStreams = streamInfo.getStreams();
        if (curChannelStreams == null) {
            return;
        }

        //同频道和跨频道连麦情况都需要处理
        ThunderAPI.sharedInstance().handleTrancodingQuerySubscribeStream(streamInfo);

        ArrayList<ThunderStream> addStreams = new ArrayList<ThunderStream>();             // 需要增加订阅的流
        ArrayList<ThunderStream> removeStreams = new ArrayList<ThunderStream>();          // 需要退订的流

        //filter self
        synchronized (streamLock) {
            Iterator<ThunderStream> it = curChannelStreams.iterator();
            while (it.hasNext()) {
                ThunderStream stream = it.next();
                if (!mIs32bitUid) {
                    if (stream.uid64.length() > 0) {
                        addUid2String(stream.speakerUid, stream.uid64);
                    }
                }

                //过滤自己的
                if ((getLongUid(mMyStrUid) == stream.speakerUid)) {
                    it.remove();
                } else {

                    /**
                     * 跨频道流通知过滤, 需要过滤掉没有通过{@link addSubscribe}接口进行跨频道订阅的uid
                     * 1、当只设置了混画任务 但是没有订阅时 subscribeStreamMap为null，但是有流通知此时也应该过滤掉
                     * 2、当跨频道订阅时 需要过滤掉同一个频道离没有订阅的spkUid
                     */
                    if (!streamInfo.getRoomId().equals(mRoomName)) {
                        Set<Long> streamSet = subscribeStreamMap.get(streamInfo.getRoomId());
                        if ((streamSet == null || streamSet.isEmpty()) ||
                                (streamSet != null && !streamSet.contains(stream.speakerUid))) {
                            it.remove();
                        }
                    }
                }
            }

            ArrayList<ThunderStream> oldStreamsInChannel = channelStreamsList.get(streamInfo.getRoomId());
            if (oldStreamsInChannel != null) {
                // 对比查找需要增加订阅的流
                for (ThunderStream newStream : curChannelStreams) {
                    boolean isFind = false;
                    for (ThunderStream oldStream : oldStreamsInChannel) {
                        if (newStream.streamName.equals(oldStream.streamName)) {
                            isFind = true;
                        }
                    }
                    if (!isFind) {
                        addStreams.add(newStream);
                    }
                }
                // 对比查找需要退订的流
                for (ThunderStream oldStream : oldStreamsInChannel) {
                    boolean isFind = false;
                    for (ThunderStream newStream : curChannelStreams) {
                        if (newStream.streamName.equals(oldStream.streamName)) {
                            isFind = true;
                        }
                    }
                    if (!isFind) {
                        removeStreams.add(oldStream);
                        // 如果之前已经订阅，则删除
                        if (anchorStreams.contains(oldStream)) {
                            anchorStreams.remove(oldStream);
                        }
                    }
                }
            } else {
                addStreams.addAll(curChannelStreams);
            }

            isJoinRoom = true;
            notifyJoinSuccess();

            // Notify stream change
            for (ThunderStream stream : removeStreams) {
                if (stream.bVideo) {
                    ThunderLog.release(ThunderLog.kLogTagRtcEngine, "onRemoteVideoStopped id:" + stream.speakerUid + " isStop:" + true);
                    mRtcEventHandler.onRemoteVideoStopped(getStringUid(stream.speakerUid), true);
                } else {
                    ThunderLog.release(ThunderLog.kLogTagRtcEngine, "onRemoteAudioStopped id:" + stream.speakerUid + " isStop:" + true);
                    mRtcEventHandler.onRemoteAudioStopped(getStringUid(stream.speakerUid), true);
                }
            }

            for (ThunderStream stream : addStreams) {
                if (stream.bVideo) {
                    ThunderLog.release(ThunderLog.kLogTagRtcEngine, "onRemoteVideoStopped id:" + stream.speakerUid + " isStop:" + false);
                    mRtcEventHandler.onRemoteVideoStopped(getStringUid(stream.speakerUid), false);
                } else {
                    ThunderLog.release(ThunderLog.kLogTagRtcEngine, "onRemoteAudioStopped id:" + stream.speakerUid + " isStop:" + false);
                    mRtcEventHandler.onRemoteAudioStopped(getStringUid(stream.speakerUid), false);
                }
            }

            // 去除黑名单音视频流
            it = addStreams.iterator();
            while (it.hasNext()) {
                boolean isMute;
                ThunderStream stream = it.next();
                if (stream.bVideo) {
                    isMute = isMuteVideoStreamWithUid(stream.speakerUid);
                } else {
                    isMute = isMuteAudioStreamWithUid(stream.speakerUid);
                }

                if (isMute) {
                    it.remove();
                } else if (stream.bVideo && remoteCanvas != null) {
                    // 订阅前需要重新绑定 YRVideoCanvas（如果之前有设置的话）
                    for (ThunderVideoCanvas canvas : remoteCanvas) {
                        if ((getLongUid(canvas.mUid) == stream.speakerUid)) {
                            stream.toView = canvas.mView;
                            stream.scaleMode = canvas.mRenderMode;
                        }
                    }
                }
            }

            wholeStreams.clear();
            channelStreamsList.put(streamInfo.getRoomId(), curChannelStreams);
            for (Map.Entry<String, ArrayList<ThunderStream>> entry : channelStreamsList.entrySet()) {
                wholeStreams.addAll(entry.getValue());
            }
            anchorStreams.addAll(addStreams);
        }

        if (removeStreams.size() > 0) {
            ThunderAPI.sharedInstance().getPlayer().stopPlayStreams(removeStreams, null);
        }

        if (addStreams.size() > 0) {
            ThunderAPI.sharedInstance().getPlayer().startPlayStreams(addStreams, null);
        }

    }

    private void notifyJoinSuccess() {
        if (isJoinRoom && needNotify && mRecv64UidMap) {
            joinEnd = System.currentTimeMillis();
            needNotify = false;

            int timeElapse = (int) (joinEnd - joinStart);
            ThunderLog.release(ThunderLog.kLogTagRtcEngine, "onJoinRoomSuccess:" + mMyStrUid
                    + "-" + getLongUid(mMyStrUid) + "," + timeElapse);

            tbGroupSubscribe(); //进入频道成功才订阅群组，对应离开频道的退订逻辑；
            mRtcEventHandler.onJoinRoomSuccess(mRoomName, mMyStrUid, timeElapse);
        }
    }

    /**
     * 创建RtcEngine对象
     * <br>仅支持一个实例
     * <br>在yylivesdk.yy.com上创建app后，系统会分配唯一appId，初始化后appId不能修改
     *
     * @param context Andoird APP 的上下文
     * @param appId   接入app的唯一标识
     * @param handler ThunderEventHandler 是一个提供了缺省实现的抽象类，SDK 通过该抽象类向应用程序报告 SDK 运行时的各种事件
     * @return YYLiveRtcEngine对象
     * @sceneId 场景Id
     * @loop 回调执行线程
     */
    public static synchronized ThunderEngine createWithLoop(Context context,
                                                            String appId,
                                                            long sceneId,
                                                            ThunderEventHandler handler,
                                                            Looper loop) {
        ThunderEngine rtcEngine = createRtcEngine(context, appId, sceneId, handler);

        if (mHandler == null) {
            mHandler = new NotificationHandler(rtcEngine, loop);
        }

        return rtcEngine;
    }

    /**
     * 销毁RtcEngine对象
     */
    public static synchronized void destroyEngine() {
        // 如果已经被销毁，就不再卸载
        if (mIsInited) {
            SingleonHolder.INSTANCE.leaveRoom();
            ThunderAPI.sharedInstance().deInit();
            mIsInited = false;
            SingleonHolder.INSTANCE.resetRtcEngine();
            SingleonHolder.INSTANCE = null;
        }
    }

    /**
     * sdk版本号
     *
     * @return sdk版本号，非空
     */
    public static String getVersion() {
        return ThunderAPI.sharedInstance().getVersion();
    }


    /**
     * 设置日志文件路径（打开日志）
     *
     * @param filePath 日志文件路径（路径为空表示关闭日志）
     * @return
     */
    public static int setLogFilePath(String filePath) {
        mLogPath = filePath;
        if (filePath == null || filePath.isEmpty()) {
            ThunderAPI.enableLog(false, mLogLevel, mLogPath, null);
        } else {
            ThunderAPI.enableLog(true, mLogLevel, mLogPath, null);
        }
        return 0;
    }

    /**
     * 设置日志回调
     *
     * @praam IThunderLogCallback 日志回调(callback = null 表示关闭日志）
     * 设置了日志回调，则setLogFile无效；
     */
    public static int setLogCallback(IThunderLogCallback callback) {
        mYyLogCallback = callback;

        if (mYyLogCallback != null) {
            ThunderAPI.enableLog(true, mLogLevel, "", mYyLogCallback);
        } else {
            ThunderAPI.enableLog(false, mLogLevel, "", mYyLogCallback);
        }

        return 0;
    }

    /**
     * 设置日志级别
     *
     * @param filter ThunderRtcConstant.LogLevel
     * @return
     */
    public static int setLogLevel(int filter) {
        mLogLevel = filter;
        return 0;
    }

    public int setParameters(String options) {
        try {
            JSONObject obj = new JSONObject(options);
            mTbSubscribeGroup = obj.getBoolean("JoinWithSubscribeGroup");
            mTbPublishGroup = obj.getBoolean("PublishAudioToGroup");
            ThunderNative.tbPublishGroup(mTbPublishGroup);

            ThunderLog.release(TAG, String.format("[tbg] setParameters JoinWithSubscribeGroup=%b PublishAudioToGroup=%b",
                    mTbSubscribeGroup, mTbPublishGroup));

        } catch (Exception exc) {
            ThunderLog.release(TAG, String.format("setParameters err=%s", exc.toString()));

            return -1;
        }

        return 0;
    }

    private void tbGroupSubscribe() {
        ThunderLog.release(TAG, "tbGroupSubscribe");

        if (!mTbSubscribeGroup) {
            return;
        }

        if (mBGroupSubscribe) {
            return;
        }

        ArrayList<ThunderGroup> audioGroup = new ArrayList<ThunderGroup>(0);
        ThunderGroup oneGroup = new ThunderGroup();

        oneGroup.appId = mRoomAppId;
        oneGroup.groupName = "g_" + mRoomName;
        audioGroup.add(oneGroup);

        ThunderLog.release(TAG, "[tbg] tbGroupSubscribe");
        ThunderAPI.sharedInstance().getPlayer().startPlayStreams(null, audioGroup);

        mBGroupSubscribe = true;
    }

    private void tbStopGroupSubscribe() {
        ThunderLog.release(TAG, "[tbg] tbStopGroupSubscribe");

        if (!mTbSubscribeGroup) {
            return;
        }

        if (mBGroupSubscribe) {
            ArrayList<ThunderGroup> audioGroup = new ArrayList<ThunderGroup>(0);
            ThunderGroup oneGroup = new ThunderGroup();
            oneGroup.appId = mRoomAppId;
            oneGroup.groupName = "g_" + mRoomName;
            audioGroup.add(oneGroup);

            ThunderAPI.sharedInstance().getPlayer().stopPlayStreams(null, audioGroup);
            mBGroupSubscribe = false;
        }
    }

    /**
     * 设置场景Id
     *
     * @param sceneId 自定义场景Id
     */
    public void setSceneId(long sceneId) {
        sMySceneId = sceneId;
        ThunderAPI.sharedInstance().setSceneId(sceneId);
    }

    /**
     * 功能1：进入频道前调用有效，可选择进入纯音频频道或者音视频频道；（默认为音视频） 功能2：设置频道属性；
     *
     * @param config            默认0：音视频模式 1：音视频模式 2：纯音频模式
     * @param roomConfig={@link ThunderRtcConstant.RoomConfig
     *                          THUNDER_ROOMCONFIG_LIVE = 直播模式（流畅）
     *                          THUNDER_ROOMCONFIG_COMMUNICATION = 通话模式（延时低）
     *                          THUNDER_ROOMCONFIG_GAME = 游戏（省流量、延时低）}
     * @return 成功或失败
     */
    public int setRoomConfig(int config, int roomConfig) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setRoomConfig: config=%d roomConfig:%d", config, roomConfig);

        //调用joinChannel后，就应该设置不生效
        if (joinStart != 0) {
            return -1;
        }

        if (isJoinRoom) {
            return -2;
        }

        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setChannelProfile: working");

        if (config == THUNDER_PROFILE_ONLY_AUDIO) {
            isThunder = true;
        } else {
            isThunder = false;
        }

        mRoomConfig = roomConfig;

        boolean bLowLatency = false;

        switch (mRoomConfig) {
            case ThunderRtcConstant.RoomConfig.THUNDER_ROOMCONFIG_LIVE: {
                bLowLatency = false;
            }
            break;
            case ThunderRtcConstant.RoomConfig.THUNDER_ROOMCONFIG_COMMUNICATION:
            case ThunderRtcConstant.RoomConfig.THUNDER_ROOMCONFIG_GAME: {
                bLowLatency = true;
            }
            break;
            case ThunderRtcConstant.RoomConfig.THUNDER_ROOMCONFIG_MULTIAUDIOROOM: {
                bLowLatency = true;
            }
            break;
            default:
                break;
        }
        ThunderAPI.sharedInstance().setRoomConfig(mRoomConfig);
        ThunderAPI.sharedInstance().enableLowLatency(bLowLatency);
        return config;
    }

    /**
     * 设置区域（国外用户必须调用此接口）
     *
     * @param area 取值范围YYLiveRtcConstant.AreaType
     * @return
     */
    public int setArea(int area) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setArea: area=%d", area);

        int iResult = 0;
        int transSdkArea = ThunderConstant.ThunderAreaType.THUNDERAREA_DEFAULT; //domestic;
        switch (area) {
            case ThunderRtcConstant.AreaType.THUNDER_AREA_DEFAULT:
                transSdkArea = ThunderConstant.ThunderAreaType.THUNDERAREA_DEFAULT; //default-domestic;
                break;
            case ThunderRtcConstant.AreaType.THUNDER_AREA_FOREIGN:
                transSdkArea = ThunderConstant.ThunderAreaType.THUNDERAREA_FOREIGN; //foreign;
                break;
            case ThunderRtcConstant.AreaType.THUNDER_AREA_RESERVED:
                transSdkArea = ThunderConstant.ThunderAreaType.THUNDERAREA_RESERVED;
                break;
            default:
                iResult = -1;
                break;
        }

        ThunderAPI.sharedInstance().setAreaType(transSdkArea);
        return iResult;
    }


    /**
     * 开启跟websdk兼容后内部禁止编码B帧，因为websdk不能正常解码B帧(要求开播前调用，跟进退频道无关)
     *
     * @param enabled 是否开启兼容，默认关闭
     * @return
     */
    public int enableWebSdkCompatibility(boolean enabled) {
        ThunderNative.enableWebSdkCompatibility(enabled);
        return 0;
    }


    /**
     * 指定是否使用64位uid，要求进频道前调用
     *
     * @param is64bitUid 默认值:false，使用无符号32位uid
     * @return
     */
    public int setUse64bitUid(boolean is64bitUid) {
        mIs32bitUid = !is64bitUid;
        return 0;
    }

    /**
     * 加入频道，在同一个频道内的用户可以互相通话，多个用户加入同一个频道，可以群聊。不同appId不互通
     *
     * @param token    参见renewToken {@link ThunderEngine##updateToken(byte[])}
     * @param roomName 频道名称(需保证一个AppId内唯一)，只支持[A,Z],[a,z],[0,9],-,_等字符的排列组合，且长度不能超过64个字节
     * @param uid      用户id，32 位无符号整数，需要保证唯一
     * @return 成功或失败
     */

    public int joinRoom(byte[] token, String roomName, String uid) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "joinRoom: roomName=%s, uid=%s, " +
                        "is32bitUid=%b, token=%s", getPrintString(roomName),
                getPrintString(uid), mIs32bitUid, getPrintString(token));


        if (!isValidRoomStream(roomName)) {
            return -1;
        }

        if (uid == null || uid.isEmpty()) {
            return -2;
        }

        mMyStrUid = uid;
        if (mIs32bitUid) {
            try {
                mMyUid = Long.parseLong(uid);
                mRecv64UidMap = true;
            } catch (NumberFormatException exception) {
                return -4;
            }
        }

        mRoomName = roomName;
        mRoomAppId = sMyAppId;

        if (isThunder) {
            //voice only sdk
            ThunderNative.setVoiceOnlySdk(true);
        } else {
            ThunderNative.setVoiceOnlySdk(false);
        }

        //register notification
        ThunderAPI.sharedInstance().registerNotificationHandler(mHandler);

        //token
        ThunderAPI.sharedInstance().updateToken(token);

        ThunderNative.setChannelName(mRoomName);

        //token
        mToken = token;
        ThunderAPI.sharedInstance().updateToken(token);

        //join
        if (mIs32bitUid) {
            ThunderNative.setUserInfo(mMyUid, 0);
            ThunderAPI.sharedInstance().joinMedia(mMyUid);
        } else {
            ThunderAPI.sharedInstance().joinMedia(mMyStrUid, 0, 0);
        }

        //user role
        ThunderAPI.sharedInstance().setUserRole(ThunderConstant.ThunderUserRole.THUNDERUSER_ROLE_ANCHOR);

        //subscribe

        if (isThunder) {
            joinRoomThunder();
        } else {
            joinRoomThunderBolt();
        }

        joinStart = System.currentTimeMillis();
        needNotify = true;
        return 0;
    }

    private boolean joinRoomThunder() {

        if (mBGroupSubscribe) {
            return false;
        }

        ArrayList<ThunderGroup> audioGroup = new ArrayList<ThunderGroup>(0);
        ThunderGroup oneGroup = new ThunderGroup();

        oneGroup.appId = mRoomAppId;
        oneGroup.groupName = "g_" + mRoomName;
        audioGroup.add(oneGroup);

        ThunderAPI.sharedInstance().getPlayer().startPlayStreams(null, audioGroup);

        mBGroupSubscribe = true;
        needNotify = false;
        return true;

    }


    private boolean joinRoomThunderBolt() {
        boolean res = ThunderAPI.sharedInstance().joinRoom(mRoomName, mMyStrUid, ThunderConstant.ThunderUserRole.THUNDERUSER_ROLE_ANCHOR, mIs32bitUid);
        if (res) {
            isBoltJoin = true;
        }

        return true;
    }

    private boolean isValidRoomStream(String roomName) {
        if (roomName == null || roomName.isEmpty()) {
            return false;
        }

        int length = roomName.length();
        if (length > 64) {
            return false;
        }
        int codePoint;
        int validCharCount = 0;
        for (int i = 0; i < length; i++) {
            codePoint = Character.codePointAt(roomName, i);
            if (codePoint == 45 || codePoint == 95         // - _
                    || (codePoint >= 48 && codePoint <= 57)    // [0,9]
                    || (codePoint >= 65 && codePoint <= 90)    // [A,Z]
                    || (codePoint >= 97 && codePoint <= 122))  // [a,z]
            {
                validCharCount += 1;
            }
        }
        if (validCharCount == length) {
            return true;
        }
        ThunderLog.error(ThunderLog.kLogTagRtcEngine, "found invalid char in roomName!");
        return false;
    }


    /**
     * 离开频道
     *
     * @return
     */
    public int leaveRoom() {
        //unregisterNotificationHandler会导致收不到离开频道消息
        //unregister notification
        //ThunderAPI.sharedInstance().unregisterNotificationHandler(mHandler);

        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "leaveRoom");

        if (isThunder) {
            leaveRoomThunder();
        } else {

            if (!isJoinRoom) {
                return -2;
            }
            leaveRoomThunderBolt();
        }

        //clear uids
        removeAllUid2String();

        isStopLocalVideo = false;

        accompanyType = -1;
        isJoinRoom = false;

        isEnableAudio = true;
        isEnableVideo = true;
        isStopAllVideo = false;
        isStopAllAudio = false;

        joinStart = 0;
        joinEnd = 0;

        mRoomName = "";

        synchronized (streamLock) {
            wholeStreams.clear();
            anchorStreams.clear();
            channelStreamsList.clear();
            //Todo remove views
            remoteCanvas.clear();
            subscribeStreamMap.clear();
        }

        return 0;
    }

    private int leaveRoomThunder() {
        if (!mBGroupSubscribe) {
            return -1;
        }

        tryStopPublish();
        tryStopSubscribe();
        ThunderAPI.sharedInstance().leaveMedia();
        mBGroupSubscribe = false;
        return 0;
    }

    private int leaveRoomThunderBolt() {
        tbStopGroupSubscribe();

        tryStopPublish();
        tryStopSubscribe();

        tryStopVideoSubscribe();
        tryStopVideoPublish();
        ThunderAPI.sharedInstance().getPublishRoom().attachVideoCapture(ThunderAPI.sharedInstance().getPublisher().getDefaluteCamera());
        tryStopVideoPreview();

        ThunderAPI.sharedInstance().leaveRoom();

        ThunderEventHandler.RoomStats status = new ThunderEventHandler.RoomStats();
        mRtcEventHandler.onLeaveRoom(status);
        return 0;
    }

    /**
     * 更新token，用于appid和业务功能鉴权
     * <br> token 格式
     * <br> -------------------------------------------------------------------------------------------------
     * <br> | TokenLen(uint16)    | AppId(uint32)        | uid (uint64)          | Timestamp(uint64)(ms)    |
     * <br> -------------------------------------------------------------------------------------------------
     * <br> | ValidTime(uint32)(s)| BizExtInfoLen(uint16)| BizExtInfoData(nBytes)| DigitalSignature(20Bytes)|
     * <br> -------------------------------------------------------------------------------------------------
     * <br> 1. 多字节整数使用网络字节序
     * <br> 2. TokenLen：整个token长度，包括自身2字节和摘要
     * <br> 3. 过期时间=Timestamp+ValidTime*1000, UTC时间距离1970的毫秒数
     * <br> 4. BizExtInfoData: 业务鉴权可能需要的扩展信息，透传
     * <br> 5. DigitalSignature：采用hmac-sha1算法对DigitalSignature前的所有数据运算得出[TokenLen,BizExtInfoData], 秘钥使用申请appId时分配的appSecret
     * <br> 6. 整个token 进行 url安全的 base64编码
     *
     * @param token 业务服务器生成的token，需要url base64编码
     *              <p>
     *              通过监听通知 kThunderAPINotification_BizAuthRes, kThunderAPINotification_SdkAuthRes获取鉴权结果
     *              {@link ThunderNotification#kThunderAPINotification_BizAuthRes}
     *              {@link ThunderNotification#kThunderAPINotification_SdkAuthRes}
     */
    public int updateToken(byte[] token) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "updateToken: %s ", getPrintString(token));

        mToken = token;
        ThunderAPI.sharedInstance().updateToken(token);
        return 0;
    }

    /**
     * 打开音频采集，并开播到频道
     *
     * @return
     */
    public int enableAudioEngine() {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "enableAudioEngine isThunder:" + isThunder);

        isEnableAudio = true;

        if (isThunder) {
            //必须在joinRoom之后调用
            if (!mBGroupSubscribe) {
                return -1;
            }

            if (mBAudioPublish) {
                return -2;
            }

            mStringName = "a_" + mMyUid + "_" + mRoomName;
            String groupName = "g_" + mRoomName;

            ArrayList<String> groupList = new ArrayList<String>();
            groupList.add(groupName);
            ThunderPublishAudioConfig config = new ThunderPublishAudioConfig(ThunderPublishAudioConfig.YYPUBLISH_AUDIO_MODE_LOWDELAY_NORMALFLOW_MEDIUMQUALITY_VOIP);
            config.bUseAudioProfile = true;
            config.roomConfig = mRoomConfig;
            config.audioConfig = mAudioConfig;
            config.commutMode = mCommutMode;
            config.scenarioMode = mScenarioMode;

            mBAudioPublish = true;


            ThunderAPI.sharedInstance().getPublisher().startPublishAudio(mStringName, groupList, config);
        } else {
            tbGroupSubscribe();

            if (mBAudioPublish) {
                return -2;
            }

            if (isJoinRoom) {
                // 重新订阅音频流
                ArrayList<ThunderStream> startStreams = new ArrayList<ThunderStream>(0);
                synchronized (streamLock) {
                    for (ThunderStream oneStream : wholeStreams) {
                        boolean isMute;
                        if (!oneStream.bVideo && !anchorStreams.contains(oneStream)) {
                            isMute = isMuteAudioStreamWithUid(oneStream.speakerUid);
                            if (!isMute) {
                                startStreams.add(oneStream);
                                anchorStreams.add(oneStream);
                            }
                        }
                    }
                }
                if (startStreams.size() > 0) {
                    ThunderAPI.sharedInstance().getPlayer().startPlayStreams(startStreams, null);
                }

                // 重新开播音频
                if (!mBAudioPublish) {
                    ThunderAPI.sharedInstance().getPublishRoom().updateProfile(mRoomConfig,
                            mAudioConfig, mCommutMode, mScenarioMode);
                    ThunderAPI.sharedInstance().getPublishRoom().setAudioEnable(true);
                    if (accompanyType >= 0) {
                        ThunderAPI.sharedInstance().getPublisher().setAudioSourceType(accompanyType);
                    }
                    mBAudioPublish = true;
                }
            }

        }

        return 0;
    }

    /**
     * 关闭音频采集，停止开播到频道
     * <p>
     * ps：目前thunder下仅停播但还有订阅，thunderbolt下不仅停播还停止订阅；
     * 若在2.2以后版本统一thunder和thunderbolt逻辑后请更新该方法注释；
     *
     * @return
     */
    public int disableAudioEngine() {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "disableAudioEngine isThunder:" + isThunder);
        if (isThunder) {
            tryStopPublish();
        } else {
            if (isEnableAudio) {
                tbStopGroupSubscribe();

                ArrayList<ThunderStream> stopStreams = new ArrayList<ThunderStream>(0);
                synchronized (streamLock) {
                    for (ThunderStream oneStream : anchorStreams) {
                        if (!oneStream.bVideo) {
                            stopStreams.add(oneStream);
                        }
                    }
                }
                ThunderAPI.sharedInstance().getPlayer().stopPlayStreams(stopStreams, null);
                tryStopPublish();

                ArrayList<ThunderStream> audioStreams = new ArrayList<ThunderStream>(0);
                synchronized (streamLock) {
                    for (ThunderStream oneStream : anchorStreams) {
                        if (!oneStream.bVideo) {
                            audioStreams.add(oneStream);
                        }
                    }
                    for (ThunderStream oneStream : audioStreams) {
                        anchorStreams.remove(oneStream);
                    }
                }
                audioStreams.clear();
//                removeAddSubscribeUserStream(false);

                isEnableAudio = false;
            }
        }
        return 0;
    }

    /**
     * 设置音频属性，参数待定
     *
     * @param profile      ThunderRtcConstant.AudioConfig
     * @param commutMode   ThunderRtcConstant.CommutMode
     * @param scenarioMode ThunderRtcConstant.ScenarioMode
     * @return
     */
    public int setAudioConfig(int profile,
                              int commutMode,
                              int scenarioMode) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setAudioConfig: profile=%d, commutMode=%d, " +
                "scenarioMode=%d", profile, commutMode, scenarioMode);

        mAudioConfig = profile;
        mCommutMode = commutMode;
        mScenarioMode = scenarioMode;
        return 0;
    }

    /**
     * 设置是否外放
     *
     * @param enabled
     * @return
     */
    public int enableLoudspeaker(boolean enabled) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "enableLoudspeaker: %b", enabled);

        ThunderAPI.sharedInstance().getPlayer().enableLoudSpeaker(enabled);
        return 0;
    }

    /**
     * 是否是扬声器状态
     *
     * @return
     */
    public boolean isLoudspeakerEnabled() {
        return ThunderAPI.sharedInstance().getPlayer().getLoudSpeakerEnabled();
    }

    /**
     * 打开用户音量回调
     *
     * @param interval    <=0: 禁用音量提示功能 >0: 回调间隔，单位为毫秒
     * @param moreThanThd 从<moreThanThd到>=moreThanThd，立即回调一次 <=0无效
     * @param lessThanThd 从>=lessThanThd到<lessThanThd，立即回调一次 <=0无效
     * @param smooth      平滑系数，未实现
     * @return
     */
    public int setAudioVolumeIndication(int interval,
                                        int moreThanThd,
                                        int lessThanThd,
                                        int smooth) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setAudioVolumeIndication: interval=%d," +
                "moreThanThd=%d, lessThanThd=%d, smooth=%d", interval, moreThanThd, lessThanThd, smooth);

        ThunderAPI.sharedInstance().setPlayVolumeInterval(interval, moreThanThd, lessThanThd);
        return 0;
    }

    /**
     * 打开采集音量回调
     *
     * @param interval    <=0: 禁用音量提示功能 >0: 回调间隔，单位为毫秒
     * @param moreThanThd 从<moreThanThd到>=moreThanThd，立即回调一次 <=0无效
     * @param lessThanThd 从>=lessThanThd到<lessThanThd，立即回调一次 <=0无效
     * @param smooth      未实现
     * @return
     */
    public int enableCaptureVolumeIndication(int interval,
                                             int moreThanThd,
                                             int lessThanThd,
                                             int smooth) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "enableCaptureVolumeIndication: interval=%d," +
                "moreThanThd=%d, lessThanThd=%d, smooth=%d", interval, moreThanThd, lessThanThd, smooth);

        ThunderAPI.sharedInstance().setCaptureVolumeInterval(interval, moreThanThd, lessThanThd);
        return 0;
    }

    /**
     * 开始将音频数据保存成aac格式的文件
     *
     * @param fileName  文件保存路径,必须是完整路径，包括文件名，文件名的后缀必须是.aac。其中保存文件的文件夹必须是已经创建好的，该接口不提供创建文件夹的功能。例如：/sdcard/helloworld.aac
     * @param saverMode =ThunderRtcConstant.AudioSaverMode.
     *                  THUNDER_AUDIO_SAVER_ONLY_CAPTURE = 只保存频道内所有的上行的音频数据。上行的音频数据指的是：无论是主播的音频数据还是是伴奏的音频数据，只有被设置成上行，才被保存
     *                  THUNDER_AUDIO_SAVER_ONLY_RENDER = 保存频道内除主播以外的音频数据，例如：伴奏的音频数据和观众端的音频数据
     *                  THUNDER_AUDIO_SAVER_BOTH = 保存频道内所有的音频数据
     * @param fileMode  = ThunderRtcConstant.AudioSaverWfMode.
     *                  THUNDER_AUDIO_SAVER_FILE_APPEND = 追加打开一个文本文件，并在文件末尾写数据
     *                  THUNDER_AUDIO_SAVER_FILE_OVERRIDE = 打开一个文本文件，写入的数据会覆盖文件本身的内容
     * @return true:成功 false:失败
     */
    public boolean startAudioSaver(String fileName, int saverMode, int fileMode) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "startAudioSaver: fileName=%s," +
                "saverMode=%d, fileMode=%d", getPrintString(fileName), saverMode, fileMode);

        if (fileName.isEmpty()) {
            return false;
        }
        return ThunderAPI.sharedInstance().startAudioSaver(fileName, saverMode, fileMode);
    }

    /**
     * 停止将音频数据保存成aac格式的文件
     *
     * @return true:成功 false:失败
     */
    public boolean stopAudioSaver() {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "stopAudioSaver");

        return ThunderAPI.sharedInstance().stopAudioSaver();
    }

    /**
     * 设置不同的音效模式
     *
     * @param mode =ThunderRtcConstant.SoundEffectMode.
     *             THUNDER_SOUND_EFFECT_MODE_NONE               = 关闭模式
     *             THUNDER_SOUND_EFFECT_MODE_VALLEY             = VALLEY模式
     *             THUNDER_SOUND_EFFECT_MODE_RANDB              = R&B模式
     *             THUNDER_SOUND_EFFECT_MODE_KTV                = KTV模式
     *             THUNDER_SOUND_EFFECT_MODE_CHARMING           = CHARMING模式
     *             THUNDER_SOUND_EFFECT_MODE_POP                = 流行模式
     *             THUNDER_SOUND_EFFECT_MODE_HIPHOP             = 嘻哈模式
     *             THUNDER_SOUND_EFFECT_MODE_ROCK               = 摇滚模式
     *             THUNDER_SOUND_EFFECT_MODE_CONCERT            = 演唱会模式
     *             THUNDER_SOUND_EFFECT_MODE_STUDIO             = 录音棚模式
     */
    public void setSoundEffect(int mode) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "ThunderEngine::setSoundEffect %d", mode);

        ThunderAPI.sharedInstance().getPublisher().setSoundEffect(mode);
    }

    /**
     * 设置变声模式
     *
     * @param mode =ThunderRtcConstant.VoiceChangerMode.
     *             THUNDER_VOICE_CHANGER_NONE                = 关闭模式
     *             THUNDER_VOICE_CHANGER_ETHEREAL            = 空灵
     *             THUNDER_VOICE_CHANGER_THRILLER            = 惊悚
     *             THUNDER_VOICE_CHANGER_LUBAN               = 鲁班
     *             THUNDER_VOICE_CHANGER_LORIE               = 萝莉
     *             THUNDER_VOICE_CHANGER_UNCLE               = 大叔
     *             THUNDER_VOICE_CHANGER_DIEFAT              = 死肥仔
     *             THUNDER_VOICE_CHANGER_BADBOY              = 熊孩子
     *             THUNDER_VOICE_CHANGER_WRACRAFT            = 魔兽农民
     *             THUNDER_VOICE_CHANGER_HEAVYMETAL          = 重金属
     *             THUNDER_VOICE_CHANGER_COLD                = 感冒
     *             THUNDER_VOICE_CHANGER_HEAVYMECHINERY      = 重机械
     *             THUNDER_VOICE_CHANGER_TRAPPEDBEAST        = 困兽
     *             THUNDER_VOICE_CHANGER_POWERCURRENT        = 强电流
     */
    public void setVoiceChanger(int mode) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "ThunderEngine::setVoiceChanger %d", mode);
        ThunderAPI.sharedInstance().getPublisher().setVoiceChanger(mode);
    }


    /**
     * 是否静音自己
     *
     * @param stop
     * @return
     */
    public int stopLocalAudioStream(boolean stop) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "stopLocalAudioStream: %b isThunder:%b", stop, isThunder);

        if (isThunder) {
            int volume = 80;
            if (stop) {
                volume = 0;
            }
            ThunderAPI.sharedInstance().getPublisher().setMicVolume(volume);
        } else {

            //Todo isJoinroom
            if (stop) {
                if (mBAudioPublish) {
                    ThunderAPI.sharedInstance().getPublishRoom().setAudioEnable(false);
                    mBAudioPublish = false;
                }
            } else {
                if (!mBAudioPublish && isJoinRoom) {
                    ThunderAPI.sharedInstance().getPublishRoom().setAudioEnable(true);
                    if (accompanyType >= 0) {
                        ThunderAPI.sharedInstance().getPublisher().setAudioSourceType(accompanyType);
                    }
                    mBAudioPublish = true;
                }
            }
        }

        return 0;
    }

    /**
     * 是否静音所有播放声音
     *
     * @param stop
     * @return
     */
    public int stopAllRemoteAudioStreams(boolean stop) {
        if (isStopAllAudio == stop) {
            return 0;
        }

        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "stopAllRemoteAudioStreams: %b isThunder:%b isEnableAudio:%b isJoinRoom:%b", stop, isThunder, isEnableAudio, isJoinRoom);
        if (!isEnableAudio) {
            return -2;
        }

        //Todo isenableAudio
        if (isThunder || mTbSubscribeGroup) {
            ThunderAPI.sharedInstance().getPlayer().enableAllMute(stop);
        }

        if (!isThunder) {
            isStopAllAudio = stop;
            uidMuteAudioList.clear();

            if (stop) {
                ArrayList<ThunderStream> stopStreams = new ArrayList<ThunderStream>(0);
                synchronized (streamLock) {
                    for (ThunderStream oneStream : anchorStreams) {
                        if (!oneStream.bVideo) {
                            stopStreams.add(oneStream);
                        }
                    }
                    for (ThunderStream oneStream : stopStreams) {
                        anchorStreams.remove(oneStream);
                    }
                }
                if (isJoinRoom) {
                    ThunderAPI.sharedInstance().getPlayer().stopPlayStreams(stopStreams, null);
                }
            } else {
                ArrayList<ThunderStream> startStreams = new ArrayList<ThunderStream>(0);
                synchronized (streamLock) {
                    for (ThunderStream oneStream : wholeStreams) {
                        boolean isPlaying = false;
                        if (!oneStream.bVideo) {
                            for (ThunderStream anStream : anchorStreams) {
                                if (anStream.speakerUid == oneStream.speakerUid && !anStream.bVideo) {
                                    isPlaying = true;
                                    break;
                                }
                            }
                            if (isPlaying) {
                                continue;
                            }

                            startStreams.add(oneStream);
                            anchorStreams.add(oneStream);
                        }
                    }
                }
                if (isJoinRoom) {
                    ThunderAPI.sharedInstance().getPlayer().startPlayStreams(startStreams, null);
                }
            }
        }
        return 0;
    }

    /**
     * 是否静音某个用户的声音
     *
     * @param uid
     * @param stop
     * @return
     */
    public int stopRemoteAudioStream(String uid, boolean stop) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "stopRemoteAudioStream: uid=%s, %b isThunder:%b isEnableAudio:%b isJoinRoom:%b", getPrintString(uid), stop, isThunder, isEnableAudio, isJoinRoom);

        if (isThunder || mTbSubscribeGroup) {
            ThunderStream stream = new ThunderStream();
            stream.speakerUid = getLongUid(uid);
            if (!mIs32bitUid) {
                if (uid == null) {
                    return -2;
                }
                ThunderAPI.sharedInstance().getPlayer().enableMute(stop, uid);
                if (stream.speakerUid == 0) {
                    return 0;
                }
            }
            ThunderAPI.sharedInstance().getPlayer().enableMute(stop, stream);
        }

        if (!isThunder) {
            if (!isEnableAudio) {
                return -2;
            }

            uidMuteAudioList.put(uid, stop);

            long lUid = getLongUid(uid);
            if (stop) {
                ArrayList<ThunderStream> stopStreams = new ArrayList<ThunderStream>(0);
                synchronized (streamLock) {
                    for (ThunderStream oneStream : anchorStreams) {
                        if ((lUid == oneStream.speakerUid) && !oneStream.bVideo) {
                            stopStreams.add(oneStream);
                        }
                    }
                    for (ThunderStream oneStream : stopStreams) {
                        anchorStreams.remove(oneStream);
                    }
                }

                if (isJoinRoom) {
                    ThunderAPI.sharedInstance().getPlayer().stopPlayStreams(stopStreams, null);
                }
            } else {
                ArrayList<ThunderStream> startStreams = new ArrayList<ThunderStream>(0);
                ThunderStream newStream = null;
                boolean alreadyPlay = false;

                synchronized (streamLock) {
                    for (ThunderStream oneStream : wholeStreams) {
                        if ((lUid == oneStream.speakerUid) && !oneStream.bVideo) {
                            newStream = oneStream;
                            break;
                        }
                    }

                    if (newStream == null) {
                        return 0;
                    }

                    for (ThunderStream oneStream : anchorStreams) {
                        if ((lUid == oneStream.speakerUid) && !oneStream.bVideo) {
                            alreadyPlay = true;
                            break;
                        }
                    }

                    if (!alreadyPlay) {
                        startStreams.add(newStream);
                        anchorStreams.add(newStream);
                    }
                }

                if (isJoinRoom) {
                    ThunderAPI.sharedInstance().getPlayer().startPlayStreams(startStreams, null);
                }
            }
        }
        return 0;
    }

    /**
     * 该方法设定外放(扬声器)音量。
     *
     * @param volume
     * @return
     */
    public int setLoudSpeakerVolume(int volume) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setSpeakerphoneVolume: %d", volume);

        boolean bResult = ThunderAPI.sharedInstance().getPlayer().setSpeakerVolume(volume);

        if (bResult) {
            return 0;
        } else {
            return -1;
        }
    }

    /**
     * 设置麦克风音量
     *
     * @param volume
     * @return
     */
    public int setMicVolume(int volume) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setMicVolume: %d", volume);

        boolean bResult = ThunderAPI.sharedInstance().getPublisher().setMicVolume(volume);
        if (bResult) {
            return 0;
        } else {
            return -1;
        }
    }

    /**
     * @param uid
     * @param volume
     * @return
     */
    public int setRemoteAudioStreamsVolume(String uid, int volume) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setRemoteAudioStreamsVolume: uid=%s, volume=%d",
                getPrintString(uid), volume);

        if (isThunder) {
            if (!mBGroupSubscribe) {
                return -1;
            }
        }

        ThunderStream stream = new ThunderStream();
        stream.speakerUid = getLongUid(uid);
        if (!mIs32bitUid) {
            if (stream.speakerUid == 0) {
                return -2;
            }
        }
        if (ThunderAPI.sharedInstance().getPlayer().setPlayVolume(volume, stream)) {
            return 0;
        }
        return -4;

    }


    /**
     * 创建文件播放对象
     *
     * @return 播放器对象
     */
    public ThunderAudioFilePlayer createAudioFilePlayer() {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "createAudioFilePlayer");

        ThunderAudioFilePlayer audioFilePlayer = new ThunderAudioFilePlayer();
        mAudioFilePlayerSet.add(audioFilePlayer);
        return audioFilePlayer;
    }

    /**
     * 销毁文件播放对象
     *
     * @param audioFilePlayer
     */
    public void destroyAudioFilePlayer(ThunderAudioFilePlayer audioFilePlayer) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "destroyAudioFilePlayer: %s", getPrintString(audioFilePlayer));

        if (audioFilePlayer == null) {
            return;
        }
        audioFilePlayer.destroyAudioFilePlayer();
        mAudioFilePlayerSet.remove(audioFilePlayer);
    }

    /**
     * 使能均衡器
     *
     * @param enabled
     * @return
     */
    public int setEnableEqualizer(boolean enabled) {
        mBEnableEqualizer = enabled;
        ThunderAPI.sharedInstance().getPublisher().EnableEqualizer(enabled);
        return 0;
    }

    /**
     * 设置均衡器参数
     *
     * @param gains -12 <= gains[i] <= 12, 0<=i<=10
     * @return
     */
    public int setEqGains(final int[] gains) {
        if (gains == null) {
            return -1;
        }

        if (gains.length < 11) {
            return -2;
        }

        for (int i = 0; i <= 10; ++i) {
            if (gains[i] < -12 || gains[i] > 12) {
                return -3;
            }
        }

        mEqGains = gains;
        ThunderAPI.sharedInstance().getPublisher().SetGqGains(gains);
        return 0;
    }

    /**
     * 使能混响
     *
     * @param enabled
     * @return
     */
    public int setEnableReverb(boolean enabled) {
        mBEnableReverbEx = enabled;
        ThunderAPI.sharedInstance().getPublisher().EnableReverb(enabled);
        return 0;
    }

    /**
     * 设置混响参数
     *
     * @param param
     * @return
     * @see ReverbExParameter
     */
    public int setReverbExParameter(ReverbExParameter param) {
        if (param == null) {
            return -1;
        }

        if ((param.mRoomSize < 0.0 || param.mRoomSize > 100.0) ||
                (param.mPreDelay < 0.0 || param.mPreDelay > 200.0) ||
                (param.mReverberance < 0.0 || param.mReverberance > 100.0) ||
                (param.mHfDamping < 0.0 || param.mHfDamping > 100.0) ||
                (param.mToneLow < 0.0 || param.mToneLow > 100.0) ||
                (param.mToneHigh < 0.0 || param.mToneHigh > 100.0) ||
                (param.mWetGain < -20.0 || param.mWetGain > 10.0) ||
                (param.mDryGain < -20.0 || param.mDryGain > 10.0) ||
                (param.mStereoWidth < 0.0 || param.mStereoWidth > 100.0)
        ) {
            return -2;
        }

        mReverbExGains = param;
        ThunderAPI.sharedInstance().getPublisher().setReverbExParameter(
                param.mRoomSize,
                param.mPreDelay,
                param.mReverberance,
                param.mHfDamping,
                param.mToneLow,
                param.mToneHigh,
                param.mWetGain,
                param.mDryGain,
                param.mStereoWidth);
        return 0;
    }

    /**
     * 使能压缩器
     *
     * @param enabled
     * @return
     */
    public int setEnableCompressor(boolean enabled) {
        mBEnableCompressor = enabled;
        ThunderAPI.sharedInstance().getPublisher().EnableCompressor(enabled);
        return 0;
    }

    /**
     * 设置压缩器参数
     *
     * @param param
     * @return
     * @see CompressorParam
     */
    public int setCompressorParam(CompressorParam param) {
        if (param == null) {
            return -1;
        }

        if ((param.mThreshold < -40 || param.mThreshold > 0) ||
                (param.mReleaseTime <= 0) || (param.mAttackTime <= 0)) {
            return -2;
        }

        mCompressorGains = param;
        ThunderAPI.sharedInstance().getPublisher().SetCompressorParam(
                param.mThreshold,
                param.mMakeupGain,
                param.mRatio,
                param.mKnee,
                param.mReleaseTime,
                param.mAttackTime);
        return 0;
    }

    /**
     * 使能压限器
     *
     * @param enabled
     * @return
     */
    public int setEnableLimiter(boolean enabled) {
        mBEnableLimiter = enabled;
        ThunderAPI.sharedInstance().getPublisher().EnableLimiter(enabled);
        return 0;
    }

    /**
     * 设置压限器参数
     *
     * @param param
     * @return
     * @see LimterParam
     */
    public int setLimiterParam(LimterParam param) {
        if (param == null) {
            return -1;
        }

        mLimiterGins = param;
        ThunderAPI.sharedInstance().getPublisher().SetLimiterParam(
                param.fCeiling,
                param.fThreshold,
                param.fPreGain,
                param.fRelease,
                param.fAttack,
                param.fLookahead,
                param.fLookaheadRatio,
                param.fRMS,
                param.fStLink);
        return 0;
    }

    /**
     * 设置外部音频处理器
     *
     * @param eap, eap是个C 函数指针数组，长度为6，每个函数的类型为：
     *             typedef void (*OnCaptureStartFun)(void*obj);
     *             typedef void (*OnCaptureDataFun)(void*obj, void* pData, uint32_t len, uint32_t sampleRate, uint32_t channelCount, uint32_t bitPerSample);
     *             typedef void (*OnCaptureStopFun)(void*obj);
     *             typedef void (*OnRenderStartFun)(void*obj);
     *             typedef void (*OnRenderDataFun)(void*obj, void* pData, uint32_t len, uint32_t sampleRate, uint32_t channelCount, uint32_t bitPerSample);
     *             typedef void (*OnRenderStopFun)(void*obj);
     */
    public void setExternalAudioProcessor(long eap) {
        ThunderAPI.sharedInstance().setExternalAudioProcessor(eap);
    }

    /**
     * 打开关闭音频播放频谱数据回调
     * 如果打开了，会收到{@link ThunderEventHandler#onAudioPlaySpectrumData} 回调
     */
    public void enableAudioPlaySpectrum(boolean enable) {
        ThunderAPI.sharedInstance().enableAudioPlaySpectrum(enable);
    }

    /**
     * 设置音频播放频谱数据回调信息
     *
     * @param spectrumLen      频谱数据的长度 [12 - 256]，默认是256
     * @param notifyIntervalMS 频谱回调的间隔，必须是10的倍数，默认是30MS
     */
    public void setAudioPlaySpectrumInfo(int spectrumLen, int notifyIntervalMS) {
        ThunderAPI.sharedInstance().setAudioPlaySpectrumInfo(spectrumLen, notifyIntervalMS);
    }

    /**
     * 用户发送透传消息
     *
     * @param msgData 发送的消息
     *                <br> 调用此接口条件:
     *                1、用户在频道内
     *                2、开麦成功后调用(纯观众和开播鉴权失败都不能发)
     *                3、调用该接口的频率每秒不能超过2次,msgData的大小不能超过200Byte
     *                <br> 不满足以上条件msg都会被丢弃
     *                <br> 通过监听YYLiveRtcEventHandler中的onRecvUserAppMsgData接收其他透传的消息
     *                <br> 通过监听YYLiveRtcEventHandler中的onSendAppMsgDataFailedStatus获得发送该msg发送失败的原因
     */
    public int sendUserAppMsgData(byte[] msgData) {
        ThunderAPI.sharedInstance().sendUserAppMsgData(msgData);
        return 0;
    }

    /**
     * 打开关闭音频数据回调
     *
     * @param enablePlay 打开播放数据回调
     */
    public void enableAudioDataIndication(boolean enablePlay) {
        mBEnablePlayDataIndication = enablePlay;

        ThunderAPI.sharedInstance().enableAudioDataIndication(enablePlay);
    }

    /**
     * 打开关闭音频采集回调
     *
     * @param enable     打开采集数据回调
     * @param sampleRate 设置需要回调数据的采样率，取值范围[-1,8000,16000,44100,48000]
     * @param channel       设置需要回调数据的声道数，取值范围[-1,1,2]
     *                   <br> 只要sampleRate和channel其中一个参数的取值为-1，回调的数据是没有经过重采样的原始数据
     */
    public void enableCapturePcmDataCallBack(boolean enable, int sampleRate, int channel) {
        ThunderAPI.sharedInstance().enableCapturePcmDataCallBack(enable, sampleRate, channel);
    }

    /**
     * 打开关闭渲染音频数据回调
     *
     * @param enable     打开渲染音频数据回调
     * @param sampleRate 设置需要回调数据的采样率，取值范围[-1,8000,16000,44100,48000]
     * @param channel       设置需要回调数据的声道数，取值范围[-1,1,2]
     *                   <br> 只要sampleRate和channel其中一个参数的取值为-1，回调的数据是没有经过重采样的原始数据
     */
    public boolean enableRenderPcmDataCallBack(boolean enable, int sampleRate, int channel) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "enableRenderPcmDataCallBack enable = %b sampleRate: %d, channel = %d ", enable, sampleRate, channel);

        return ThunderAPI.sharedInstance().enableRenderPcmDataCallBack(enable, sampleRate, channel);

    }

    /**
     * 是否将当前播放的文件作为直播伴奏使用(可替代enablePublish)
     * <br>
     *
     * @param sourceType {@link ThunderRtcConstant.SourceType }
     *                   THUNDER_PUBLISH_MODE_MIC   = 0; //麦克风
     *                   THUNDER_PUBLISH_MODE_FILE  = 1; //文件
     *                   THUNDER_PUBLISH_MODE_MIX   = 2; //文件+麦克风
     *                   THUNDER_PUBLISH_MODE_NONE  = 10, //停止所有音频数据上行
     */
    public void setAudioSourceType(int sourceType) {
        ThunderLog.release(ThunderLog.kLogTagCall, "setAudioSourceType: mode=%d", sourceType);

        ThunderAPI.sharedInstance().getPublisher().setAudioSourceType(sourceType);
        accompanyType = sourceType;
    }

    /**
     * 打开关闭耳返
     *
     * @param enable true=打开，false=关闭；默认为关闭状态
     * @return
     */
    public int setEnableInEarMonitor(boolean enable) {
        ThunderLog.release(ThunderLog.kLogTagCall, "setEnableInEarMonitor: %b", enable);

        if (ThunderAPI.sharedInstance().getPublisher().enableInEarMonitor(enable)) {
            return 0;
        } else {
            return -1;
        }
    }

    public Object CreateRendererView(Context context, int type) {
        Object view = null;
        switch (type) {
            case ThunderConstant.ThunderVideoViewType.THUNDERVIDEO_VIEW_PLAYVIEW:
                view = new ThunderPlayerView(context);
                break;
            case ThunderConstant.ThunderVideoViewType.THUNDERVIDEO_VIEW_PREVIEW:
                view = new ThunderPreviewView(context);
                break;
        }
        return view;
    }

    /**
     * joinroom之前调用：设置视频开，不触发任何实际操作；
     * joinroom之后调用：前置条件满足的情况下，开播视频；
     */
    public int enableVideoEngine() {

        if (isThunder) {
            return -2;
        }

        isEnableVideo = true;

//        if(isEnableVideo) {
//            return -1;
//        }

        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "enableVideoEngine " + "," + isOtherSource);

//        //Todo judge start preview
//        if(localCanvas != null) {
//            startVideoPreview();
//        }

        // 重新订阅视频流
        if (isJoinRoom) {
            synchronized (streamLock) {
                ArrayList<ThunderStream> startStreams = new ArrayList<ThunderStream>(0);
                for (ThunderStream stream : wholeStreams) {
                    if (stream.bVideo && !anchorStreams.contains(stream)) {
                        boolean isMute = isMuteVideoStreamWithUid(stream.speakerUid);
                        if (!isMute) {
                            // 订阅前需要重新绑定 YRVideoCanvas（如果之前有设置的话）
                            for (ThunderVideoCanvas canvas : remoteCanvas) {
                                if ((getLongUid(canvas.mUid) == stream.speakerUid)) {
                                    stream.toView = canvas.mView;
                                    stream.scaleMode = canvas.mRenderMode;
                                }
                            }
                            startStreams.add(stream);
                            anchorStreams.add(stream);
                        }
                    }
                }
                if (startStreams.size() > 0) {
                    ThunderAPI.sharedInstance().getPlayer().startPlayStreams(startStreams, null);
                }
            }
        }


        if (isJoinRoom && (isPreview || isOtherSource) && !mBVideoPublish) {
            ThunderAPI.sharedInstance().getPublishRoom().setVideoEnable(true);
            mBVideoPublish = true;
        }

        return 0;
    }

    /**
     * 流程1：
     * joinRoom：加入频道，自动订阅频道内的视频流；
     * disableVideoEngine：退订频道内的视频流；如果打开预览，则关闭预览；
     * 流程2：
     * joinRoom：加入频道，自动订阅频道内的视频流；
     * enableVideoEngine：（参见enableVideo）
     * disableVideoEngine：退订频道内的视频流；如果打开预览，则关闭预览；如果已开播，则停播；
     */
    public int disableVideoEngine() {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "disableVideoEngine ");
        if (!isEnableVideo || isThunder) {
            return -1;
        }

        tryStopVideoSubscribe();
        tryStopVideoPublish();

        //恢复摄像头，镜像，前后置摄像头默认值

        ThunderDefaultCamera camera = ThunderAPI.sharedInstance().getPublisher().getDefaluteCamera();
        ThunderPreviewConfig config = (ThunderPreviewConfig) camera.getCaptureConfig();

        config.cameraPosition = THUNDERCAMERA_POSITION_FRONT;
        config.captureOrientation = THUNDER_VIDEO_CAPTURE_ORIENTATION_PORTRAIT;
        if (isPreview) {
            setLocalVideoMirrorMode(THUNDER_VIDEO_MIRROR_MODE_PREVIEW_MIRROR_PUBLISH_NO_MIRROR);
        }

        ThunderAPI.sharedInstance().getPublishRoom().attachVideoCapture(ThunderAPI.sharedInstance().getPublisher().getDefaluteCamera());

        tryStopVideoPreview();
        
        isEnableVideo = false;
        isOtherSource = false;

        return 0;
    }

    /**
     * 根据参数从Argo获取视频开播参数；
     * 如果已经预览，则在预览中生效；
     * 如果已经开播，则更新开播参数，本地预览和远端订阅会看到变化后的效果；
     */
    public int setVideoEncoderConfig(ThunderVideoEncoderConfiguration yyVideoConfig) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setVideoEncoderConfig playtype:" + yyVideoConfig.playType + " publishmode:" + yyVideoConfig.publishMode + " isEnableVideo:" + isEnableVideo);
        if (isEnableVideo && !isThunder) {
            mThunderVideoEncoderConfiguration = yyVideoConfig;

//            if (mBVideoPublish) {
            ThunderAPI.sharedInstance().getPublishRoom().updatePlayTypeAndPublishMode(yyVideoConfig.playType, yyVideoConfig.publishMode);
//            }
        } else {
            return -2;
        }
        return 0;
    }

    /**
     * 功能：设置本地视图，即预览的窗口；
     */
    public int setLocalVideoCanvas(ThunderVideoCanvas local) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setLocalVideoCanvas view:" + local.mView + " isEnableVideo:" + isEnableVideo);
        if (isEnableVideo && !isThunder) {
            if (local != null && local.mView != null) {
                staticYYLivePreview = (ThunderPreviewView) local.mView;
            }
            localCanvas = local;
        }
        return 0;
    }

    /**
     * 功能：设置远端用户视图
     * 不设置此窗口，也可以订阅；
     * 设置此窗口，则可以看到远端订阅的对应uid的流的画面；
     */
    public int setRemoteVideoCanvas(ThunderVideoCanvas remote) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setRemoteVideoCanvas view:" + remote.mView + "uid:" + remote.mUid + " isEnableVideo:" + isEnableVideo);
        if (!isEnableVideo || isThunder) {
            return -2;
        }

        if (remote == null) {
            return -1;
        }

        boolean isFind = false;
        ArrayList<ThunderStream> startStreams = new ArrayList<ThunderStream>(0);

        if (remote.mView != null) {
            synchronized (streamLock) {
                //first check view &
                for (ThunderVideoCanvas oneCanvas : remoteCanvas) {
                    if (oneCanvas.mView == remote.mView) {
                        // 如果设置的视图已经在remoteCanvas中，但是之前绑定了的uid不一样，先修改之前的绑定
                        if (!oneCanvas.mUid.equals(remote.mUid)) {
                            Long lUid = getLongUid(oneCanvas.mUid);
                            ArrayList<ThunderStream> stopStreams = new ArrayList<ThunderStream>(0);

                            for (ThunderStream oneStream : anchorStreams) {
                                if (oneStream.bVideo && (lUid == oneStream.speakerUid)) {
                                    oneStream.toView = null;
                                    oneStream.scaleMode = 1;
                                    stopStreams.add(oneStream);
                                    ThunderAPI.sharedInstance().getPlayer().stopPlayStreams(stopStreams, null);
                                    ThunderAPI.sharedInstance().getPlayer().startPlayStreams(stopStreams, null);
                                    break;
                                }
                            }

                            for (ThunderStream oneStream : wholeStreams) {
                                if (oneStream.bVideo && (lUid == oneStream.speakerUid)) {
                                    oneStream.toView = null;
                                    oneStream.scaleMode = 1;
                                    break;
                                }
                            }
                        }

                        isFind = true;
                        oneCanvas.mUid = remote.mUid;
                        oneCanvas.mRenderMode = remote.mRenderMode;
                        break;
                    }
                }

                if (!isFind) {
                    remoteCanvas.add(remote);
                }

                Long lUid = getLongUid(remote.mUid);
                for (ThunderStream oneStream : anchorStreams) {
                    if (oneStream.bVideo && (lUid == oneStream.speakerUid)) {
                        // 如果设置的视图绑定的uid已经开播，不需要重新开播
                        if (oneStream.toView != remote.mView) {
                            oneStream.toView = remote.mView;
                            oneStream.scaleMode = remote.mRenderMode;
                            startStreams.add(oneStream);
                        }
                        break;
                    }
                }

                if (startStreams.size() > 0) {
                    ThunderAPI.sharedInstance().getPlayer().stopPlayStreams(startStreams, null);
                    ThunderAPI.sharedInstance().getPlayer().startPlayStreams(startStreams, null);
                    startStreams.clear();
                }

                for (ThunderStream oneStream : wholeStreams) {
                    if (oneStream.bVideo && (lUid == oneStream.speakerUid)) {
                        oneStream.toView = remote.mView;
                        oneStream.scaleMode = remote.mRenderMode;
                        break;
                    }
                }
            }
        }
        return 0;
    }

    /**
     * 设置本地视图显示模式
     * THUNDER_RENDER_MODE_FILL(0)：铺满窗口，如果比例不适应的，会拉伸以铺满窗口；
     * THUNDER_RENDER_MODE_ASPECT_FIT(1)：适应窗口，如果比例不适应，会留黑边；
     * THUNDER_RENDER_MODE_CLIP_TO_BOUNDS(2)：铺满窗口，如果比例不适应，会截取;
     */
    public int setLocalCanvasScaleMode(int mode) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setLocalCanvasScaleMode mode:" + mode + " isEnableVideo:" + isEnableVideo);
        if (!isEnableVideo || isThunder) {
            return -2;
        }

        ThunderAPI.sharedInstance().setPreviewRenderMode(mode);
        return 0;
    }

    /**
     * 设置远端视图显示模式
     * THUNDER_RENDER_MODE_FILL(0)：铺满窗口，如果比例不适应的，会拉伸以铺满窗口；
     * THUNDER_RENDER_MODE_ASPECT_FIT(1)：适应窗口，如果比例不适应，会留黑边；
     * THUNDER_RENDER_MODE_CLIP_TO_BOUNDS(2)：铺满窗口，如果比例不适应，会截取;
     */
    public int setRemoteCanvasScaleMode(String uid, int mode) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setRemoteCanvasScaleMode Uid:" + uid + " mode:" + mode + " isEnableVideo:" + isEnableVideo);
        if (!isEnableVideo || isThunder) {
            return -2;
        }

        synchronized (streamLock) {
            for (ThunderVideoCanvas oneCanvas : remoteCanvas) {
                if (uid.equals(oneCanvas.mUid)) {
                    ThunderPlayerView remote = (ThunderPlayerView) oneCanvas.mView;
                    oneCanvas.mRenderMode = mode;
//                remote.setScaleMode(mode);
                    ThunderNative.setPlayViewScaleMode(remote, mode);
                }
            }
        }

        return 0;
    }

    /**
     * 开启视频预览
     *
     * @return
     */
    public int startVideoPreview() {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "startVideoPreview local view:" + localCanvas + " isEnableVideo:" + isEnableVideo);
        if (!isEnableVideo || isThunder || isStopLocalVideo) {
            return -2;
        }

        if (isPreview) {
            return 0;
        }

        if (mBVideoPublish && !isOtherSource && mBOnlyReleaseCamera) {
            ThunderNative.stopAndRecoverVideoEncode(false);
            mBOnlyReleaseCamera = false;
        } else {
            if (staticYYLivePreview == null) {
                staticYYLivePreview = new ThunderPreviewView(appContext);
            }
            ThunderAPI.sharedInstance().getPublishRoom().startVideoPreview(staticYYLivePreview, mThunderVideoEncoderConfiguration.playType, mThunderVideoEncoderConfiguration.publishMode);
        }
        isPreview = true;

        return 0;
    }

    /**
     * 停止视频预览
     *
     * @return
     */
    public int stopVideoPreview() {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "stopVideoPreview local view:" + localCanvas + " isEnableVideo:" + isEnableVideo + " isPreview " + isPreview
                + " mBVideoPublish " + mBVideoPublish);
        if (!isEnableVideo || isThunder) {
            return -2;
        }

        if (isPreview) {
            if (mBVideoPublish && !isOtherSource && !mBOnlyReleaseCamera) {
                ThunderNative.stopAndRecoverVideoEncode(true);
                mBOnlyReleaseCamera = true;
            } else {
                ThunderAPI.sharedInstance().getPublishRoom().stopVideoPreview();

            }
            if (localCanvas != null && localCanvas.mView != null) {
                isPreview = false;
            }
        }

        return 0;
    }

    /**
     * 开关本地视频采集
     *
     * @return
     */
    public int enableLocalVideoCapture(boolean enable) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "enableLocalVideoCapture localCanvas:" + localCanvas + " isEnableVideo:" + isEnableVideo);
        if (!isEnableVideo || isThunder) {
            return -2;
        }

        if (enable == false) {
            tryStopVideoPublish();
            tryStopVideoPreview();
            isStopLocalVideo = true;
        } else {
            isStopLocalVideo = false;
        }
        return 0;
    }

    /**
     * 开关本地视频发送
     *
     * @return
     */
    public int stopLocalVideoStream(boolean stop) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "stopVideoPreview stopLocalVideoStream:" + stop + " isEnableVideo:" + isEnableVideo + ",isOtherSource" + isOtherSource
                + " isMuteLocalVideo " + isStopLocalVideo + " isPreview " + isPreview);
        if (!isEnableVideo || isThunder || isStopLocalVideo) {
            return -2;
        }

        if (stop) {
            if (mBVideoPublish) {
                ThunderAPI.sharedInstance().getPublishRoom().setVideoEnable(false);
                mBVideoPublish = false;
                mVideoStringName = "";
            }
        } else {
            if (isJoinRoom && !mBVideoPublish && (isPreview || isOtherSource)) {
                ThunderAPI.sharedInstance().getPublishRoom().setVideoEnable(true);
                mBVideoPublish = true;
            }

        }
        return 0;
    }

    /**
     * 接收/停止接收指定视频流
     *
     * @return
     */
    public int stopRemoteVideoStream(String uid, boolean stop) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "stopRemoteVideoStream Uid:" + uid + " stop:" + stop + " isEnableVideo:" + isEnableVideo);
        if (!isEnableVideo || isThunder) {
            return -2;
        }

        uidMuteVideoList.put(uid, stop);

        long lUid = getLongUid(uid);
        if (stop) {
            ArrayList<ThunderStream> stopStreams = new ArrayList<ThunderStream>(0);
            synchronized (streamLock) {
                for (ThunderStream oneStream : anchorStreams) {
                    if ((lUid == oneStream.speakerUid) && oneStream.bVideo) {
                        stopStreams.add(oneStream);
                    }
                }
                for (ThunderStream oneStream : stopStreams) {
                    anchorStreams.remove(oneStream);
                }
            }

            if (isJoinRoom) {
                ThunderAPI.sharedInstance().getPlayer().stopPlayStreams(stopStreams, null);
            }
        } else {
            ArrayList<ThunderStream> startStreams = new ArrayList<ThunderStream>(0);
            ThunderStream newStream = null;
            boolean alreadyPlay = false;

            synchronized (streamLock) {
                for (ThunderStream oneStream : wholeStreams) {
                    if ((lUid == oneStream.speakerUid) && oneStream.bVideo) {
                        newStream = oneStream;
                        break;
                    }
                }
                //可以在进频道前设置
                if (newStream == null) {
                    return 0;
                }

                for (ThunderStream oneStream : anchorStreams) {
                    if ((lUid == oneStream.speakerUid) && oneStream.bVideo) {
                        alreadyPlay = true;
                        break;
                    }
                }

                if (!alreadyPlay) {
                    if (remoteCanvas != null) {
                        for (ThunderVideoCanvas oneCanvas : remoteCanvas) {
                            if ((getLongUid(oneCanvas.mUid) == newStream.speakerUid)) {
                                newStream.toView = oneCanvas.mView;
                                newStream.scaleMode = oneCanvas.mRenderMode;
                            }
                        }
                    }
                    startStreams.add(newStream);
                    anchorStreams.add(newStream);
                }
            }

            if (isJoinRoom) {
                ThunderAPI.sharedInstance().getPlayer().startPlayStreams(startStreams, null);
            }
        }

        return 0;
    }

    /**
     * 接收/停止接收所有视频流
     *
     * @return
     */
    public int stopAllRemoteVideoStreams(boolean stop) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "stopAllRemoteVideoStreams  stop:" + stop + " isEnableVideo:" + isEnableVideo);
        if (!isEnableVideo || isThunder) {
            return -2;
        }
        if (isStopAllVideo == stop) {
            return 0;
        }

        isStopAllVideo = stop;
        uidMuteVideoList.clear();

        if (stop) {
            ArrayList<ThunderStream> stopStreams = new ArrayList<ThunderStream>(0);
            synchronized (streamLock) {
                for (ThunderStream oneStream : anchorStreams) {
                    if (oneStream.bVideo) {
                        stopStreams.add(oneStream);
                    }
                }
                for (ThunderStream oneStream : stopStreams) {
                    anchorStreams.remove(oneStream);
                }
            }
            if (isJoinRoom) {
                ThunderAPI.sharedInstance().getPlayer().stopPlayStreams(stopStreams, null);
            }
        } else {
            ArrayList<ThunderStream> startStreams = new ArrayList<ThunderStream>(0);
            synchronized (streamLock) {
                for (ThunderStream oneStream : wholeStreams) {
                    boolean isPlaying = false;
                    if (oneStream.bVideo) {

                        for (ThunderStream anStream : anchorStreams) {
                            if (anStream.speakerUid == oneStream.speakerUid && anStream.bVideo) {
                                isPlaying = true;
                                break;
                            }
                        }
                        if (isPlaying) {
                            continue;
                        }

                        if (remoteCanvas != null) {
                            for (ThunderVideoCanvas oneCanvas : remoteCanvas) {
                                if ((getLongUid(oneCanvas.mUid) == oneStream.speakerUid)) {
                                    oneStream.toView = oneCanvas.mView;
                                    oneStream.scaleMode = oneCanvas.mRenderMode;
                                }
                            }
                        }

                        startStreams.add(oneStream);
                        anchorStreams.add(oneStream);
                    }
                }
            }
            if (isJoinRoom) {
                ThunderAPI.sharedInstance().getPlayer().startPlayStreams(startStreams, null);
            }
        }

        return 0;
    }

    /**
     * {@link IFaceDetection} 接口对象实例；如果传入 null，则取消注册
     * @param faceDetection 用于设置第三方人脸到sdk，非必须,仅仅用于需要sdk拿到人脸数据
     * @return <0 返回异常 0正常
     */
    public int registerFaceDetection(IFaceDetection faceDetection) {
        if (isEnableVideo && !isThunder) {
            ThunderAPI.sharedInstance().getPublisher().setMobileFaceDetection(faceDetection);
            return 0;
        }
        return -2;
    }

    /**
     * {@link IGPUProcess} 接口对象实例；如果传入 null，则取消注册
     * @param observer 用于设置获取处理每一帧video渲染纹理的实例
     * @return <0 返回异常 0正常
     */
    public int registerVideoCaptureTextureObserver(IGPUProcess observer) {
        if (isEnableVideo && !isThunder) {
            ThunderAPI.sharedInstance().getPublisher().setVideoCaptureTexture(observer);
            return 0;
        }
        return -2;
    }

    /**
     * {@link IVideoCaptureObserver} 接口对象实例；如果传入 null，则取消注册
     * @param observer 用于设置分别获取video camera yuv采集和video渲染数据的实例
     * @return <0 返回异常 0正常
     */

    public int registerVideoCaptureFrameObserver(IVideoCaptureObserver observer) {

        if (isEnableVideo && !isThunder) {
            ThunderAPI.sharedInstance().getPublisher().setVideoCaptureFrame(observer);
            return 0;
        }
        return -2;
    }


    public int registerVideoDecodeFrameObserver(String uid, IVideoDecodeObserver observer) {

        if (isEnableVideo && !isThunder) {
            ThunderAPI.sharedInstance().getPlayer().setVideoFrameObserver(uid, observer);
            return 0;
        }
        return -2;
    }

    /**
     * {@link IAudioFrameObserver} 接口对象实例；如果传入 null，则取消注册
     *
     * @param observer
     * @return
     */
    public int registerAudioFrameObserver(IAudioFrameObserver observer) {
        return ThunderAPI.sharedInstance().registerAudioFrameObserver(observer);
    }

    /**
     * 设置回调采集数据的格式
     *
     * @param sampleRate     指定 onRecordFrame 中返回数据的采样率，可设置为 8000，16000，32000，44100 或 48000
     * @param room           指定 onRecordFrame 中返回数据的通道数，可设置为 1（单声道） 或 2（双声道）
     * @param mode           指定 onRecordFrame 的使用模式:{@link ThunderRtcConstant.ThunderAudioRawFrameOperationMode}
     * @param samplesPerCall 指定 onRecordFrame 中返回数据的采样点数，如 RTMP 推流应用中通常为 1024。
     * @return
     */
    public int setRecordingAudioFrameParameters(int sampleRate, int room, int mode, int samplesPerCall) {

        return ThunderAPI.sharedInstance().setRecordingAudioFrameParameters(sampleRate, room, mode, samplesPerCall);
    }

    /**
     * 设置回调播放数据的格式
     *
     * @param sampleRate     指定 onPlaybackFrame 中返回数据的采样率，可设置为 8000，16000，32000，44100 或 48000
     * @param room           指定 onPlaybackFrame 中返回数据的通道数，可设置为 1（单声道） 或 2（双声道）
     * @param mode           指定 onPlaybackFrame 的使用模式:{@link ThunderRtcConstant.ThunderAudioRawFrameOperationMode}
     * @param samplesPerCall 指定 onPlaybackFrame 中返回数据的采样点数，如 RTMP 推流应用中通常为 1024。
     * @return
     */
    public int setPlaybackAudioFrameParameters(int sampleRate, int room, int mode, int samplesPerCall) {
        return ThunderAPI.sharedInstance().setPlaybackAudioFrameParameters(sampleRate, room, mode, samplesPerCall);
    }


    ///////////////////

    /**
     * 添加本地视频水印 该方法将一张PNG图片你作为水印添加到本地视频上，通过本地视频一起发布出去
     * 如果待添加的 PNG 图片的尺寸与你该方法中设置的尺寸不一致，SDK 会对 PNG 图片进行裁剪，以与设置相符。
     * 当前只支持在直播视频流中添加一个水印，后添加的水印会替换掉之前添加的水印。
     * 取消设置水印接口传null即可。
     * 屏幕旋转时，水印会跟着画面一起旋转。
     *
     * @param watermark 待添加在本地直播推流中的水印图片，详细定义见{@link ThunderBoltImage}
     * @return 0：方法调用成功  < 0：方法调用失败
     */
    public int setVideoWatermark(ThunderBoltImage watermark) {
        if (!isEnableVideo || isThunder) {
            return -2;
        }

        Bitmap bitmap = null;
        int x = 0;
        int y = 0;
        if (watermark != null) {
            x = watermark.x;
            y = watermark.y;
            Bitmap tmpBitmap = BitmapFactory.decodeFile(watermark.url);

            int w = tmpBitmap.getWidth();
            int h = tmpBitmap.getHeight();

            Matrix matrix = new Matrix();
            float scaleW = ((float) watermark.width) / w;
            float scaleH = ((float) watermark.height) / h;
            matrix.postScale(scaleW, scaleH);
            bitmap = Bitmap.createBitmap(tmpBitmap, 0, 0, w, h, matrix, true);


        }
        return ThunderAPI.sharedInstance().getPublishRoom().setWatermark(x, y, bitmap);
    }

    /**
     * 设置外部音频采集参数 需要在开播音频前调用该接口 确定外部推流后再开播
     *
     * @param enabled    true：开启外部音频采集  false：关闭外部音频采集（默认）
     * @param sampleRate 外部音频源的采样率，可设置为 8000，16000，32000，44100 或 48000
     * @param channel      外部音频源的通道数（最多支持两个声道)
     * @return 0：方法调用成功  < 0：方法调用失败
     */
    public int setCustomAudioSource(boolean enabled, int sampleRate, int channel) {

        if (enabled) {

            if (mAudioSource == null) {
                mAudioSource = new ExternalAudioSource(sampleRate, channel);
            }
        } else {
            mAudioSource = null;
        }

        ThunderAPI.sharedInstance().getPublishRoom().attachAudioCapture(mAudioSource);
        return 0;
    }

    /**
     * 推送外部音频帧 需要先调用{@link ExternalAudioSource}
     *
     * @param data      外部音频数据
     * @param timeStamp 外部音频帧的时间戳，用于和外部视频源同步
     * @return 0：方法调用成功  < 0：方法调用失败
     */
    public int pushCustomAudioFrame(byte[] data, long timeStamp) {

        if (mAudioSource != null) {
            mAudioSource.pushCustomAudioFrame(data, timeStamp);
        } else {
            ThunderLog.info(ThunderLog.kLogTagRtcEngine, "ExternalAudioSource is null");
            return -1;
        }
        return 0;
    }

    /**
     * 设置自定义视频源
     *
     * @param videoSource 自定义视频源 用户需要实现{@link ThunderCustomVideoSource}接口，监听相应的方法，通过onInitialize
     *                    获得外部推流{@link ThunderVideoFrameConsumer}接口对象，然后通过consumeByteArrayFrame方法进行推流
     * @return 0：方法调用成功  < 0：方法调用失败
     */
    public int setCustomVideoSource(ThunderCustomVideoSource videoSource) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setCustomVideoSource  isThunder:" + isThunder + " isEnableVideo:" + isEnableVideo +
                "videoSource == null ?" + (videoSource == null ? true : false));
        if (!isEnableVideo || isThunder) {
            return -2;
        }

        if (videoSource == null) {
            ThunderAPI.sharedInstance().getPublishRoom().attachVideoCapture(ThunderAPI.sharedInstance().getPublisher().getDefaluteCamera());
            isOtherSource = false;
        } else if (videoSource instanceof ScreenRecordSource) {
            ThunderAPI.sharedInstance().getPublishRoom().attachVideoCapture(((ScreenRecordSource) videoSource).mScreenCapture);
            isOtherSource = true;
        } else {
            ExternalVideoSource externalVideoSource = new ExternalVideoSource(videoSource);
            ThunderAPI.sharedInstance().getPublishRoom().attachVideoCapture(externalVideoSource);
            isOtherSource = true;
        }
        return 0;
    }

    /**
     * 添加源流推流地址。该方法每次只能增加一路推流地址。若需推送多路流，则需多次调用该方法。
     * 推流地址不支持中文等特殊字符
     *
     * @param url 推流地址，格式为 RTMP
     * @return 0：添加成功  < 0: 添加用失败
     */
    public int addPublishOriginStreamUrl(String url) {
        return ThunderAPI.sharedInstance().updateSrcStreamUrlSet(true, url);
    }

    /**
     * 删除源流推流地址，该方法每次只能删除一路推流地址。若需删除多路流，则需多次调用该方法
     * 推流地址不支持中文等特殊字符
     *
     * @param url
     * @return 0：删除成功  < 0: 删除失败
     */
    public int removePublishOriginStreamUrl(String url) {
        return ThunderAPI.sharedInstance().updateSrcStreamUrlSet(false, url);
    }

    /**
     * 添加转码流的推流地址，为指定转码任务添加推流地址，该方法每次只能增加一路推流地址，若需推送多路流，则需多次调用该方法
     * 确保在调用 setLiveTransCoding 接口后再调用该接口
     *
     * @param taskId 转码任务id，表示为该taskId的转码任务添加推流地址
     * @param url    推流地址，，格式为 RTMP
     * @return 0：添加成功  < 0: 添加失败
     */
    public int addPublishTranscodingStreamUrl(String taskId, String url) {
        return ThunderAPI.sharedInstance().updateTranscodingStreamUrlMap(taskId, true, url);
    }

    /**
     * 删除转码推流地址，该方法每次只能删除一路推流地址。若需删除多路流，则需多次调用该方法
     *
     * @param taskId 转码任务id
     * @param url
     * @return 0：删除成功  < 0: 删除失败
     */
    public int removePublishTranscodingStreamUrl(String taskId, String url) {

        return ThunderAPI.sharedInstance().updateTranscodingStreamUrlMap(taskId, false, url);
    }

    /**
     * 添加or更新转码任务
     * 先调用该方法，再调用 addPublishTranscodingStreamUrl
     *
     * @param taskId      转码任务标示，由用户管理，保证同一任务taskId在频道内唯一；
     *                    不同的taskId标示不同的混画任务，用户更新转码任务时需要指定taskId；
     *                    同一频道sdk最大支持同时启动5个转码任务；
     * @param transcoding 混画布局
     * @return 0：方法调用成功  < 0: 方法调用失败
     */
    public int setLiveTranscodingTask(String taskId, LiveTranscoding transcoding) {
        return ThunderAPI.sharedInstance().updateTranscodingMap(taskId, false, transcoding);
    }

    /**
     * 删除转码任务
     *
     * @param taskId 转码任务标示 由用户管理，0-9 a-z A-Z
     * @return 0：方法调用成功  < 0: 方法调用失败
     */
    public int removeLiveTranscodingTask(String taskId) {
        return ThunderAPI.sharedInstance().updateTranscodingMap(taskId, true, null);
    }

    /**
     * 订阅用户
     *
     * @param roomId 频道号
     * @param uid    用户uid
     * @return 方法调用成功返回 0，失败返回 < 0
     */
    public int addSubscribe(String roomId, String uid) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "addSubscribe roomId %s, uid %s", roomId, uid);
        if (mRoomName.equals(roomId))
            return -1;

        long lUid = getLongUid(uid);
        synchronized (streamLock) {
            Set<Long> streamSet = subscribeStreamMap.get(roomId);
            if (streamSet == null) {
                streamSet = new HashSet<>();
            }
            streamSet.add(lUid);
            subscribeStreamMap.put(roomId, streamSet);
        }

        return ThunderAPI.sharedInstance().addSubscribe(roomId, uid);
    }

    /**
     * 删除订阅
     *
     * @param roomId 频道号
     * @param uid    用户uid
     * @return
     */
    public int removeSubscribe(String roomId, String uid) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "removeSubscribe roomId %s, uid %s", roomId, uid);
        if (mRoomName.equals(roomId))
            return -1;

        Long lUid = getLongUid(uid);
        ArrayList<ThunderStream> stopStreams = new ArrayList<ThunderStream>(0);

        //FIXME 目前跨频道连麦, 同一个频道里面只能与一个主播连麦
        synchronized (streamLock) {
            // 需要退订视频流和音频流
            Iterator<ThunderStream> it = anchorStreams.iterator();
            while(it.hasNext()){
                ThunderStream stream = it.next();
                if (stream != null && lUid == stream.speakerUid) {
                    stopStreams.add(stream);
                    it.remove();
                }
            }

            it = wholeStreams.iterator();
            while (it.hasNext()) {
                ThunderStream stream = it.next();
                if (stream != null && lUid == stream.speakerUid) {
                    it.remove();
                }
            }

            if (stopStreams.size() > 0) {
                ThunderAPI.sharedInstance().getPlayer().stopPlayStreams(stopStreams, null);
            }

            Set<Long> streamSet = subscribeStreamMap.get(roomId);
            if (streamSet != null && streamSet.contains(lUid)) {
                streamSet.remove(lUid);
                if (streamSet.size() == 0) {
                    subscribeStreamMap.remove(roomId);
                    channelStreamsList.remove(roomId);
                    return ThunderAPI.sharedInstance().removeSubscribe(roomId);
                }
            }
        }

        return 0;
    }

    /**
     * 切到前/后置摄像头，
     * 需要在开启预览后{@linkstartPreview}调用不调用该方法时引擎默认启动前置摄像头
     *
     * @param bFront true：前置摄像头  false：后置摄像头
     * @return 方法调用成功返回 0，失败返回 < 0
     */
    public int switchFrontCamera(boolean bFront) {
        boolean ret = false;
        mIsFrontCamera = bFront;
        if (bFront) {
            ret = ThunderAPI.sharedInstance().getPublishRoom().setCameraPosition(THUNDERCAMERA_POSITION_FRONT);
        } else {
            ret = ThunderAPI.sharedInstance().getPublishRoom().setCameraPosition(ThunderConstant.ThunderCameraPosition.THUNDERCAMERA_POSITION_BACK);
        }
        return ret ? 0 : -1;

    }

    /**
     * 设置摄像头开播角度（横屏/竖屏）
     *
     * @param orientation 0:竖屏 1:横屏
     *                    {@link ThunderRtcConstant.ThunderVideoCaptureOrientation}
     */
    public int setVideoCaptureOrientation(int orientation) {
        if (!isEnableVideo || isThunder) {
            return -2;
        }
        ThunderNative.setOrientation(orientation);
        return 0;
    }

    /**
     * 设置摄像头镜像(只对前置摄像头生效，后置摄像头不生效，后置摄像头固定预览推流都不镜像,
     * 前置摄像头默认预览镜像推流不镜像)
     *
     * @param mode 参加{@link ThunderRtcConstant.ThunderVideoMirrorMode}
     * @return
     */
    public int setLocalVideoMirrorMode(int mode) {
        ThunderLog.info(ThunderLog.kLogTagCall, "setLocalVideoMirrorMode %d", mode);
        if (!isEnableVideo || isThunder) {
            return -2;
        }
        if (!mIsFrontCamera) {
            return -1;
        }

        switch (mode) {
            case THUNDER_VIDEO_MIRROR_MODE_PREVIEW_MIRROR_PUBLISH_NO_MIRROR:
                ThunderNative.enablePreviewMirror(true);
                ThunderNative.enableMirror(false);
                break;
            case THUNDER_VIDEO_MIRROR_MODE_PREVIEW_PUBLISH_BOTH_MIRROR:
                ThunderNative.enablePreviewMirror(true);
                ThunderNative.enableMirror(true);
                break;
            case THUNDER_VIDEO_MIRROR_MODE_PREVIEW_PUBLISH_BOTH_NO_MIRROR:
                ThunderNative.enablePreviewMirror(false);
                ThunderNative.enableMirror(false);
                break;
            case THUNDER_VIDEO_MIRROR_MODE_PREVIEW_NO_MIRROR_PUBLISH_MIRROR:
                ThunderNative.enablePreviewMirror(false);
                ThunderNative.enableMirror(true);
                break;
            default:
                ThunderLog.info(ThunderLog.kLogTagCall, "invalid mirror mode");
                return -1;
        }

        return 0;
    }

    public boolean getIsThunder() {
        return isThunder;
    }

    private void tryStopPublish() {
        if (isThunder) {
            if (mBAudioPublish) {
                ThunderAPI.sharedInstance().getPublisher().stopPublishAudio();
                mBAudioPublish = false;
                mStringName = "";
            }
        } else {
            if (mBAudioPublish) {
                ThunderAPI.sharedInstance().getPublishRoom().setAudioEnable(false);
                mBAudioPublish = false;
                mStringName = "";
            }
        }
    }

    private void tryStopVideoPublish() {
        if (mBVideoPublish) {
            ThunderAPI.sharedInstance().getPublishRoom().setVideoEnable(false);
            mBVideoPublish = false;
            mVideoStringName = "";
        }
    }

    private boolean isNumeric(String strNum) {

        Pattern pattern = Pattern.compile("^\\d+$");
        String bigStr;
        try {
            bigStr = new BigDecimal(strNum).toString();
        } catch (Exception e) {
            return false;
        }

        Matcher isNum = pattern.matcher(bigStr);
        if (!isNum.matches()) {
            return false;
        }
        return true;
    }

    private void tryStopSubscribe() {
        if (isThunder) {
            if (mBGroupSubscribe) {
                ArrayList<ThunderGroup> audioGroup = new ArrayList<ThunderGroup>(0);
                ThunderGroup oneGroup = new ThunderGroup();
                oneGroup.appId = mRoomAppId;
                oneGroup.groupName = "g_" + mRoomName;
                audioGroup.add(oneGroup);
                ThunderAPI.sharedInstance().getPlayer().stopPlayStreams(null, audioGroup);
                mBGroupSubscribe = false;
            }
        } else {
            ArrayList<ThunderStream> stopSteams = new ArrayList<ThunderStream>(0);
            for (ThunderStream oneStream : anchorStreams) {
                if (!oneStream.bVideo) {
                    stopSteams.add(oneStream);
                }
            }
            if (stopSteams.size() > 0) {
                for (ThunderStream oneStream : stopSteams) {
                    anchorStreams.remove(oneStream.streamName);
                }
                ThunderAPI.sharedInstance().getPlayer().stopPlayStreams(stopSteams, null);
            }

//            removeAddSubscribeUserStream(false);
        }
    }

    private void tryStopVideoSubscribe() {
        ArrayList<ThunderStream> stopStreams = new ArrayList<ThunderStream>(0);
        synchronized (streamLock) {
            for (ThunderStream oneStream : anchorStreams) {
                if (oneStream.bVideo) {
                    stopStreams.add(oneStream);
//                anchorStreams.remove(oneStream);
                }
            }
            ThunderAPI.sharedInstance().getPlayer().stopPlayStreams(stopStreams, null);
            for (ThunderStream oneStream : stopStreams) {
                anchorStreams.remove(oneStream);
            }
        }

//        removeAddSubscribeUserStream(true);
    }

    private void tryStopVideoPreview() {
        if (isPreview) {
            stopVideoPreview();
            isPreview = false;
        }
    }

    private void addUid2String(long iUid, String strUid) {
        ThunderLog.release(TAG, String.format("addUid2String %d,%s", iUid, strUid));
        removeUid2String(strUid);

        if (strUid.equals(mMyStrUid)) {
            mRecv64UidMap = true;
            mMyUid = iUid;
            ThunderNative.setUserInfo(iUid, 0);
            notifyJoinSuccess();
        }

        synchronized (this) {
            mUidToStringMap.put(iUid, strUid);
        }
    }

    private String getStringUid(long iUid) {
        if (mIs32bitUid) {
            return String.valueOf(iUid);
        }

        String strUid;
        synchronized (this) {
            strUid = mUidToStringMap.get(iUid);
        }

        //远端用户可能使用32位uid，所以map中没法匹配到
        if (strUid == null || strUid.isEmpty()) {
            strUid = Long.toString(iUid);
        }

        return strUid;
    }

    private long getLongUid(String strUid) {
        long iUid = 0;

        if (mIs32bitUid) {
            try {
                iUid = Long.parseLong(strUid, 10);
            } catch (NumberFormatException exception) {
                iUid = 0;
            }

            return iUid;
        }

        synchronized (this) {
            if (strUid != null && strUid.length() != 0) {
                Iterator<Long> iter = mUidToStringMap.keySet().iterator();
                Long key;
                while (iter.hasNext()) {
                    key = iter.next();
                    if (strUid.equals(mUidToStringMap.get(key))) {
                        iUid = key;
                        break;
                    }
                }
            }
        }

        //远端用户可能使用32位uid，所以map中没法匹配到
        if (iUid == 0) {
            if (isNumeric(strUid)) {
                try {
                    iUid = Long.parseLong(strUid, 10);
                } catch (NumberFormatException exception) {
                    iUid = 0;
                }
            }
        }

        return iUid;
    }

    private void removeUid2String(int iUid) {
        synchronized (this) {
            mUidToStringMap.remove(iUid);
        }
    }

    private void removeUid2String(String strUid) {
        synchronized (this) {
            if (strUid != null && strUid.length() != 0) {
                Iterator<Long> iter = mUidToStringMap.keySet().iterator();
                Long key;
                while (iter.hasNext()) {
                    key = iter.next();
                    if (strUid.equals(mUidToStringMap.get(key))) {
                        mUidToStringMap.remove(key);
                        break;
                    }
                }
            }
        }
    }

    private void removeAllUid2String() {
        //根据服务器的逻辑，映射关系是不变的，所以不需要清理
//        synchronized (this){
//            mUidToStringMap.clear();
//        }
    }

    private void resetRtcEngine() {
        //static info
        mHandler = null;
        sMyAppId = 0;
        sMySceneId = 0;

        mRtcEventHandler = null;
        mHttpsRequestHandler = null;

        //my info
        mMyUid = 0;
        mIs32bitUid = false;
        mMyStrUid = "";
        //uid info
        mUidToStringMap = new HashMap<Long, String>();

        //log info
        mLogLevel = ThunderRtcConstant.ThunderLogLevel.THUNDERLOG_LEVEL_TRACE;
        mLogPath = "";
        mYyLogCallback = null;

        //audio srbscribe
        mBGroupSubscribe = false;
        mBAudioPublish = false;

        //room info
        mRoomAppId = 0;

        //room profile
        mRoomConfig = ThunderRtcConstant.RoomConfig.THUNDER_ROOMCONFIG_LIVE;
        //audio profile
        mAudioConfig = ThunderRtcConstant.AudioConfig.THUNDER_AUDIO_CONFIG_DEFAULT;
        mCommutMode = ThunderRtcConstant.CommutMode.THUNDER_COMMUT_MODE_DEFAULT;
        mScenarioMode = ThunderRtcConstant.ScenarioMode.THUNDER_SCENARIO_MODE_DEFAULT;

        //switch
        s_playVolumeNotifyCount = 0;
        s_playDataNotifyCount = 0;
        mBEnablePlayDataIndication = false;

        // Equalizer
        mEqGains = new int[11];
        mBEnableEqualizer = false;
        mBEnableCompressor = false;
        mBEnableLimiter = false;
        mBEnableReverbEx = false;
        mReverbExGains = new ReverbExParameter();
        mCompressorGains = new CompressorParam();
        mLimiterGins = new LimterParam();

        // audioFilePlayer
        for (ThunderAudioFilePlayer audioFilePlayer : mAudioFilePlayerSet) {
            audioFilePlayer.destroyAudioFilePlayer();
        }
        mAudioFilePlayerSet.clear();

        accompanyType = -1;

        isStopLocalVideo = false;
    }

    private String getPrintString(String str) {
        String result = "";
        if (str != null) {
            result = str;
        }

        return result;
    }

    private String getPrintString(byte[] data) {
        String result = "";
        if (data != null) {
            result = data.toString();
        }

        return result;
    }

    private String getPrintString(Object obj) {
        String result = "";
        if (obj != null) {
            result = obj.toString();
        }
        return result;
    }

    /**
     * 1. 如果视频模块总开关是关闭状态，则不能订阅任何流，需要取消订阅所有流；
     * 2. 如果视频模块总开关是开启的，则先根据用户设置黑白名单mutelist来决定是否可以进行订阅操作，
     * false表示需要订阅，true表示取消订阅；其中mutelist列表只可以通过用户调用moteRemote接
     * 口设置，内部不可以修改；
     * 3. 如果视频模块总开关是开启的，但是uid不在用户设置的黑白名单mutelist里，则根据用户设置的默
     * 认值muteAll执行，true false表示需要订阅，true表示取消订阅；
     *
     * @param uid
     * @return
     */
    private boolean isMuteVideoStreamWithUid(long uid) {
        if (!isEnableVideo)
            return true;

        Boolean result = uidMuteVideoList.get(getStringUid(uid));
        if (result != null) {
            return result;
        }

        return isStopAllVideo;
    }

    /**
     * 同isMuteVideoStreamWithUid
     *
     * @param uid
     * @return
     */
    private boolean isMuteAudioStreamWithUid(long uid) {
        if (!isEnableAudio)
            return true;

        Boolean result = uidMuteAudioList.get(getStringUid(uid));
        if (result != null) {
            return result;
        }

        return isStopAllAudio;
    }

    public static void notifyNetworkTypeChanged(int netState) {
        if (mRtcEventHandler != null) {
            int type;
            switch (netState) {
                case ThunderNetStateService.NetState.SYSNET_WIFI:
                    type = ThunderRtcConstant.ThunderNetworkType.THUNDER_NETWORK_TYPE_WIFI;
                    break;
                case ThunderNetStateService.NetState.SYSNET_MOBILE:
                    type = ThunderRtcConstant.ThunderNetworkType.THUNDER_NETWORK_TYPE_MOBILE;
                    break;
                case ThunderNetStateService.NetState.SYSNET_DISCONNECT:
                    type = ThunderRtcConstant.ThunderNetworkType.THUNDER_NETWORK_TYPE_DISCONNECTED;
                    break;
                case ThunderNetStateService.NetState.SYSNET_2G:
                    type = ThunderRtcConstant.ThunderNetworkType.THUNDER_NETWORK_TYPE_MOBILE_2G;
                    break;
                case ThunderNetStateService.NetState.SYSNET_3G:
                    type = ThunderRtcConstant.ThunderNetworkType.THUNDER_NETWORK_TYPE_MOBILE_3G;
                    break;
                case ThunderNetStateService.NetState.SYSNET_4G:
                    type = ThunderRtcConstant.ThunderNetworkType.THUNDER_NETWORK_TYPE_MOBILE_4G;
                    break;
                case ThunderNetStateService.NetState.SYSNET_UNKNOWN:
                    type = ThunderRtcConstant.ThunderNetworkType.THUNDER_NETWORK_TYPE_UNKNOWN;
                    break;
                default:
                    type = ThunderRtcConstant.ThunderNetworkType.THUNDER_NETWORK_TYPE_UNKNOWN;
                    break;
            }
            mRtcEventHandler.onNetworkTypeChanged(type);
        }
    }

    public static void notifyServiceLinkStatus(int status) {
        if (status == ThunderServiceChannel.OnConnecting ||
                status == ThunderServiceChannel.OnConnected ||
                status == ThunderServiceChannel.OnClosed) {
            if (mHandler != null) {
                int convertStatus = 0;
                switch (status) {
                    case ThunderServiceChannel.OnConnecting:
                        convertStatus = THUNDER_CONNECTION_STATUS_CONNECTING;
                        break;
                    case ThunderServiceChannel.OnConnected:
                        convertStatus = THUNDER_CONNECTION_STATUS_CONNECTED;
                        break;
                    case ThunderServiceChannel.OnClosed:
                        convertStatus = THUNDER_CONNECTION_STATUS_DISCONNECTED;
                        break;
                }
                Message msg = Message.obtain();
                msg.what = ThunderNotification.kThunderAPINotification_ServiceLinkStatus;
                msg.obj = new ThunderNotification.ServiceLinkStatus(convertStatus);
                mHandler.sendMessage(msg);
            }
        }
    }

}

