/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivesdk4cloud.video.serviceConfig;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import com.yy.argo.Argo;
import com.yy.yylivesdk4cloud.YYDeviceInfo;
import com.yy.yylivesdk4cloud.YYLiveAPI;
import com.yy.yylivesdk4cloud.audio.AudioConfigManager;
import com.yy.yylivesdk4cloud.helper.YYLiveLog;
import com.yy.yylivesdk4cloud.log.LogConfigManager;
import com.yy.yylivesdk4cloud.trans.TransConfigManager;
import com.yy.yylivesdk4cloud.video.serviceConfig.IArgoServiceInterface;
import com.yy.yylivesdk4cloud.video.serviceConfig.LocalCachedConfigs;
import com.yy.yylivesdk4cloud.video.serviceConfig.VideoConfigManager;
import java.util.HashMap;
import java.util.Map;

public class ArgoServiceImp
implements IArgoServiceInterface {
    private static final String TAG = "cfg_ArgoServiceImp";
    private HandlerThread mProcessThread;
    private Handler mProcessHandler;
    private LocalCachedConfigs mLocalConfigs;
    private Argo mArgo;
    private String mAppId;
    private String mSceneId;
    private String mUid;
    private String mChannelID;
    private String mAppVersion;
    Map<String, String> mProfiles = new HashMap<String, String>();
    private static final int MESSAGE_CONFIG_SAVE = 0;
    private static final int MESSAGE_CONFIG_REQUEST = 1;
    private static final int MESSAGE_CONFIG_RESPONSE = 2;
    private static final int MESSAGE_CONFIG_LOCAL = 3;
    private static final int MESSAGE_CONFIG_SET_PROFILR = 4;

    public ArgoServiceImp(Context context, YYDeviceInfo deviceInfo, long appId, long sceneId) {
        this.mAppId = Long.toString(appId);
        this.mSceneId = Long.toString(sceneId);
        this.mArgo = Argo.create((String)"sdk", (Context)context);
        this.mAppVersion = deviceInfo.appInfo.split("-")[1];
        this.mProcessThread = new HandlerThread("ArgoServiceThread");
        this.mProcessThread.start();
        this.mProcessHandler = new Handler(this.mProcessThread.getLooper()){

            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        ArgoServiceImp.this.handleConfigRequest();
                        break;
                    }
                    case 2: {
                        ArgoServiceImp.this.handleConfigResponse((Map)msg.obj);
                        break;
                    }
                    case 0: {
                        break;
                    }
                    case 3: {
                        ArgoServiceImp.this.handleQueryLocalCachedConfigs((Context)msg.obj);
                        break;
                    }
                    case 4: {
                        ArgoServiceImp.this.handleArgoSetProfile();
                        break;
                    }
                }
            }
        };
        this.mProcessHandler.sendMessage(Message.obtain((Handler)this.mProcessHandler, (int)4));
        this.mProcessHandler.sendMessage(Message.obtain((Handler)this.mProcessHandler, (int)3, (Object)context));
        this.mProcessHandler.sendMessage(Message.obtain((Handler)this.mProcessHandler, (int)1));
    }

    public void fini() {
        if (this.mProcessThread != null) {
            this.mProcessThread.quit();
        }
        this.mProcessThread = null;
        this.mProcessHandler = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleArgoSetProfile() {
        ArgoServiceImp argoServiceImp = this;
        synchronized (argoServiceImp) {
            this.mProfiles.put("sdk_version", Integer.toString(YYLiveAPI.sharedInstance().getVersionInt()));
            if (this.mUid != null && !this.mUid.isEmpty()) {
                this.mProfiles.put("uid", this.mUid);
            }
            this.mProfiles.put("app_ver", this.mAppVersion);
            this.mProfiles.put("appid", this.mAppId);
            this.mProfiles.put("os", "Android");
            this.mProfiles.put("model", Build.MODEL);
            this.mProfiles.put("osversion", Build.VERSION.RELEASE);
            if (this.mChannelID != null && !this.mChannelID.isEmpty()) {
                this.mProfiles.put("channel_id", this.mChannelID);
            }
            this.mProfiles.put("scene_id", this.mSceneId);
            if (YYLiveAPI.sharedInstance().getVersion() != null) {
                this.mProfiles.put("app_ver", YYLiveAPI.sharedInstance().getVersion());
            }
            this.mArgo.setProfiles(this.mProfiles);
        }
    }

    private void handleQueryLocalCachedConfigs(Context context) {
        String xml;
        this.mLocalConfigs = new LocalCachedConfigs(context);
        for (String key : VideoConfigManager.ARGO_CONFIG_KEYS) {
            xml = this.mLocalConfigs.getConfigString(key);
            VideoConfigManager.instance().onConfig(key, xml);
        }
        for (String key : AudioConfigManager.ARGO_CONFIG_KEYS) {
            xml = this.mLocalConfigs.getConfigString(key);
            AudioConfigManager.instance().onConfig(key, xml);
        }
        for (String key : LogConfigManager.ARGO_CONFIG_KEYS) {
            xml = this.mLocalConfigs.getConfigString(key);
            LogConfigManager.instance().onConfig(key, xml);
        }
        for (String key : TransConfigManager.ARGO_CONFIG_KEYS) {
            xml = this.mLocalConfigs.getConfigString(key);
            TransConfigManager.instance().onConfig(key, xml);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleConfigRequest() {
        ArgoServiceImp argoServiceImp = this;
        synchronized (argoServiceImp) {
            this.mArgo.setProfiles(this.mProfiles);
        }
        this.mArgo.queryConfigs(new Argo.ConfigsHandler(){

            public void onConfigs(Map<String, String> configs) {
                if (ArgoServiceImp.this.mProcessHandler == null || configs.isEmpty()) {
                    return;
                }
                YYLiveLog.info(ArgoServiceImp.TAG, "receive argo config " + configs.toString().length());
                Message msg = Message.obtain();
                msg.what = 2;
                msg.obj = configs;
                ArgoServiceImp.this.mProcessHandler.sendMessage(msg);
            }

            public void onFailure(int code, String message) {
                YYLiveLog.warn(ArgoServiceImp.TAG, "Argo query failed: " + message);
            }

            public void onCompletion(int result) {
                YYLiveLog.info(ArgoServiceImp.TAG, "Did end querying");
            }
        });
        YYLiveLog.info(TAG, "begin queryConfigs");
    }

    private void handleConfigResponse(Map<String, String> configs) {
        for (String key : configs.keySet()) {
            String value = configs.get(key);
            VideoConfigManager.instance().onConfig(key, value);
            AudioConfigManager.instance().onConfig(key, value);
            LogConfigManager.instance().onConfig(key, value);
            TransConfigManager.instance().onConfig(key, value);
            this.mLocalConfigs.setConfigString(key, value);
        }
    }

    public void queryConfigs() {
        YYLiveLog.info(TAG, " queryConfigs begin");
        this.mProcessHandler.sendMessage(Message.obtain((Handler)this.mProcessHandler, (int)1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProfileParam(String key, String value) {
        if (value == null || key == null || key.isEmpty() || value.isEmpty()) {
            return;
        }
        if (key.equalsIgnoreCase("uid")) {
            this.mUid = value;
        }
        if (key.equalsIgnoreCase("channel_id")) {
            this.mChannelID = value;
        }
        ArgoServiceImp argoServiceImp = this;
        synchronized (argoServiceImp) {
            this.mProfiles.put(key, value);
            YYLiveLog.info(TAG, "setProfileParam " + this.mProfiles);
        }
    }

    static {
        String argoTag = "ArgoSDK";
        Argo.init((int)0, (Argo.Logger)new Argo.Logger(){

            public void log(int lv, String msg) {
                switch (lv) {
                    case 0: {
                        YYLiveLog.debug("ArgoSDK", msg);
                        break;
                    }
                    case 1: {
                        YYLiveLog.info("ArgoSDK", msg);
                        break;
                    }
                    case 2: {
                        YYLiveLog.warn("ArgoSDK", msg);
                        break;
                    }
                    case 3: {
                        YYLiveLog.error("ArgoSDK", msg);
                        break;
                    }
                    default: {
                        YYLiveLog.debug("ArgoSDK", msg);
                    }
                }
            }
        });
    }

    public static class ArgoProfileKey {
        public static final String ARGO_PROFILE_KEY_SDK_VER = "sdk_version";
        public static final String ARGO_PROFILE_KEY_UID = "uid";
        public static final String ARGO_PROFILE_KEY_APP_VER = "app_ver";
        public static final String ARGO_PROFILE_KEY_APPID = "appid";
        public static final String ARGO_PROFILE_KEY_OS = "os";
        public static final String ARGO_PROFILE_KEY_MODEL = "model";
        public static final String ARGO_PROFILE_KEY_OS_VERSION = "osversion";
        public static final String ARGO_PROFILE_KEY_CHANNEL_ID = "channel_id";
        public static final String ARGO_PROFILE_KEY_SCENE_ID = "scene_id";
    }
}

