/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivesdk4cloud.video;

import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import com.yy.mediaframework.CameraPreviewConfig;
import com.yy.mediaframework.IPublishListener;
import com.yy.mediaframework.ITextureListener;
import com.yy.mediaframework.PublishVideoConfig;
import com.yy.mediaframework.VideoPublish;
import com.yy.mediaframework.YYVideoCodec;
import com.yy.mediaframework.YYVideoSDK;
import com.yy.mediaframework.base.VideoEncoderConfig;
import com.yy.mediaframework.base.VideoEncoderType;
import com.yy.mediaframework.gpuimage.custom.OrangeFilterWrapper;
import com.yy.mediaframework.stat.VideoDataStat;
import com.yy.videoplayer.IVideoLibInfoExt;
import com.yy.videoplayer.VideoPlayer;
import com.yy.videoplayer.decoder.YYVideoLibMgr;
import com.yy.videoplayer.render.VideoRenderNotify;
import com.yy.videoplayer.stat.VideoPlayerDataStat;
import com.yy.videoplayer.videoview.IVideoInfoCallback;
import com.yy.yylivesdk4cloud.YYLiveAPI;
import com.yy.yylivesdk4cloud.YYLiveDefaultCamera;
import com.yy.yylivesdk4cloud.YYLivePlayerView;
import com.yy.yylivesdk4cloud.YYLivePreviewView;
import com.yy.yylivesdk4cloud.YYLiveScreenCapture;
import com.yy.yylivesdk4cloud.YYLiveVideoCapture;
import com.yy.yylivesdk4cloud.YYPreviewConfig;
import com.yy.yylivesdk4cloud.helper.YYLiveLog;
import com.yy.yylivesdk4cloud.helper.YYLiveNative;
import com.yy.yylivesdk4cloud.video.YYVideoConfig;
import com.yy.yylivesdk4cloud.video.YYVideoPlayListener;
import com.yy.yylivesdk4cloud.video.serviceConfig.VideoConfigManager;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;

public class YYVideoEngineImp
implements IPublishListener,
ITextureListener {
    public static final int YYPUBLISH_VIDEO_STATE_NONE = 0;
    public static final int YYPUBLISH_VIDEO_STATE_PREVIEW = 1;
    public static final int YYPUBLISH_VIDEO_STATE_ENCODE = 2;
    HashMap<String, YYLivePlayerView> mVideoViewMap;
    HashMap<String, Long> mVideoViewStreamKeyAndIdMap;
    HashMap<String, Integer> mVideoScaleModeMap;
    private VideoPublish mPublisher = null;
    private long mCallBackPtr = 0L;
    private boolean bMixMode = false;
    private YYLiveVideoCapture mCapture;
    private OrangeFilterWrapper mOrangeFilterWrapper;
    private static final int VIDEO_STAT_FPS = 0;
    private static final int VIDEO_STAT_BITRATE = 1;
    private static final int VIDEO_STATE_RESOLUTION = 2;
    private VideoConfigManager mVideoConfigManager;
    private int mVideoPublishState = 0;
    private int mVideoPreviewState = 0;
    private YVideoPublishVideoConfig mCurrentVideoConfig = null;
    private Handler mUiHandler = null;
    private Map<String, WeakReference> mPlayViewAndStreamKeyMap = new HashMap<String, WeakReference>();
    private YYVideoPlayListener mYYVideoPlayListener = null;
    private Boolean mScreenCaptureInited = false;

    public YYVideoEngineImp() {
        YYVideoCodec.testVideoEncoderCrash();
    }

    public void init() {
        this.mVideoViewMap = new HashMap();
        this.mVideoScaleModeMap = new HashMap();
        this.mVideoViewStreamKeyAndIdMap = new HashMap();
        this.mPublisher = VideoPublish.getInstance();
        this.mVideoConfigManager = VideoConfigManager.instance();
        this.mYYVideoPlayListener = new YYVideoPlayListener(YYVideoLibMgr.instance().getAppContext(), this);
        YYVideoLibMgr.instance().setVideoInfoListener((IVideoLibInfoExt)this.mYYVideoPlayListener);
        this.mUiHandler = new Handler(Looper.getMainLooper());
        YYVideoConfig config = new YYVideoConfig();
        YYVideoSDK.getInstance().enbaleSTLibrary(false);
        config.AsyncLoad();
    }

    public void setPreviewScaleMode(int scaleMode) {
        if (this.mPublisher != null) {
            this.mPublisher.setScaleMode(scaleMode);
        }
    }

    public static String getVideoEngineVersion() {
        return "Android: 200.0.12.2&200.0.7";
    }

    public void updatePlayVideoStream(String streamKey, long streamId, int streamType, boolean bSoftDecode) {
        int scaleMode;
        long oldStreamId;
        YYLiveLog.info("YYvideoEngineImp", "updatePlayVideoStream bSoftDecode ==" + Boolean.toString(bSoftDecode));
        final YYLivePlayerView view = this.mVideoViewMap.get(streamKey);
        if (view == null) {
            YYLiveLog.warn("YYvideoEngineImp", "updatePlayVideoStream: cann't find video view for stream:%s", streamKey);
            return;
        }
        long l = oldStreamId = this.mVideoViewStreamKeyAndIdMap.get(streamKey) == null ? -1L : this.mVideoViewStreamKeyAndIdMap.get(streamKey);
        if (bSoftDecode) {
            YYLiveLog.info("YYvideoEngineImp", "updatePlayVideoStream bSoftDecode == true, view == hard,need change");
            view.unLinkFromStream(oldStreamId);
            if (Thread.currentThread().getId() == this.mUiHandler.getLooper().getThread().getId()) {
                view.prepareView(0);
            } else {
                final CountDownLatch barrier = new CountDownLatch(1);
                this.mUiHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        view.prepareView(0);
                        barrier.countDown();
                    }
                });
                try {
                    barrier.await();
                }
                catch (InterruptedException e) {
                    YYLiveLog.error("YYVideoEngineImp", "updatePlayVideoStream .barrier.await" + e.toString());
                }
            }
            YYLiveLog.info("YYvideoEngineImp", "updatePlayVideoStream link stream:%s, %d", streamKey, streamId);
            view.linkToStream(streamId);
        } else {
            YYLiveLog.info("YYvideoEngineImp", "updatePlayVideoStream unlink stream:%s-%d", streamKey, oldStreamId);
            view.unLinkFromStream(oldStreamId);
            this.setDecodeType(streamKey, streamType);
            YYLiveLog.info("YYvideoEngineImp", "updatePlayVideoStream link stream:%s, %d", streamKey, streamId);
            view.linkToStream(streamId);
        }
        int n = scaleMode = this.mVideoScaleModeMap.get(streamKey) == null ? -1 : this.mVideoScaleModeMap.get(streamKey);
        if (scaleMode == -1) {
            YYLiveLog.error("YYVideoEngineImp", "updatePlayVideoStream mVideoScaleModeMap can't find scaleMode in map :" + this.mVideoScaleModeMap.size());
            return;
        }
        view.setScaleMode(scaleMode);
    }

    public void setLowDelayMode(boolean mode) {
        if (this.mCurrentVideoConfig != null && this.mCurrentVideoConfig.bLowLatency != mode) {
            this.mPublisher.setLowDelayMode(mode);
            this.mCurrentVideoConfig.bLowLatency = mode;
        }
        YYLiveLog.info("YYVideoEngineImp", "setLowDelayMode new mode " + mode + " old :" + (this.mCurrentVideoConfig != null ? Boolean.valueOf(this.mCurrentVideoConfig.bLowLatency) : "null"));
    }

    public int setDecodeType(String streamKey, int streamType) {
        int scaleMode;
        final int decodeType = this.mVideoConfigManager.getPlayViewTypeFromStream(streamType);
        YYLiveLog.info("YYVideoEngineImp", "setDecodeType streamKey " + streamKey + " type:" + streamType);
        if (this.mVideoConfigManager == null) {
            YYLiveLog.error("YYVideoEngineImp", "setDecodeType mVideoConfigManager == null!");
            return -1;
        }
        int n = scaleMode = this.mVideoScaleModeMap.get(streamKey) == null ? -1 : this.mVideoScaleModeMap.get(streamKey);
        if (scaleMode == -1) {
            YYLiveLog.error("YYVideoEngineImp", "setDecodeType mVideoScaleModeMap can't find scaleMode in map :" + this.mVideoScaleModeMap.size());
            return -1;
        }
        final YYLivePlayerView view = this.mVideoViewMap.get(streamKey);
        if (this.mVideoViewMap.get(streamKey) == null) {
            YYLiveLog.error("YYVideoEngineImp", "setDecodeType mVideoScaleModeMap can't find view in map :" + this.mVideoViewMap.size());
            return -1;
        }
        if (Thread.currentThread().getId() == this.mUiHandler.getLooper().getThread().getId()) {
            view.prepareView(decodeType);
        } else {
            final CountDownLatch barrier = new CountDownLatch(1);
            this.mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    view.prepareView(decodeType);
                    barrier.countDown();
                }
            });
            try {
                barrier.await();
            }
            catch (InterruptedException e) {
                YYLiveLog.error("YYVideoEngineImp", "setDecodeType .barrier.await" + e.toString());
            }
        }
        view.setScaleMode(scaleMode);
        YYLiveLog.info("YYVideoEngineImp", streamKey + " setDecodeType success : scaleMode" + scaleMode + ", decodeType: " + decodeType);
        return decodeType == 1 ? 1 : 0;
    }

    public boolean H265PlaySupport() {
        if (this.mVideoConfigManager == null) {
            return false;
        }
        YYLiveLog.info("YYVideoEngineImp", "H265PlaySupport " + this.mVideoConfigManager.H265PlaySupport());
        return this.mVideoConfigManager.H265PlaySupport();
    }

    public boolean startVideoEngine() {
        return true;
    }

    public int getVideoDecodeTranscoding(int transcoding) {
        if (this.mVideoConfigManager == null) {
            return transcoding;
        }
        return this.mVideoConfigManager.getVideoDecodeTranscoding(transcoding);
    }

    public int getVideoEncodeTranscoding(int playType, int mode) {
        if (this.mVideoConfigManager == null) {
            return mode;
        }
        return this.mVideoConfigManager.getVideoEncodeTranscoding(playType, mode);
    }

    public boolean stopVideoEngine() {
        return true;
    }

    public void setVideoEngineCallBack(long ptr) {
        this.mCallBackPtr = ptr;
    }

    private boolean isUsingDefaultCamera() {
        return !this.bMixMode && this.mCapture != null && this.mCapture instanceof YYLiveDefaultCamera;
    }

    public void attachVideoCapture(Object capture) {
        if (this.mVideoPublishState == 2) {
            if (this.mCapture != null && this.mCapture instanceof YYLiveScreenCapture) {
                this.mPublisher.stopPublishScreenVideo();
            } else if (this.mCapture == null || this.mCapture instanceof YYLiveDefaultCamera) {
                this.mPublisher.stopPublishLiveVideo();
            }
        }
        YYLiveLog.info("YYvideoEngineImp", "detach capture: " + (this.mCapture == null ? "YYLiveDefaultCamera" : this.mCapture.toString()) + " mVideoPublishState" + this.mVideoPublishState);
        this.mCapture = (YYLiveVideoCapture)capture;
        YYLiveLog.info("YYvideoEngineImp", "attach capture: " + this.mCapture.toString());
        if (this.mVideoPublishState == 2) {
            int mid;
            int playType = this.mCurrentVideoConfig.playType;
            if (this.mCapture instanceof YYLiveScreenCapture) {
                playType = 5;
            }
            VideoEncoderConfig newEncoderConfig = this.getVideoEncoderConfigByType(playType, this.mCurrentVideoConfig.mode);
            if (this.mCapture.getClass() == YYLiveScreenCapture.class && ((YYLiveScreenCapture)this.mCapture).isLandscap()) {
                mid = newEncoderConfig.mEncodeWidth;
                newEncoderConfig.mEncodeWidth = newEncoderConfig.mEncodeHeight;
                newEncoderConfig.mEncodeHeight = mid;
            } else if (this.mCapture.getClass() == YYLiveDefaultCamera.class && ((YYPreviewConfig)this.mCapture.getCaptureConfig()).captureOrientation == 1 && newEncoderConfig.mEncodeWidth < newEncoderConfig.mEncodeHeight) {
                mid = newEncoderConfig.mEncodeWidth;
                newEncoderConfig.mEncodeWidth = newEncoderConfig.mEncodeHeight;
                newEncoderConfig.mEncodeHeight = mid;
            }
            this.mPublisher.enableMirror(this.mCurrentVideoConfig.bMirrorFrontCamera);
            newEncoderConfig.mLowDelay = this.mCurrentVideoConfig.bLowLatency;
            this.mPublisher.setResolutionModifyConfigs(this.mVideoConfigManager.getCurrentModifyConfig(), this.mVideoConfigManager.getCurrentIntervalSecs());
            if (this.mCapture instanceof YYLiveScreenCapture) {
                if (!this.mScreenCaptureInited.booleanValue()) {
                    YYLiveScreenCapture yyLiveScreenCapture = (YYLiveScreenCapture)this.mCapture;
                    this.mPublisher.initScreenLiveSession(yyLiveScreenCapture.getMediaProjection(), (IPublishListener)this, yyLiveScreenCapture.isLandscap());
                    this.mScreenCaptureInited = true;
                }
                this.mPublisher.startPublishScreenVideo("general", null, (Object)newEncoderConfig);
                YYLiveLog.info("YYvideoEngineImp", "startPublishScreenVideo %dx%d %d %d %s %b %b", newEncoderConfig.mEncodeWidth, newEncoderConfig.mEncodeHeight, newEncoderConfig.mFrameRate, newEncoderConfig.mBitRate, newEncoderConfig.mEncodeType.name(), this.mCurrentVideoConfig.bMirrorFrontCamera, newEncoderConfig.mLowDelay);
            } else {
                this.mPublisher.startPublishLiveVideo("general", null, (Object)newEncoderConfig);
                YYLiveLog.info("YYvideoEngineImp", "startPublishLiveVideo %dx%d %d %d %s %b %b", newEncoderConfig.mEncodeWidth, newEncoderConfig.mEncodeHeight, newEncoderConfig.mFrameRate, newEncoderConfig.mBitRate, newEncoderConfig.mEncodeType.name(), this.mCurrentVideoConfig.bMirrorFrontCamera, newEncoderConfig.mLowDelay);
            }
        }
    }

    private CameraPreviewConfig getCameraPreviewConfigByType(int playType, int previewMode) {
        CameraPreviewConfig result = this.mVideoConfigManager.getCameraPreviewConfigByType(playType, previewMode);
        YYLiveLog.info("YYVideoEngineImp", "getCameraPreviewConfigByType:" + result.toString());
        return result;
    }

    private int getBeautyLevelInCurrentConfig() {
        int result = 0;
        if (this.mVideoConfigManager != null) {
            result = this.mVideoConfigManager.getCurrentBeautifyLevel();
        }
        YYLiveLog.info("YYVideoEngineImp", "getBeautyLevelInCurrentConfig:" + result);
        return result;
    }

    private VideoEncoderConfig getVideoEncoderConfigByType(int playType, int mode) {
        VideoEncoderConfig result = this.mVideoConfigManager.getVideoEncodeConfigByType(playType, mode);
        YYLiveLog.info("YYVideoEngineImp", "getVideoEncoderConfigByType:" + result.toString());
        return result;
    }

    private boolean checkLowDelayByType(int playType) {
        return this.mVideoConfigManager.checkLowDelayByType(playType);
    }

    private CameraPreviewConfig toCamerePreviewConfig(YYPreviewConfig config) {
        CameraPreviewConfig newConf = new CameraPreviewConfig(0);
        newConf.mCaptureResolutionWidth = config.captureResolutionWidth;
        newConf.mCaptureResolutionHeight = config.captureResolutionHeight;
        newConf.mCameraPosition = config.cameraPosition;
        newConf.mCaptureFrameRate = config.captureFrameRate;
        newConf.mCaptureOrientation = config.captureOrientation;
        return newConf;
    }

    public YVideoPublishVideoConfig setOrientation(int orientatin) {
        YYLiveLog.info("YYVideoEngineImp", " setOrientation " + orientatin);
        if (this.mCapture != null && this.mCapture instanceof YYLiveScreenCapture) {
            YYLiveScreenCapture yyLiveScreenCapture = (YYLiveScreenCapture)this.mCapture;
            if (yyLiveScreenCapture.isLandscap() && orientatin != 1 || !yyLiveScreenCapture.isLandscap() && orientatin != 0) {
                this.stopEncodeVideo();
                yyLiveScreenCapture.setIslandScape(orientatin == 1);
                this.startEncodeVideo(this.mCurrentVideoConfig.bMirrorFrontCamera, this.mCurrentVideoConfig.bLowLatency, this.mCurrentVideoConfig.playType, this.mCurrentVideoConfig.mode);
            }
            return this.mCurrentVideoConfig;
        }
        YYLiveDefaultCamera camera = YYLiveAPI.sharedInstance().getPublisher().getDefaluteCamera();
        YYPreviewConfig config = (YYPreviewConfig)camera.getCaptureConfig();
        if (orientatin != config.captureOrientation) {
            config.captureOrientation = orientatin;
            config.captureResolutionWidth += config.captureResolutionHeight;
            config.captureResolutionHeight = config.captureResolutionWidth - config.captureResolutionHeight;
            config.captureResolutionWidth -= config.captureResolutionHeight;
            camera.setCaptureConfig(config);
        }
        if (this.mCapture != null && this.mCapture instanceof YYLiveScreenCapture && this.mVideoPublishState == 2 && this.mVideoPreviewState == 1 || this.mCapture == null && this.mVideoPublishState != 2 && this.mVideoPreviewState == 1) {
            this.mPublisher.updateCameraPreviewParam(this.toCamerePreviewConfig(config));
        } else {
            this.stopEncodeVideo();
            this.mPublisher.updateCameraPreviewParam(this.toCamerePreviewConfig(config));
            this.startEncodeVideo(this.mCurrentVideoConfig.bMirrorFrontCamera, this.mCurrentVideoConfig.bLowLatency, this.mCurrentVideoConfig.playType, this.mCurrentVideoConfig.mode);
        }
        if (this.mCurrentVideoConfig != null) {
            this.mCurrentVideoConfig.orientation = orientatin;
            this.mCurrentVideoConfig.encodeResolutionWidth += this.mCurrentVideoConfig.encodeResolutionHeight;
            this.mCurrentVideoConfig.encodeResolutionHeight = this.mCurrentVideoConfig.encodeResolutionWidth - this.mCurrentVideoConfig.encodeResolutionHeight;
            this.mCurrentVideoConfig.encodeResolutionWidth -= this.mCurrentVideoConfig.encodeResolutionHeight;
        }
        if (this.mVideoPublishState == 2) {
            return this.mCurrentVideoConfig;
        }
        return null;
    }

    public int startPreview(Object toView, int playType, int publishMode) {
        YYLiveDefaultCamera camera = YYLiveAPI.sharedInstance().getPublisher().getDefaluteCamera();
        YYPreviewConfig config = (YYPreviewConfig)camera.getCaptureConfig();
        this.mPublisher.setPhonePerformanceLevel(this.getBeautyLevelInCurrentConfig());
        CameraPreviewConfig newConfig = this.getCameraPreviewConfigByType(playType, publishMode);
        newConfig.mCameraPosition = ((YYPreviewConfig)camera.getCaptureConfig()).cameraPosition;
        if (config.captureOrientation == 1 && newConfig.mCaptureResolutionWidth < newConfig.mCaptureResolutionHeight) {
            int mid = newConfig.mCaptureResolutionWidth;
            newConfig.mCaptureResolutionWidth = newConfig.mCaptureResolutionHeight;
            newConfig.mCaptureResolutionHeight = mid;
        }
        this.mPublisher.startPreviewWithView(((YYLivePreviewView)((Object)toView)).getSurfaceView(), newConfig, (IPublishListener)this);
        if (camera.getCameraDataCallback() != null) {
            YYLiveLog.info("YYvideoEngineImp", "setTextureListener %s %s", camera.getCameraDataCallback().toString(), this.toString());
            this.mPublisher.setTextureListener((ITextureListener)this);
        }
        this.mOrangeFilterWrapper = this.mPublisher.getOrangeFilterWrapperObject();
        config.captureFrameRate = newConfig.mCaptureFrameRate;
        config.captureResolutionHeight = newConfig.mCaptureResolutionHeight;
        config.captureResolutionWidth = newConfig.mCaptureResolutionWidth;
        camera.setCaptureConfig(config);
        this.mVideoPreviewState = 1;
        if (this.mCapture != null && this.mCapture.getClass() == YYLiveDefaultCamera.class && this.mVideoPublishState == 2) {
            YYLiveLog.info("YYvideoEngineImp", "startPreview attach camera SO publish:" + playType + ":" + publishMode);
            this.startEncodeVideo(false, false, playType, publishMode);
        }
        return 0;
    }

    public int stopPreview() {
        if (this.mVideoPreviewState != 1) {
            YYLiveLog.info("YYvideoEngineImp", "stopPreview previewState wrong:" + this.mVideoPublishState);
        }
        this.mVideoPreviewState = 0;
        return this.mPublisher.stopPreview();
    }

    public YVideoPublishVideoConfig startEncodeVideo(boolean bMirrorFrontCamera, boolean bLowLatency, int playType, int mode) {
        int mid;
        if (this.mCapture != null && this.mCapture.getClass() == YYLiveScreenCapture.class) {
            YYLiveLog.info("YYvideoEngineImp", "updatePublishVideoConfig change playType from %d :%d", playType, 5);
            playType = 5;
        }
        VideoEncoderConfig newEncoderConfig = this.getVideoEncoderConfigByType(playType, mode);
        if (this.mCapture != null && this.mCapture.getClass() == YYLiveScreenCapture.class && ((YYLiveScreenCapture)this.mCapture).isLandscap()) {
            mid = newEncoderConfig.mEncodeWidth;
            newEncoderConfig.mEncodeWidth = newEncoderConfig.mEncodeHeight;
            newEncoderConfig.mEncodeHeight = mid;
        } else if (((YYPreviewConfig)YYLiveAPI.sharedInstance().getPublisher().getDefaluteCamera().getCaptureConfig()).captureOrientation == 1 && newEncoderConfig.mEncodeWidth < newEncoderConfig.mEncodeHeight) {
            mid = newEncoderConfig.mEncodeWidth;
            newEncoderConfig.mEncodeWidth = newEncoderConfig.mEncodeHeight;
            newEncoderConfig.mEncodeHeight = mid;
        }
        this.mPublisher.enableMirror(bMirrorFrontCamera);
        newEncoderConfig.mLowDelay = this.checkLowDelayByType(playType);
        YYLiveLog.info("YYvideoEngineImp", "startPublishVideo %dx%d %d %d %s %b %b", newEncoderConfig.mEncodeWidth, newEncoderConfig.mEncodeHeight, newEncoderConfig.mFrameRate, newEncoderConfig.mBitRate, newEncoderConfig.mEncodeType.name(), bMirrorFrontCamera, newEncoderConfig.mLowDelay);
        if (this.mCapture != null && this.mCapture.getClass() == YYLiveScreenCapture.class) {
            YYLiveScreenCapture yyLiveScreenCapture = (YYLiveScreenCapture)this.mCapture;
            this.mPublisher.initScreenLiveSession(yyLiveScreenCapture.getMediaProjection(), (IPublishListener)this, yyLiveScreenCapture.isLandscap());
            this.mScreenCaptureInited = true;
        }
        this.mPublisher.setResolutionModifyConfigs(this.mVideoConfigManager.getCurrentModifyConfig(), this.mVideoConfigManager.getCurrentIntervalSecs());
        int ret = -1;
        ret = this.mCapture != null && this.mCapture instanceof YYLiveScreenCapture ? this.mPublisher.startPublishScreenVideo("general", null, (Object)newEncoderConfig) : this.mPublisher.startPublishLiveVideo("general", null, (Object)newEncoderConfig);
        if (ret == 0) {
            int videoLevel;
            int encodeType = 0;
            boolean hard = false;
            if (newEncoderConfig.mEncodeType == VideoEncoderType.HARD_ENCODER_H264) {
                hard = true;
                encodeType = 0;
            } else if (newEncoderConfig.mEncodeType == VideoEncoderType.SOFT_ENCODER_X264) {
                hard = false;
                encodeType = 0;
            } else if (newEncoderConfig.mEncodeType == VideoEncoderType.SOFT_ENCODER_H265) {
                hard = false;
                encodeType = 1;
            } else if (newEncoderConfig.mEncodeType == VideoEncoderType.HARD_ENCODER_H265) {
                hard = true;
                encodeType = 1;
            }
            int n = videoLevel = this.mVideoConfigManager.getCurrentVideoLiveConfig() == null ? -1 : this.mVideoConfigManager.getCurrentVideoLiveConfig().videoLevel;
            if (this.mCurrentVideoConfig == null) {
                this.mCurrentVideoConfig = new YVideoPublishVideoConfig(newEncoderConfig.mFrameRate, newEncoderConfig.mBitRate / 1000, newEncoderConfig.mEncodeWidth, newEncoderConfig.mEncodeHeight, encodeType, hard, videoLevel);
            }
            this.mCurrentVideoConfig.bLowLatency = newEncoderConfig.mLowDelay;
            this.mCurrentVideoConfig.bMirrorFrontCamera = bMirrorFrontCamera;
            this.mCurrentVideoConfig.playType = playType;
            this.mCurrentVideoConfig.mode = videoLevel;
            this.mCurrentVideoConfig.encodeFrameRate = newEncoderConfig.mFrameRate;
            this.mCurrentVideoConfig.encodeBitrate = newEncoderConfig.mBitRate / 1000;
            this.mCurrentVideoConfig.encodeResolutionWidth = newEncoderConfig.mEncodeWidth;
            this.mCurrentVideoConfig.encodeResolutionHeight = newEncoderConfig.mEncodeHeight;
            this.mCurrentVideoConfig.bHardwareEncoder = hard;
            this.mCurrentVideoConfig.encodeType = encodeType;
            int n2 = this.mCurrentVideoConfig.orientation = this.mCurrentVideoConfig.encodeResolutionWidth > this.mCurrentVideoConfig.encodeResolutionHeight ? 1 : 0;
        }
        if (this.mVideoPreviewState != 1) {
            YYLiveLog.info("YYvideoEngineImp", "startPublishVideo videoState wrong:" + this.mVideoPreviewState);
        }
        this.mVideoPublishState = 2;
        return this.mCurrentVideoConfig;
    }

    public int stopEncodeVideo() {
        YYLiveLog.info("YYvideoEngineImp", "stopEncodeVideo ....");
        this.mVideoConfigManager.resetCurrentVideoLiveConfig();
        if (this.mVideoPublishState != 2) {
            YYLiveLog.info("YYvideoEngineImp", "stopEncodeVideo videoState wrong:" + this.mVideoPublishState);
        }
        this.mVideoPublishState = 0;
        this.mPublisher.stopPublishVideo();
        if (this.mCapture != null && this.mCapture.getClass() == YYLiveScreenCapture.class) {
            this.mPublisher.deInitScreenLiveSession();
            this.mScreenCaptureInited = false;
        }
        return 0;
    }

    public void changeScreenLiveMode(boolean pictureMode, Object bitmap) {
        this.mPublisher.changeScreenLiveMode(Boolean.valueOf(pictureMode), (Bitmap)bitmap);
    }

    public int startPlayVideoStream(String streamKey, Object toView, int scaleMode) {
        if (toView == null || streamKey == null || streamKey.isEmpty()) {
            return -1;
        }
        YYLivePlayerView view = (YYLivePlayerView)((Object)toView);
        YYLiveLog.info("YYvideoEngineImp", "startPlayVideoStream " + streamKey + " scaleMode:" + scaleMode);
        this.mVideoScaleModeMap.put(streamKey, scaleMode);
        this.mVideoViewMap.put(streamKey, view);
        return 0;
    }

    public int stopPlayVideoStream(String streamKey) {
        final YYLivePlayerView view = this.mVideoViewMap.get(streamKey);
        if (view == null) {
            return -1;
        }
        YYLiveLog.debug("YYvideoEngineImp", "stopPlayVideoStream" + streamKey);
        view.unLinkFromStream();
        if (Thread.currentThread().getId() == this.mUiHandler.getLooper().getThread().getId()) {
            view.unPrepareView();
        } else {
            this.mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    view.unPrepareView();
                }
            });
        }
        this.mVideoViewMap.remove(streamKey);
        this.mVideoViewStreamKeyAndIdMap.remove(streamKey);
        return 0;
    }

    public void setPlayVideoViewScaleMode(Object toView, int scaleMode) {
        String streamKey = null;
        if (toView == null) {
            return;
        }
        Set<Map.Entry<String, YYLivePlayerView>> entrySet = this.mVideoViewMap.entrySet();
        for (Map.Entry<String, YYLivePlayerView> me : entrySet) {
            if (!toView.equals((Object)me.getValue())) continue;
            streamKey = me.getKey();
            this.mVideoScaleModeMap.put(streamKey, scaleMode);
            me.getValue().setScaleMode(scaleMode);
            return;
        }
        YYLiveLog.warn("YYvideoEngineImp", "setPlayVideoViewScaleMode toView is not found!");
    }

    public boolean updatePlayVideoView(String streamKey, Object toView, int scaleMode) {
        if (toView == null || streamKey == null || streamKey.isEmpty()) {
            return false;
        }
        YYLivePlayerView view = this.mVideoViewMap.get(streamKey);
        if (view == null) {
            return false;
        }
        if (!((Object)((Object)view)).equals(toView)) {
            YYLiveLog.warn("YYvideoEngineImp", "may toView is change!");
            return false;
        }
        this.mVideoScaleModeMap.put(streamKey, scaleMode);
        YYLiveLog.debug("YYvideoEngineImp", "update play scale mode: " + scaleMode);
        return view.setScaleMode(scaleMode);
    }

    public YVideoPublishVideoConfig updatePublishVideoConfig(boolean bMirrorFrontCamera, boolean bLowLatency, int playType, int mode) {
        if (this.mCapture != null && this.mCapture.getClass() == YYLiveScreenCapture.class) {
            YYLiveLog.info("YYvideoEngineImp", "updatePublishVideoConfig change playType from %d :%d", playType, 5);
            playType = 5;
        }
        if (this.mCurrentVideoConfig == null || playType != this.mCurrentVideoConfig.playType || mode != this.mCurrentVideoConfig.mode) {
            int videoLevel;
            VideoEncoderConfig newEncoderConfig = this.getVideoEncoderConfigByType(playType, mode);
            PublishVideoConfig videoConfig = new PublishVideoConfig();
            videoConfig.assign(newEncoderConfig);
            videoConfig.mLowDelay = this.checkLowDelayByType(playType);
            if (videoConfig.mLowDelay != bLowLatency) {
                YYLiveLog.info("YYvideoEngineImp", "updatePublishVideoConfig %b :%d", bLowLatency, playType);
            }
            this.mPublisher.setResolutionModifyConfigs(this.mVideoConfigManager.getCurrentModifyConfig(), this.mVideoConfigManager.getCurrentIntervalSecs());
            this.mPublisher.updatePublishVideoConfig(videoConfig);
            int encodeType = 0;
            boolean hard = false;
            if (newEncoderConfig.mEncodeType == VideoEncoderType.HARD_ENCODER_H264) {
                hard = true;
                encodeType = 0;
            } else if (newEncoderConfig.mEncodeType == VideoEncoderType.SOFT_ENCODER_X264) {
                hard = false;
                encodeType = 0;
            } else if (newEncoderConfig.mEncodeType == VideoEncoderType.SOFT_ENCODER_H265) {
                hard = false;
                encodeType = 1;
            } else if (newEncoderConfig.mEncodeType == VideoEncoderType.HARD_ENCODER_H265) {
                hard = true;
                encodeType = 1;
            }
            int n = videoLevel = this.mVideoConfigManager.getCurrentVideoLiveConfig() == null ? -1 : this.mVideoConfigManager.getCurrentVideoLiveConfig().videoLevel;
            if (this.mCurrentVideoConfig == null) {
                this.mCurrentVideoConfig = new YVideoPublishVideoConfig(newEncoderConfig.mFrameRate, newEncoderConfig.mBitRate / 1000, newEncoderConfig.mEncodeWidth, newEncoderConfig.mEncodeHeight, encodeType, hard, videoLevel);
            }
            this.mCurrentVideoConfig.playType = playType;
            this.mCurrentVideoConfig.mode = videoLevel;
            this.mCurrentVideoConfig.encodeFrameRate = newEncoderConfig.mFrameRate;
            this.mCurrentVideoConfig.encodeBitrate = newEncoderConfig.mBitRate / 1000;
            this.mCurrentVideoConfig.encodeResolutionWidth = newEncoderConfig.mEncodeWidth;
            this.mCurrentVideoConfig.encodeResolutionHeight = newEncoderConfig.mEncodeHeight;
            this.mCurrentVideoConfig.bHardwareEncoder = hard;
            this.mCurrentVideoConfig.encodeType = encodeType;
            this.mCurrentVideoConfig.orientation = this.mCapture == null || this.mCapture.getClass() == YYLiveDefaultCamera.class ? ((YYPreviewConfig)YYLiveAPI.sharedInstance().getPublisher().getDefaluteCamera().getCaptureConfig()).captureOrientation : 0;
            this.mCurrentVideoConfig.bLowLatency = videoConfig.mLowDelay;
        }
        if (bMirrorFrontCamera != this.mCurrentVideoConfig.bMirrorFrontCamera) {
            this.mPublisher.enableMirror(bMirrorFrontCamera);
            this.mCurrentVideoConfig.bMirrorFrontCamera = bMirrorFrontCamera;
        }
        if (2 != this.mVideoPublishState) {
            this.mVideoPublishState = 2;
            YYLiveLog.info("YYVideoEngineImp", "updatePublishVideoConfig state:2");
        }
        return this.mCurrentVideoConfig;
    }

    public boolean setCameraPosition(int position) {
        ((YYPreviewConfig)YYLiveAPI.sharedInstance().getPublisher().getDefaluteCamera().getCaptureConfig()).cameraPosition = position;
        return this.mPublisher.setCameraPosition(position);
    }

    public int setPubWatermark(float x, float y, Object image) {
        return this.mPublisher.setWatermark((Bitmap)image, (int)x, (int)y);
    }

    public int setPubFaceBeautyLevel(float level) {
        if (this.mOrangeFilterWrapper != null) {
            this.mOrangeFilterWrapper.setBeautyParam(level);
        }
        return 0;
    }

    public int onVideoStreamArrive(String streamKey, long streamId) {
        YYLivePlayerView view = this.mVideoViewMap.get(streamKey);
        if (view == null) {
            YYLiveLog.warn("YYvideoEngineImp", "onVideoStreamArrive: cannot find video view for stream:%s", streamKey);
            return -1;
        }
        YYLiveLog.info("YYvideoEngineImp", "link stream:%s, %d", streamKey, streamId);
        view.linkToStream(streamId);
        if (view != null && view.getYspVideoView() != null) {
            view.getYspVideoView().setVideoInfoCallback((IVideoInfoCallback)this.mYYVideoPlayListener);
        }
        this.mVideoViewStreamKeyAndIdMap.put(streamKey, streamId);
        return 0;
    }

    public int onVideoStreamStop(String streamKey, long streamId) {
        YYLivePlayerView view = this.mVideoViewMap.get(streamKey);
        if (view == null) {
            YYLiveLog.warn("YYvideoEngineImp", "onVideoStreamStop: cann't find video view for stream:%s", streamKey);
            return -1;
        }
        YYLiveLog.info("YYvideoEngineImp", "unlink stream:%s-%d", streamKey, streamId);
        view.unLinkFromStream(streamId);
        if (view != null && view.getYspVideoView() != null) {
            view.getYspVideoView().setVideoInfoCallback(null);
        }
        return 0;
    }

    public int onRequestIFrame() {
        this.mPublisher.requestEncodeIFrame();
        return 0;
    }

    public int onDynamicBitrate(long bitrate) {
        this.mPublisher.setNetworkBitrateSuggest((int)bitrate * 1000);
        return 0;
    }

    public String getAnchorHiidoStatInfo(long streamId) {
        return VideoDataStat.getInstance().getAnchorVideoData(streamId);
    }

    public String getAudienceHiidoStatInfo(long streamId) {
        return VideoPlayerDataStat.getInstance().getAudienceVideoData(streamId);
    }

    public int getPublishRuntimeInfo(int type) {
        switch (type) {
            case 0: {
                return this.mPublisher.getVideoPublishInfo(VideoPublish.VideoPublishInfoEnum.FRAME);
            }
            case 1: {
                return this.mPublisher.getVideoPublishInfo(VideoPublish.VideoPublishInfoEnum.BITRATE);
            }
            case 2: {
                return this.mPublisher.getVideoPublishInfo(VideoPublish.VideoPublishInfoEnum.RESOLUTION);
            }
        }
        return 0;
    }

    public long getPlayRuntimeInfo(long streamId, int type) {
        switch (type) {
            case 0: {
                return VideoPlayer.getInstance().getPlayerInfo(streamId, VideoPlayer.VideoPlayerInfoEnum.FRAME);
            }
            case 1: {
                break;
            }
            case 2: {
                return VideoPlayer.getInstance().getPlayerInfo(streamId, VideoPlayer.VideoPlayerInfoEnum.RESOLUTION);
            }
        }
        return 0L;
    }

    public int setPublisherPtsAdjustVal(int adjustVal) {
        if (this.mPublisher != null) {
            YYLiveLog.debug("YYvideoEngineImp", "setPublisherPtsAdjustVal " + adjustVal);
            this.mPublisher.setDeltaYYPtsMillions((long)adjustVal);
        }
        return 0;
    }

    public void onEncodeFrameData(byte[] data, int len, long pts, long dts, int frameType, VideoEncoderType encoderType) {
        int encodeType = 1;
        boolean bHardware = false;
        switch (encoderType) {
            case SOFT_ENCODER_X264: {
                bHardware = false;
                encodeType = 1;
                break;
            }
            case HARD_ENCODER_H264: {
                bHardware = true;
                encodeType = 1;
                break;
            }
            case SOFT_ENCODER_H265: {
                bHardware = false;
                encodeType = 2;
                break;
            }
            case HARD_ENCODER_H265: {
                bHardware = true;
                encodeType = 2;
                break;
            }
            case DEFAULT: 
            case ERROR: {
                YYLiveLog.warn("YYvideoEngineImp", "unknown encoder type" + encoderType.toString());
            }
        }
        if (this.mCallBackPtr != 0L) {
            this.onVideoEncodedFrame(this.mCallBackPtr, data, len, pts, dts, frameType, encodeType, bHardware);
        }
    }

    public int onTextureCallback(int textureId, int width, int height) {
        if (!this.isUsingDefaultCamera()) {
            return textureId;
        }
        YYLiveDefaultCamera camera = YYLiveAPI.sharedInstance().getPublisher().getDefaluteCamera();
        if (camera.getCameraDataCallback() == null) {
            return textureId;
        }
        return camera.getCameraDataCallback().onTextureCallback(textureId, width, height);
    }

    void onVideoRenderNotify(ArrayList<VideoRenderNotify> notifications) {
        if (this.mCallBackPtr != 0L) {
            YYLiveNative.onVideoRenderEvent(this.mCallBackPtr, notifications);
        }
    }

    void onHardwareDecodeErrorNotify(long userGroupId, long streamId, int errorType) {
        YYLiveLog.info("YYvideoEngineImp", "onHardwareDecodeErrorNotify %d", errorType);
        YYLiveNative.enableHardwareDecoder(false, 1);
        YYLiveNative.enableHardwareDecoder(false, 2);
        if (this.mVideoConfigManager != null) {
            this.mVideoConfigManager.disableHardDecode(true);
        }
    }

    private native void onVideoEncodedFrame(long var1, byte[] var3, int var4, long var5, long var7, int var9, int var10, boolean var11);

    public void stopAndRecoverVideoEncode(boolean stop) {
        if (this.mPublisher != null && this.mVideoPreviewState != 0) {
            this.mPublisher.stopAndRecoverStream(Boolean.valueOf(stop));
        }
    }

    public void onFirstFrameRenderNotify(long userGroupId, long streamId, long currentSystemMilliSecond, long firstFrameToRenderInMilliSec, int eatenFrames) {
        YYLiveNative.onFirstFrameRenderNotify(userGroupId, streamId, currentSystemMilliSecond, firstFrameToRenderInMilliSec, eatenFrames);
    }

    public void onUpdateVideoSizeChanged(long streamId, int width, int height) {
        YYLiveNative.onUpdateVideoSizeChanged(streamId, width, height);
    }

    private static class YVideoPublishVideoConfig {
        int encodeFrameRate;
        int encodeBitrate;
        int encodeResolutionWidth;
        int encodeResolutionHeight;
        int encodeType;
        boolean bHardwareEncoder;
        int mode;
        boolean bMirrorFrontCamera;
        boolean bLowLatency;
        int playType;
        int orientation;

        public YVideoPublishVideoConfig(int encodeFrameRate, int encodeBitrate, int encodeResolutionWidth, int encodeResolutionHeight, int encodeType, boolean bHardwareEncoder, int mode) {
            this.encodeFrameRate = encodeFrameRate;
            this.encodeBitrate = encodeBitrate;
            this.encodeResolutionWidth = encodeResolutionWidth;
            this.encodeResolutionHeight = encodeResolutionHeight;
            this.encodeType = encodeType;
            this.bHardwareEncoder = bHardwareEncoder;
            this.mode = mode;
        }

        public String toString() {
            String tmp = "" + this.encodeResolutionWidth + "x" + this.encodeResolutionHeight + "@" + this.encodeFrameRate + " " + this.encodeBitrate + " hard:" + this.bHardwareEncoder + " mode:" + this.mode;
            return tmp;
        }
    }
}

