/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivesdk4cloud.audio;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import com.yy.yylivesdk4cloud.audio.AudioCodecConfig;
import com.yy.yylivesdk4cloud.audio.AudioDeviceModeConfig;
import com.yy.yylivesdk4cloud.audio.AudioKaraokeCompensateConfig;
import com.yy.yylivesdk4cloud.audio.AudioOpenSlEsConfig;
import com.yy.yylivesdk4cloud.audio.AudioPreProcConfig;
import com.yy.yylivesdk4cloud.audio.IAudioConfigCallbackInterface;
import com.yy.yylivesdk4cloud.audio.IAudioJsonParseInterface;
import com.yy.yylivesdk4cloud.helper.YYLiveLog;
import org.json.JSONArray;
import org.json.JSONObject;

public class AudioJsonParseImp
implements IAudioJsonParseInterface {
    private static final String TAG = "AudioJsonParseImp";
    private HandlerThread mProcessAudioJsonParseThread;
    private Handler mProcessAudioJsonParseHandler;
    private IAudioConfigCallbackInterface mCallback;
    private boolean mReady = false;
    private static final int MESSAGE_AUDIO_ENCODE_CONFIG = 0;
    private static final int MESSAGE_AUDIO_PREPROC_CONFIG = 1;
    private static final int MESSAGE_AUDIO_OPENSLES_CONFIG = 2;
    private static final int MESSAGE_AUDIO_DEVICE_MODE_CONFIG = 3;
    private static final int MESSAGE_AUDIO_KARAOKE_COMP_CONFIG = 4;

    public AudioJsonParseImp(IAudioConfigCallbackInterface callback) {
        this.mCallback = callback;
        this.mProcessAudioJsonParseThread = new HandlerThread("AudioJsonParseThread");
        this.mProcessAudioJsonParseThread.start();
        this.mProcessAudioJsonParseHandler = new Handler(this.mProcessAudioJsonParseThread.getLooper()){

            public void handleMessage(Message msg) {
                if (!AudioJsonParseImp.this.mReady) {
                    YYLiveLog.warn(AudioJsonParseImp.TAG, " ProcessAudioJsonParseHandler not Ready !");
                    return;
                }
                try {
                    String data = (String)msg.obj;
                    switch (msg.what) {
                        case 0: {
                            AudioJsonParseImp.this.handleParseAudioEncodeConfig(data);
                            break;
                        }
                        case 1: {
                            AudioJsonParseImp.this.handleParseAudioPreProcConfig(data);
                            break;
                        }
                        case 2: {
                            AudioJsonParseImp.this.handleParseAudioOpenSlEsConfig(data);
                            break;
                        }
                        case 3: {
                            AudioJsonParseImp.this.handleParseAudioDeviceModeConfig(data);
                            break;
                        }
                        case 4: {
                            AudioJsonParseImp.this.handleParseAudioKaraokeCompConfig(data);
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    YYLiveLog.error(AudioJsonParseImp.TAG, " mProcessAudioJsonParseHandler deal error :" + e.toString());
                }
            }
        };
        this.mReady = true;
    }

    private void handleParseAudioEncodeConfig(String response) {
        if (response.length() == 0) {
            if (this.mCallback != null) {
                this.mCallback.notifyAudioEncodeJsonConfigResult(null);
            }
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(response);
            JSONArray jsonArray = jsonObject.optJSONArray("codecConfig");
            AudioCodecConfig[] configs = new AudioCodecConfig[jsonArray.length()];
            for (int i = 0; i < jsonArray.length(); ++i) {
                AudioCodecConfig config = new AudioCodecConfig();
                JSONObject item = jsonArray.getJSONObject(i);
                config.codecId = item.optInt("codecId");
                config.bitRate = item.optInt("bitRate");
                config.sampleRate = item.optInt("sampleRate");
                config.channels = item.optInt("channels");
                configs[i] = config;
            }
            if (this.mCallback != null) {
                this.mCallback.notifyAudioEncodeJsonConfigResult(configs);
            } else {
                YYLiveLog.error(TAG, " handlderParseAudioEncodeConfig no callback");
            }
        }
        catch (Exception e) {
            YYLiveLog.error(TAG, " handlderParseAudioEncodeConfig error :" + e.toString());
        }
    }

    private void handleParseAudioPreProcConfig(String response) {
        if (response.length() == 0) {
            if (this.mCallback != null) {
                this.mCallback.notifyAudioPreProcJsonConfigResult(null);
            }
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(response);
            JSONArray jsonArray = jsonObject.optJSONArray("preProcConfig");
            AudioPreProcConfig[] configs = new AudioPreProcConfig[jsonArray.length()];
            for (int i = 0; i < jsonArray.length(); ++i) {
                AudioPreProcConfig config = new AudioPreProcConfig();
                JSONObject item = jsonArray.getJSONObject(i);
                config.sceneId = item.optInt("sceneId");
                config.aec = item.optInt("aec");
                config.agc = item.optInt("agc");
                config.vad = item.optInt("vad");
                configs[i] = config;
            }
            if (this.mCallback != null) {
                this.mCallback.notifyAudioPreProcJsonConfigResult(configs);
            } else {
                YYLiveLog.error(TAG, " handleParseAudioPreProcConfig no callback");
            }
        }
        catch (Exception e) {
            YYLiveLog.error(TAG, " handleParseAudioPreProcConfig error :" + e.toString());
        }
    }

    private void handleParseAudioOpenSlEsConfig(String response) {
        if (response.length() == 0) {
            if (this.mCallback != null) {
                this.mCallback.notifyAudioOpenSlEsJsonConfigResult(null);
            }
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(response);
            JSONArray jsonArray = jsonObject.optJSONArray("openslesConfig");
            AudioOpenSlEsConfig[] configs = new AudioOpenSlEsConfig[jsonArray.length()];
            for (int i = 0; i < jsonArray.length(); ++i) {
                AudioOpenSlEsConfig config = new AudioOpenSlEsConfig();
                JSONObject item = jsonArray.getJSONObject(i);
                config.inputNumSLBuffer = item.optInt("inputNumSLBuffer");
                config.inputNum10msBuffer = item.optInt("inputNum10msBuffer");
                config.outputNumSLBuffer = item.optInt("outputNumSLBuffer");
                config.outputNum10msBuffer = item.optInt("outputNum10msBuffer");
                config.enableOpenSlEsOutputNewLogic = item.optBoolean("openslesOutputNewLogic");
                configs[i] = config;
            }
            if (this.mCallback != null) {
                this.mCallback.notifyAudioOpenSlEsJsonConfigResult(configs);
            } else {
                YYLiveLog.error(TAG, " handleParseAudioOpenSlEsConfig no callback");
            }
        }
        catch (Exception e) {
            YYLiveLog.error(TAG, " handleParseAudioOpenSlEsConfig error :" + e.toString());
        }
    }

    private void handleParseAudioDeviceModeConfig(String response) {
        if (response.length() == 0) {
            if (this.mCallback != null) {
                this.mCallback.notifyAudioDeviceModeJsonConfigResult(null);
            }
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(response);
            JSONArray jsonArray = jsonObject.optJSONArray("deviceModeConfig");
            AudioDeviceModeConfig[] configs = new AudioDeviceModeConfig[jsonArray.length()];
            for (int i = 0; i < jsonArray.length(); ++i) {
                AudioDeviceModeConfig config = new AudioDeviceModeConfig();
                JSONObject item = jsonArray.getJSONObject(i);
                config.audioLoudMode = item.optInt("audioLoudMode");
                config.inputLoudStreamType = item.optInt("inputLoudStreamType");
                config.outputLoudStreamType = item.optInt("outputLoudStreamType");
                config.audioMode = item.optInt("audioMode");
                config.inputStreamType = item.optInt("inputStreamType");
                config.outputStreamType = item.optInt("outputStreamType");
                config.audioHDMode = item.optInt("audioHDMode");
                config.inputHDStreamType = item.optInt("inputHDStreamType");
                config.outputHDStreamType = item.optInt("outputHDStreamType");
                configs[i] = config;
            }
            if (this.mCallback != null) {
                this.mCallback.notifyAudioDeviceModeJsonConfigResult(configs);
            } else {
                YYLiveLog.error(TAG, " handleParseAudioDeviceModeConfig no callback");
            }
        }
        catch (Exception e) {
            YYLiveLog.error(TAG, " handleParseAudioDeviceModeConfig error :" + e.toString());
        }
    }

    private void handleParseAudioKaraokeCompConfig(String response) {
        if (response.length() == 0) {
            if (this.mCallback != null) {
                this.mCallback.notifyAudioKaraokeCompJsonConfigResult(null);
            }
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(response);
            JSONArray jsonArray = jsonObject.optJSONArray("karaokeCompConfig");
            AudioKaraokeCompensateConfig[] configs = new AudioKaraokeCompensateConfig[jsonArray.length()];
            for (int i = 0; i < jsonArray.length(); ++i) {
                AudioKaraokeCompensateConfig config = new AudioKaraokeCompensateConfig();
                JSONObject item = jsonArray.getJSONObject(i);
                config.compValue = item.optInt("compValue");
                configs[i] = config;
            }
            if (this.mCallback != null) {
                this.mCallback.notifyAudioKaraokeCompJsonConfigResult(configs);
            } else {
                YYLiveLog.error(TAG, " handleParseAudioKaraokeCompConfig no callback");
            }
        }
        catch (Exception e) {
            YYLiveLog.error(TAG, " handleParseAudioKaraokeCompConfig error :" + e.toString());
        }
    }

    @Override
    public void parseAudioEncodeConfig(String response) {
        if (this.mReady) {
            Message msg = Message.obtain();
            msg.what = 0;
            msg.obj = response;
            this.mProcessAudioJsonParseHandler.sendMessage(msg);
        }
    }

    @Override
    public void parseAudioPreProcConfig(String response) {
        if (this.mReady) {
            Message msg = Message.obtain();
            msg.what = 1;
            msg.obj = response;
            this.mProcessAudioJsonParseHandler.sendMessage(msg);
        }
    }

    @Override
    public void parseAudioOpensSlEsConfig(String response) {
        if (this.mReady) {
            Message msg = Message.obtain();
            msg.what = 2;
            msg.obj = response;
            this.mProcessAudioJsonParseHandler.sendMessage(msg);
        }
    }

    @Override
    public void parseAudioDeviceModeConfig(String response) {
        if (this.mReady) {
            Message msg = Message.obtain();
            msg.what = 3;
            msg.obj = response;
            this.mProcessAudioJsonParseHandler.sendMessage(msg);
        }
    }

    @Override
    public void parseAudioKaraokeCompConfig(String response) {
        if (this.mReady) {
            Message msg = Message.obtain();
            msg.what = 4;
            msg.obj = response;
            this.mProcessAudioJsonParseHandler.sendMessage(msg);
        }
    }
}

