/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivesdk4cloud;

import android.graphics.Bitmap;
import com.yy.mediaframework.gpuimage.custom.OrangeFilterWrapper;
import com.yy.mediaframework.utils.YMFLog;
import com.yy.yylivesdk4cloud.YYConstant;
import com.yy.yylivesdk4cloud.YYLiveAudioCapture;
import com.yy.yylivesdk4cloud.YYLiveBridgeLib;
import com.yy.yylivesdk4cloud.YYLiveDefaultCamera;
import com.yy.yylivesdk4cloud.YYLiveDefaultMic;
import com.yy.yylivesdk4cloud.YYLiveScreenCapture;
import com.yy.yylivesdk4cloud.YYLiveVideoCapture;
import com.yy.yylivesdk4cloud.YYPublishAudioConfig;
import com.yy.yylivesdk4cloud.YYPublishVideoConfig;
import com.yy.yylivesdk4cloud.helper.YYLiveLog;
import com.yy.yylivesdk4cloud.helper.YYLiveNative;
import com.yy.yylivesdk4cloud.video.YYVideoLogCallback;
import java.util.ArrayList;
import java.util.HashMap;

public class YYLivePublisher {
    private YYPublishAudioConfig mAudioConfig = null;
    private YYLiveAudioCapture mAudioCapture = null;
    private YYLiveDefaultMic mDefaultMic = new YYLiveDefaultMic();
    private YYPublishVideoConfig mVideoConfig = null;
    private YYLiveVideoCapture mVideoCapture = null;
    private YYLiveDefaultCamera mDefaultCamera = new YYLiveDefaultCamera();

    YYLivePublisher() {
        YMFLog.registerLogger((Object)YYVideoLogCallback.sharedInstance());
    }

    public int startPreviewWithView(Object view, int playType, int publishMode) {
        YYLiveLog.release("ycall-Java", "startPreviewWithView view:%s", view.toString());
        return YYLiveNative.startVideoPreview(view, playType, publishMode);
    }

    public int stopPreview() {
        YYLiveLog.release("ycall-Java", "stopVideoPreview");
        return YYLiveNative.stopVideoPreview();
    }

    public void setLivePublishRtmpParam(boolean bOpen, String url, String playPath) {
        YYLiveLog.release("ycall-Java", "setLivePublishRtmpParam");
        YYLiveNative.setLivePublishRtmpParam(bOpen, url, playPath);
    }

    public OrangeFilterWrapper getBeautyFilter() {
        return YYLiveBridgeLib.getInstance().getBeautyFilter();
    }

    public int startPublishVideo(String streamName, ArrayList<String> groupNames, YYPublishVideoConfig config) {
        if (streamName == null || streamName.isEmpty()) {
            YYLiveLog.error("ycall-Java", "startPublishVideo stream name must be set");
            return -1;
        }
        if (groupNames == null) {
            groupNames = new ArrayList(0);
        }
        if (config == null) {
            config = new YYPublishVideoConfig();
        }
        this.mVideoConfig = config;
        YYLiveLog.release("ycall-Java", "startPublishVideo streamName:%s, groupNames size:%d, config:%s", streamName, groupNames.size(), config.toString());
        return YYLiveNative.startPublishVideo(streamName, groupNames, config);
    }

    public int stopPublishVideo() {
        YYLiveLog.release("ycall-Java", "stopPublishVideo");
        return YYLiveNative.stopPublishVideo();
    }

    public HashMap<Integer, String> getSupportModeInfoWithPlayType(int playType) {
        int convertType = this.convertPlayType(playType);
        HashMap<Integer, String> map = YYLiveNative.getSupportModeInfoWithPlayType(convertType);
        return map;
    }

    public void disableHardEncoder(Boolean disable) {
        YYLiveNative.disableHardEncoder(disable);
    }

    public YYPublishVideoConfig getRemotePublishVideoConfig(int playType, int mode) {
        int convertType = this.convertPlayType(playType);
        YYPublishVideoConfig remotePublishVideoConfig = YYLiveNative.getRemoteVideoConfig(convertType, mode);
        return remotePublishVideoConfig;
    }

    public int getDefaultPublishVideoMode(int playType) {
        int convertType = this.convertPlayType(playType);
        return YYLiveNative.getDefaultPublishVideoMode(convertType);
    }

    public YYPublishVideoConfig getCurPublishVideoConfig() {
        return YYLiveNative.getVideoConfig();
    }

    public boolean updatePublishVideoConfig(YYPublishVideoConfig config) {
        this.mVideoConfig = config;
        return YYLiveNative.updateVideoConfig(config);
    }

    public int startPublishAudio(String streamName, ArrayList<String> groupNames, YYPublishAudioConfig config) {
        if (this.mAudioCapture == null) {
            YYLiveNative.attachAudioCapture(this.mDefaultMic);
        }
        if (streamName == null || streamName.isEmpty()) {
            YYLiveLog.error("ycall-Java", "startPublishAudio stream name must be set");
            return -1;
        }
        if (groupNames == null) {
            groupNames = new ArrayList(0);
        }
        if (config == null) {
            config = new YYPublishAudioConfig(4);
        }
        this.mAudioConfig = config;
        YYLiveLog.release("ycall-Java", "startPublishAudio streamName:%s, groupNames size:%d, config:%s", streamName, groupNames.size(), config.toString());
        return YYLiveNative.startPublishAudio(streamName, groupNames, config);
    }

    public int stopPublishAudio() {
        YYLiveLog.release("ycall-Java", "stopPublishAudio");
        return YYLiveNative.stopPublishAudio();
    }

    public YYPublishAudioConfig getCurPublishAudioConfig() {
        return this.mAudioConfig;
    }

    public boolean setCameraPosition(int position) {
        YYLiveLog.release("ycall-Java", "setCameraPosition %d", position);
        return YYLiveNative.setCameraPosition(position);
    }

    public int setWatermark(int posX, int posY, Bitmap image) {
        if (image == null) {
            return -1;
        }
        YYLiveLog.release("ycall-Java", "setWatermark in (%d,%d)", posX, posY);
        return YYLiveNative.setWatermark(posX, posY, image);
    }

    public int setFaceBeautyLevel(float level) {
        if (level >= 1.000001f) {
            level = 1.0f;
        } else if (level < 1.0E-6f) {
            level = 0.0f;
        }
        YYLiveLog.release("ycall-Java", "setFaceBeautyLevel %f", Float.valueOf(level));
        return YYLiveNative.setFaceBeautyLevel(level);
    }

    public boolean setMicVolume(int volume) {
        if (volume < 0) {
            volume = 0;
        }
        YYLiveLog.release("ycall-Java", "setMicVolume %d", volume);
        return YYLiveNative.setMicVolume(volume);
    }

    public void enableVad(boolean enable) {
        YYLiveLog.release("ycall-Java", "enableVad %b", enable);
        YYLiveNative.enableVad(enable);
    }

    public void EnableEqualizer(boolean enable) {
        YYLiveLog.release("ycall-Java", "EnableEqualizer %b", enable);
        YYLiveNative.EnableEqualizer(enable);
    }

    public void SetGqGains(int[] gains) {
        YYLiveNative.SetGqGains(gains);
    }

    public void EnableCompressor(boolean enable) {
        YYLiveNative.EnableCompressor(enable);
    }

    public void EnableLimiter(boolean enable) {
        YYLiveNative.EnableLimiter(enable);
    }

    public void SetCompressorParam(int threshold, int makeupGain, int ratio, int knee, int releaseTime, int attackTime) {
        YYLiveNative.SetCompressorParam(threshold, makeupGain, ratio, knee, releaseTime, attackTime);
    }

    public void SetLimiterParam(float fCeiling, float fThreshold, float fPreGain, float fRelease, float fAttack, float fLookahead, float fLookaheadRatio, float fRMS, float fStLink) {
        YYLiveNative.setLimiterParameter(fCeiling, fThreshold, fPreGain, fRelease, fAttack, fLookahead, fLookaheadRatio, fRMS, fStLink);
    }

    public void EnableReverb(boolean enable) {
        YYLiveNative.EnableReverb(enable);
    }

    public void setReverbExParameter(float RoomSize, float PreDelay, float Reverberance, float HfDamping, float ToneLow, float ToneHigh, float WetGain, float DryGain, float StereoWidth) {
        YYLiveNative.setReverbExParameter(RoomSize, PreDelay, Reverberance, HfDamping, ToneLow, ToneHigh, WetGain, DryGain, StereoWidth);
    }

    public YYLiveDefaultMic getDefaluteMic() {
        return this.mDefaultMic;
    }

    public void attachAudioCapture(YYLiveAudioCapture capture) {
        this.mAudioCapture = capture == null ? this.mDefaultMic : capture;
        YYLiveLog.release("ycall-Java", "attachAudioCapture %s", this.mAudioCapture.toString());
        YYLiveNative.attachAudioCapture(this.mAudioCapture);
    }

    public void setMixAudioCapture(ArrayList<YYLiveAudioCapture> mixCaptureList) {
    }

    public YYLiveDefaultCamera getDefaluteCamera() {
        return this.mDefaultCamera;
    }

    public void attachVideoCapture(YYLiveVideoCapture capture) {
        this.mVideoCapture = capture == null ? this.mDefaultCamera : capture;
        YYLiveLog.release("ycall-Java", "attachVideoCapture %s", this.mVideoCapture.toString());
        YYLiveNative.attachVideoCapture(this.mVideoCapture);
    }

    public void setMixVideoCapture(ArrayList<YYLiveVideoCapture> mixCaptureList) {
    }

    public void initSreenLiveSession(YYLiveScreenCapture yyLiveScreenCapture) {
        if (yyLiveScreenCapture != null) {
            this.attachVideoCapture(yyLiveScreenCapture);
        }
    }

    public void setOrientation(int orientation) {
        YYLiveNative.setOrientation(orientation);
    }

    public void setAudioSourceType(int mode) {
        YYLiveNative.setAudioSourceType(mode);
    }

    public boolean enableInEarMonitor(boolean enable) {
        return YYLiveNative.enableInEarMonitor(enable);
    }

    public void setSoundEffect(int mode) {
        YYLiveLog.release("ycall-Java", "YYLivePublisher::setSoundEffect %d", mode);
        YYLiveNative.setSoundEffect(mode);
    }

    private int convertPlayType(int playType) {
        switch (playType) {
            case 0: {
                playType = 0;
                break;
            }
            case 1: {
                playType = 1;
                break;
            }
            case 2: {
                playType = 5;
                break;
            }
        }
        return playType;
    }

    public static interface IVideoPublisher {
        public void pushVideoData(byte[] var1, int var2, int var3, int var4, int var5, long var6);

        public void pushVideoData(byte[] var1, YYConstant.YYVideoEncodeType var2, long var3, long var5);
    }

    public static interface IAudioPublisher {
        public void pushAudioData(byte[] var1, long var2);
    }
}

