/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivesdk4cloud;

import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.yy.videoplayer.decoder.GLVersionUtils;
import com.yy.videoplayer.decoder.H264DecRender;
import com.yy.videoplayer.decoder.H265DecRender;
import com.yy.videoplayer.decoder.VideoConstant;
import com.yy.videoplayer.videoview.YCustomGLVideoViewHighEGLExt;
import com.yy.videoplayer.videoview.YCustomGLVideoViewLowEGLExt;
import com.yy.videoplayer.videoview.YGLVideoViewExt;
import com.yy.videoplayer.videoview.YSpVideoView;
import com.yy.videoplayer.videoview.YSurfaceVideoViewExt;
import com.yy.videoplayer.videoview.YVideoViewExt;
import com.yy.yylivesdk4cloud.helper.YYLiveLog;
import com.yy.yylivesdk4cloud.video.YYVideoConfig;

public class YYLivePlayerView
extends FrameLayout {
    private YSpVideoView mVideoView = null;
    private VideoConstant.ViewType mViewType;
    private VideoConstant.ScaleMode mScaleMode = VideoConstant.ScaleMode.AspectFit;
    private long mStreamId = 0L;

    public int getViewType() {
        if (this.mViewType == null) {
            return -1;
        }
        if (this.mViewType == VideoConstant.ViewType.SURFACE_VIDEO_VIEW) {
            return 1;
        }
        return 0;
    }

    public YYLivePlayerView(Context context) {
        super(context);
        this.addView((View)new SurfaceView(context));
    }

    public YYLivePlayerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.addView((View)new SurfaceView(context));
    }

    public YYLivePlayerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.addView((View)new SurfaceView(context));
    }

    private VideoConstant.ScaleMode scaleModeConvert(int scaleMode) {
        switch (scaleMode) {
            case 0: {
                return VideoConstant.ScaleMode.FillParent;
            }
            case 1: {
                return VideoConstant.ScaleMode.AspectFit;
            }
            case 2: {
                return VideoConstant.ScaleMode.ClipToBounds;
            }
        }
        YYLiveLog.warn("yvideo-Java", "invalid scale mode %d", scaleMode);
        return VideoConstant.ScaleMode.AspectFit;
    }

    private boolean createVideoView(VideoConstant.ViewType type) {
        switch (type) {
            case SURFACE_VIDEO_VIEW: {
                this.mVideoView = new YSurfaceVideoViewExt(this.getContext());
                break;
            }
            case NO_GL_VIDEO_VIEW: {
                this.mVideoView = new YVideoViewExt(this.getContext());
                break;
            }
            case CUSTOM_GL_VIDEO_VIEW_LOW: {
                this.mVideoView = new YCustomGLVideoViewLowEGLExt(this.getContext());
                break;
            }
            case CUSTOM_GL_VIDEO_VIEW_HIGH: {
                this.mVideoView = new YCustomGLVideoViewHighEGLExt(this.getContext());
                break;
            }
            case GL_VIDEO_VIEW: {
                this.mVideoView = new YGLVideoViewExt(this.getContext());
                break;
            }
            default: {
                YYLiveLog.release("yvideo-Java", "createVideoView unsupported:" + type.name());
                return false;
            }
        }
        this.mViewType = type;
        ((View)this.mVideoView).setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.addView((View)this.mVideoView);
        this.mVideoView.onParentSizeChanged(this.getWidth(), this.getHeight());
        YYLiveLog.release("yvideo-Java", "createVideoView:" + type.name() + " size " + this.getWidth() + "x" + this.getHeight());
        this.mVideoView.setScaleMode(this.mScaleMode);
        return true;
    }

    public boolean prepareView() {
        this.unPrepareView();
        VideoConstant.ViewType type = YYVideoConfig.isHw264DecodeEnabled() || YYVideoConfig.isHw265DecodeEnabled() ? VideoConstant.ViewType.SURFACE_VIDEO_VIEW : (GLVersionUtils.isGLES20Supported() ? (Build.VERSION.SDK_INT >= 16 && YYVideoConfig.isWindowSurfaceSupport() ? (Build.VERSION.SDK_INT >= 18 ? VideoConstant.ViewType.CUSTOM_GL_VIDEO_VIEW_HIGH : VideoConstant.ViewType.CUSTOM_GL_VIDEO_VIEW_LOW) : VideoConstant.ViewType.GL_VIDEO_VIEW) : VideoConstant.ViewType.NO_GL_VIDEO_VIEW);
        YYLiveLog.release("yvideo-Java", "prepareView:" + type.name());
        return this.createVideoView(type);
    }

    public boolean prepareView(int decoderType) {
        VideoConstant.ViewType type;
        this.unPrepareView();
        if (decoderType == 1) {
            type = VideoConstant.ViewType.SURFACE_VIDEO_VIEW;
        } else if (decoderType == 0 && GLVersionUtils.isGLES20Supported()) {
            type = Build.VERSION.SDK_INT >= 16 && YYVideoConfig.isWindowSurfaceSupport() ? (Build.VERSION.SDK_INT >= 18 ? VideoConstant.ViewType.CUSTOM_GL_VIDEO_VIEW_HIGH : VideoConstant.ViewType.CUSTOM_GL_VIDEO_VIEW_LOW) : VideoConstant.ViewType.GL_VIDEO_VIEW;
        } else if (decoderType == 0) {
            type = VideoConstant.ViewType.NO_GL_VIDEO_VIEW;
        } else {
            YYLiveLog.error("yvideo-Java", "prepareView: invalid decoder type");
            return false;
        }
        YYLiveLog.release("yvideo-Java", "prepareView:%s, decoder type:%d", type.name(), decoderType);
        return this.createVideoView(type);
    }

    public boolean rePrepareView(int format, boolean bHardware) {
        VideoConstant.ViewType type = bHardware && (format == 2 && H264DecRender.IsAvailable() || format == 5 && H265DecRender.IsAvailable()) ? VideoConstant.ViewType.SURFACE_VIDEO_VIEW : (GLVersionUtils.isGLES20Supported() ? (Build.VERSION.SDK_INT >= 16 && YYVideoConfig.isWindowSurfaceSupport() ? (Build.VERSION.SDK_INT >= 18 ? VideoConstant.ViewType.CUSTOM_GL_VIDEO_VIEW_HIGH : VideoConstant.ViewType.CUSTOM_GL_VIDEO_VIEW_LOW) : VideoConstant.ViewType.GL_VIDEO_VIEW) : VideoConstant.ViewType.NO_GL_VIDEO_VIEW);
        if (this.mVideoView != null && this.mViewType == type) {
            return true;
        }
        YYLiveLog.release("yvideo-Java", "rePrepareView: %s -> %s", this.mViewType.name(), type.name());
        this.unPrepareView();
        boolean ret = this.createVideoView(type);
        if (!ret) {
            return false;
        }
        if (this.mStreamId != 0L) {
            this.linkToStream(this.mStreamId);
        }
        return this.mVideoView.setScaleMode(this.mScaleMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unPrepareView() {
        YYLivePlayerView yYLivePlayerView = this;
        synchronized (yYLivePlayerView) {
            this.removeAllViews();
            if (this.mVideoView != null) {
                this.mVideoView.release();
                this.mVideoView = null;
            }
        }
        YYLiveLog.release("yvideo-Java", "unPrepareView.");
    }

    public void linkToStream(long streamId) {
        if (this.mVideoView == null) {
            YYLiveLog.warn("yvideo-Java", "linkToStream: this view doesn't prepare or prepare failed!");
            return;
        }
        this.mStreamId = streamId;
        this.mVideoView.linkToStream(0L, streamId);
    }

    public void unLinkFromStream(long streamId) {
        if (this.mVideoView == null) {
            YYLiveLog.warn("yvideo-Java", "unLinkFromStream: this view doesn't prepare or prepare failed!");
            return;
        }
        this.mStreamId = 0L;
        this.mVideoView.unLinkFromStream(0L, streamId);
    }

    public void unLinkFromStream() {
        if (this.mVideoView == null) {
            YYLiveLog.warn("yvideo-Java", "unLinkFromStream: this view doesn't prepare or prepare failed!");
            return;
        }
        this.mStreamId = 0L;
        this.mVideoView.unLinkFromStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setScaleMode(int scaleMode) {
        boolean reasult = false;
        YYLivePlayerView yYLivePlayerView = this;
        synchronized (yYLivePlayerView) {
            this.mScaleMode = this.scaleModeConvert(scaleMode);
            if (this.mVideoView == null) {
                YYLiveLog.warn("yvideo-Java", "setScaleMode: this view doesn't prepare or prepare failed!");
                return false;
            }
            reasult = this.mVideoView.setScaleMode(this.mScaleMode);
        }
        return reasult;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.mVideoView != null) {
            this.mVideoView.onParentSizeChanged(w, h);
        }
    }

    public YSpVideoView getYspVideoView() {
        return this.mVideoView;
    }
}

