/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivesdk4cloud;

import com.yy.videoplayer.utils.YMFLog;
import com.yy.yylivesdk4cloud.YYLiveGroup;
import com.yy.yylivesdk4cloud.YYLiveStream;
import com.yy.yylivesdk4cloud.helper.YYLiveLog;
import com.yy.yylivesdk4cloud.helper.YYLiveNative;
import com.yy.yylivesdk4cloud.video.YYVideoLogCallback;
import java.util.ArrayList;

public class YYLivePlayer {
    public ArrayList<YYLiveStream> subscribeStreams = null;

    YYLivePlayer() {
        YMFLog.registerLogger((Object)YYVideoLogCallback.sharedInstance());
        this.subscribeStreams = new ArrayList(0);
    }

    public int startPlayStreams(ArrayList<YYLiveStream> streamList, ArrayList<YYLiveGroup> groupList) {
        if (streamList == null) {
            streamList = new ArrayList(0);
        }
        if (groupList == null) {
            groupList = new ArrayList(0);
        }
        if (streamList.size() == 0 && groupList.size() == 0) {
            YYLiveLog.warn("ycall-Java", "startPlayStreams both stream list and group list is empty");
            return -1;
        }
        for (YYLiveStream oneStream : streamList) {
            if (!oneStream.bVideo) continue;
            oneStream.startSubscribeTime = System.currentTimeMillis();
            this.subscribeStreams.add(oneStream);
        }
        YYLiveLog.release("ycall-Java", "startPlayStreams list size: %d %d", streamList.size(), groupList.size());
        return YYLiveNative.startPlayStreams(streamList, groupList);
    }

    public int stopPlayStreams(ArrayList<YYLiveStream> streamList, ArrayList<YYLiveGroup> groupList) {
        if (streamList == null) {
            streamList = new ArrayList(0);
        }
        if (groupList == null) {
            groupList = new ArrayList(0);
        }
        if (streamList.size() == 0 && groupList.size() == 0) {
            YYLiveLog.warn("ycall-Java", "stopPlayStreams both stream list and group list is empty");
            return -1;
        }
        block0: for (YYLiveStream oneStream : streamList) {
            if (!oneStream.bVideo) continue;
            for (YYLiveStream rmStream : this.subscribeStreams) {
                if (!rmStream.bVideo || rmStream.speakerUid != oneStream.speakerUid) continue;
                this.subscribeStreams.remove(rmStream);
                continue block0;
            }
        }
        YYLiveLog.release("ycall-Java", "stopPlayStreams list size: %d %d", streamList.size(), groupList.size());
        return YYLiveNative.stopPlayStreams(streamList, groupList);
    }

    public boolean enableHardwareDecoder(boolean enable) {
        YYLiveLog.release("ycall-Java", "enableHardwareDecoder:%b", enable);
        return YYLiveNative.enableHardwareDecoder(enable, 1);
    }

    public boolean enableMute(boolean enable, YYLiveStream stream) {
        if (stream == null) {
            return false;
        }
        YYLiveLog.release("ycall-Java", "enableMute %b for stream %s", enable, stream.streamName);
        return YYLiveNative.enableMuteStream(enable, stream);
    }

    public boolean enableMute(boolean enable, String uid) {
        YYLiveLog.release("ycall-Java", "enableMute %b for %s", enable, uid);
        return YYLiveNative.enableMuteStringUid(enable, uid);
    }

    public boolean enableAllMute(boolean enable) {
        YYLiveLog.release("ycall-Java", "enableAllMute %b", enable);
        YYLiveNative.enableAllMute(enable);
        return true;
    }

    public boolean setPlayVolume(int volume, YYLiveStream stream) {
        if (stream == null) {
            return false;
        }
        if (volume < 0) {
            volume = 0;
        } else if (volume > 100) {
            volume = 100;
        }
        YYLiveLog.release("ycall-Java", "setPlayVolume %d for stream %s", volume, stream.streamName);
        return YYLiveNative.setStreamPlayVolume(volume, stream);
    }

    public boolean setSpeakerVolume(int volume) {
        if (volume < 0) {
            volume = 0;
        } else if (volume > 100) {
            volume = 100;
        }
        YYLiveLog.release("ycall-Java", "setSpeakerVolume %d", volume);
        return YYLiveNative.setSpeakerVolume(volume);
    }

    public void enableLoudSpeaker(boolean enable) {
        YYLiveLog.release("ycall-Java", "enableLoudSpeaker %b", enable);
        YYLiveNative.enableLoudSpeaker(enable);
    }

    public boolean getLoudSpeakerEnabled() {
        YYLiveLog.release("ycall-Java", "getLoudSpeakerEnabled");
        return YYLiveNative.getLoudSpeakerEnabled();
    }

    public boolean isSupportPlayH265() {
        return YYLiveNative.isSupportPlayH265();
    }

    public void setSubscribeStreamWHByUid(long uid, int _width, int _height) {
        for (YYLiveStream oneStream : this.subscribeStreams) {
            if (!oneStream.bVideo || oneStream.speakerUid != uid) continue;
            oneStream.width = _width;
            oneStream.height = _height;
        }
    }

    public YYLiveStream getSubscribeStreamByUid(long uid) {
        for (YYLiveStream oneStream : this.subscribeStreams) {
            if (!oneStream.bVideo || oneStream.speakerUid != uid) continue;
            return oneStream;
        }
        return null;
    }

    public void removeSubscribeStreamByUid(long uid) {
        YYLiveStream findStream = null;
        for (YYLiveStream oneStream : this.subscribeStreams) {
            if (!oneStream.bVideo || oneStream.speakerUid != uid) continue;
            findStream = oneStream;
        }
        if (findStream != null) {
            this.subscribeStreams.remove(findStream);
        }
    }
}

