package com.yy.yylivesdk4cloud.video.serviceConfig;

import com.yy.yylivesdk4cloud.YYConstant;
import com.yy.yylivesdk4cloud.YYLiveAPI;
import com.yy.yylivesdk4cloud.helper.YYLiveLog;
import com.yy.yylivesdk4cloud.helper.YYLiveNative;


/**
 * Created by Administrator on 2018/8/15.
 */

public class VideoPlayerImp implements IVideoPlayerInterface {
    private final static String TAG = "cfg_VideoPlayerImp";

    private boolean mH265Support = false;
    @Override
    public void performVideoConfig(VideoLiveConfig[] configs) {
        if(configs == null || configs.length == 0){
            YYLiveLog.warn(TAG, "VideoConfig is null!");
            return;
        }
        if(configs[0].playType == VideoLiveConfig.Type.PLAYER_H264){
            if(configs[0].decodeType == VideoLiveConfig.DecodeType.CODEC_DECODEC_H264_HW){
                YYLiveLog.info(TAG, "player enable hardware h264");
                YYLiveNative.enableHardwareDecoder(true, YYConstant.YYVideoEncodeType.YYVIDEO_ENCODE_TYPE_H264);
            }else {
                YYLiveLog.info(TAG, "player disable hardware h264");
                YYLiveNative.enableHardwareDecoder(false, YYConstant.YYVideoEncodeType.YYVIDEO_ENCODE_TYPE_H264);
            }
        }


        if(configs[0].playType == VideoLiveConfig.Type.PLAYER_H265){
            if(configs[0].decodeType == VideoLiveConfig.DecodeType.CODEC_DECODEC_H265_HW){
                YYLiveLog.info(TAG, "player enable hardware h265");
                YYLiveNative.enableHardwareDecoder(true, YYConstant.YYVideoEncodeType.YYVIDEO_ENCODE_TYPE_H265);
                mH265Support = true;
            }else if(configs[0].decodeType == VideoLiveConfig.DecodeType.CODEC_DECODEC_H265_SOFT){
                YYLiveLog.info(TAG, "player enable soft h265");
                YYLiveNative.enableHardwareDecoder(false, YYConstant.YYVideoEncodeType.YYVIDEO_ENCODE_TYPE_H265);
                mH265Support = true;
            }else {
                //不支持H265
                YYLiveLog.info(TAG, "player no support 265 dec  ");
            }
        }
    }

    @Override
    public boolean H265PlaySupport() {
        return mH265Support;
    }
}
