package com.yy.yylivesdk4cloud.video;

import android.os.DeadSystemException;

import com.yy.yylivesdk4cloud.helper.YYLiveLog;

import java.net.UnknownHostException;

import static com.yy.yylivesdk4cloud.YYConstant.YYLogLevel.YYLOG_LEVEL_DEBUG;
import static com.yy.yylivesdk4cloud.YYConstant.YYLogLevel.YYLOG_LEVEL_ERROR;
import static com.yy.yylivesdk4cloud.YYConstant.YYLogLevel.YYLOG_LEVEL_INFO;
import static com.yy.yylivesdk4cloud.YYConstant.YYLogLevel.YYLOG_LEVEL_TRACE;
import static com.yy.yylivesdk4cloud.YYConstant.YYLogLevel.YYLOG_LEVEL_WARN;
import static com.yy.yylivesdk4cloud.helper.YYLiveLog.YYLogModule.YYLOG_MODULE_VIDEO;

/**
 * Created by xiaojun on 2017/12/28.
 * Copyright (c) 2017 YY Inc. All rights reserved.
 */

public class YYVideoLogCallback implements com.yy.videoplayer.utils.ILog,
										   com.yy.mediaframework.utils.ILog {

	private static class SingletonHolder {
		private static final YYVideoLogCallback INSTANCE = new YYVideoLogCallback();
	}

	public static YYVideoLogCallback sharedInstance() {
		return SingletonHolder.INSTANCE;
	}

	@Override
	public void verbose(String tag, String text) {
		YYLiveLog.logM(YYLOG_LEVEL_TRACE, YYLOG_MODULE_VIDEO, tag, text);
	}

	@Override
	public void debug(String tag, String text) {
		YYLiveLog.logM(YYLOG_LEVEL_DEBUG, YYLOG_MODULE_VIDEO, tag, text);
	}

	@Override
	public void info(String tag, String text) {
		YYLiveLog.logM(YYLOG_LEVEL_INFO, YYLOG_MODULE_VIDEO, tag, text);
	}

	@Override
	public void warn(String tag, String text) {
		YYLiveLog.logM(YYLOG_LEVEL_WARN, YYLOG_MODULE_VIDEO, tag, text);
	}

	@Override
	public void error(String tag, String text) {
		YYLiveLog.logM(YYLOG_LEVEL_ERROR, YYLOG_MODULE_VIDEO, tag, text);
	}

	@Override
	public void error(String tag, String text, Throwable tr) {
		if (tr != null) {
			Throwable t = tr;
			while (t != null) {
				if (t instanceof UnknownHostException) {
					break;
				}
				if (t instanceof DeadSystemException) {
					YYLiveLog.error(YYLiveLog.kLogTagSdk, "DeadSystemException: The system died; "
							+ "earlier logs will point to the root cause");
					break;
				}
				t = t.getCause();
			}
			if (t == null) {
				tr.printStackTrace();
			}
		}

		YYLiveLog.logM(YYLOG_LEVEL_ERROR, YYLOG_MODULE_VIDEO, tag, text);
	}
}
