package com.yy.yylivesdk4cloud.system;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.Application;
import android.app.KeyguardManager;
import android.content.Context;
import android.os.Bundle;

import com.yy.yylivesdk4cloud.helper.YYLiveLog;
import com.yy.yylivesdk4cloud.helper.YYLiveNative;

import java.util.List;

/**
 * Created by xiaojun on 2018/1/12.
 * Copyright (c) 2017 YY Inc. All rights reserved.
 */

public class YYForeBackgroundListener implements Application.ActivityLifecycleCallbacks {

	private Context mContext;
	private boolean mIsAppOnBackground = false;

	public YYForeBackgroundListener(Context context) {
		this.mContext = context;
	}

	public void init() {
		((Application)mContext).registerActivityLifecycleCallbacks(this);
	}

	public void fini() {
		((Application)mContext).unregisterActivityLifecycleCallbacks(this);
	}

	private boolean isBackgroundRunning(Activity activity) {
		try {
			String processName = activity.getPackageName();
			ActivityManager activityManager = (ActivityManager) activity.getSystemService(Activity.ACTIVITY_SERVICE);
			KeyguardManager keyguardManager = (KeyguardManager) activity.getSystemService(Activity.KEYGUARD_SERVICE);

			if (activityManager == null || keyguardManager == null) {
				return false;
			}

			List<ActivityManager.RunningAppProcessInfo> processList = activityManager.getRunningAppProcesses();
			if (processList == null) {
				return false;
			}

			for (ActivityManager.RunningAppProcessInfo process : processList) {
				if (process.processName.equalsIgnoreCase(processName)) {
					boolean isBackground = false;
					if (process.importance != ActivityManager.RunningAppProcessInfo.IMPORTANCE_FOREGROUND
							&& process.importance != ActivityManager.RunningAppProcessInfo.IMPORTANCE_VISIBLE) {
						isBackground = true;
					}

					boolean isLockedState = keyguardManager.inKeyguardRestrictedInputMode();
					return isBackground || isLockedState;
				}
			}
		} catch (Exception e) {
			String msg = (e == null) ? "null" : e.getMessage();
			YYLiveLog.error(YYLiveLog.kLogTagSdk, "isBackgroundRunning error:%s", msg);
		}
		return false;
	}

	public void onActivityCreated(Activity activity, Bundle savedInstanceState) {

	}

	public void onActivityStarted(Activity activity) {

	}

	public void onActivityResumed(Activity activity) {

		if (activity != null) {
			if (mIsAppOnBackground) {
				boolean flag = isBackgroundRunning(activity);
				if (!flag) {
					mIsAppOnBackground = false;
					YYLiveLog.info(YYLiveLog.kLogTagSdk, "%s APP background -> foreground",
							activity.toString());
					YYLiveNative.enterForeground();
				}
			}
		}
	}

	public void onActivityPaused(Activity activity) {

	}

	public void onActivityStopped(Activity activity) {
		if (activity != null) {
			boolean flag = isBackgroundRunning(activity);
			if (!mIsAppOnBackground && flag) {
				YYLiveLog.info(YYLiveLog.kLogTagSdk, "%s APP foreground -> background", activity);
				YYLiveNative.enterBackground();
			}
			mIsAppOnBackground = flag;
		}
	}

	public void onActivitySaveInstanceState(Activity activity, Bundle outState) {

	}

	public void onActivityDestroyed(Activity activity) {

	}
}
