package com.yy.yylivesdk4cloud.log;

public class YYLoggerImp {
	private LogCtrlConfig m_logCtrlConfig = null;
	public void init() {
	}

	private LogCtrlConfig getLogConfig() {
		LogConfig config = LogConfigManager.instance().getLogConfig();
		if (config != null) {
			m_logCtrlConfig = new LogCtrlConfig(config.freelyWriteLogCount, config.maxQueueSize,
					config.limitingInterval, config.audioengineLimit,
					config.transsdkLimit, config.platformLimit);
			return m_logCtrlConfig;
		}
		return null;
	}

	private static class LogCtrlConfig {
		int freelyWriteLogCount; // sdk运行时自由写日志的量
		int maxQueueSize; // 日志队列最大长度
		int limitingInterval; // 限制日志输入的时间间隔
		int audioengineLimit; // 在限制的时间间隔内，audioengine模块日志限量
		int transsdkLimit; // 在限制的时间间隔内，transsdk模块日志限量
		int platformLimit; // 在限制的时间间隔内，platform模块日志限量

		public LogCtrlConfig(int freelyWriteLogCount, int maxQueueSize, int limitingInterval,
						 int audioengineLimit, int transsdkLimit, int platformLimit) {
			this.freelyWriteLogCount = freelyWriteLogCount;
			this.maxQueueSize = maxQueueSize;
			this.limitingInterval = limitingInterval;
			this.audioengineLimit = audioengineLimit;
			this.transsdkLimit = transsdkLimit;
			this.platformLimit = platformLimit;
		}
		@Override
		public String toString() {
			String tmp = "LogCtrlConfig:" + "["+"freelyWriteLogCount:" + freelyWriteLogCount +
					",maxQueueSize:" + maxQueueSize +
					",limitingInterval:" + limitingInterval +
					",audioengineLimit" + audioengineLimit +
					",transsdkLimit" + transsdkLimit +
					",platformLimit" + platformLimit + "]";
			return tmp;
		}
	}
}
