package com.yy.yylivesdk4cloud.helper;

/*
 * Created by xiaojun on 2017/11/21.
 * Copyright (c) 2017 YY Inc. All rights reserved.
 */

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Message;
import android.util.Log;

import com.yy.mediaframework.base.VideoEncoderConfig;
import com.yy.mediaframework.base.VideoEncoderType;
import com.yy.videoplayer.render.VideoRenderNotify;
import com.yy.yylivesdk4cloud.IYYLogCallback;
import com.yy.yylivesdk4cloud.YYConstant;
import com.yy.yylivesdk4cloud.YYDeviceInfo;
import com.yy.yylivesdk4cloud.YYLiveAPI;
import com.yy.yylivesdk4cloud.YYLiveAudioCapture;
import com.yy.yylivesdk4cloud.YYLiveAudioFilePlayer;
import com.yy.yylivesdk4cloud.YYLiveChannelLayout;
import com.yy.yylivesdk4cloud.YYLiveGroup;
import com.yy.yylivesdk4cloud.YYLiveLayout;
import com.yy.yylivesdk4cloud.YYLiveNotification;
import com.yy.yylivesdk4cloud.YYLiveNotificationInside;
import com.yy.yylivesdk4cloud.YYLiveStream;
import com.yy.yylivesdk4cloud.YYLiveStreamInfo;
import com.yy.yylivesdk4cloud.YYLiveStreamLevelInfo;
import com.yy.yylivesdk4cloud.YYLiveStreamLineInfo;
import com.yy.yylivesdk4cloud.YYLiveVideoCapture;
import com.yy.yylivesdk4cloud.YYPublishAudioConfig;
import com.yy.yylivesdk4cloud.YYPublishInfo;
import com.yy.yylivesdk4cloud.YYPublishVideoConfig;
import com.yy.yylivesdk4cloud.audio.IAudioFrameObserver;
import com.yy.yylivesdk4cloud.video.serviceConfig.VideoConfigManager;
import com.yy.yylivesdk4cloud.video.serviceConfig.VideoLiveConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;


/**
 * 与C++代码互调的JNI相关的代码
 */
public class YYLiveNative {

	private static IYYLogCallback s_logCallback = null;
	private static NotificationDispatcher s_notificationDispatcher = null;
	private static YYLiveNotificationInside.PublishVideoCfg mPublishVideoCfg = null;
	private static ReentrantLock s_notificationLock = null;
	private static GSLBMethod mGslbMethod = null;

	/******************************** YYLive Events Begin *****************************************/
	//YYLive Base Events
	private static final int YYLIVE_SDK_INIT = 1;
	private static final int YYLIVE_SDK_FINI = 2;
	private static final int YYLIVE_ENABLE_LOG = 3;
	private static final int YYLIVE_SET_SCENE_ID = 4;
	private static final int YYLIVE_SET_USER_ROLE = 5;
	private static final int YYLIVE_LOG_TEXT = 6;
	private static final int YYLIVE_JOIN_MEDIA = 7;
	private static final int YYLIVE_LEAVE_MEDIA = 8;
	private static final int YYLIVE_ENABLE_LOW_LATENCY = 9;
	private static final int YYLIVE_UPDATE_TOKEN = 10;
	private static final int YYLIVE_JOIN_MEDIA_STR_UID = 11;
	private static final int YYLIVE_JOIN_CHANNEL = 12;
	private static final int YYLIVE_LEAVE_CHANNEL = 13;
	private static final int YYLIVE_SET_AREA_TYPE = 14;
	private static final int YYLIVE_SET_CHANNEL_PROFILE = 15;
	private static final int YYLIVE_SET_PLAY_VOLUME_INTERVAL = 16;
	private static final int YYLIVE_SET_CAPTURE_VOLUME_INTERVAL = 17;
	private static final int YYLIVE_START_AUDIO_SAVER = 18;
	private static final int YYLIVE_STOP_AUDIO_SAVER = 19;
	private static final int YYLIVE_FETCHED_LOG_CONFIG = 20;
	private static final int YYLIVE_SET_VOICE_ONLY_SDK = 21;
	private static final int YYLIVE_SET_ARGO_CONFIG = 22;
	private static final int YYLIVE_SET_HTTPS_RESPONSE = 23;
	private static final int YYLIVE_SET_CHANNEL_NAME = 24;
	private static final int YYLIVE_SET_RECORD_AUDIO_PARAMS = 25;
	private static final int YYLIVE_SET_PLAY_AUDIO_PARAMS = 26;

	//YYLive Play Events
	private static final int YYLIVE_START_PLAY_STREAMS = 101;
	private static final int YYLIVE_STOP_PLAY_STREAMS = 102;
	private static final int YYLIVE_ENABLE_HARDWARE_DECODER = 103;
	private static final int YYLIVE_UPDATE_PLAY_VIDEO_VIEW = 104;
	private static final int YYLIVE_ENABLE_MUTE_STREAM = 105;
	private static final int YYLIVE_SET_STREAM_PLAY_VOLUME = 106;
	private static final int YYLIVE_VIDEO_RENDER_EVENT = 107;
	private static final int YYLIVE_ENABLE_LOUD_SPEAKER = 108;
	private static final int YYLIVE_GET_LOUDSPEAKER_ENABLED = 109;
	private static final int YYLIVE_SET_SPEAKER_VOLUME = 110;
	private static final int YYLIVE_ENABLE_ALL_MUTE = 111;
	private static final int YYLIVE_IS_SUPPORT_H265 = 112;
	private static final int YYLIVE_ENABLE_MUTE_STRING_UID = 113;

	//YYLive Publish Events
	private static final int YYLIVE_START_PUBLISH_AUDIO = 201;
	private static final int YYLIVE_STOP_PUBLISH_AUDIO = 202;
	private static final int YYLIVE_START_PUBLISH_VIDEO = 203;
	private static final int YYLIVE_STOP_PUBLISH_VIDEO = 204;
	private static final int YYLIVE_SET_MIC_VOLUME = 205;
	private static final int YYLIVE_ENABLE_VAD = 206;
	private static final int YYLIVE_START_VIDEO_PREVIEW = 207;
	private static final int YYLIVE_STOP_VIDEO_PREVIEW = 208;
	private static final int YYLIVE_UPDATE_VIDEO_CONFIG = 209;
	private static final int YYLIVE_SET_CAMERA_POSTION = 210;
	private static final int YYLIVE_SET_WATERMARK = 211;
	private static final int YYLIVE_SET_FACE_BEAUTY_LEVEL = 212;
	private static final int YYLIVE_ATTACH_AUDIO_CAPTURE = 213;
	private static final int YYLIVE_SET_MIX_AUDIO_CAPTURE = 214;
	private static final int YYLIVE_ATTACH_VIDEO_CAPTURE = 215;
	private static final int YYLIVE_SET_MIX_VIDEO_CAPTURE = 216;
	private static final int YYLIVE_SET_PUBLISH_RTMP_PARAM = 217;
	private static final int YYLIVE_CHANGE_SCREEN_LIVE_MODE = 218;
	private static final int YYLIVE_START_PUBLISH_LIVE = 220;
	private static final int YYLIVE_UPDATE_PUBLISH_LIVE = 221;
	private static final int YYLIVE_STOP_PUBLISH_LIVE = 222;
	private static final int YYLIVE_SET_ORIENTATION = 223;
    private static final int YYLIVE_SET_SOUND_EFFECT = 224;
    private static final int YYLIVE_START_CAPTURE = 225;
    private static final int YYLIVE_STOP_CAPTURE = 226;
    private static final int YYLIVE_SET_PREVIEW_RENDER_MODE = 227;
	private static final int YYLIVE_RESOLVE_SERVICE_DATA = 228;

	private static final int YYLIVE_ON_VIDEO_SIZE_CHANGE = 229;
	private static final int YYLIVE_ON_RENDER_FIRST_FRAME = 230;

	private static final int YYLIVE_SET_PLAYVIEW_SCALEMODE = 231;

	private static final int YYLIVE_STOP_AND_RECOVER_VIDEO_ENCODE = 232;


	//YYLive System Events
	private static final int YYLIVE_ENTER_BACKGROUND = 301;
	private static final int YYLIVE_ENTER_FOREGROUND = 302;
	private static final int YYLIVE_NOTIFY_NETWORK_STATE = 303;

	//YYLive Audio File Play Events
	private static final int YYLIVE_AUDIO_FILE_OPEN = 401;
	private static final int YYLIVE_AUDIO_FILE_CLOSE = 402;
	private static final int YYLIVE_AUDIO_FILE_PLAY = 403;
	private static final int YYLIVE_AUDIO_FILE_STOP = 404;
	private static final int YYLIVE_AUDIO_FILE_PAUSE = 405;
	private static final int YYLIVE_AUDIO_FILE_RESUME = 406;
	private static final int YYLIVE_AUDIO_FILE_SEEK = 407;
	private static final int YYLIVE_AUDIO_FILE_GET_TOTAL_TIME = 408;
	private static final int YYLIVE_AUDIO_FILE_GET_CURRENT_TIME = 409;
	private static final int YYLIVE_AUDIO_FILE_SET_PLAY_VOLUME = 410;
	private static final int YYLIVE_AUDIO_FILE_SET_SEMITONE = 411;
	private static final int YYLIVE_AUDIO_FILE_ENABLE_PUBLISH = 412;

	private static final int YYLIVE_AUDIO_SET_EXTERNAL_PROCESSOR = 414;
	private static final int YYLIVE_AUDIO_FILE_PUBLISH_BYMODE = 415;
	private static final int YYLIVE_AUDIO_ENABLE_AUDIO_PLAY_SPECTRUM = 416;
	private static final int YYLIVE_AUDIO_SET_AUDIO_PLAY_SPECTRUM_INFO  = 417;
	private static final int YYLIVE_AUDIO_FILE_SET_COMPENSATE_VALUE = 418;
	private static final int YYLIVE_AUDIO_ENABLE_CAPTURE_PCM_DATA_CALLBACK = 419;
	private static final int YYLIVE_AUDIO_ENABLE_AUDIO_DATA_INDICATION = 420;
	private static final int YYLIVE_CREATE_AUDIO_FILE_PLAYER = 421;
	private static final int YYLIVE_DESTROY_AUDIO_FILE_PLAYER = 422;
	private static final int YYLIVE_AUDIO_ENABLE_RENDER_PCM_DATA_CALLBACK = 423;
	private static final int YYLIVE_AUDIO_FILE_ENABLE_VOLUME_CALLBACK = 424;

	private static final int YYLIVE_AUDIO_EFFECT_ENABLE_EQUALIZER = 501;
	private static final int YYLIVE_AUDIO_EFFECT_SET_EQUALIZER = 502;
	private static final int YYLIVE_AUDIO_EFFECT_ENABLE_COMPRESSOR = 503;
	private static final int YYLIVE_AUDIO_EFFECT_SET_COMPRESSOR = 504;
	private static final int YYLIVE_AUDIO_EFFECT_ENABLE_REVERB = 505;
	private static final int YYLIVE_AUDIO_EFFECT_SET_REVERB = 506;
	private static final int YYLIVE_SET_AUDIO_SOURCE_TYPE = 507;
	private static final int YYLIVE_ENABLE_IN_EAR_MONITOR = 508;
	private static final int YYLIVE_AUDIO_EFFECT_SET_LIMITER = 509;
	private static final int YYLIVE_AUDIO_EFFECT_ENABLE_LIMITER = 510;

	//YYLive App Event
	private static final int YYLIVE_SEND_USER_APP_MSG_DATA = 601;

	private static Boolean isInit = false;

	private native static int YYLiveSdkInit(Context appContext, byte[] data);
	private native static void YYLiveSdkFini();
	private native static long YYLiveSdkProcess(int event, byte[] data);
	private native static String YYLiveSdkGetVersion();
	private native static int YYLiveSdkGetVersionInt();
	private native static long YYLiveObjectToPtr(Object obj);
	private native static void YYLiveRegisterAudioObserver(IAudioFrameObserver observer);

	public static YYPublishVideoConfig getVideoConfig(){
		VideoLiveConfig config = VideoConfigManager.instance().getCurrentVideoLiveConfig();
		YYPublishVideoConfig result = new YYPublishVideoConfig();
		result.playType = config.playType;
		result.mode = config.videoLevel;

		 if(config.encodeId == VideoEncoderType.HARD_ENCODER_H264){
			 result.hardwareEncoder = true;
			 result.encodeType = YYConstant.YYVideoEncodeType.YYVIDEO_ENCODE_TYPE_H264;
		}else if(config.encodeId == VideoEncoderType.HARD_ENCODER_H265){
			 result.hardwareEncoder = true;
			 result.encodeType = YYConstant.YYVideoEncodeType.YYVIDEO_ENCODE_TYPE_H265;
		}else {
			 result.hardwareEncoder = false;
			 result.encodeType = YYConstant.YYVideoEncodeType.YYVIDEO_ENCODE_TYPE_H264;
		 }

		result.encodeBitrate = config.curRate /1000;
		result.encodeFrameRate = config.frameRate;
		result.encodeResolutionHeight = config.videoHeight;
		result.encodeResolutionWidth = config.videoWidth;

		return result;
	}

	public static YYPublishInfo getPublishInfo() {
		VideoLiveConfig config = VideoConfigManager.instance().getCurrentVideoLiveConfig();
		if (config == null)
		{
			return  null;
		}
		YYPublishInfo result = new YYPublishInfo();
		result.playType = config.playType;
		result.publishMode = config.videoLevel;

		if(config.encodeId == VideoEncoderType.HARD_ENCODER_H264){
			result.hardwareEncoder = true;
			result.encodeType = YYConstant.YYVideoEncodeType.YYVIDEO_ENCODE_TYPE_H264;
		}else if(config.encodeId == VideoEncoderType.HARD_ENCODER_H265){
			result.hardwareEncoder = true;
			result.encodeType = YYConstant.YYVideoEncodeType.YYVIDEO_ENCODE_TYPE_H265;
		}else {
			result.hardwareEncoder = false;
			result.encodeType = YYConstant.YYVideoEncodeType.YYVIDEO_ENCODE_TYPE_H264;
		}

		result.bitrate = config.curRate / 1000;
		result.frameRate = config.frameRate;
		result.encodeHeight = config.videoHeight;
		result.encodeWidth = config.videoWidth;

		return result;
	}

	public static HashMap<Integer, String> getSupportModeInfoWithPlayType(int playType){
		return VideoConfigManager.instance().getModeListByPlayType(playType);
	}

	public static int getDefaultPublishVideoMode(int playType){
		return VideoConfigManager.instance().getDefaultPublishVideoMode(playType);
	}

	public static void disableHardEncoder(Boolean disable){
		VideoConfigManager.instance().disableHardEncode(disable);
	}

	public static YYPublishVideoConfig getRemoteVideoConfig(int playType, int publishMode){
		YYPublishVideoConfig result = new YYPublishVideoConfig();
		VideoEncoderConfig encoderConfig = VideoConfigManager.instance().getVideoEncodeConfigByType(playType, publishMode);
		result.playType = playType;
		result.mode = publishMode;

		if(encoderConfig.mEncodeType == VideoEncoderType.HARD_ENCODER_H264){
			result.hardwareEncoder = true;
			result.encodeType = YYConstant.YYVideoEncodeType.YYVIDEO_ENCODE_TYPE_H264;
		}else if(encoderConfig.mEncodeType == VideoEncoderType.HARD_ENCODER_H265){
			result.hardwareEncoder = true;
			result.encodeType = YYConstant.YYVideoEncodeType.YYVIDEO_ENCODE_TYPE_H265;
		}else {
			result.hardwareEncoder = false;
			result.encodeType = YYConstant.YYVideoEncodeType.YYVIDEO_ENCODE_TYPE_H264;
		}

		result.encodeBitrate = encoderConfig.mBitRate /1000;
		result.encodeMaxBitrate = encoderConfig.mMaxBitRate / 1000;
		result.encodeFrameRate = encoderConfig.mFrameRate;
		result.encodeResolutionHeight = encoderConfig.mEncodeHeight;
		result.encodeResolutionWidth = encoderConfig.mEncodeWidth;
		return result;
	}

	private static class YLESdkInit extends HPMarshaller {
		long appId;
		long sceneId;
		YYDeviceInfo info;

		YLESdkInit(long _addId, long _sceneId, YYDeviceInfo _info) {
			appId = _addId;
			sceneId = _sceneId;
			info = _info;
		}

		@Override
		public byte[] marshall() {
			pushInt(appId);
			pushInt(sceneId);
			pushString16(info.osVersion);
			pushString16(info.manufacturer);
			pushString16(info.model);
			pushString16(info.deviceID);
			pushString16(info.appInfo);
			pushInt64(info.imsi);

			return super.marshall();
		}
	}

	public static int init(long appId, long sceneId, Context appContext, YYDeviceInfo info, NotificationDispatcher handlers) {
		if (s_notificationLock == null){
			s_notificationLock = new ReentrantLock();
		}

		s_notificationLock.lock();
		try {
			s_notificationDispatcher = handlers;
		}finally {
			s_notificationLock.unlock();
		}

		if (mGslbMethod == null) {
			mGslbMethod = new GSLBMethod();
			mGslbMethod.initService(appContext);
		}

		YLESdkInit yle = new YLESdkInit(appId, sceneId, info);
		MshBuffer buffer = new MshBuffer(Marshallable.kProtoPacketSize, NativeByteBufferPool.get());
		int ret = YYLiveSdkInit(appContext, yle.HPmarshall(buffer));
		buffer.freeBuffer();
		isInit = true;
		return ret;
	}

	public static void fini() {
		isInit = false;
		s_notificationLock.lock();
		try {
			s_notificationDispatcher = null;
		}finally {
			s_notificationLock.unlock();
		}

		if (mGslbMethod != null) {
			mGslbMethod.destroyService();
			mGslbMethod = null;
		}

		YYLiveSdkFini();
	}

	public static String getVersion() {
		return YYLiveSdkGetVersion();
	}

	public static int getVersionInt() {
		return YYLiveSdkGetVersionInt();
	}

	public static void registerAudioFrameObserver(IAudioFrameObserver observer) {
		YYLiveRegisterAudioObserver(observer);
	}

	private static long YLEProcess(YLEBase e) {
		MshBuffer buffer = new MshBuffer(Marshallable.kProtoPacketSize, NativeByteBufferPool.get());
		long ret = YYLiveSdkProcess(e.event(), e.HPmarshall(buffer));
		buffer.freeBuffer();
		return ret;
	}

	public static void enableLog(boolean enable, IYYLogCallback callback, int level, String logPath) {
		s_logCallback = callback;
		YLEProcess(new YLEEnableLog(enable, (callback != null), level, logPath));
	}

	public static void fetchedLogConfig() {
		YLEProcess(new YLEFetchedLogConfig());
	}

	public static void setSceneId(long sceneId) {
		YLEProcess(new YLESetSceneId(sceneId));
	}

	public static void setUserRole(int role) {
		YLEProcess(new YLESetUserRole(role));
	}

	public static void setArgoConfig(HashMap<Integer, Integer> cfg) {
		if(isInit) {
			YLEProcess(new YLESetArgoConfig(cfg));
		}
	}

	public static void logText(int level, int module, String tag, String text) {
		YLEProcess(new YLELogText(level, module, tag, text));
	}

	public static void joinMedia(long uid, long sid, long subSid) {
		YLEProcess(new YLEJoinMedia(uid, sid, subSid));
	}

	public static void joinMedia(String uid, long sid, long subSid) {
		YLEProcess(new YLEJoinMediaStrUid(uid, sid, subSid));
	}

	public static void leaveMedia() {
		YLEProcess(new YLELeaveMedia());
	}

	public static void joinChannel(String channelId, String uid, boolean is32Bit, int role) {
		YYLiveAPI.sharedInstance().getPublishChannel().syncUserInfo(channelId, uid, is32Bit, role);
		YLEProcess(new YLEJoinChannel(channelId, uid, is32Bit, role));
	}

	public static void leaveChannel() {
		YYLiveAPI.sharedInstance().getPublishChannel().syncUserInfo(null, null, true, 0);
		YLEProcess(new YLELeaveChannel());
	}

	public static void enableLowLatency(boolean enable) {
		YLEProcess(new YLEEnableLowLatency(enable));
	}

	public static void setChannelProfile(int profile) {
		YLEProcess(new YLESetChannelProfile(profile));
	}

	public static void setChannelName(String channelName) {
		YLEProcess(new YLESetChannelName(channelName));
	}

	public static void setPlayVolumeInterval(int interval, int moreThanThd, int lessThanThd) {
		YLEProcess(new YLESetPlayVolumeInterval(interval, moreThanThd, lessThanThd));
	}

	public static void onUpdateVideoSizeChanged(long uid, int width, int height) {
		YLEProcess(new YLEOnVideoSizeChange(uid,width,height));
	}

	public static void onFirstFrameRenderNotify(long userGroupId, long streamId, long currentSystemMilliSecond, long firstFrameToRenderInMilliSec,  int eatenFrames) {
		YLEProcess(new YLEOnRenderFirstFrame(userGroupId,streamId,currentSystemMilliSecond,firstFrameToRenderInMilliSec,eatenFrames));
	}

	public static void setCaptureVolumeInterval(int interval, int moreThanThd, int lessThanThd) {
		YLEProcess(new YLESetCaptureVolumeInterval(interval, moreThanThd, lessThanThd));
	}
	
	public static boolean startAudioSaver(String fileName, int saverMode, int fileMode){
		if (YLEProcess(new YLEStartAudioSaver(fileName, saverMode, fileMode)) == 0) {
			return true;
		}else{
			return false;
		}
	}

	public static boolean stopAudioSaver(){
		if (YLEProcess(new YLEStopAudioSaver()) == 0){
			return true;
		}else{
			return false;
		}
	}

    public static boolean setSoundEffect(int soundEffectMode){
        if (YLEProcess(new YLESetSoundEffect(soundEffectMode)) == 0){
            return true;
        }else{
            return false;
        }
    }

    public static void resolveServiceData(String uid, int uri, byte[] data){
		YLEProcess(new YLEResolveServiceData(uri, uid, data));
	}


	public static void setVoiceOnlySdk(boolean enable) {
		YLEProcess(new YLESetVoiceOnlySdk(enable));
	}

	public static void updateToken(byte[] token, byte[] bizAuthExtInfo) {
		YLEProcess(new YLEUpdateToken(token, bizAuthExtInfo));
	}

	public static void setAreaType(int areaType) {
		YYLiveLog.info(YYLiveLog.kLogTagCall, "setAreaType %d", areaType);
		YLEProcess(new YLESetAreaType(areaType));
	}

	public static int startPlayStreams(ArrayList<YYLiveStream> streamList,
									   ArrayList<YYLiveGroup> groupList) {
		return (int)YLEProcess(new YLEStartPlayStreams(streamList, groupList));
	}

	public static int stopPlayStreams(ArrayList<YYLiveStream> streamList,
									  ArrayList<YYLiveGroup> groupList) {
		return (int)YLEProcess(new YLEStopPlayStreams(streamList, groupList));
	}

	//YYVideoEncodeType 0 h264 1 h265
	public static boolean enableHardwareDecoder(boolean enable, int decodeType)
	{
		return YLEProcess(new YLEEnableHardwareDecoder(enable, decodeType)) != 0;
	}

	public static boolean updatePlayVideoView(Object view, int scaleMode, YYLiveStream stream)
	{
		return YLEProcess(new YLEUpdatePlayVideoView(view, scaleMode, stream)) != 0;
	}

	public static boolean enableMuteStream(boolean enable, YYLiveStream stream) {
		return (YLEProcess(new YLEEnableMuteStream(enable, stream)) != 0);
	}

	public static boolean enableMuteStringUid(boolean enable, String uid) {
		return (YLEProcess(new YLEEnableMuteStringUid(enable, uid)) != 0);
	}

	public static boolean enableAllMute(boolean enable){
		return (YLEProcess(new YLEEnableAllMute(enable)) != 0);
	}

	public static boolean setStreamPlayVolume(int volume, YYLiveStream stream) {
		return (YLEProcess(new YLESetStreamPlayVolume(volume, stream)) != 0);
	}

	public static boolean setSpeakerVolume(int volume){
		return (YLEProcess(new YLESetSpeakerVolume(volume)) != 0);
	}

	public static void onVideoRenderEvent(long callBackPtr,
										  final ArrayList<VideoRenderNotify> notifications) {
		YLEProcess(new YLEVideoRenderEvent(callBackPtr, notifications));
	}

	public static void enableLoudSpeaker(boolean enable) {
		YLEProcess(new YLEEnableLoudSpeaker(enable));
	}


	public static boolean getLoudSpeakerEnabled(){
		return YLEProcess(new YLEGetLoudSpeakerEnabled())  != 0;
	}
	public static boolean isSupportPlayH265() {
		return (YLEProcess(new YLEIsSupportPlayH265()) != 0);
	}

	public static int startPublishAudio(String streamName,
										ArrayList<String> groupNames,
										YYPublishAudioConfig config) {
		return (int)YLEProcess(new YLEStartPublishAudio(streamName, groupNames, config));
	}

	public static int stopPublishAudio() {
		return (int)YLEProcess(new YLEStopPublishAudio());
	}

	public static boolean setMicVolume(int volume) {
		return YLEProcess(new YLESetMicVolume(volume)) != 0;
	}

	public static void enableVad(boolean enable) {
		YLEProcess(new YLEEnableVad(enable));
	}

	public static void setOrientation(int ori){
		YLEProcess(new YLESetOrientation(ori));
	}

	public static void EnableEqualizer(boolean enable)
	{
		YLEProcess(new YLEEnableEqualizer(enable));
	}

	public static void SetGqGains(final int [] gains)
	{
		YLEProcess(new YLESetGqGains(gains));
	}

	public static void EnableCompressor(boolean enable)
	{
		YLEProcess(new YLEEnableCompressor(enable));
	}

	public static void EnableLimiter(boolean enable)
	{
		YLEProcess(new YLEEnableLimiter(enable));
	}

	public static void SetCompressorParam(int threshold, int makeupGain, int ratio, int knee, int releaseTime, int attackTime)
	{
		YLEProcess(new YLESetCompressorParam(threshold, makeupGain, ratio, knee, releaseTime, attackTime));
	}

	public static void EnableReverb(boolean enable)
	{
		YLEProcess(new YLEEnableReverb(enable));
	}

	public static void setReverbExParameter(final float RoomSize, final float PreDelay, final float Reverberance,
									 final float HfDamping, final float ToneLow, final float ToneHigh,
									 final float WetGain,  final  float DryGain, final float StereoWidth)
	{
		YLEProcess(new YLEsetReverbExParameter(RoomSize,PreDelay,Reverberance,HfDamping,ToneLow,ToneHigh,WetGain,DryGain,StereoWidth));
	}

	public static int startVideoPreview(Object view, int playType, int publishMode) {
		return (int) YLEProcess(new YLEStartVideoPreview(view, playType, publishMode));
	}

	public static int setPlayViewScaleMode(Object view, int mode) {
		return (int) YLEProcess(new YLESetPlayViewScaleMode(view,mode));
	}

	public static void setLimiterParameter(final float fCeiling, final float fThreshold, final float fPreGain,
										   final float fRelease, final float fAttack, final float fLookahead,
										   final float fLookaheadRatio, final float fRMS, final float fStLink)
	{
		YLEProcess(new YLEsetLimiterParameter(fCeiling, fThreshold, fPreGain, fRelease, fAttack, fLookahead, fLookaheadRatio, fRMS, fStLink));
	}

	public static void 	setAudioSourceType(int mode)
	{
		YLEProcess(new YLEsetAudioSourceType(mode));
	}

	public static boolean enableInEarMonitor(boolean enable)
	{
		return YLEProcess(new YLEenableInEarMonitor(enable)) != 0;
	}

	public static void stopAndRecoverVideoEncode(boolean isStop){
		YLEProcess(new YLEstopAndRcoverVideoEncode(isStop));
	}

	public static int stopVideoPreview() {
		return (int)YLEProcess(new YLEStopVideoPreview());
	}

	public  static void setLivePublishRtmpParam(boolean bOpen, String url, String playPath) {
		YLEProcess(new YLEsetPublishRtmpParam(bOpen, url, playPath));
	}

	public static int startPublishVideo(String streamName,
										ArrayList<String> groupNames,
										YYPublishVideoConfig config) {
		return (int)YLEProcess(new YLEStartPublishVideo(streamName, groupNames, config));
	}

	public static int stopPublishVideo() {
		return (int)YLEProcess(new YLEStopPublishVideo());
	}

	public static int startPublishLive(String channelId,
									   boolean uniq,
									   YYPublishVideoConfig videoConfig,
									   YYPublishAudioConfig audioConfig,
									   YYLiveLayout layout) {
		return (int)YLEProcess(new YLEStartPublishLive(channelId, uniq, videoConfig, audioConfig, layout));
	}

	public static int updatePublishLive(String channelId,
										boolean uniq,
										YYPublishVideoConfig videoConfig,
										YYPublishAudioConfig audioConfig,
										YYLiveLayout layout) {
		return (int)YLEProcess(new YLEUpdatePublishLive(channelId, uniq, videoConfig, audioConfig, layout));
	}

	public static int stopPublishLive(String channelId) {
		return (int)YLEProcess(new YLEStopPublishLive(channelId));
	}

	public static boolean updateVideoConfig(YYPublishVideoConfig config) {
		return YLEProcess(new YLEUpdateVideoConfig(config)) != 0;
	}

	public static boolean setCameraPosition(int postion) {
		return YLEProcess(new YLESetCameraPosition(postion)) != 0;
	}

	public static int setWatermark(int posX, int posY, Bitmap image) {
		return (int)YLEProcess(new YLESetWatermark(posX, posY, image));
	}

	public static int setFaceBeautyLevel(float level) {
		return (int)YLEProcess(new YLESetFaceBeautyLevel(level));
	}

	public static void attachAudioCapture(YYLiveAudioCapture capture) {
		YLEProcess(new YLEAttachAudioCapture(capture));
	}

	public static void attachVideoCapture(YYLiveVideoCapture capture) {
		YLEProcess(new YLEAttachVideoCapture(capture));
	}

	public static int startCapture() {
		return (int)YLEProcess(new YLEStartCapture());
	}

	public static int stopCapture() {
		return (int)YLEProcess(new YLEStopCapture());
	}

	public static int setPreviewRenderMode(int mode) {
		return (int)YLEProcess(new YLESetPreviewRenderMode(mode));
	}

	public static void changeScreenLiveMode(boolean bPicMode, Object bitmap) {
		YLEProcess(new YLEChangeScreenLiveMode(bPicMode, bitmap));
	}

	public static void notifyNetState(int state) {
		YLEProcess(new YLENotifyNetworkState(state));
	}

	public static void enterBackground() {
		YLEProcess(new YLEEnterBackground());
	}

	public static void enterForeground() {
		YLEProcess(new YLEEnterForeground());
	}

	public static long createAudioFilePlayer(Object obj){
		return YLEProcess(new YLECreateAudioFilePlayer(obj));
	}

	public static long destroyAudioFilePlayer(long ctx){
		return YLEProcess(new YLEAudioFileEventCommon(YYLIVE_DESTROY_AUDIO_FILE_PLAYER, ctx));
	}

	public static long audioFileOpen(long ctx, String path) {
		return YLEProcess(new YLEAudioFileOpen(ctx, path));
	}

	public static void audioFileClose(long ctx) {
		YLEProcess(new YLEAudioFileEventCommon(YYLIVE_AUDIO_FILE_CLOSE, ctx));
	}

	public static void audioFilePlay(long ctx) {
		YLEProcess(new YLEAudioFileEventCommon(YYLIVE_AUDIO_FILE_PLAY, ctx));
	}

	public static void audioFileStop(long ctx) {
		YLEProcess(new YLEAudioFileEventCommon(YYLIVE_AUDIO_FILE_STOP, ctx));
	}

	public static void audioFilePause(long ctx) {
		YLEProcess(new YLEAudioFileEventCommon(YYLIVE_AUDIO_FILE_PAUSE, ctx));
	}

	public static void audioFileResume(long ctx) {
		YLEProcess(new YLEAudioFileEventCommon(YYLIVE_AUDIO_FILE_RESUME, ctx));
	}

	public static void audioFileSeek(long ctx, long timeMS) {
		YLEProcess(new YLEAudioFileSeek(ctx, timeMS));
	}

	public static long audioFileGetTotalTime(long ctx) {
		return YLEProcess(new YLEAudioFileEventCommon(YYLIVE_AUDIO_FILE_GET_TOTAL_TIME, ctx));
	}

	public static long audioFileGetCurrentPlayTime(long ctx) {
		return YLEProcess(new YLEAudioFileEventCommon(YYLIVE_AUDIO_FILE_GET_CURRENT_TIME, ctx));
	}

	public static void audioFileSetPlayVolume(long ctx, int volume) {
		YLEProcess(new YLEAudioFileSetPlayVolume(ctx, volume));
	}

	public static void audioFileSetSemitone(long ctx, float val) {
		YLEProcess(new YLEAudioFileSetSemitone(ctx, val));
	}

	public static void audioFileEnablePublish(long ctx, boolean enable) {
		YLEProcess(new YLEAudioFileEnablePublish(ctx, enable));
	}

	public static void audioFileSetCompensateValue(long ctx, int value) {
		YLEProcess(new YLEAudioFileSetCompensateValue(ctx, value));
	}

	public static void audioFilePublishByMode(long ctx, int mode) {
		YLEProcess(new YLEAudioFilePublishByMode(ctx, mode));
	}

	public static void enableAudioFileVolumeCallback(long ctx, boolean enable, int interval) {
		YLEProcess(new YLEEnableAudioFileVolumeCallback(ctx, enable, interval));
	}

	public static void setExternalAudioProcessor(long eap) {
		YLEProcess(new YLEAudioSetExternalProcessor(eap));
	}

	public static void enableAudioPlaySepctrum(boolean enable) {
		YLEProcess(new YLEEnableAudioPlaySpectrum(enable));
	}

	public static void setAudioPlaySepctrumInfo(int spectrumLen, int notifyIntervalMS) {
		YLEProcess(new YLESetAudioPlaySpectrumInfo(spectrumLen, notifyIntervalMS));
	}

	public static void enableAudioDataIndication(boolean enable){
		YLEProcess(new YLEEnableAudioDataIndication(enable));
	}

	public static void enableCapturePcmDataCallBack(boolean enable, int sampleRate, int channel) {
		YLEProcess(new YLEEnableCapturePcmDataCallBack(enable, sampleRate, channel));
	}

	public static void enableRenderPcmDataCallBack(boolean enable, int sampleRate, int channel) {
		YLEProcess(new YLEEnableRenderPcmDataCallBack(enable, sampleRate, channel));
	}

	public static void sendUserAppMsgData(byte[] msgData) {
		YLEProcess(new YLESendUserAppMsgData(msgData));
	}

	public static void setHttpsBinaryResponse(String reqUrl,
											  byte[] response,
											  int statusCode,
											  int errCode,
											  int target) {
		YLEProcess(new YLESetHttpsBinaryResponse(reqUrl, response, statusCode, errCode, target));
	}

	public static void setHttpsTextResponse(String reqUrl,
											String response,
											int statusCode,
											int errCode,
											int target) {
		YLEProcess(new YLESetHttpsTextResponse(reqUrl, response, statusCode, errCode, target));
	}

	public static void setRecordingAudioFrameParameters (int sampleRate,
														 int channel,
														 int mode,
														 int samplesPerCall) {
		YLEProcess(new YLESetRecordingAudioFrameParameters(sampleRate, channel, mode, samplesPerCall));
	}

	public static void setPlaybackAudioFrameParameters (int sampleRate,
														int channel,
														int mode,
														int samplesPerCall) {
		YLEProcess(new YLESetPlaybackAudioFrameParameters(sampleRate, channel, mode, samplesPerCall));
	}

	private static class YLEBase extends HPMarshaller {
		int event = 0;

		int event() {
			return event;
		}

		public byte[] marshall() {
			return super.marshall();
		}
	}

	private static class YLEEnableLog extends YLEBase {
		private boolean enable;
		private boolean callback;
		private int level;
		private String logPath;

		YLEEnableLog(boolean _enable, boolean _callback, int _level, String _logPath) {
			event = YYLIVE_ENABLE_LOG;
			enable = _enable;
			callback = _callback;
			level = _level;
			logPath = _logPath;
		}

		@Override
		public byte[] marshall() {
			pushBool(enable);
			pushBool(callback);
			pushInt(level);
			pushString16(logPath);

			return super.marshall();
		}
	}

	private static class YLEFetchedLogConfig extends YLEBase {
		YLEFetchedLogConfig() {
			event = YYLIVE_FETCHED_LOG_CONFIG;
		}

		@Override
		public byte[] marshall() {
			return super.marshall();
		}
	}

	private static class YLESetAreaType extends YLEBase {
		private int areaType;

		YLESetAreaType(int _areaType) {
			event = YYLIVE_SET_AREA_TYPE;
			areaType = _areaType;
		}

		@Override
		public byte[] marshall() {
			pushInt(areaType);
			return super.marshall();
		}
	}

	private static class YLESetSceneId extends YLEBase {
		private long sceneId;

		YLESetSceneId(long _sceneId) {
			event = YYLIVE_SET_SCENE_ID;
			sceneId = _sceneId;
		}

		@Override
		public byte[] marshall() {
			pushInt(sceneId);
			return super.marshall();
		}
	}

	private static class YLESetUserRole extends YLEBase {
		private int role;

		YLESetUserRole(int _role) {
			event = YYLIVE_SET_USER_ROLE;
			role = _role;
		}

		@Override
		public byte[] marshall() {
			pushInt(role);
			return super.marshall();
		}
	}

	private static class YLESetArgoConfig extends YLEBase {
		private HashMap<Integer, Integer> config;

		YLESetArgoConfig(HashMap<Integer, Integer> _config) {
			event = YYLIVE_SET_ARGO_CONFIG;
			config = _config;
		}

		@Override
		public byte[] marshall() {
			pushMap(config, Integer.class, ELenType.E_INT, ELenType.E_INT);
			return super.marshall();
		}
	}

	private static class YLELogText extends YLEBase {
		private int level;
		private int module;
		private String tag;
		private String text;

		YLELogText(int _level, int _module, String _tag, String _text) {
			event = YYLIVE_LOG_TEXT;
			level = _level;
			module = _module;
			tag = _tag;
			text = _text;
		}

		@Override
		public byte[] marshall() {
			pushInt(level);
			pushInt(module);
			pushString16(tag);
			pushString32(text);
			return super.marshall();
		}
	}

	private static class YLEJoinMedia extends YLEBase {
		private long uid;
		private long sid;
		private long subSid;

		YLEJoinMedia(long _uid, long _sid, long _subSid) {
			event = YYLIVE_JOIN_MEDIA;
			uid = _uid;
			sid = _sid;
			subSid = _subSid;
		}

		@Override
		public byte[] marshall() {
			pushInt(uid);
			pushInt(sid);
			pushInt(subSid);
			return super.marshall();
		}
	}

	private static class YLEJoinMediaStrUid extends YLEBase {
		private String uid;
		private long sid;
		private long subSid;

		YLEJoinMediaStrUid(String _uid, long _sid, long _subSid) {
			event = YYLIVE_JOIN_MEDIA_STR_UID;
			uid = _uid;
			sid = _sid;
			subSid = _subSid;
		}

		@Override
		public byte[] marshall() {
			pushString16(uid);
			pushInt(sid);
			pushInt(subSid);
			return super.marshall();
		}
	}

	private static class YLELeaveMedia extends YLEBase {
		private int reverse;

		YLELeaveMedia() {
			event = YYLIVE_LEAVE_MEDIA;
			reverse = 0;
		}

		@Override
		public byte[] marshall() {
			pushInt(reverse);
			return super.marshall();
		}
	}

	private static class YLEJoinChannel extends YLEBase {
		private String channelId;
		private String uid;
		private boolean is32Bit;
		private int role;

		YLEJoinChannel(String _channelId, String _uid, boolean _is32Bit, int _role) {
			event = YYLIVE_JOIN_CHANNEL;
			channelId = _channelId;
			uid = _uid;
			is32Bit = _is32Bit;
			role = _role;
		}
		@Override
		public byte[] marshall() {
			pushString16(channelId);
			pushString16(uid);
			pushBool(is32Bit);
			pushInt(role);
			return super.marshall();
		}
	}

	private static class YLELeaveChannel extends YLEBase {
		private int reverse;

		YLELeaveChannel() {
			event = YYLIVE_LEAVE_CHANNEL;
			reverse = 0;
		}

		@Override
		public byte[] marshall() {
			pushInt(reverse);
			return super.marshall();
		}
	}

	private static class YLEEnableLowLatency extends YLEBase {
		private boolean enable;

		YLEEnableLowLatency(boolean _enable) {
			event = YYLIVE_ENABLE_LOW_LATENCY;
			enable = _enable;
		}

		@Override
		public byte[] marshall() {
			pushBool(enable);
			return super.marshall();
		}
	}

	private static class YLESetChannelProfile extends YLEBase {
		private int profile;

		YLESetChannelProfile(int _profile) {
			event = YYLIVE_SET_CHANNEL_PROFILE;
			profile = _profile;
		}

		@Override
		public byte[] marshall() {
			pushInt(profile);
			return super.marshall();
		}
	}

	private static class YLESetChannelName extends YLEBase {
		private String channelName;

		YLESetChannelName(String _channelName) {
			event = YYLIVE_SET_CHANNEL_NAME;
			channelName = _channelName;
		}

		@Override
		public byte[] marshall() {
			pushString16(channelName);
			return super.marshall();
		}
	}

	private static class YLESetPlayVolumeInterval extends YLEBase {
		private int interval;
		private int moreThanThd;
		private int lessThanThd;

		YLESetPlayVolumeInterval(int _interval, int _moreThanThd, int _lessThanThd) {
			event = YYLIVE_SET_PLAY_VOLUME_INTERVAL;
			interval = _interval;
			moreThanThd = _moreThanThd;
			lessThanThd = _lessThanThd;
		}

		@Override
		public byte[] marshall() {
			pushInt(interval);
			pushInt(moreThanThd);
			pushInt(lessThanThd);
			return super.marshall();
		}
	}

	private static class YLEOnVideoSizeChange extends YLEBase {
		private long uid;
		private int width;
		private int height;

		YLEOnVideoSizeChange(long _uid, int _width, int _height) {
			event = YYLIVE_ON_VIDEO_SIZE_CHANGE;
			uid = _uid;
			width = _width;
			height= _height;
		}

		@Override
		public byte[] marshall() {
			pushInt64(uid);
			pushInt(width);
			pushInt(height);
			return super.marshall();
		}
	}

	private static class YLEOnRenderFirstFrame extends YLEBase {
		private long userGroupId;
		private long streamId;
		private long currentSystemMilliSecond;
		private long firstFrameToRenderInMilliSec;
		private int eatenFrames;

		YLEOnRenderFirstFrame(long _userGroupId, long _streamId, long _currentSystemMilliSecond, long _firstFrameToRenderInMilliSec,  int _eatenFrames) {
			event = YYLIVE_ON_RENDER_FIRST_FRAME;
			userGroupId = _userGroupId;
			streamId = _streamId;
			currentSystemMilliSecond = _currentSystemMilliSecond;
			firstFrameToRenderInMilliSec = _firstFrameToRenderInMilliSec;
			eatenFrames = _eatenFrames;
		}

		@Override
		public byte[] marshall() {
			pushInt64(userGroupId);
			pushInt64(streamId);
			pushInt64(currentSystemMilliSecond);
			pushInt64(firstFrameToRenderInMilliSec);
			pushInt64(eatenFrames);
			return super.marshall();
		}
	}

	private static class YLESetCaptureVolumeInterval extends YLEBase {
		private int interval;
		private int moreThanThd;
		private int lessThanThd;

		YLESetCaptureVolumeInterval(int _interval, int _moreThanThd, int _lessThanThd) {
			event = YYLIVE_SET_CAPTURE_VOLUME_INTERVAL;
			interval = _interval;
			moreThanThd = _moreThanThd;
			lessThanThd = _lessThanThd;
		}

		@Override
		public byte[] marshall() {
			pushInt(interval);
			pushInt(moreThanThd);
			pushInt(lessThanThd);
			return super.marshall();
		}
	}
	
	private static class YLEStartAudioSaver extends YLEBase{
		private String fileName;
		private int saverMode;
		private int fileMode;

		YLEStartAudioSaver(String _fileName, int _saverMode, int _fileMode){
			event = YYLIVE_START_AUDIO_SAVER;
			fileName = _fileName;
			saverMode = _saverMode;
			fileMode = _fileMode;
		}

		@Override
		public byte[] marshall() {
			pushString16(fileName);
			pushInt(saverMode);
			pushInt(fileMode);
			return super.marshall();
		}
	}

	private static class YLEStopAudioSaver extends YLEBase{
		YLEStopAudioSaver(){
			event = YYLIVE_STOP_AUDIO_SAVER;
		}
	}

	private static class YLESetSoundEffect extends YLEBase{
        private int soundEffectMode;

        YLESetSoundEffect( int _soundEffectMode){
            event = YYLIVE_SET_SOUND_EFFECT;
            soundEffectMode = _soundEffectMode;
        }

        @Override
        public byte[] marshall() {
            pushInt(soundEffectMode);
            return super.marshall();
        }
    }

	private static class YLEResolveServiceData extends YLEBase {
		private  int uri;
		private  String uid;
		private  byte[] msg;
		YLEResolveServiceData(int _uri, String _uid, byte[] _data) {
			event = YYLIVE_RESOLVE_SERVICE_DATA;
			uri = _uri;
			uid = _uid;
			msg = _data;
		}
		@Override
		public byte[] marshall()
		{
			pushInt(uri);
			pushString16(uid);
			pushBytes(msg);
			return super.marshall();
		}
	};


	private static class YLESetVoiceOnlySdk extends YLEBase {
		private boolean enable;

		YLESetVoiceOnlySdk(boolean _enable) {
			event = YYLIVE_SET_VOICE_ONLY_SDK;
			enable = _enable;
		}

		@Override
		public byte[] marshall() {
			pushBool(enable);
			return super.marshall();
		}
	}

	private static class YLEUpdateToken extends YLEBase {
		byte[] token;
		byte[] bizAuthExtInfo;

		YLEUpdateToken(byte[] _token, byte[] _bizAuthExtInfo) {
			event = YYLIVE_UPDATE_TOKEN;
			token = _token;
			bizAuthExtInfo = _bizAuthExtInfo;
		}

		@Override
		public byte[] marshall() {
			pushBytes(token);
			pushBytes(bizAuthExtInfo);
			return super.marshall();
		}
	}


	//YYLIVE_PLAY_EVENT
	private static class YLEStartPlayStreams extends YLEBase {
		ArrayList<YYLiveStream> streamList;
		ArrayList<YYLiveGroup> groupList;

		YLEStartPlayStreams(ArrayList<YYLiveStream> _streamList,
							ArrayList<YYLiveGroup> _groupList) {
			event = YYLIVE_START_PLAY_STREAMS;
			streamList = _streamList;
			groupList = _groupList;
		}

		@Override
		public byte[] marshall() {
			YYLiveStream stream;
			YYLiveGroup group;

			int size = streamList.size();
			pushInt(size);
			for (int i = 0; i < size; ++i) {
				stream = streamList.get(i);
				pushInt(stream.appId);
				pushString16(stream.streamName);
				pushInt(stream.speakerUid);
				pushBool(stream.bVideo);
				pushInt(stream.scaleMode);
				pushInt(stream.lineSeq);
				pushInt64(YYLiveObjectToPtr(stream.toView));
			}

			size = groupList.size();
			pushInt(size);
			for (int i = 0; i < size; ++i) {
				group = groupList.get(i);
				pushInt(group.appId);
				pushString16(group.groupName);
			}

			return super.marshall();
		}
	}

	private static class YLEStopPlayStreams extends YLEBase {
		ArrayList<YYLiveStream> streamList;
		ArrayList<YYLiveGroup> groupList;

		YLEStopPlayStreams(ArrayList<YYLiveStream> _streamList, ArrayList<YYLiveGroup> _groupList) {
			event = YYLIVE_STOP_PLAY_STREAMS;
			streamList = _streamList;
			groupList = _groupList;
		}

		@Override
		public byte[] marshall() {
			YYLiveStream stream = null;
			YYLiveGroup group = null;

			int size = streamList.size();
			pushInt(size);
			for (int i = 0; i < size; ++i) {
				stream = streamList.get(i);
				pushInt(stream.appId);
				pushString16(stream.streamName);
				pushInt(stream.speakerUid);
				pushBool(stream.bVideo);
				pushInt(stream.scaleMode);
				//pushInt64(YYLiveObjectToPtr(stream.toView));
			}

			size = groupList.size();
			pushInt(size);
			for (int i = 0; i < size; ++i) {
				group = groupList.get(i);
				pushInt(group.appId);
				pushString16(group.groupName);
			}

			return super.marshall();
		}
	}

	private static class YLEEnableHardwareDecoder extends YLEBase {
		private boolean enable;
		private int decodeType;

		YLEEnableHardwareDecoder(boolean _enable, int _decodeType) {
			event = YYLIVE_ENABLE_HARDWARE_DECODER;
			enable = _enable;
			decodeType = _decodeType;
		}

		@Override
		public byte[] marshall() {
			pushBool(enable);
			pushInt(decodeType);

			return super.marshall();
		}
	}

	private static class YLEUpdatePlayVideoView extends YLEBase {
		private YYLiveStream stream;
		private int scaleMode;
		private Object view;

		YLEUpdatePlayVideoView(Object _view, int _scaleMode, YYLiveStream _stream) {
			event = YYLIVE_UPDATE_PLAY_VIDEO_VIEW;
			view = _view;
			scaleMode = _scaleMode;
			stream = _stream;
		}

		@Override
		public byte[] marshall() {
			pushInt(stream.appId);
			pushString16(stream.streamName);
			pushInt(stream.speakerUid);
			pushInt(scaleMode);
			pushInt64(YYLiveObjectToPtr(view));

			return super.marshall();
		}
	}

	private static class YLEEnableMuteStream extends YLEBase {
		private YYLiveStream stream;
		private boolean enable;

		YLEEnableMuteStream(boolean _enable, YYLiveStream _stream) {
			event = YYLIVE_ENABLE_MUTE_STREAM;
			enable = _enable;
			stream = _stream;
		}

		@Override
		public byte[] marshall() {
			pushInt(stream.appId);
			pushString16(stream.streamName);
			pushInt(stream.speakerUid);
			pushBool(stream.bVideo);

			pushBool(enable);

			return super.marshall();
		}
	}

	private static class YLEEnableMuteStringUid extends YLEBase {
		private boolean enable;
		private String uid;

		YLEEnableMuteStringUid(boolean _enable, String _uid) {
			event = YYLIVE_ENABLE_MUTE_STRING_UID;
			enable = _enable;
			uid = _uid;
		}

		@Override
		public byte[] marshall() {
			pushBool(enable);
			pushString16(uid);
			return super.marshall();
		}
	}

	private static class YLEEnableAllMute extends YLEBase {
		private boolean enable;

		YLEEnableAllMute(boolean _enable){
			event = YYLIVE_ENABLE_ALL_MUTE;
			enable = _enable;
		}

		@Override
		public byte[] marshall() {
			pushBool(enable);

			return super.marshall();
		}
	}

	private static class YLESetStreamPlayVolume extends YLEBase {
		private YYLiveStream stream;
		private int volume;

		YLESetStreamPlayVolume(int _volume, YYLiveStream _stream) {
			event = YYLIVE_SET_STREAM_PLAY_VOLUME;
			volume = _volume;
			stream = _stream;
		}

		@Override
		public byte[] marshall() {
			pushInt(stream.appId);
			pushString16(stream.streamName);
			pushInt(stream.speakerUid);
			pushBool(stream.bVideo);

			pushInt(volume);

			return super.marshall();
		}
	}

	private static class YLESetSpeakerVolume extends YLEBase {
		private int volume;

		YLESetSpeakerVolume(int _volume) {
			event = YYLIVE_SET_SPEAKER_VOLUME;
			volume = _volume;
		}

		@Override
		public byte[] marshall() {
			pushInt(volume);

			return super.marshall();
		}
	}

	private static class YLEVideoRenderEvent extends YLEBase {
		private long callbackPtr;
		private ArrayList<VideoRenderNotify> notifications;

		YLEVideoRenderEvent(long _callBackPtr, final ArrayList<VideoRenderNotify> _notifications) {
			event = YYLIVE_VIDEO_RENDER_EVENT;
			callbackPtr = _callBackPtr;
			notifications = _notifications;
		}
		@Override
		public byte[] marshall() {
			pushInt64(callbackPtr);
			pushInt(notifications.size());
			for (VideoRenderNotify item : notifications)
			{
				pushInt64(item.mUserGroupId);
				pushInt64(item.mStreamId);
				pushInt64(item.mPts);
				pushInt64(item.mRenderStamp);
			}
			return super.marshall();
		}
	}

	private static class YLEEnableLoudSpeaker extends YLEBase {
		private boolean enable;

		YLEEnableLoudSpeaker(boolean _enable) {
			event = YYLIVE_ENABLE_LOUD_SPEAKER;
			enable = _enable;
		}

		@Override
		public byte[] marshall() {
			pushBool(enable);

			return super.marshall();
		}
	}


	private static class YLEIsSupportPlayH265 extends YLEBase {
		YLEIsSupportPlayH265() {
			event = YYLIVE_IS_SUPPORT_H265;
		}

		@Override
		public byte[] marshall() {
			return super.marshall();
		}
	}

	private static class YLEGetLoudSpeakerEnabled extends YLEBase{
		private int reverse;

		YLEGetLoudSpeakerEnabled(){
			event = YYLIVE_GET_LOUDSPEAKER_ENABLED;
			reverse = 0;
		}

		@Override
		public byte[] marshall(){
			pushInt(reverse);
			return super.marshall();
		}

	}

	//YYLIVE_PUBLISH_EVENT
	private static class YLEStartPublishAudio extends YLEBase {
		private String streamName;
		private ArrayList<String> groupNames;
		private YYPublishAudioConfig config;

		YLEStartPublishAudio(String _streamName,
							 ArrayList<String> _groupNames,
							 YYPublishAudioConfig _config) {
			event = YYLIVE_START_PUBLISH_AUDIO;
			streamName = _streamName;
			groupNames = _groupNames;
			config = _config;
		}

		@Override
		public byte[] marshall() {
			pushInt(config.mode);
			pushBool(config.pubToGroupAndName);
			pushBool(config.bUseAudioProfile);
			pushInt(config.channelProfile);
			pushInt(config.audioProfile);
			pushInt(config.commutMode);
			pushInt(config.scenarioMode);
			pushString16(streamName);
			int size = groupNames.size();
			pushInt(size);
			for (int i = 0; i < size; ++i) {
				pushString16(groupNames.get(i));
			}

			return super.marshall();
		}
	}

	private static class YLEStopPublishAudio extends YLEBase {
		private int reverse;

		YLEStopPublishAudio() {
			event = YYLIVE_STOP_PUBLISH_AUDIO;
			reverse = 0;
		}

		@Override
		public byte[] marshall() {
			pushInt(reverse);
			return super.marshall();
		}

	}

	private static class YLESetMicVolume extends YLEBase {
		private int volume;

		YLESetMicVolume(int _volume) {
			event = YYLIVE_SET_MIC_VOLUME;
			volume = _volume;
		}

		@Override
		public byte[] marshall() {
			pushInt(volume);
			return super.marshall();
		}
	}

	private static class YLESetOrientation extends YLEBase {
		private int orientation;

		YLESetOrientation(int ori) {
			event = YYLIVE_SET_ORIENTATION;
			orientation = ori;
		}

		@Override
		public byte[] marshall() {
			pushInt(orientation);
			return super.marshall();
		}
	}

	private static class YLEEnableVad extends YLEBase {
		private boolean enable;

		YLEEnableVad(boolean _enable) {
			event = YYLIVE_ENABLE_VAD;
			enable = _enable;
		}

		@Override
		public byte[] marshall() {
			pushBool(enable);
			return super.marshall();
		}
	}

	private static class YLEEnableEqualizer extends YLEBase {
		private boolean enable;

		YLEEnableEqualizer(boolean _enable) {
			event = YYLIVE_AUDIO_EFFECT_ENABLE_EQUALIZER;
			enable = _enable;
		}

		@Override
		public byte[] marshall() {
			pushBool(enable);
			return super.marshall();
		}
	}

	private static class YLESetGqGains extends YLEBase {
		private float mPreamp;
		private float mBand0;
		private float mBand1;
		private float mBand2;
		private float mBand3;
		private float mBand4;
		private float mBand5;
		private float mBand6;
		private float mBand7;
		private float mBand8;
		private float mBand9;

		YLESetGqGains(int [] gains) {
			event = YYLIVE_AUDIO_EFFECT_SET_EQUALIZER;
			mPreamp  =  gains[0];
			mBand0   = gains[1];
			mBand1   = gains[2];
			mBand2   = gains[3];
			mBand3   = gains[4];
			mBand4   = gains[5];
			mBand5   = gains[6];
			mBand6   = gains[7];
			mBand7   = gains[8];
			mBand8   = gains[9];
			mBand9   = gains[10];
		}

		@Override
		public byte[] marshall() {
			pushString16(String.valueOf(mPreamp * 1000000));
			pushString16(String.valueOf(mBand0 * 1000000));
			pushString16(String.valueOf(mBand1 * 1000000));
			pushString16(String.valueOf(mBand2 * 1000000));
			pushString16(String.valueOf(mBand3 * 1000000));
			pushString16(String.valueOf(mBand4 * 1000000));
			pushString16(String.valueOf(mBand5 * 1000000));
			pushString16(String.valueOf(mBand6 * 1000000));
			pushString16(String.valueOf(mBand7 * 1000000));
			pushString16(String.valueOf(mBand8 * 1000000));
			pushString16(String.valueOf(mBand9 * 1000000));
			return super.marshall();
		}
	}

	private static class YLEEnableCompressor extends YLEBase {
		private boolean enable;

		YLEEnableCompressor(boolean _enable) {
			event = YYLIVE_AUDIO_EFFECT_ENABLE_COMPRESSOR;
			enable = _enable;
		}

		@Override
		public byte[] marshall() {
			pushBool(enable);
			return super.marshall();
		}
	}

	private static class YLEEnableLimiter extends YLEBase {
		private boolean enable;

		YLEEnableLimiter(boolean _enable) {
			event = YYLIVE_AUDIO_EFFECT_ENABLE_LIMITER;
			enable = _enable;
		}

		@Override
		public byte[] marshall() {
			pushBool(enable);
			return super.marshall();
		}
	}

	private static class YLESetCompressorParam extends YLEBase {
		private int mthreshold;
		private int mmakeupGain;
		private int mratio;
		private int mknee;
		private int mreleaseTime;
		private int mattackTime;

		YLESetCompressorParam(int threshold, int makeupGain, int ratio, int knee, int releaseTime, int attackTime)
		{
			event = YYLIVE_AUDIO_EFFECT_SET_COMPRESSOR;
			mthreshold = threshold;
			mmakeupGain = makeupGain;
			mratio = ratio;
			mknee = knee;
			mreleaseTime = releaseTime;
			mattackTime = attackTime;
		}

		@Override
		public byte[] marshall() {
			pushInt(mthreshold);
			pushInt(mmakeupGain);
			pushInt(mratio);
			pushInt(mknee);
			pushInt(mreleaseTime);
			pushInt(mattackTime);
			return super.marshall();
		}
	}

	private static class YLEEnableReverb extends YLEBase {
		private boolean enable;

		YLEEnableReverb(boolean _enable) {
			event = YYLIVE_AUDIO_EFFECT_ENABLE_REVERB;
			enable = _enable;
		}

		@Override
		public byte[] marshall() {
			pushBool(enable);
			return super.marshall();
		}
	}

	private static class YLEsetReverbExParameter extends YLEBase {
		private float mRoomSize;
		private float mPreDelay;
		private float mReverberance;
		private float mHfDamping;
		private float mToneLow;
		private float mToneHigh;
		private float mWetGain;
		private float mDryGain;
		private float mStereoWidth;

		YLEsetReverbExParameter(float RoomSize,   float PreDelay, float Reverberance,
								float HfDamping,  float ToneLow,  float ToneHigh,
								float WetGain,    float DryGain,  float StereoWidth)
		{
			event = YYLIVE_AUDIO_EFFECT_SET_REVERB;
			mRoomSize    = RoomSize;
			mPreDelay    = PreDelay;
			mReverberance= Reverberance;
			mHfDamping   = HfDamping;
			mToneLow     = ToneLow;
			mToneHigh    = ToneHigh;
			mWetGain     = WetGain;
			mDryGain     = DryGain;
			mStereoWidth = StereoWidth;
		}

		@Override
		public byte[] marshall() {
			pushString16(String.valueOf(mRoomSize * 1000000));
			pushString16(String.valueOf(mPreDelay * 1000000));
			pushString16(String.valueOf(mReverberance * 1000000));
			pushString16(String.valueOf(mHfDamping * 1000000));
			pushString16(String.valueOf(mToneLow * 1000000));
			pushString16(String.valueOf(mToneHigh * 1000000));
			pushString16(String.valueOf(mWetGain * 1000000));
			pushString16(String.valueOf(mDryGain * 1000000));
			pushString16(String.valueOf(mStereoWidth * 1000000));
			return super.marshall();
		}
	}

	private static class YLEsetLimiterParameter extends YLEBase {
		private float m_fCeiling;
		private float m_fRelease;
		private float m_fLookaheadRatio;
		private float m_fThreshold;
		private float m_fAttack;
		private float m_fRMS;
		private float m_fPreGain;
		private float m_fLookahead;
		private float m_fStLink;

		YLEsetLimiterParameter(float fCeiling,        float fThreshold, float fPreGain,
							   float fRelease,        float fAttack,    float fLookahead,
							   float fLookaheadRatio, float fRMS,       float fStLink)
		{
			event = YYLIVE_AUDIO_EFFECT_SET_LIMITER;
			m_fCeiling         = fCeiling;
			m_fRelease         = fRelease;
			m_fLookaheadRatio = fLookaheadRatio;
			m_fThreshold       = fThreshold;
			m_fAttack           = fAttack;
			m_fRMS              = fRMS;
			m_fPreGain         = fPreGain;
			m_fLookahead       = fLookahead;
			m_fStLink          = fStLink;
		}

		@Override
		public byte[] marshall() {
			pushString16(String.valueOf(m_fCeiling * 1000000));
			pushString16(String.valueOf(m_fRelease * 1000000));
			pushString16(String.valueOf(m_fLookaheadRatio * 1000000));
			pushString16(String.valueOf(m_fThreshold * 1000000));
			pushString16(String.valueOf(m_fAttack * 1000000));
			pushString16(String.valueOf(m_fRMS * 1000000));
			pushString16(String.valueOf(m_fPreGain * 1000000));
			pushString16(String.valueOf(m_fLookahead * 1000000));
			pushString16(String.valueOf(m_fStLink * 1000000));
			return super.marshall();
		}
	}

	private static class YLEsetAudioSourceType extends YLEBase {
		private int mode;

		YLEsetAudioSourceType(int _mode) {
			event = YYLIVE_SET_AUDIO_SOURCE_TYPE;
			mode = _mode;
		}

		@Override
		public byte[] marshall() {
			pushInt(mode);
			return super.marshall();
		}
	}

	private static class YLEenableInEarMonitor extends YLEBase {
		private boolean enable;

		YLEenableInEarMonitor(boolean _enable) {
			event = YYLIVE_ENABLE_IN_EAR_MONITOR;
			enable = _enable;
		}

		@Override
		public byte[] marshall() {
			pushBool(enable);
			return super.marshall();
		}
	}

	private static class YLEstopAndRcoverVideoEncode extends YLEBase {
		private boolean stop;

		YLEstopAndRcoverVideoEncode(boolean _stop) {
			event = YYLIVE_STOP_AND_RECOVER_VIDEO_ENCODE;
			stop = _stop;
		}

		@Override
		public byte[] marshall() {
			pushBool(stop);
			return super.marshall();
		}
	}

	private static class YLEStartVideoPreview extends YLEBase {
		private Object view;
		private int playType;
		private int publishMode;
		YLEStartVideoPreview(Object _view, int play, int mode) {
			event = YYLIVE_START_VIDEO_PREVIEW;
			view = _view;
			playType = play;
			publishMode = mode;
		}

		@Override
		public byte[] marshall() {
			pushInt64(YYLiveObjectToPtr(view));
			pushInt(playType);
			pushInt(publishMode);
			return super.marshall();
		}
	}

	private static class YLESetPlayViewScaleMode extends YLEBase {
		private Object view;
		private int mode;

		YLESetPlayViewScaleMode(Object _view, int _mode) {
			event = YYLIVE_SET_PLAYVIEW_SCALEMODE;
			view = _view;
			mode = _mode;
		}

		@Override
		public byte[] marshall() {
			pushInt64(YYLiveObjectToPtr(view));
			pushInt64(mode);
			return super.marshall();
		}
	}

	private static class YLEStopVideoPreview extends YLEBase {
		private int reverse;

		YLEStopVideoPreview() {
			event = YYLIVE_STOP_VIDEO_PREVIEW;
			reverse = 0;
		}

		@Override
		public byte[] marshall() {
			pushInt(reverse);
			return super.marshall();
		}

	}

	private static class  YLEsetPublishRtmpParam extends  YLEBase {
		private boolean bOpen;
		private String rtmpUrl;
		private String playPath;

		YLEsetPublishRtmpParam(boolean _bOpen, String _rtmpUrl, String _playPath) {
			event = YYLIVE_SET_PUBLISH_RTMP_PARAM;
			bOpen = _bOpen;
			rtmpUrl = _rtmpUrl;
			playPath = _playPath;
		}

		@Override
		public byte[] marshall() {
			pushBool(bOpen);
			pushString16(rtmpUrl);
			pushString16(playPath);

			return super.marshall();
		}
	}

	private static class YLEStartPublishVideo extends YLEBase {
		private String streamName;
		private ArrayList<String> groupNames;
		private YYPublishVideoConfig config;

		YLEStartPublishVideo(String _streamName,
							 ArrayList<String> _groupNames,
							 YYPublishVideoConfig _config) {
			event = YYLIVE_START_PUBLISH_VIDEO;
			streamName = _streamName;
			groupNames = _groupNames;
			config = _config;
		}

		@Override
		public byte[] marshall() {
			pushInt(config.encodeFrameRate);
			pushInt(config.encodeBitrate);
			pushInt(config.encodeMaxBitrate);
			pushInt(config.encodeResolutionWidth);
			pushInt(config.encodeResolutionHeight);
			pushInt(config.encodeType);
			pushBool(config.hardwareEncoder);
			pushBool(config.mirrorFrontCamera);
			pushBool(config.pubToGroupAndName);
			pushInt(config.playType);
			pushInt(config.mode);
			pushInt(config.screenOrientation);

			pushString16(streamName);
			int size = groupNames.size();
			pushInt(size);
			for (int i = 0; i < size; ++i) {
				pushString16(groupNames.get(i));
			}

			return super.marshall();
		}

	}

	private static class YLEStopPublishVideo extends YLEBase {
		private int reverse;

		YLEStopPublishVideo() {
			event = YYLIVE_STOP_PUBLISH_VIDEO;
			reverse = 0;
		}

		@Override
		public byte[] marshall() {
			pushInt(reverse);
			return super.marshall();
		}

	}

	private static class YLEStartPublishLive extends YLEBase {
		private String channelId;
		private boolean uniq;
		private YYPublishVideoConfig videoConfig;
		private YYPublishAudioConfig audioConfig;
		private YYLiveLayout layout;

		YLEStartPublishLive(String _channelId,
							boolean _uniq,
							YYPublishVideoConfig _videoConfig,
							YYPublishAudioConfig _audioConfig,
							YYLiveLayout _layout) {
			event = YYLIVE_START_PUBLISH_LIVE;
			channelId = _channelId;
			uniq = _uniq;
			videoConfig = _videoConfig;
			audioConfig = _audioConfig;
			layout = _layout;
		}

		@Override
		public byte[] marshall() {
			pushString16(channelId);
			pushInt(videoConfig.encodeFrameRate);
			pushInt(videoConfig.encodeBitrate);
			pushInt(videoConfig.encodeMaxBitrate);
			pushInt(videoConfig.encodeResolutionWidth);
			pushInt(videoConfig.encodeResolutionHeight);
			pushInt(videoConfig.encodeType);
			pushBool(videoConfig.hardwareEncoder);
			pushBool(videoConfig.mirrorFrontCamera);
			pushBool(videoConfig.pubToGroupAndName);
			pushInt(videoConfig.playType);
			pushInt(videoConfig.mode);
			pushInt(videoConfig.screenOrientation);

			pushInt(audioConfig.mode);
			pushBool(audioConfig.pubToGroupAndName);
			pushBool(audioConfig.bUseAudioProfile);
			pushInt(audioConfig.channelProfile);
			pushInt(audioConfig.audioProfile);
			pushInt(audioConfig.commutMode);
			pushInt(audioConfig.scenarioMode);

			YYLiveChannelLayout channelLayout = layout.getChannelLayout(0);
			pushString16(channelLayout.channelId);
			pushBool(channelLayout.owner);
			pushBool(uniq);
			pushInt(channelLayout.layoutNo);
			pushInt(channelLayout.layout.left);
			pushInt(channelLayout.layout.top);
			pushInt(channelLayout.layout.right);
			pushInt(channelLayout.layout.bottom);
			pushInt(layout.width);
			pushInt(layout.height);
			//pushInt64(channelLayout.version);
			int size = layout.speakers.size();
			pushInt(size);
			for (int i = 0; i < size; ++i) {
				String uid = layout.getSpeaker(i);
				if ((uid != null) && (!uid.isEmpty())) {
					pushInt(Long.parseLong(uid));
				}
			}

			return super.marshall();
		}
	}

	private static class YLEUpdatePublishLive extends YLEBase {
		private String channelId;
		private boolean uniq;
		private YYPublishVideoConfig videoConfig;
		private YYPublishAudioConfig audioConfig;
		private YYLiveLayout layout;

		YLEUpdatePublishLive(String _channelId,
							boolean _uniq,
							YYPublishVideoConfig _videoConfig,
							YYPublishAudioConfig _audioConfig,
							YYLiveLayout _layout) {
			event = YYLIVE_UPDATE_PUBLISH_LIVE;
			channelId = _channelId;
			uniq = _uniq;
			videoConfig = _videoConfig;
			audioConfig = _audioConfig;
			layout = _layout;
		}

		@Override
		public byte[] marshall() {
			pushString16(channelId);
			pushInt(videoConfig.encodeFrameRate);
			pushInt(videoConfig.encodeBitrate);
			pushInt(videoConfig.encodeMaxBitrate);
			pushInt(videoConfig.encodeResolutionWidth);
			pushInt(videoConfig.encodeResolutionHeight);
			pushInt(videoConfig.encodeType);
			pushBool(videoConfig.hardwareEncoder);
			pushBool(videoConfig.mirrorFrontCamera);
			pushBool(videoConfig.pubToGroupAndName);
			pushInt(videoConfig.playType);
			pushInt(videoConfig.mode);
			pushInt(videoConfig.screenOrientation);

			pushInt(audioConfig.mode);
			pushBool(audioConfig.pubToGroupAndName);
			pushBool(audioConfig.bUseAudioProfile);
			pushInt(audioConfig.channelProfile);
			pushInt(audioConfig.audioProfile);
			pushInt(audioConfig.commutMode);
			pushInt(audioConfig.scenarioMode);

			YYLiveChannelLayout channelLayout = layout.getChannelLayout(0);
			pushString16(channelLayout.channelId);
			pushBool(channelLayout.owner);
			pushBool(uniq);
			pushInt(channelLayout.layoutNo);
			pushInt(channelLayout.layout.left);
			pushInt(channelLayout.layout.top);
			pushInt(channelLayout.layout.right);
			pushInt(channelLayout.layout.bottom);
			pushInt(layout.width);
			pushInt(layout.height);
			//pushInt64(channelLayout.version);
			int size = layout.speakers.size();
			pushInt(size);
			for (int i = 0; i < size; ++i) {
				String uid = layout.getSpeaker(i);
				pushInt(Long.parseLong(uid));
			}

			return super.marshall();
		}
	}

	private static class YLEStopPublishLive extends YLEBase {
		private String channelId;

		YLEStopPublishLive(String _channelId) {
			event = YYLIVE_STOP_PUBLISH_LIVE;
			channelId = _channelId;
		}

		@Override
		public byte[] marshall() {
			pushString16(channelId);
			return super.marshall();
		}
	}

	private static class YLEUpdateVideoConfig extends YLEBase {
		private YYPublishVideoConfig config;

		YLEUpdateVideoConfig(YYPublishVideoConfig _config) {
			event = YYLIVE_UPDATE_VIDEO_CONFIG;
			config = _config;
		}

		@Override
		public byte[] marshall() {
			pushInt(config.encodeFrameRate);
			pushInt(config.encodeBitrate);
			pushInt(config.encodeResolutionWidth);
			pushInt(config.encodeResolutionHeight);
			pushInt(config.encodeType);
			pushBool(config.hardwareEncoder);
			pushBool(config.mirrorFrontCamera);
			pushBool(config.pubToGroupAndName);
			pushInt(config.playType);
			pushInt(config.mode);
			pushInt(config.screenOrientation);

			return super.marshall();
		}
	}

	private static class YLESetCameraPosition extends YLEBase {
		private int position;

		YLESetCameraPosition(int _position) {
			event = YYLIVE_SET_CAMERA_POSTION;
			position = _position;
		}

		@Override
		public byte[] marshall() {
			pushInt(position);
			return super.marshall();
		}
	}

	private static class YLESetWatermark extends YLEBase {
		private int posX;
		private int posY;
		private Bitmap image;

		YLESetWatermark(int _posX, int _posY, Bitmap _image) {
			event = YYLIVE_SET_WATERMARK;
			posX = _posX;
			posY = _posY;
			image = _image;
		}

		@Override
		public byte[] marshall() {
			pushInt(posX);
			pushInt(posY);
			pushInt64(YYLiveObjectToPtr(image));

			return super.marshall();
		}
	}

	private static class YLESetFaceBeautyLevel extends YLEBase {
		private float level;

		YLESetFaceBeautyLevel(float _level) {
			event = YYLIVE_SET_FACE_BEAUTY_LEVEL;
			level = _level;
		}

		@Override
		public byte[] marshall() {
			pushInt((int)(level * 1000000));

			return super.marshall();
		}
	}

	private static class YLEAttachAudioCapture extends YLEBase {
		private YYLiveAudioCapture capture;

		YLEAttachAudioCapture(YYLiveAudioCapture _capture) {
			event = YYLIVE_ATTACH_AUDIO_CAPTURE;
			capture = _capture;
		}

		@Override
		public byte[] marshall() {
			pushInt64(YYLiveObjectToPtr(capture));

			return super.marshall();
		}
	}

	private static class YLEAttachVideoCapture extends YLEBase {
		private YYLiveVideoCapture capture;

		YLEAttachVideoCapture(YYLiveVideoCapture _capture) {
			event = YYLIVE_ATTACH_VIDEO_CAPTURE;
			capture = _capture;
		}

		@Override
		public byte[] marshall() {
			pushInt64(YYLiveObjectToPtr(capture));

			return super.marshall();
		}
	}

	private static class YLEStartCapture extends YLEBase {
		private int reverse;

		YLEStartCapture() {
			event = YYLIVE_START_CAPTURE;
			reverse = 0;
		}

		@Override
		public byte[] marshall() {
			pushInt(reverse);
			return super.marshall();
		}
	}

	private static class YLEStopCapture extends YLEBase {
		private int reverse;

		YLEStopCapture() {
			event = YYLIVE_STOP_CAPTURE;
			reverse = 0;
		}

		@Override
		public byte[] marshall() {
			pushInt(reverse);
			return super.marshall();
		}
	}

	private static class YLESetPreviewRenderMode extends YLEBase {
		private int mode;

		YLESetPreviewRenderMode(int _volume) {
			event = YYLIVE_SET_PREVIEW_RENDER_MODE;
			mode = _volume;
		}

		@Override
		public byte[] marshall() {
			pushInt(mode);
			return super.marshall();
		}
	}


	public static class YLEChangeScreenLiveMode extends YLEBase {
		private boolean bPicMode;
		private Object bitmap;

		public YLEChangeScreenLiveMode(boolean _bPicMode, Object _bitmap) {
			event = YYLIVE_CHANGE_SCREEN_LIVE_MODE;
			bPicMode = _bPicMode;
			bitmap = _bitmap;
		}

		@Override
		public byte[] marshall() {
			pushBool(bPicMode);
			pushInt64(YYLiveObjectToPtr(bitmap));
			return super.marshall();
		}
	}

	//YYLive System events
	private static class YLEEnterBackground extends YLEBase {
		private int reverse;

		YLEEnterBackground() {
			event = YYLIVE_ENTER_BACKGROUND;
			reverse = 0;
		}

		@Override
		public byte[] marshall() {
			pushInt(reverse);
			return super.marshall();
		}
	}

	private static class YLEEnterForeground extends YLEBase {
		private int reverse;

		YLEEnterForeground() {
			event = YYLIVE_ENTER_FOREGROUND;
			reverse = 0;
		}

		@Override
		public byte[] marshall() {
			pushInt(reverse);
			return super.marshall();
		}
	}

	private static class YLENotifyNetworkState extends YLEBase {
		private int state;

		YLENotifyNetworkState(int _state) {
			event = YYLIVE_NOTIFY_NETWORK_STATE;
			state = _state;
		}

		@Override
		public byte[] marshall() {
			pushInt(state);

			return super.marshall();
		}
	}

	private static class YLECreateAudioFilePlayer extends YLEBase {
		private Object obj;

		YLECreateAudioFilePlayer(Object _obj) {
			event = YYLIVE_CREATE_AUDIO_FILE_PLAYER;
			obj = _obj;
		}

		@Override
		public byte[] marshall() {
			pushInt64(YYLiveObjectToPtr(obj));

			return super.marshall();
		}
	}

	private static class YLEAudioFileOpen extends YLEBase {
		private long ctx;
		private String path;

		YLEAudioFileOpen(long _ctx, String _path) {
			event = YYLIVE_AUDIO_FILE_OPEN;
			path = _path;
			ctx  = _ctx;
		}

		@Override
		public byte[] marshall() {
			pushInt64(ctx);
			pushString16(path);
			return super.marshall();
		}
	}

	private static class YLEAudioFileEventCommon extends YLEBase {
		private long ctx;

		YLEAudioFileEventCommon(int _event, long _ctx) {
			event = _event;
			ctx = _ctx;
		}

		@Override
		public byte[] marshall() {
			pushInt64(ctx);

			return super.marshall();
		}
	}

	private static class YLEAudioFileSeek extends YLEBase {
		private long ctx;
		private long timeMS;

		YLEAudioFileSeek(long _ctx, long _timeMS) {
			event = YYLIVE_AUDIO_FILE_SEEK;
			ctx = _ctx;
			timeMS = _timeMS;
		}

		@Override
		public byte[] marshall() {
			pushInt64(ctx);
			pushInt(timeMS);

			return super.marshall();
		}
	}

	private static class YLEAudioFileSetPlayVolume extends YLEBase {
		private long ctx;
		private int volume;

		YLEAudioFileSetPlayVolume(long _ctx, int _volume) {
			event = YYLIVE_AUDIO_FILE_SET_PLAY_VOLUME;
			ctx = _ctx;
			volume = _volume;
		}

		@Override
		public byte[] marshall() {
			pushInt64(ctx);
			pushInt(volume);

			return super.marshall();
		}
	}

	private static class YLEAudioFileSetSemitone extends YLEBase {
		private long ctx;
		private float val;

		YLEAudioFileSetSemitone(long _ctx, float _val) {
			event = YYLIVE_AUDIO_FILE_SET_SEMITONE;
			ctx = _ctx;
			val = _val;
		}

		@Override
		public byte[] marshall() {
			pushInt64(ctx);
			pushString16(String.valueOf(val * 1000000));

			return super.marshall();
		}
	}

	private static class YLEAudioFileEnablePublish extends YLEBase {
		private long ctx;
		private boolean enable;

		YLEAudioFileEnablePublish(long _ctx, boolean _enable) {
			event = YYLIVE_AUDIO_FILE_ENABLE_PUBLISH;
			ctx = _ctx;
			enable = _enable;
		}

		@Override
		public byte[] marshall() {
			pushInt64(ctx);
			pushBool(enable);

			return super.marshall();
		}
	}

	private static class YLEAudioFileSetCompensateValue extends YLEBase {
		private long ctx;
		private long value;

		YLEAudioFileSetCompensateValue(long _ctx, int _value) {
			event = YYLIVE_AUDIO_FILE_SET_COMPENSATE_VALUE;
			ctx = _ctx;
			value = _value;
		}

		@Override
		public byte[] marshall() {
			pushInt64(value);

			return super.marshall();
		}
	}

	private static class YLEAudioFilePublishByMode extends YLEBase {
		private long ctx;
		private long mode;

		YLEAudioFilePublishByMode(long _ctx, long _mode) {
			event = YYLIVE_AUDIO_FILE_PUBLISH_BYMODE;
			ctx = _ctx;
			mode = _mode;
		}

		@Override
		public byte[] marshall() {
			pushInt64(ctx);
			pushInt64(mode);

			return super.marshall();
		}
	}

	private static class YLEEnableAudioFileVolumeCallback extends YLEBase {
		private long ctx;
		private boolean enable;
		private int interval;

		YLEEnableAudioFileVolumeCallback(long _ctx, boolean _enable, int _interval) {
			event = YYLIVE_AUDIO_FILE_ENABLE_VOLUME_CALLBACK;
			ctx = _ctx;
			enable = _enable;
			interval = _interval;
		}

		@Override
		public byte[] marshall() {
			pushInt64(ctx);
			pushBool(enable);
			pushInt(interval);

			return super.marshall();
		}
	}

	private static class YLEAudioSetExternalProcessor extends YLEBase {
		private long eap;

		YLEAudioSetExternalProcessor(long _eap) {
			event = YYLIVE_AUDIO_SET_EXTERNAL_PROCESSOR;
			this.eap = _eap;
		}

		@Override
		public byte[] marshall() {
			pushInt64(eap);

			return super.marshall();
		}
	}

	private static class YLEEnableAudioPlaySpectrum extends YLEBase {
		private boolean enable;

		YLEEnableAudioPlaySpectrum (boolean enable) {
			event = YYLIVE_AUDIO_ENABLE_AUDIO_PLAY_SPECTRUM;
			this.enable = enable;
		}

		@Override
		public byte[] marshall() {
			pushBool(enable);

			return super.marshall();
		}
	}

	private static class YLESetAudioPlaySpectrumInfo extends YLEBase {
		private int spectrumLen;
		private int notifyIntervalMS;
		YLESetAudioPlaySpectrumInfo(int spectrumLen, int notifyIntervalMS) {
			event = YYLIVE_AUDIO_SET_AUDIO_PLAY_SPECTRUM_INFO;
			this.spectrumLen = spectrumLen;
			this.notifyIntervalMS = notifyIntervalMS;
		}

		@Override
		public byte[] marshall() {
			pushInt(spectrumLen);
			pushInt(notifyIntervalMS);

			return super.marshall();
		}
	}

	private static class YLEEnableCapturePcmDataCallBack extends YLEBase {
		private boolean enable;
		private int sampleRate;
		private int channel;
		YLEEnableCapturePcmDataCallBack(boolean enable, int sampleRate, int channel) {
			event = YYLIVE_AUDIO_ENABLE_CAPTURE_PCM_DATA_CALLBACK;
			this.enable = enable;
			this.sampleRate = sampleRate;
			this.channel = channel;
		}

		@Override
		public byte[] marshall() {
			pushBool(enable);
			pushInt(sampleRate);
			pushInt(channel);

			return super.marshall();
		}
	}

	private static class YLEEnableRenderPcmDataCallBack extends YLEBase {
		private boolean enable;
		private int sampleRate;
		private int channel;
		YLEEnableRenderPcmDataCallBack(boolean enable, int sampleRate, int channel) {
			event = YYLIVE_AUDIO_ENABLE_RENDER_PCM_DATA_CALLBACK;
			this.enable = enable;
			this.sampleRate = sampleRate;
			this.channel = channel;
		}

		@Override
		public byte[] marshall() {
			pushBool(enable);
			pushInt(sampleRate);
			pushInt(channel);

			return super.marshall();
		}
	}

	private static class YLESendUserAppMsgData extends YLEBase {
		private byte[] msgData;

		YLESendUserAppMsgData(byte[] _msgData) {
			event = YYLIVE_SEND_USER_APP_MSG_DATA;
			msgData = _msgData;
		}

		@Override
		public byte[] marshall() {
			pushBytes(msgData);
			return super.marshall();
		}
	}

	private static class YLEEnableAudioDataIndication extends YLEBase {
		private boolean enable;
		YLEEnableAudioDataIndication(boolean enable) {
			event = YYLIVE_AUDIO_ENABLE_AUDIO_DATA_INDICATION;
			this.enable = enable;
		}

		@Override
		public byte[] marshall() {
			pushBool(enable);

			return super.marshall();
		}
	}

	private static class YLESetHttpsBinaryResponse extends YLEBase {
		private String reqUrl;
		private byte[] response;
		private int statusCode;
		private int errCode;
		private int target;

		YLESetHttpsBinaryResponse(String _reqUrl,
								  byte[] _response,
								  int _statusCode,
								  int _errCode,
								  int _target) {
			event = YYLIVE_SET_HTTPS_RESPONSE;
			reqUrl = _reqUrl;
			response = _response;
			statusCode = _statusCode;
			errCode = _errCode;
			target = _target;
		}

		@Override
		public byte[] marshall() {
			pushString16(reqUrl);
			pushBytes(response);
			pushInt(statusCode);
			pushInt(errCode);
			pushInt(target);
			return super.marshall();
		}
	}

	private static class YLESetHttpsTextResponse extends YLEBase {
		private String reqUrl;
		private String response;
		private int statusCode;
		private int errCode;
		private int target;

		YLESetHttpsTextResponse(String _reqUrl,
								String _response,
								int _statusCode,
								int _errCode,
								int _target) {
			event = YYLIVE_SET_HTTPS_RESPONSE;
			reqUrl = _reqUrl;
			response = _response;
			statusCode = _statusCode;
			errCode = _errCode;
			target = _target;
		}

		@Override
		public byte[] marshall() {
			pushString16(reqUrl);
			pushString16(response);
			pushInt(statusCode);
			pushInt(errCode);
			pushInt(target);
			return super.marshall();
		}
	}

	private static class YLESetRecordingAudioFrameParameters extends YLEBase {
		private int sampleRate;
		private int channel;
		private int mode;
		private int samplesPerCall;

		YLESetRecordingAudioFrameParameters(int _sampleRate, int _channel, int _mode,
											int _samplesPerCall) {

			event = YYLIVE_SET_RECORD_AUDIO_PARAMS;
			sampleRate = _sampleRate;
			channel = _channel;
			mode = _mode;
			samplesPerCall = _samplesPerCall;
		}

		@Override
		public byte[] marshall() {
			pushInt(sampleRate);
			pushInt(channel);
			pushInt(mode);
			pushInt(samplesPerCall);
			return super.marshall();
		}

	}

	private static class YLESetPlaybackAudioFrameParameters extends YLEBase {
		private int sampleRate;
		private int channel;
		private int mode;
		private int samplesPerCall;

		YLESetPlaybackAudioFrameParameters(int _sampleRate, int _channel, int _mode,
											int _samplesPerCall) {

			event = YYLIVE_SET_PLAY_AUDIO_PARAMS;
			sampleRate = _sampleRate;
			channel = _channel;
			mode = _mode;
			samplesPerCall = _samplesPerCall;
		}

		@Override
		public byte[] marshall() {
			pushInt(sampleRate);
			pushInt(channel);
			pushInt(mode);
			pushInt(samplesPerCall);
			return super.marshall();
		}

	}
	/********************************* YYLive Events End ******************************************/

	/****************************** YYLive Notifications Begin ************************************/
	private static class YLNBase extends Marshallable {
		Object notification;

		public Object get() {
			return notification;
		}
	}

	private static class YLNPublishStatus extends YLNBase {
		@Override
		public void unmarshall(byte[] buf) {
			super.unmarshall(buf);
			notification = new YYLiveNotification.PublishStatusInfo(popString16(), popInt());
		}
	}

	private static class YLNPublishRunTimeInfo extends YLNBase {
		@Override
		public void unmarshall(byte[] buf) {
			super.unmarshall(buf);
			notification = new YYLiveNotification.PublishRunTimeInfo(popString16(),
					new YYLiveNotification.YYLiveRunTimeInfo(popInt(), popInt(), popInt(),
							popInt(), popInt(), popInt(), popInt(), popInt(), popInt(), popInt()));
		}
	}

	private static class YLNPlayStatus extends YLNBase {
		@Override
		public void unmarshall(byte[] buf) {
			super.unmarshall(buf);

			YYLiveStream stream = new YYLiveStream();
			stream.appId = popInt();
			stream.streamName = popString16();
			stream.speakerUid = popInt();
			stream.bVideo = popBool();
			notification = new YYLiveNotification.PlayStatusInfo(stream, popInt());
		}
	}

	private static class YLNPlayRunTimeInfo extends YLNBase {
		@Override
		public void unmarshall(byte[] buf) {
			super.unmarshall(buf);

			YYLiveStream stream = new YYLiveStream();
			stream.appId = popInt();
			stream.streamName = popString16();
			stream.speakerUid = popInt();
			stream.bVideo = popBool();

			notification = new YYLiveNotification.PlayRunTimeInfo(stream,
					new YYLiveNotification.YYLiveRunTimeInfo(popInt(), popInt(), popInt(),
							popInt(), popInt(), popInt(), popInt(), popInt(), popInt(), popInt()));
		}
	}

	private static class YLNAudioCaptureVolume extends YLNBase{
		@Override
		public void unmarshall(byte[] buf) {
			super.unmarshall(buf);

			notification = new YYLiveNotification.YYAudioCaptureVolume(popInt(), popInt2Long(), popInt());
		}
	}

	private static class YLNAudioVolume extends YLNBase {
		@Override
		public void unmarshall(byte[] buf) {
			super.unmarshall(buf);
			int size = popInt();
			if (size > 0) {
				Map<Long, YYLiveNotification.YYVolumeInfo> volumeInfos = new HashMap<Long, YYLiveNotification.YYVolumeInfo>();
				for (int i = 0; i < size; ++i) {
					long uid = popInt2Long();
					int volume = popInt();
					long pts = popInt2Long();
					int actualSpkSize = popInt();
					if (actualSpkSize > 0) {
						ArrayList<Long> uidList = new ArrayList<>(actualSpkSize);
						for (int k = 0; k < actualSpkSize; ++k) {
							uidList.add(popInt2Long());
						}
						YYLiveNotification.YYVolumeInfo info = new YYLiveNotification.YYVolumeInfo(volume, pts, uidList);
						volumeInfos.put(uid, info);
					} else {
						YYLiveNotification.YYVolumeInfo info = new YYLiveNotification.YYVolumeInfo(volume, pts, null);
						volumeInfos.put(uid, info);
					}
				}
				notification = new YYLiveNotification.AudioVolumeInfo(volumeInfos);
			}
		}
	}

	// app authenticate result
	private static class YLNBizAuthRes extends YLNBase {
		@Override
		public void unmarshall(byte[] buf) {
			super.unmarshall(buf);

			YYLiveStream stream = new YYLiveStream();
			stream.appId = popInt();
			stream.streamName = popString16();
			stream.speakerUid = popInt();
			stream.bVideo = popBool();

			YYLiveGroup group = new YYLiveGroup();
			group.appId = popInt();
			group.groupName = popString16();
			if (group.groupName.isEmpty()) {
				group = null;
			}
			notification = new YYLiveNotification.BizAuthResult(stream, group, popBool(), popInt());
		}
	}

	// sdk auth authenticate result
	private static class YLNSdkAuthRes extends YLNBase {
		@Override
		public void unmarshall(byte[] buf) {
			super.unmarshall(buf);
			notification = new YYLiveNotification.SdkAuthResult(popInt(), popInt(),popInt());
		}
	}

	private static class YLNResolutionChangeInfo extends YLNBase {
		@Override
		public void unmarshall(byte[] buf) {
			super.unmarshall(buf);

			YYLiveStream stream = new YYLiveStream();
			stream.appId = popInt();
			stream.streamName = popString16();
			stream.speakerUid = popInt();
			stream.bVideo = popBool();

			notification = new YYLiveNotification.ResolutionChangeInfo(stream, popInt(), popInt());
		}
	}

	private static class YLNJoinChannelStatus extends YLNBase {
		@Override
		public void unmarshall(byte[] buf) {
			super.unmarshall(buf);
			notification = new YYLiveNotification.JoinChannelStatus(popString16(), popInt());
		}
	}

	private static class YLNAllStreamNotify extends YLNBase {
		@Override
		public void unmarshall(byte[] buf) {
			super.unmarshall(buf);

			int curLine = popInt();
			int appId = popInt();
			String channelId = popString16();
			int reason = popInt();
			Map<Integer, YYLiveStreamLevelInfo> levelMap = new HashMap<Integer, YYLiveStreamLevelInfo>();
			int levelCnt = popInt();
			for (int i = 0; i < levelCnt; ++ i) //level
			{
				int level = (int)popShort();
				YYLiveStreamLevelInfo levelInfo = new YYLiveStreamLevelInfo();
				int lineCnt = popInt();
				for (int j = 0; j < lineCnt; ++ j) // line
				{
					int line = popInt();
					YYLiveStreamLineInfo streamLine = new YYLiveStreamLineInfo();
					int lineSeq = popInt();
					int providerId = popInt();
					int urlId = popInt();
					boolean isCdn = popBool();
					boolean cdnType = popBool();
					int streamCnt = popInt();
					ArrayList<YYLiveStreamInfo> streamList = new ArrayList<YYLiveStreamInfo>();
					for (int k = 0; k < streamCnt; ++ k) // stream
					{
						YYLiveStreamInfo streamInfo = new YYLiveStreamInfo();
						streamInfo.streamName = popString16();
						streamInfo.spkUid = popInt();
						String url = popString16();
						streamInfo.appId = appId;
						int configCnt = popInt();
						Map<Integer, Integer> configMap = new HashMap<Integer, Integer>();
						for (int l = 0; l < configCnt; ++ l)
						{
							int key = popInt();
							int value = popInt();
							configMap.put(key, value);
						}
						streamInfo.streamConfig = configMap;
						streamList.add(streamInfo);
					}
					streamLine.lineSeq = lineSeq;
					streamLine.isCdn = isCdn;
					streamLine.streamInfo = streamList;

					levelInfo.streamLine.put(line, streamLine);
				}
				levelMap.put(level, levelInfo);
			}

			notification = new YYLiveNotification.StreamStatusInfo(curLine, channelId, reason, levelMap);
		}
	}

	private static class YLNRtmpPublishStatus extends YLNBase {
		@Override
		public void unmarshall(byte[] buf) {
			super.unmarshall(buf);
			notification = new YYLiveNotification.RtmpPublishStatus(popInt(), popInt());
		}
	}

// uninstall sdk
	private static class YLNUninstallSdk extends YLNBase
	{
		@Override
		public void unmarshall(byte[] buf)
		{
			super.unmarshall(buf);
			notification = new YYLiveNotification.UninstallSdk();
		}

	}



	//string uid
	private static class YLNStringUid extends YLNBase
	{
		@Override
		public void unmarshall(byte[] buf)
		{
			super.unmarshall(buf);
			notification = new YYLiveNotification.UidInt2String(popInt(), popString16());
		}
	}

	//audio data
	private static class YLNAudioData extends YLNBase
	{
		@Override
		public void unmarshall(byte[] buf)
		{
			super.unmarshall(buf);

			int uid = popInt();
			int duration = popInt();
			int cpt = popInt();
			int pts = popInt();
			byte[] data = popBytes32();

			long longUid = uid & 0x0FFFFFFFFl;

			notification = new YYLiveNotification.AudioDataInfo(longUid, duration, cpt, pts ,data);
		}
	}

	private static class YLNAudioPlaySpectrumData extends YLNBase
	{
		@Override
		public void unmarshall(byte[] buf)
		{
			super.unmarshall(buf);
			byte[] data = popBytes32();

			notification = new YYLiveNotification.AudioPlaySpectrumData(data);
		}
	}

	private static class YLNAudioCapturePcmData extends YLNBase
	{
		@Override
		public void unmarshall(byte[] buf)
		{
			super.unmarshall(buf);
			byte[] data = popBytes32();
			int dataSize = popInt();
			int sampleRate = popInt();
			int channel = popInt();
			notification = new YYLiveNotification.AudioCapturePcmData(data, dataSize, sampleRate, channel);
		}
	}

	private static class YLNAudioRenderPcmData extends YLNBase
	{
		@Override
		public void unmarshall(byte[] buf)
		{
			super.unmarshall(buf);
			byte[] data = popBytes32();
			int dataSize = popInt();
			int duration = popInt();
			int sampleRate = popInt();
			int channel = popInt();
			notification = new YYLiveNotification.AudioRenderPcmData(data, dataSize, duration, sampleRate, channel);
		}
	}

	private static class YLNUserAppMsgData extends YLNBase
	{
		@Override
		public void unmarshall(byte[] buf)
		{
			super.unmarshall(buf);
			String data = popString16();
			long uid = popInt64();

			notification = new YYLiveNotification.UserAppMsgData(data.getBytes(), uid);
		}
	}

	private static class YLNAppMsgDataFailedStatus extends YLNBase
	{
		@Override
		public void unmarshall(byte[] buf)
		{
			super.unmarshall(buf);
			int status = popInt();

			notification = new YYLiveNotification.AppMsgDataFailedStatus(status);
		}
	}


	//publish loss result notify
	private static class YLNPublishLossResult extends YLNBase
	{
		@Override
		public void unmarshall(byte[] buf) {
			super.unmarshall(buf);
			notification = new YYLiveNotification.PublishLossResult(popInt(), popInt());
		}
	}

	//live pub channel
	private static class YLNPublishChannelStatus extends YLNBase
	{
		@Override
		public void unmarshall(byte[] buf) {
			super.unmarshall(buf);

			notification = new YYLiveNotification.PublishChannelStatus(popString16(), popInt());
		}
	}

	private static class YLNPublishChannelStreamInfo extends YLNBase
	{
		@Override
		public void unmarshall(byte[] buf) {
			super.unmarshall(buf);

			int appid = popInt();
			String channelId = popString16();
			ArrayList<YYLiveStream> streams = new ArrayList<YYLiveStream>();
			int streamSize = popInt();
			for (int i = 0; i < streamSize; ++i) {
				YYLiveStream stream = new YYLiveStream();
				String streamName = popString16();
				int configSize = popInt();
				for (int j = 0; j < configSize; ++j) {
					int key = popInt();
					int value = popInt();
					if (key == YYLiveStreamInfo.STREAM_CONFIG_KEY_SPEAKER_UID) {
						stream.speakerUid = value;
					}else if (key == YYLiveStreamInfo.STREAM_CONFIG_KEY_STREAM_TYPE) {
						stream.bVideo = (value == 1);
					}
				}
				stream.appId = appid;
				stream.streamName = streamName;
				streams.add(stream);
			}

			notification = new YYLiveNotification.PublishChannelStreamInfo(channelId, streams);
		}
	}

	private static class YLNInitiateHttpsRequest extends YLNBase
	{
		@Override
		public void unmarshall(byte[] buf) {
			super.unmarshall(buf);
			notification = new YYLiveNotification.InitiateHttpsRequest(popString16(), popInt());
		}
	}

	private static class YLNStreamsNotify extends YLNBase
	{
		@Override
		public void unmarshall(byte[] buf) {
			super.unmarshall(buf);

			int appid = popInt();
			String channelId = popString16();
			ArrayList<YYLiveStream> streams = new ArrayList<YYLiveStream>();
			int streamSize = popInt();
			for (int i = 0; i < streamSize; ++i) {
				YYLiveStream stream = new YYLiveStream();
				String streamName = popString16();
				int configSize = popInt();
				for (int j = 0; j < configSize; ++j) {
					int key = popInt();
					int value = popInt();
					if (key == YYLiveStreamInfo.STREAM_CONFIG_KEY_SPEAKER_UID) {
						stream.speakerUid = value;
					}else if (key == YYLiveStreamInfo.STREAM_CONFIG_KEY_STREAM_TYPE) {
						stream.bVideo = (value == 1);
					}
				}
				stream.appId = appid;
				stream.streamName = streamName;
				streams.add(stream);
			}

			notification = new YYLiveNotification.StreamsNotify(channelId, streams);
		}
	}

	private static class YLNVideoSizeChangeNotify extends YLNBase
    {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);

            long uid = popInt64();
            int width = popInt();
            int height = popInt();

            notification = new YYLiveNotification.OnVideoSizeChange(uid,width,height);
        }
    }

    private static class YLNRenderFirstFrameNotify extends YLNBase
    {
    	@Override
		public void unmarshall(byte[] buf) {
    		super.unmarshall(buf);

    		long userGroupId = popInt64();
    		long streamId = popInt64();
    		long currentTimeMs = popInt64();
    		long firstTimeMs = popInt64();
    		int eatenFrame = popInt();

    		notification = new YYLiveNotification.OnRenderVideoFirstFrame(userGroupId,streamId,currentTimeMs,firstTimeMs,eatenFrame);
		}
    }

	public interface NotificationDispatcher {
		void registerNotificationHandler(Handler handler);
		void unregisterNotificationHandler(Handler handler);
		Object[] collectNotificationHandlers();
	}

	private static int s_audioCaptureVolumeNotificationCount = 0;
	private static int s_audioPlayVolumeNotificationCount = 0;
	private static int s_playRuntimeNotificationCount = 0;
	private static int s_publishRuntimeNotificationCount = 0;

	/* C++ 代码通知回调函数 */
	public static void notificationCallback(int type, byte[] data) {


		s_notificationLock.lock();

		try {
			if (s_notificationDispatcher == null) {
				return;
			}

			YLNBase yln;

			switch (type) {
				case YYLiveNotification.kYYLiveAPINotification_PublishStatus:
					yln = new YLNPublishStatus();
					break;
				case YYLiveNotification.kYYLiveAPINotification_PublishRunTimeInfo:
					yln = new YLNPublishRunTimeInfo();
					break;
				case YYLiveNotification.kYYLiveAPINotification_PlayStatus:
					yln = new YLNPlayStatus();
					break;
				case YYLiveNotification.kYYLiveAPINotification_PlayRunTimeInfo:
					yln = new YLNPlayRunTimeInfo();
					break;
				case YYLiveNotification.kYYLiveAPINotification_AudioCaptureVolume:
					yln = new YLNAudioCaptureVolume();
					break;
				case YYLiveNotification.kYYLiveAPINotification_AudioPlayVolume:
					yln = new YLNAudioVolume();
					break;
				case YYLiveNotification.kYYLiveAPINotification_BizAuthRes:
					yln = new YLNBizAuthRes();
					break;
				case YYLiveNotification.kYYLiveAPINotification_SdkAuthRes:
					yln = new YLNSdkAuthRes();
					break;
				case YYLiveNotification.kYYLiveAPINotification_UninstallSdk:
					yln = new YLNUninstallSdk();
					break;
				case YYLiveNotification.kYYLiveAPINotifioation_StringUid:
					yln = new YLNStringUid();
					break;
				case YYLiveNotification.kYYLiveAPINotification_JoinChannelStatus:
					yln = new YLNJoinChannelStatus();
					break;
				case YYLiveNotification.kYYLiveAPINotification_StreamInfoStatus:
					yln = new YLNAllStreamNotify();
					break;
				case YYLiveNotification.kYYLiveAPINotification_RtmpPublishStatus:
					yln = new YLNRtmpPublishStatus();
					break;
				case YYLiveNotification.kYYLiveAPINotification_ResolutionChangeInfo:
					yln = new YLNResolutionChangeInfo();
					break;
				case YYLiveNotification.kYYLiveAPINotification_AudioPlayData:
					yln = new YLNAudioData();
					break;
                case YYLiveNotification.kYYLiveAPINotification_AudioPlaySpectrumData:
					yln = new YLNAudioPlaySpectrumData();
					break;
				case YYLiveNotification.kYYLiveAPINotification_AudioCapturePcmData:
					yln = new YLNAudioCapturePcmData();
					break;
				case YYLiveNotification.kYYLiveAPINotification_UserAppMsgData:
					yln = new YLNUserAppMsgData();
					break;
				case YYLiveNotification.kYYLiveAPINotification_AppMsgDataFailedStatus:
					yln = new YLNAppMsgDataFailedStatus();
					break;
				case YYLiveNotification.kYYLiveAPINotification_AudioRenderPcmData:
					yln = new YLNAudioRenderPcmData();
					break;

				case YYLiveNotification.kYYLiveAPINotification_PublishLossResult:
					yln = new YLNPublishLossResult();
					break;
				case YYLiveNotification.kYYLiveAPINotification_PublishChannelStatus:
					yln = new YLNPublishChannelStatus();
					break;
				case YYLiveNotification.kYYLiveAPINotification_PublishChannelStreamInfo:
					yln = new YLNPublishChannelStreamInfo();
					break;
				case YYLiveNotification.kYYLiveAPINotification_InitiateHttpsRequest:
					yln = new YLNInitiateHttpsRequest();
					break;
				case YYLiveNotification.kYYLiveAPINotification_StreamsNotify:
					yln = new YLNStreamsNotify();
					break;
                case YYLiveNotification.kYYLiveAPINotification_OnVideoSizeChange:
                    yln = new YLNVideoSizeChangeNotify();
                    break;
				case YYLiveNotification.kYYLiveAPINotification_OnRenderFirstFrame:
					yln = new YLNRenderFirstFrameNotify();
					break;
				default:
					YYLiveLog.warn(YYLiveLog.kLogTagCallback, "unknown notification type %d", type);
					return;
			}

			yln.unmarshall(data);

			//Message msg = Message.obtain();
			//msg.what = type;
			//msg.obj = yln.get();

			// 发送非内部消息到 handler
			if (type < YYLiveNotificationInside.kYYLiveAPINotification_Start_Tag) {
				Object[] handlers = s_notificationDispatcher.collectNotificationHandlers();
				if (handlers != null) {
					for (Object handler : handlers) {
						Message msg = Message.obtain();
						msg.what = type;
						msg.obj = yln.get();

						((Handler) handler).sendMessage(msg);
					}
				}
			} else {
				switch (type) {
					case YYLiveNotificationInside.kYYLiveAPINotification_PublishVideoCfg:
						mPublishVideoCfg = (YYLiveNotificationInside.PublishVideoCfg) (yln.get());
						break;
					default:
						break;
				}
			}


			//通知日志
			switch (type) {
				case YYLiveNotification.kYYLiveAPINotification_PublishStatus: {
					YYLiveNotification.PublishStatusInfo notification =
							(YYLiveNotification.PublishStatusInfo) yln.get();
					YYLiveLog.release(YYLiveLog.kLogTagCallback,
							"kYYLiveAPINotification_PublishStatus name=%s, status=%d",
							notification.getStreamName(), notification.getStatus());
					break;
				}
				case YYLiveNotification.kYYLiveAPINotification_PublishRunTimeInfo: {
					if ((s_publishRuntimeNotificationCount % 10) == 0) {
						YYLiveNotification.PublishRunTimeInfo notification =
								(YYLiveNotification.PublishRunTimeInfo) yln.get();
						YYLiveLog.release(YYLiveLog.kLogTagCallback,
								"kYYLiveAPINotification_PublishRunTimeInfo name=%s, fps=%d, " +
										"bitrate=%d, audioBitrate=%d, resolution=%dx%d, realBitrate=%d, count=%d",
								notification.getStreamName(), notification.getInfo().getFps(),
								notification.getInfo().getBitrate(), notification.getInfo().getAudioBitrate(),
								notification.getInfo().getWidth(), notification.getInfo().getHeight(), notification.getInfo().getPublishRealBitrate(),
								s_publishRuntimeNotificationCount);
					}
					++s_publishRuntimeNotificationCount;
					break;
				}
				case YYLiveNotification.kYYLiveAPINotification_PlayStatus: {
					YYLiveNotification.PlayStatusInfo notification =
							(YYLiveNotification.PlayStatusInfo) yln.get();
					YYLiveLog.release(YYLiveLog.kLogTagCallback,
							"kYYLiveAPINotification_PlayStatus name=%s, bVideo=%b, speaker=%d, status=%d",
							notification.getStream().streamName, notification.getStream().bVideo,
							notification.getStream().speakerUid, notification.getStatus());
					break;
				}
				case YYLiveNotification.kYYLiveAPINotification_PlayRunTimeInfo: {
					if ((s_playRuntimeNotificationCount % 10) == 0) {
						YYLiveNotification.PlayRunTimeInfo notification =
								(YYLiveNotification.PlayRunTimeInfo) yln.get();
						YYLiveLog.release(YYLiveLog.kLogTagCallback,
								"kYYLiveAPINotification_PlayRunTimeInfo name=%s, bVideo=%b, speaker=%d," +
										"fps=%d, bitrate=%d, audioBitrate=%d, resolution=%dx%d, count=%d",
								notification.getStream().streamName, notification.getStream().bVideo,
								notification.getStream().speakerUid, notification.getInfo().getFps(),
								notification.getInfo().getBitrate(), notification.getInfo().getAudioBitrate(),
								notification.getInfo().getWidth(), notification.getInfo().getHeight(),
								s_playRuntimeNotificationCount);
					}
					++s_playRuntimeNotificationCount;
					break;
				}
				case YYLiveNotification.kYYLiveAPINotification_AudioCaptureVolume: {
					if ((s_audioCaptureVolumeNotificationCount % 50) == 0) {
						YYLiveNotification.YYAudioCaptureVolume notification =
								(YYLiveNotification.YYAudioCaptureVolume) yln.get();

						YYLiveLog.release(YYLiveLog.kLogTagCallback,
								"kYYLiveAPINotification_AudioCaptureVolume volume=%d, cpt=%d, mic=%d, count=%d",
								notification.mVolume, notification.mCpt, notification.mMicVolume, s_audioCaptureVolumeNotificationCount);
					}
					++s_audioCaptureVolumeNotificationCount;
					break;
				}
				case YYLiveNotification.kYYLiveAPINotification_AudioPlayVolume: {
					if ((s_audioPlayVolumeNotificationCount % 50) == 0) {
						YYLiveNotification.AudioVolumeInfo notification =
								(YYLiveNotification.AudioVolumeInfo) yln.get();
						Map<Long, YYLiveNotification.YYVolumeInfo> volumeInfos = notification.getVolumeInfos();
						int index = 0;
						for (Map.Entry<Long, YYLiveNotification.YYVolumeInfo> entry : volumeInfos.entrySet()) {
							++index;
							YYLiveLog.release(YYLiveLog.kLogTagCallback,
									"kYYLiveAPINotification_AudioPlayVolume [%d] volume=%d, speakers=%s, count=%d",
									index, entry.getValue().mVolume,
									(entry.getValue().mActualSpeakerUidList != null) ? entry.getValue().mActualSpeakerUidList.toString() : "null",
									s_audioPlayVolumeNotificationCount);
						}
					}
					++s_audioPlayVolumeNotificationCount;
					break;
				}
				case YYLiveNotification.kYYLiveAPINotification_BizAuthRes: {
					YYLiveNotification.BizAuthResult notification =
							(YYLiveNotification.BizAuthResult) yln.get();
					YYLiveLog.release(YYLiveLog.kLogTagCallback,
							"kYYLiveAPINotification_BizAuthRes: name=%s, group=%s, bPublish=%b, bizAuthResult=%d",
							(notification.getAuthStream() != null) ? notification.getAuthStream().streamName : "null",
							(notification.getAuthGroup() != null) ? notification.getAuthGroup().groupName : "null",
							notification.isPublishAuth(), notification.getBizAuthResult());
					break;
				}
				case YYLiveNotification.kYYLiveAPINotification_SdkAuthRes: {
					YYLiveNotification.SdkAuthResult notification = (YYLiveNotification.SdkAuthResult) yln.get();
					YYLiveLog.info(YYLiveLog.kLogTagCallback,
							"kYYLiveAPINotification_SdkAuthRes: appId=%d, uid=%d, sdkAuthRes=%d",
							notification.getAppId(), notification.getUid(), notification.getSdkAuthResult());
					break;
				}
				case YYLiveNotification.kYYLiveAPINotification_UninstallSdk: {
					YYLiveLog.info(YYLiveLog.kLogTagCallback, "YYLiveNotification.UninstallSdk");
					break;
				}
				case YYLiveNotification.kYYLiveAPINotifioation_StringUid: {
					YYLiveNotification.UidInt2String notification = (YYLiveNotification.UidInt2String) yln.get();
					YYLiveLog.release(YYLiveLog.kLogTagCallback,
							"kYYLiveAPINotifioation_StringUid: uid=%d, strUid=%s",
							notification.getUidInt(), notification.getUidString());
					break;
				}
				case YYLiveNotification.kYYLiveAPINotification_ResolutionChangeInfo: {
					YYLiveNotification.ResolutionChangeInfo notification = (YYLiveNotification.ResolutionChangeInfo) yln.get();
					YYLiveLog.release(YYLiveLog.kLogTagCallback,
							"kYYLiveAPINotification_ResolutionChangeInfo: name=%s, width=%d, height=%d",
							notification.getStream().streamName, notification.getWidth(), notification.getHeight());
					break;
				}
				case YYLiveNotification.kYYLiveAPINotification_JoinChannelStatus: {
					YYLiveLog.release(YYLiveLog.kLogTagCallback, "kYYLiveAPINotification_JoinChannelStatus");
					break;
				}
				case YYLiveNotification.kYYLiveAPINotification_StreamInfoStatus: {
					YYLiveLog.release(YYLiveLog.kLogTagCallback, "kYYLiveAPINotification_StreamInfoStatus");
					break;
				}
				case YYLiveNotification.kYYLiveAPINotification_RtmpPublishStatus: {
					YYLiveNotification.RtmpPublishStatus notification =
							(YYLiveNotification.RtmpPublishStatus) yln.get();
					YYLiveLog.release(YYLiveLog.kLogTagCallback,
							"kYYLiveAPINotification_RtmpPublishStatus: appid=%d, status=%d",
							notification.getAppid(), notification.getStatus());
					break;
				}
				case YYLiveNotification.kYYLiveAPINotification_AudioPlayData: {
					//todo log
					break;
				}
				case YYLiveNotification.kYYLiveAPINotification_AudioPlaySpectrumData: {
					//todo log
					break;
				}
				case YYLiveNotification.kYYLiveAPINotification_AudioCapturePcmData: {
					//todo log
					break;
				}
				case YYLiveNotification.kYYLiveAPINotification_AudioRenderPcmData:{
					//todo log
					break;
				}
				case YYLiveNotification.kYYLiveAPINotification_UserAppMsgData: {
					YYLiveNotification.UserAppMsgData notification =
							(YYLiveNotification.UserAppMsgData) yln.get();
					YYLiveLog.release(YYLiveLog.kLogTagCallback,
							"kYYLiveAPINotification_UserAppMsgData: uid %d MsgSize %d",
							notification.getUid(), notification.getData().length);
						break;
				}
				case YYLiveNotification.kYYLiveAPINotification_AppMsgDataFailedStatus:{
					YYLiveNotification.AppMsgDataFailedStatus notification =
							(YYLiveNotification.AppMsgDataFailedStatus) yln.get();
					YYLiveLog.release(YYLiveLog.kLogTagCallback,
							"kYYLiveAPINotification_AppMsgDataFailedStatus: status:%d",
							notification.getFailedStatus());
					break;
				}
				case YYLiveNotification.kYYLiveAPINotification_PublishLossResult: {
					YYLiveNotification.PublishLossResult notification =
							(YYLiveNotification.PublishLossResult)yln.get();
					YYLiveLog.info(YYLiveLog.kLogTagCallback,
							"kYYLiveAPINotification_PublishLossResult: appid=%d, result=%d",
							notification.getAppid(), notification.getResult());
					break;
				}
				case YYLiveNotification.kYYLiveAPINotification_PublishChannelStatus: {
					YYLiveNotification.PublishChannelStatus notification =
							(YYLiveNotification.PublishChannelStatus)yln.get();
					YYLiveLog.info(YYLiveLog.kLogTagCallback,
							"kYYLiveAPINotification_PublishChannelStatus: channelId=%s, status=%d",
							 notification.getChannelId(), notification.getStatus());
					break;
				}
				case YYLiveNotification.kYYLiveAPINotification_PublishChannelStreamInfo: {
					YYLiveNotification.PublishChannelStreamInfo notification =
							(YYLiveNotification.PublishChannelStreamInfo)yln.get();
					YYLiveLog.info(YYLiveLog.kLogTagCallback,
							"kYYLiveAPINotification_PublishChannelStreamInfo: channelId=%s , streams size=%d",
							 notification.getChannelId(), notification.getStreams().size());
					break;
				}
				case YYLiveNotification.kYYLiveAPINotification_StreamsNotify:{
					YYLiveNotification.StreamsNotify notification =
							(YYLiveNotification.StreamsNotify)yln.get();
					YYLiveLog.info(YYLiveLog.kLogTagCallback,
							"kYYLiveAPINotification_StreamsNotify: channelId=%s , streams size=%d",
							notification.getChannelId(), notification.getStreams().size());
					break;
				}

				case YYLiveNotification.kYYLiveAPINotification_OnVideoSizeChange: {
					YYLiveNotification.OnVideoSizeChange notification = (YYLiveNotification.OnVideoSizeChange) yln.get();
					YYLiveLog.info(YYLiveLog.kLogTagCallback,
							"kYYLiveAPINotification_OnVideoSizeChange: uid=%d , width=%d height=%d",
							notification.getUid(),notification.getWidth(),notification.getHeight());
					break;
				}
				case YYLiveNotification.kYYLiveAPINotification_OnRenderFirstFrame: {
					YYLiveNotification.OnRenderVideoFirstFrame notification = (YYLiveNotification.OnRenderVideoFirstFrame) yln.get();
					YYLiveLog.info(YYLiveLog.kLogTagCallback,
							"kYYLiveAPINotification_OnRenderFirstFrame: userGroupId=%d streamId=%d currentTimeMs=%d firstTimeMs=%d eatenFrame=%d",
							notification.getUserGroupId(),notification.getStreamId(),notification.getCurrentTimeMs(),notification.getFirstTimeMs(),notification.getEatenFrame());
					break;
				}
				default: {
					YYLiveLog.warn(YYLiveLog.kLogTagCallback, "unknown notification type=%d", type);
					break;
				}
			}
		} finally {
			s_notificationLock.unlock();
		}
	}

	/******************************* YYLive Notifications End *************************************/

	/* C++ 代码日志回调 */
	public static void logCallback(int level, byte[] tag, byte[] msg) {
		if (tag == null || msg == null || s_logCallback == null) {
			return;
		}
		s_logCallback.onYYLogWithLevel(level, new String(tag), new String(msg));
	}

	public static void audioFilePlayCallback(Object obj, int event) {
		if (obj == null) {
			return;
		}
		YYLiveAudioFilePlayer player = (YYLiveAudioFilePlayer)obj;
		player.onPlayEvent(event);
	}

	public static void audioFilePlayVolumeCallback(Object obj, int volume, int currentMs, int totalMs){
		if (obj == null){
			return;
		}

		YYLiveAudioFilePlayer player = (YYLiveAudioFilePlayer)obj;
		player.onAudioFileVolume(volume, currentMs, totalMs);
	}

	/* C++ GSLB DNS 回调 */
	public static void dnsSetPreResolveHosts(byte[] msg) {
		if (msg == null || mGslbMethod == null) {
			return;
		}
		mGslbMethod.dnsSetPreResolveHosts(new String(msg));
	}

	public static byte[] dnsGetByNameWithHost(byte[] msg) {
		String ret = new String();
		if (msg == null || mGslbMethod == null) {
			return ret.getBytes();
		}
		return mGslbMethod.dnsGetByNameWithHost(new String(msg));
	}
}
