package com.yy.yylivesdk4cloud.helper;

import com.yy.gslbsdk.DnsResultInfo;
import com.yy.gslbsdk.GslbEvent;
import com.yy.gslbsdk.HttpDnsService;
import android.content.Context;
import android.util.Log;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GSLBMethod {
    private final static String TAG = "GSLBMethod";
    private HttpDnsService mService = null;

    public void initService(Context context)
    {
        mService = HttpDnsService.getService(context, "60345f3e-d0ca-4f0b-bcef-5cb3862f12a6", null, null, null);
    }

    public void destroyService()
    {
        HttpDnsService.destroyService();
		mService = null;
    }

    public byte[] dnsGetByNameWithHost(String host) {
        String ret = new String();
        if (mService == null) {
            YYLiveLog.warn(TAG, "dnsGetByNameWithHost GSLB service not init");
            return ret.getBytes();
        }
        YYLiveLog.info(TAG, "dnsGetByNameWithHost host=%s", host);

        DnsResultInfo res = mService.getIpsByHost(host);
        if(res.mErrorCode == 0) {
            ret += "success|";
            for(String ip : res.mIps) {
                ret += ip +",";
            }
        } else {
            ret += "fail|"+res.mErrorCode;
        }
        YYLiveLog.info(TAG, "dnsGetByNameWithHost ret=%s", ret);
        return ret.getBytes();
    }

    public void dnsSetPreResolveHosts(String hosts)
    {
        if (mService == null) {
            YYLiveLog.warn(TAG, "dnsSetPreResolveHosts GSLB service not init");
            return;
        }

        String[] hostArray = hosts.split("\\|");
        List<String> hostList = Arrays.asList(hostArray);
        mService.setPreResolveHosts(new ArrayList<String>(hostList));
        YYLiveLog.info(TAG, "dnsSetPreResolveHosts host=%s", hosts);
    }
}
