package com.yy.yylivesdk4cloud.audio;

import com.yy.yylivesdk4cloud.YYLiveAudioCapture;
import com.yy.yylivesdk4cloud.YYLiveDefaultMic;
import com.yy.yylivesdk4cloud.YYLivePublisher;

/**
 * Created by xiaojun on 2018/4/4.
 * Copyright (c) 2017 YY Inc. All rights reserved.
 */
public class YYLiveAudioCaptureProxyImp {

	static boolean isDefaultMic(final Object obj) {
		return (obj instanceof YYLiveDefaultMic);
	}

	static boolean isNeedMicData(final Object obj) {
		return isDefaultMic(obj) && ((YYLiveDefaultMic) obj).getMicDataCallback() != null;
	}

	static void startCapture(final long ownerPtr, final long capturePtr, final Object obj) {
		((YYLiveAudioCapture)obj).startCapture(new YYLivePublisher.IAudioPublisher() {
			@Override
			public void pushAudioData(byte[] samples, long cts) {
				pushCaptureData(ownerPtr, capturePtr, samples, cts);
			}
		});
	}

	static void stopCapture(final Object obj) {
		((YYLiveAudioCapture)obj).stopCapture();
	}

	static int getSampleRate(final Object obj) {
		return ((YYLiveAudioCapture)obj).getSampleRate();
	}

	static int getChannels(final Object obj) {
		return ((YYLiveAudioCapture)obj).getChannels();
	}

	static int getBitDepth(final Object obj) {
		return ((YYLiveAudioCapture)obj).getBitDepth();
	}

	static void onCaptureData(final Object obj,
							  byte[] audioSamples,
							  int nBytesPerSample,
							  boolean bActiveAudio) {
		// only inner microphone need this
		if (!isDefaultMic(obj)) {
			return;
		}
		YYLiveDefaultMic.IYYLiveDefaultMicDataCallback callback =
				((YYLiveDefaultMic)obj).getMicDataCallback();
		if (callback != null) {
			callback.onAudioDataCallback(audioSamples, bActiveAudio);
		}
	}

	private static native void pushCaptureData(long ownerPtr,
											   long capture,
											   byte[] sampleData,
											   long captureStamp);

}
