package com.yy.yylivesdk4cloud;

import android.content.Context;
import android.util.Log;

import com.yy.platform.baseservice.ConstCode;
import com.yy.platform.baseservice.IRPCChannel;
import com.yy.platform.baseservice.YYServiceCore;
import com.yy.platform.baseservice.IChannel;
import com.yy.platform.baseservice.IChannelListener;
import com.yy.platform.baseservice.profile.ChannelProfile;
import com.yy.platform.baseservice.profile.LogProfile;
import com.yy.platform.baseservice.profile.ServiceProfileFactory;
import com.yy.platform.baseservice.task.BroadSubOrUnSubTask;
import com.yy.platform.baseservice.task.RPCTask;
import com.yy.platform.baseservice.utils.UserGroupType;
import com.yy.yylivesdk4cloud.helper.Marshallable;
import com.yy.yylivesdk4cloud.helper.YYLiveLog;
import com.yy.yylivesdk4cloud.helper.YYLiveNative;

import java.util.ArrayList;
import java.util.Arrays;

import static com.yy.yylivesdk4cloud.YYLiveNotification.kYYLiveAPINotification_PublishChannelStreamInfo;


public class YYLiveServiceChannel implements IChannelListener.IServiceBroadcastNotify, IRPCChannel.RPCCallback<BroadSubOrUnSubTask.ResponseParam>{
    private IChannel mServiceChannel;
    private int mServiceChannelStatus = 0;
    private ArrayList<UserGroupType> mGrps = new ArrayList<UserGroupType>();
    private long mAppid = 0;


    public void init(Context appContext, long appid){
        //初始化Service通道
        mAppid = appid;
        mServiceChannel = YYServiceCore.init(appContext, appid,"",
                new ServiceProfileFactory() {
                    @Override
                    public LogProfile logProfile() {
                        return new LogProfile() {
                            @Override
                            public ILog getLog() {
                                return new ILog() {
                                    @Override
                                    public void outputLog(String log) {
                                        YYLiveLog.error(YYLiveLog.kLogTagCall, log);
                                    }
                                };
                            }
                            @Override
                            public String logPath() {
                                return null;
                            }

                            @Override
                            public boolean isLogCat() {
                                return false;
                            }
                        };
                    }
                    @Override
                    public ChannelProfile channelProfile() {
                        return null;
                    }

                },
                new IChannelListener.IChannelStatusNotify() {
                    @Override
                    public void onStatus(int status) {
                        mServiceChannelStatus = status;
                        YYLiveLog.error(YYLiveLog.kLogTagCall, "YYLiveServiceChannel  init status =  %d", status);
                    }
                });
    }

    public int getServiceChannelStatus(){
        return mServiceChannelStatus;
    }

    public void registBroadcastListener(){
        YYLiveLog.error(YYLiveLog.kLogTagCall, "YYLiveServiceChannel registBroadcastListener");
        mServiceChannel.registBroadcastListener(this);
    }

    public void unregistBroadcastListener(){
        YYLiveLog.error(YYLiveLog.kLogTagCall, "YYLiveServiceChannel unregistBroadcastListener");
        mServiceChannel.unregistBroadcastListener(this);
    }

    public int subscribeBroadcast(String channelId, String uid){
        RPCTask.RequestParam requestParam = new RPCTask.RequestParam("", "svcLog", uid, "".getBytes(),"",null,null,null );


        mServiceChannel.rpcCall(requestParam, null, new IRPCChannel.RPCCallback<RPCTask.ResponseParam>(){
            @Override
            public void onSuccess(int requestId, RPCTask.ResponseParam response) {

            }
            @Override
            public void onFail(int requestId, int sdkResCode,int srvResCode, Exception e) {

            }
        });

        String strAppid = Long.toString(mAppid);
        String hashValue = strAppid + "-" + channelId;
        int hashChan = hashString(hashValue);
        UserGroupType  groupTypes = new UserGroupType(2147483686l, toUnsigned(hashChan));
        mGrps.add(groupTypes);
        YYLiveLog.error(YYLiveLog.kLogTagCall, "YYLiveServiceChannel subscribeBroadcast channelid = %s, hashchanid = %d , gid = %d", channelId, hashChan, groupTypes.mGroupId);
        return mServiceChannel.subscribeBroadcast(mGrps, this);
    }

    public int unSubscribeBroadcast(){
        YYLiveLog.error(YYLiveLog.kLogTagCall, "YYLiveServiceChannel unSubscribeBroadcast");
        return mServiceChannel.unSubscribeBroadcast(mGrps, this);
    }

    public void onBroadCast(long uid, long grpType, long grpId, String serviceName,String functionName, String protoType,byte[] data)
    {
        if (mGrps.get(0).mGroupId == grpId && mGrps.get(0).mGroupType == grpType){
            if (serviceName != null && serviceName.length() != 0 && functionName != null && functionName.length() != 0 && data.length != 0) {
                YYLiveNative.resolveServiceData(String.valueOf(uid), Integer.parseInt(functionName), data);
            }
        }
    }

    public void onSuccess(int requestId,BroadSubOrUnSubTask.ResponseParam response)
    {
        YYLiveLog.error(YYLiveLog.kLogTagCall, "YYLiveServiceChannel registBroadcastListener Success mResCode =  %d", response.mResCode);
    }

    public void onFail(int requestId,int sdkResCode, int srvResCode, Exception e)
    {
        YYLiveLog.error(YYLiveLog.kLogTagCall, "YYLiveServiceChannel registBroadcastListener Fail requestId = %d sdkResCode = %d srvResCode =  %d", requestId, sdkResCode, srvResCode);
    }

    private long toUnsigned(int s) {
        return s&0xffffffffl;
    }
    private int hashString(String channelId) {
        int lHash = 0xf1e2d3c4;
        for (int i = 0; i < channelId.length(); ++i){
            char c = channelId.charAt(i);
            lHash <<= 1;
            lHash += c;
        }
        return lHash;
    }
}
