package com.yy.yylivesdk4cloud;

import java.util.ArrayList;

public interface YYLiveRtcEventHandler {

    /**
     * sdk错误信息回调(error定义待定)
     * @param error
     */
    public void onError(int error);

    /**
     * 加入频道回调
     * @param channel
     * @param uid
     * @param elapsed 参数功能未实现
     */
    public void onJoinChannelSuccess(String channel, String uid, int elapsed);



    /**
     * 离开频道回调
     * @param status 功能暂未实现
     */
    public void onLeaveChannel(YYLiveRtcEventHandler.RtcStats status);

    /**
     * 业务鉴权结果
      */
    public void onBizAuthResult(boolean bPublish, int result);

    /**
     * sdk鉴权结果
     * @param result
     */
    public void onSdkAuthResult(int result);

    /**
     * 说话声音音量提示回调
     * @param speakers 用户音量和采集时间戳
     * @param totalVolume (混音后的)总音量
     * 默认关闭，开关：enableAudioVolumeIndication
     */
    public void onAudioVolumeIndication(YYLiveRtcEventHandler.AudioVolumeInfo[] speakers, int totalVolume);

    /**
     * 采集音量回调
     * @param totalVolume 上行音量能量值[0-100]
     * @param cpt 采集时间戳
     * @param micVolume 仅麦克风采集的音量能量值[0-100]
     * 默认关闭，开关：enableCaptureVolumeIndication
     */
    public void onCaptureVolumeIndication(int totalVolume, int cpt, int micVolume);

    /**
     * 声网对标接口，功能暂未实现
     * @param uid
     * @param quality
     * @param delay
     * @param lost
     */
    public void onAudioQuality(String uid, int quality, short delay, short lost);

    /**
     * 声网对标接口，功能暂未实现
     */
    public void onConnectionLost();

    /**
     * 声网对标接口，功能暂未实现
     */
    public void onConnectionInterrupted();

    /**
     * 声网对标接口，功能暂未实现
     * @param routing
     */
    public void onAudioRouteChanged(int routing);

    /**
     * 音频播放数据回调
     * @param data
     * @param data 解码前数据
     * @param cpt 采集时间戳
     * @param pts 播放时间戳
     * @param uid 用户id
     * @param duration 时长
     * 默认关闭，开关：enableAudioDataIndication
     */
    public void onAudioPlayData(byte[] data, long cpt, long pts, String uid, long duration);


    /**
     * 音频播放频谱数据回调
     * @param data 数值范围[0-100]
     * 默认关闭，开关：enableAudioPlaySpectrum
     */
    public void onAudioPlaySpectrumData(byte[] data);

    /**
     * 音频采集数据回调
     * @param data 采集的pcm数据
     * @param dataSize 数据大小
     * @param sampleRate 数据的采样率
     * @param channel 数据的声道数
     * 默认关闭，开关：enableCapturePcmDataCallBack
     */
    public void onAudioCapturePcmData(byte[] data, int dataSize, int sampleRate, int channel);

    /**
     * 音频渲染数据回调
     * @param data 采集的pcm数据
     * @param dataSize 数据大小
     * @param sampleRate 数据的采样率
     * @param channel 数据的声道数
     * @param duration 数据时长 单位：ms
     * 默认关闭，开关：enableRenderPcmDataCallBack
     */
    public void onAudioRenderPcmData(byte[] data, int dataSize, long duration, int sampleRate, int channel);

    /**
     *  接收到的透传协议消息回调
     *  @param data 透传消息
     *  @param uid 发该消息的uid
     */
    public void onRecvUserAppMsgData(byte[] data, String uid);

    /**
     * 透传协议发送失败状态回调
     *  @param status 失败状态(1-频率太高 2-发送数据太大 3-未成功开播)
     *  目前规定透传频率2次/s,发送数据大小限制在<=200Byte
     */
    public void onSendAppMsgDataFailedStatus(int status);

    public void didAudioMuted(String uid, boolean muted);

    public void didVideoMuted(String uid, boolean muted);

    public void onFirstRemoteVideoFrame(long uid, int width, int height, int elapsed);

    public void onVideoSizeChanged(long uid, int width, int height, int rotation);

    public static class AudioVolumeInfo {
        public String uid;
        public int volume;
        public int pts;

        public AudioVolumeInfo() {
        }
    }

    public static class RtcStats{
        public int temp;
        public RtcStats(){
        }
    }
}
