package com.yy.yylivesdk4cloud;

/**
 * Created by zhangfei on 2018/06/20.
 */

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import android.view.SurfaceView;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.Matcher;
import java.math.BigDecimal;

import com.yy.yylivesdk4cloud.audio.IAudioFrameObserver;
import com.yy.yylivesdk4cloud.helper.YYLiveHttpsRequestHandler;
import com.yy.yylivesdk4cloud.helper.YYLiveLog;
import com.yy.yylivesdk4cloud.helper.YYLiveNative;

import static com.yy.yylivesdk4cloud.YYConstant.YYLiveRtcProfile.YR_PROFILE_DEFAULT;
import static com.yy.yylivesdk4cloud.YYConstant.YYLiveRtcProfile.YR_PROFILE_ONLY_AUDIO;

/**
 * YY音频简易接入SDK
 * 所有接口，int型返回值，未做特殊说明，0表示成功，<0 error
 */

public class YYLiveRtcEngine {
        private final static String TAG = "RtcEngine";
        private static boolean mIsInited = false;

        private static class NotificationHandler extends Handler {
            private final WeakReference<YYLiveRtcEngine> mRtcEngine;

            public NotificationHandler(YYLiveRtcEngine rtc) {
                mRtcEngine = new WeakReference<YYLiveRtcEngine>(rtc);
            }

            public NotificationHandler(YYLiveRtcEngine rtc, Looper loop) {
                super(loop);

                mRtcEngine = new WeakReference<YYLiveRtcEngine>(rtc);
            }

            @Override
            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case YYLiveNotification.kYYLiveAPINotification_PublishStatus: {
                        YYLiveNotification.PublishStatusInfo info = (YYLiveNotification.PublishStatusInfo) msg.obj;
                        YYLiveLog.release(TAG, String.format("YYLiveNotification.PublishStatusInfo stream=%s status=%d",
                                info.getStreamName(), info.getStatus()));
                        break;
                    }
                    case YYLiveNotification.kYYLiveAPINotification_PublishRunTimeInfo: {
                        YYLiveNotification.PublishRunTimeInfo info = (YYLiveNotification.PublishRunTimeInfo) msg.obj;
                        YYLiveLog.info(TAG, String.format("YYLiveNotification.PublishRunTimeInfo stream=%s fps=%d " +
                                        "bitrate=%d audioBitrate=%d resolution=%dx%d", info.getStreamName(),
                                info.getInfo().getFps(), info.getInfo().getBitrate(), info.getInfo().getAudioBitrate(),
                                info.getInfo().getWidth(), info.getInfo().getHeight()));
                        break;
                    }
                    case YYLiveNotification.kYYLiveAPINotification_PlayStatus: {
                        YYLiveNotification.PlayStatusInfo info = (YYLiveNotification.PlayStatusInfo) msg.obj;
                        YYLiveLog.release(TAG, String.format("YYLiveNotification.PlayStatusInfo stream=%s status=%d",
                                info.getStream().streamName, info.getStatus()));

                        switch (info.getStatus()) {
                            case YYLiveNotification.PlayStatusInfo.YYLIVE_PLAYSTATUS_PARAM_ERROR: {

                            }
                            break;
                            case YYLiveNotification.PlayStatusInfo.YYLIVE_PLAYSTATUS_SUBSCRIBE_SUCCUSS: {
                                if (mRtcEventHandler != null && mRtcEngine.get().getIsThunder()) {
                                    mRtcEngine.get().isJoinChannel = true;
                                    mRtcEventHandler.onJoinChannelSuccess(mRtcEngine.get().getChannelName(),
                                            mRtcEngine.get().getMyUid(), 0);
                                }
                            }
                            break;
                            case YYLiveNotification.PlayStatusInfo.YYLIVE_PLAYSTATUS_SUBSCRIBE_FAILED: {

                            }
                            break;
                            case YYLiveNotification.PlayStatusInfo.YYLIVE_PLAYSTATUS_SUBSCRIBE_CANCEL: {
                                if (mRtcEventHandler != null && mRtcEngine.get().getIsThunder()) {
                                    YYLiveRtcEventHandler.RtcStats status = new YYLiveRtcEventHandler.RtcStats();
                                    mRtcEventHandler.onLeaveChannel(status);
                                }
                            }
                            break;
                            case YYLiveNotification.PlayStatusInfo.YYLIVE_PLAYSTATUS_STREAM_ARRIVE: {

                            }
                            break;
                            case YYLiveNotification.PlayStatusInfo.YYLIVE_PLAYSTATUS_STREAM_RENDERED: {
                                long renderTime = System.currentTimeMillis();
                                YYLiveStream playStream = info.getStream();
                                YYLiveStream findStream = YYLiveAPI.sharedInstance().getPlayer().getSubscribeStreamByUid(playStream.speakerUid);

                                if(findStream!=null) {
                                    int elapseTime = (int)(renderTime - findStream.startSubscribeTime);
                                    mRtcEventHandler.onFirstRemoteVideoFrame(findStream.speakerUid,findStream.width,findStream.height,elapseTime);
                                }

                            }
                            break;
                            case YYLiveNotification.PlayStatusInfo.YYLIVE_PLAYSTATUS_STREAM_STOP: {

                            }
                            break;
                        }

                        break;
                    }
                    case YYLiveNotification.kYYLiveAPINotification_PlayRunTimeInfo: {
                        //                    YYLiveNotification.PlayRunTimeInfo info = (YYLiveNotification.PlayRunTimeInfo) msg.obj;
                        //                    YYLiveLog.info(TAG, String.format("YYLiveNotification.PlayRunTimeInfo stream=%s fps=%d " +
                        //                                    "bitrate=%d audioBitrate=%d resolution=%dx%d", info.getStream().streamName,
                        //                            info.getInfo().getFps(), info.getInfo().getBitrate(), info.getInfo().getAudioBitrate(),
                        //                            info.getInfo().getWidth(), info.getInfo().getHeight()));
                        break;
                    }
                    case YYLiveNotification.kYYLiveAPINotification_AudioCaptureVolume: {
                        YYLiveNotification.YYAudioCaptureVolume info = (YYLiveNotification.YYAudioCaptureVolume) msg.obj;

                        if (mRtcEventHandler != null) {
                            mRtcEventHandler.onCaptureVolumeIndication(info.mVolume, (int) info.mCpt, info.mMicVolume);
                        }
                        break;
                    }
                    case YYLiveNotification.kYYLiveAPINotification_AudioPlayVolume: {
                        YYLiveNotification.AudioVolumeInfo info = (YYLiveNotification.AudioVolumeInfo) msg.obj;
                        if (info.getVolumeInfos() != null) {
                            int maxVol = 0;
                            int index = 0;
                            ArrayList<YYLiveRtcEventHandler.AudioVolumeInfo> volInfos = new ArrayList<>();
                            for (Map.Entry<Long, YYLiveNotification.YYVolumeInfo> entry : info.getVolumeInfos().entrySet()) {
                                if (entry.getValue().mActualSpeakerUidList == null || entry.getValue().mActualSpeakerUidList.isEmpty()) {
                                    continue;
                                }
                                for (long uid : entry.getValue().mActualSpeakerUidList) {
                                    YYLiveRtcEventHandler.AudioVolumeInfo volInfo = new YYLiveRtcEventHandler.AudioVolumeInfo();
                                    if (mRtcEngine.get().mIs32bitUid) {
                                        volInfo.uid = Long.toString(uid);
                                    } else {
                                        volInfo.uid = mRtcEngine.get().getStringUid((int) uid);
                                        if (volInfo.uid == null || volInfo.uid.isEmpty()) {
                                            continue;
                                        }
                                    }
                                    volInfo.volume = entry.getValue().mVolume;
                                    volInfo.pts = (int) entry.getValue().mPts;
                                    if (maxVol < volInfo.volume) {
                                        maxVol = volInfo.volume;
                                    }
                                    ++index;
                                    volInfos.add(volInfo);
                                    if ((s_playVolumeNotifyCount % 200) == 0) {
                                        YYLiveLog.release(TAG, String.format("YYLiveNotification.AudioPlayVolume, [%d] uid %s, volume %d",
                                                index, volInfo.uid.toString(), volInfo.volume));
                                    }
                                }
                            }

                            int volSize = volInfos.size();
                            if (volSize > 0) {
                                YYLiveRtcEventHandler.AudioVolumeInfo[] volList = new YYLiveRtcEventHandler.AudioVolumeInfo[volSize];
                                for (int i = 0; i < volSize; ++i) {
                                    volList[i] = volInfos.get(i);
                                }
                                if (mRtcEventHandler != null) {
                                    mRtcEventHandler.onAudioVolumeIndication(volList, maxVol);
                                    ++s_playVolumeNotifyCount;
                                }
                            }
                        }

                        break;
                    }
                    case YYLiveNotification.kYYLiveAPINotification_BizAuthRes: {
                        YYLiveNotification.BizAuthResult result = (YYLiveNotification.BizAuthResult) msg.obj;
                        YYLiveLog.release(TAG, String.format("YYLiveNotification.BizAuthResult stream=%s group=%s result=%d",
                                result.getAuthStream() != null ? result.getAuthStream().streamName : "null",
                                result.getAuthGroup() != null ? result.getAuthGroup().groupName : "null",
                                result.getBizAuthResult()));

                        if (mRtcEventHandler != null) {
                            mRtcEventHandler.onBizAuthResult(result.isPublishAuth(), result.getBizAuthResult());
                        }
                        break;
                    }
                    case YYLiveNotification.kYYLiveAPINotification_SdkAuthRes: {
                        YYLiveNotification.SdkAuthResult result = (YYLiveNotification.SdkAuthResult) msg.obj;
                        YYLiveLog.release(TAG, String.format("YYLiveNotification.SdkAuthResult appId=%d uid=%d result=%d",
                                result.getAppId(), result.getUid(), result.getSdkAuthResult()));

                        if (mRtcEventHandler != null) {
                            mRtcEventHandler.onSdkAuthResult(result.getSdkAuthResult());
                        }
                        break;
                    }
                    case YYLiveNotification.kYYLiveAPINotifioation_StringUid: {
                        YYLiveNotification.UidInt2String result = (YYLiveNotification.UidInt2String) msg.obj;
                        mRtcEngine.get().addUid2String(result.getUidInt(), result.getUidString());
                        YYLiveLog.release(TAG, String.format("YYLiveNotification.UidInt2String uid=%d str=%s",
                                result.getUidInt(), result.getUidString()));
                        break;
                    }
                    case YYLiveNotification.kYYLiveAPINotification_AudioPlayData: {
                        YYLiveNotification.AudioDataInfo result = (YYLiveNotification.AudioDataInfo) msg.obj;

                        long uid = result.getUid();
                        String strUid = "";
                        if (mRtcEngine.get().mIs32bitUid) {
                            strUid = Long.toString(uid);
                        } else {
                            strUid = mRtcEngine.get().getStringUid((int) uid);
                            if (strUid == null || strUid.isEmpty()) {
                                strUid = Long.toString(uid);
                                if (strUid == null || strUid.isEmpty()) {
                                    return;
                                }
                            }
                        }

                        int duration = result.getDuration();
                        int cpt = result.getCpt();
                        int pts = result.getPts();
                        byte[] data = result.getData();
                        int len = 0;
                        if (null != data) {
                            len = data.length;
                        }

                        if ((s_playDataNotifyCount % 500) == 0) {
                            YYLiveLog.release(TAG, String.format("YYLiveNotification.AudioPlayData,cpt:%d,pts:%d, len:%d", cpt, pts, len));
                        }
                        ++s_playDataNotifyCount;

                        if (mRtcEventHandler != null) {
                            mRtcEventHandler.onAudioPlayData(data, cpt, pts, strUid, duration);
                        }
                        break;
                    }
                    case YYLiveNotification.kYYLiveAPINotification_AudioPlaySpectrumData: {
                        YYLiveNotification.AudioPlaySpectrumData result = (YYLiveNotification.AudioPlaySpectrumData) msg.obj;
                        if (mRtcEventHandler != null) {
                            mRtcEventHandler.onAudioPlaySpectrumData(result.getData());
                        }
                        break;
                    }
                    case YYLiveNotification.kYYLiveAPINotification_AudioCapturePcmData: {
                        YYLiveNotification.AudioCapturePcmData result = (YYLiveNotification.AudioCapturePcmData) msg.obj;
                        if (mRtcEventHandler != null) {
                            mRtcEventHandler.onAudioCapturePcmData(result.getData(), result.getDataSize(), result.getSampleRate(), result.getChannel());
                        }
                        break;
                    }
                    case YYLiveNotification.kYYLiveAPINotification_AudioRenderPcmData: {
                        YYLiveNotification.AudioRenderPcmData result = (YYLiveNotification.AudioRenderPcmData) msg.obj;
                        if (mRtcEventHandler != null) {
                            //duration = (result.getDataSize() * 1000) /  (result.getSampleRate() * result.getChannel() * 2) 单位：ms
                            mRtcEventHandler.onAudioRenderPcmData(result.getData(), result.getDataSize(), result.getDuration(), result.getSampleRate(), result.getChannel());
                        }
                        break;
                    }
                    case YYLiveNotification.kYYLiveAPINotification_UserAppMsgData: {
                        YYLiveNotification.UserAppMsgData result = (YYLiveNotification.UserAppMsgData) msg.obj;

                        long uid = result.getUid();
                        String strUid = "";
                        strUid = Long.toString(uid);

                        //YYLiveLog.info(TAG, String.format("YYLiveNotification.UserAppMsgData uid %s msgSize %d",
                        //        strUid, result.getData().length));
                        if (mRtcEventHandler != null) {
                            mRtcEventHandler.onRecvUserAppMsgData(result.getData(), strUid);
                        }
                        break;
                    }
                    case YYLiveNotification.kYYLiveAPINotification_AppMsgDataFailedStatus: {
                        YYLiveNotification.AppMsgDataFailedStatus result = (YYLiveNotification.AppMsgDataFailedStatus) msg.obj;
                        YYLiveLog.info(TAG, String.format("YYLiveNotification.AppMsgDataFailedStatus status=%d",
                                result.getFailedStatus()));
                        if (mRtcEventHandler != null) {
                            mRtcEventHandler.onSendAppMsgDataFailedStatus(result.getFailedStatus());
                        }
                        break;
                    }
                    case YYLiveNotification.kYYLiveAPINotification_InitiateHttpsRequest: {
                        YYLiveNotification.InitiateHttpsRequest result =
                                (YYLiveNotification.InitiateHttpsRequest) msg.obj;
                        String reqUrl = result.getReqUrl();
                        int target = result.getTarget();
                        YYLiveLog.info(TAG, String.format("YYLiveNotification.InitiateHttpsRequest " +
                                "reqUrl=%s target=%d", reqUrl, target));
                        if (mHttpsRequestHandler != null) {
                            mHttpsRequestHandler.send(reqUrl, target);
                        }
                        break;
                    }
                    case YYLiveNotification.kYYLiveAPINotification_PublishChannelStreamInfo: {
                        YYLiveNotification.PublishChannelStreamInfo info = (YYLiveNotification.PublishChannelStreamInfo) msg.obj;
                        YYLiveLog.info(TAG,"*************** (Not deal in thunderbolt)PublishChannelStreamInfo ***************");
                        YYLiveLog.info(TAG,"YYLiveNotification.PublishChannelStreamInfo channelID:" + info.getChannelId() + " streams:" + info.getStreams().size());
                        for (YYLiveStream oneStream : info.getStreams()) {
                            YYLiveLog.info(TAG,String.format("YYLiveNotification.PublishChannelStreamInfo stream name:%s speak id:%d appid:%d",oneStream.streamName,oneStream.speakerUid,oneStream.appId));
                        }
                        YYLiveLog.info(TAG,"*************** *********************************************** ***************");
                        break;
                    }
                    case YYLiveNotification.kYYLiveAPINotification_StreamsNotify: {
                        YYLiveNotification.StreamsNotify info = (YYLiveNotification.StreamsNotify) msg.obj;
                        YYLiveLog.info(TAG,"*************** kYYLiveAPINotification_StreamsNotify ***************");
                        YYLiveLog.info(TAG,"YYLiveNotification.StreamsNotify channelID:" + info.getChannelId() + " streams:" + info.getStreams().size());
                        for (YYLiveStream oneStream : info.getStreams()) {
                            YYLiveLog.info(TAG,String.format("YYLiveNotification.StreamsNotify stream name:%s speak id:%d appid:%d",oneStream.streamName,oneStream.speakerUid,oneStream.appId));
                        }
                        YYLiveLog.info(TAG,"*************** *********************************************** ***************");
                        mRtcEngine.get().onStreamsNotify(info);
                        break;
                    }
                    case YYLiveNotification.kYYLiveAPINotification_ResolutionChangeInfo: {
//                        YYLiveNotification.OnVideoSizeChange info = (YYLiveNotification.OnVideoSizeChange) msg.obj;
//                        mRtcEventHandler.onVideoSizeChanged(info.getUid(),info.getWidth(),info.getHeight(),0);
                        YYLiveNotification.ResolutionChangeInfo info = (YYLiveNotification.ResolutionChangeInfo) msg.obj;
                        YYLiveAPI.sharedInstance().getPlayer().setSubscribeStreamWHByUid(info.getStream().speakerUid,info.getWidth(),info.getHeight());
                        mRtcEventHandler.onVideoSizeChanged(info.getStream().speakerUid,info.getWidth(),info.getHeight(),0);
                        break;
                    }
                    default:
                        break;
                }
            }
        }

    // param type define

    /**
     * 混响参数
     */
    public static final class ReverbExParameter {
        /**
         * 房间大小; 范围: [0~100]
         */
        public float mRoomSize = 0;
        /**
         * 预延时; 范围: [0~200]
         */
        public float mPreDelay = 0;
        /**
         * 混响度; 范围: [0~100]
         */
        public float mReverberance = 0;
        /**
         * 高频因子; 范围: [0~100]
         */
        public float mHfDamping = 0;
        /**
         * 低频量; 范围: [0~100]
         */
        public float mToneLow = 0;
        /**
         * 高频量; 范围: [0~100]
         */
        public float mToneHigh = 0;
        /**
         * 湿增益; 范围: [-20~10]
         */
        public float mWetGain = 0;
        /**
         * 干增益; 范围: [-20~10]
         */
        public float mDryGain = 0;
        /**
         * 立体声宽度; 范围: [0~100]
         */
        public float mStereoWidth = 0;
    }

    /**
     * 压缩参数
     */
    public static final class CompressorParam {
        /**
         * 阈值; 范围: [-40~0]
         */
        public int mThreshold = 0;
        /**
         * 增益
         */
        public int mMakeupGain = 0;
        /**
         * 比例
         */
        public int mRatio = 0;
        /**
         * 斜率
         */
        public int mKnee = 0;
        /**
         * 释放时间; 范围: 大于0
         */
        public int mReleaseTime = 0;
        /**
         * 启动时间; 范围: 大于0
         */
        public int mAttackTime = 0;
    }

    /**
     * 限制器参数
     */
    public static final class LimterParam {
        /*
         *  -30 ~ 0
         */
        public float fCeiling = 0;
        /*
         *  -10 ~ 0
         */
        public float fThreshold = 0;
        /*
         *   0 ~ 30
         */
        public float fPreGain = 0;
        /*
         *  0 ~ 1000
         */
        public float fRelease = 0;
        /*
         *  0 ~ 1000
         */
        public float fAttack = 0;
        /*
         *   0 ~ 8
         */
        public float fLookahead = 0;
        /*
         * 0.5 ~ 2
         */
        public float fLookaheadRatio = 0;
        /*
         * 0 ~ 100
         */
        public float fRMS = 0;
        /*
         * 0 ~ 1
         */
        public float fStLink = 0;
    }

    //static info
    private static int sMyAppId = 0;
    private static long sMySceneId = 0;

    private static YYLiveRtcEventHandler mRtcEventHandler;

	// https request handler
	private static YYLiveHttpsRequestHandler mHttpsRequestHandler;

    //my info
    private long mMyUid = 0;
    //uid info
    private Map<Integer, String> mUidToStringMap = new HashMap<Integer, String>();
    private boolean mIs32bitUid = false;
    private String mMyStrUid = "";

    //log info
    private static String mLogPath = "";
    private static int mLogLevel = YYLiveRtcConstant.LogLevel.YR_LOG_LEVEL_TRACE;
    private static IYYLogCallback mYyLogCallback = null;

    //audio srbscribe
    private boolean mBGroupSubscribe = false;
    private boolean mBAudioPublish = false;
    private boolean mBVideoPublish =false;
    private String mStringName = "";
    private String mVideoStringName = "";

    //channel info
    private int mChannelAppId = 0;
    private String mChannelName = "";

    //channel profile
    private int mChannelProfile = YYLiveRtcConstant.ChannelProfile.YR_ChannelProfile_Live;
    //audio profile
    private int mAudioProfile = YYLiveRtcConstant.AudioProfile.YR_AUDIO_PROFILE_DEFAULT;
    private int mCommutMode = YYLiveRtcConstant.CommutMode.YR_COMMUT_MODE_DEFAULT;
    private int mScenarioMode = YYLiveRtcConstant.ScenarioMode.YR_SCENARIO_MODE_DEFAULT;

    private boolean mBEnablePlayDataIndication = false;
    private static int s_playVolumeNotifyCount = 0;
    private static int s_playDataNotifyCount = 0;
    private static NotificationHandler mHandler = null;

    // Equalizer
    private int[] mEqGains = new int [11];
    private boolean mBEnableEqualizer = false;
    private boolean mBEnableCompressor = false;
    private boolean mBEnableLimiter = false;
    private boolean mBEnableReverbEx = false;
    private ReverbExParameter mReverbExGains = new ReverbExParameter();
    private CompressorParam mCompressorGains = new CompressorParam();
    private LimterParam mLimiterGins = new LimterParam();

    //Video
    private boolean mBOnlyReleaseCamera = false;

    // audioFilePlayer
    private Set<YYLiveAudioFilePlayer> mAudioFilePlayerSet = new TreeSet<YYLiveAudioFilePlayer>();

    public String getChannelName(){return mChannelName;}
    public String getMyUid(){return mMyStrUid;}


    // param for thunder bolt
    private Boolean isJoinChannel = false;
    private Boolean isThunder = false;
    private Boolean isBoltJoin =false;

    private Boolean isEnableAudio =true;
    private Boolean isEnableVideo = true;
    private Boolean isMuteAllVideo = false;
    private Boolean isMuteAllAudio = false;
    private Boolean isMuteLocalVideo = false;
    private Boolean isPreview = false;
    private Boolean isOtherSource = false;
    private Boolean needNotify = false;
    private int     accompanyType = -1;

    private static Context appContext = null;
    private SurfaceView rtcSurfaceView = null;

    private long joinStart = 0;
    private long joinEnd = 0;

    private  YRVideoCanvas localCanvas = null;
    private static YYLivePreviewView staticYYLivePreview = null;
    //    private YRVideoCanvas remoteCanvas = null;
    private ArrayList<YRVideoCanvas> remoteCanvas = new ArrayList<YRVideoCanvas>(0);
    private int thunderBoltProfile = YR_PROFILE_DEFAULT;
    private int playType = YYConstant.YYPublishPlayType.YYPUBLISH_PLAY_SINGLE;
    private int resolutionMode = -1;
    private YYVideoEncoderConfiguration mYYVideoEncoderConfiguration = new YYVideoEncoderConfiguration();
    private ArrayList<YYLiveStream> anchorStreams = new ArrayList<YYLiveStream>(0);
    private ArrayList<YYLiveStream> wholeStreams = new ArrayList<YYLiveStream>(0);
    private Map<String, ArrayList<YYLiveStream>> channelStreamsList = new HashMap<>();
    private Map<String, Boolean> uidMuteVideoList = new HashMap<>();
    private Map<String, Boolean> uidMuteAudioList = new HashMap<>();
    private final Object streamLock = new Object();

    // End of Para


    private YYLiveRtcEngine(){
    }

    private static class SingleonHolder{
        private static YYLiveRtcEngine INSTANCE = new YYLiveRtcEngine();
    }

    private static synchronized YYLiveRtcEngine createRtcEngine(Context context,
                                                               String appId,
                                                               long sceneId,
                                                               YYLiveRtcEventHandler handler){
        if(SingleonHolder.INSTANCE == null){
            SingleonHolder.INSTANCE = new YYLiveRtcEngine();
        }

        // 如果已经被创建过，就不再初始化
        if (!mIsInited) {
            mRtcEventHandler = handler;
            mHttpsRequestHandler = new YYLiveHttpsRequestHandler();

            sMyAppId = Integer.parseInt(appId);
            sMySceneId = sceneId;

            // 部分机型需要手动先于yyvideoplayer库加载ffmpeg 和 ittiam .
            {
                System.loadLibrary("ffmpeg-neon");
                System.loadLibrary("Ittiamhevcdec");
            }
            YYLiveAPI.sharedInstance().initWithAppId(sMyAppId, sMySceneId, context);
            mIsInited = true;
        }

        return SingleonHolder.INSTANCE;
    }

    /**
     * 创建RtcEngine对象
     * <br>仅支持一个实例
     * <br>在yylivesdk.yy.com上创建app后，系统会分配唯一appId，初始化后appId不能修改
     *
     * @param context Andoird APP 的上下文
     * @param appId 接入app的唯一标识
     * @sceneId 场景Id
     * @param handler YYLiveRtcEventHandler 是一个提供了缺省实现的抽象类，SDK 通过该抽象类向应用程序报告 SDK 运行时的各种事件\
     * @return YYLiveRtcEngine对象
     */
    public static synchronized YYLiveRtcEngine create(Context context,
                                                      String appId,
                                                      long sceneId,
                                                      YYLiveRtcEventHandler handler){

        YYLiveRtcEngine rtcEngine = createRtcEngine(context,appId,sceneId,handler);

        if (mHandler == null) {
            mHandler = new NotificationHandler(rtcEngine);
		}

		appContext = context;

        staticYYLivePreview = new YYLivePreviewView(appContext);
//        localCanvas = new YRVideoCanvas(yPreviewView,1,null);


        return rtcEngine;
    }

    public void onStreamsNotify(YYLiveNotification.StreamsNotify streamInfo){
        if(streamInfo.getChannelId().equals(mChannelName)) {

            ArrayList<YYLiveStream> curChannelStreams = streamInfo.getStreams();
            if (curChannelStreams == null) {
                return;
            }

            //filter self
            Iterator<YYLiveStream> it = curChannelStreams.iterator();
            while (it.hasNext())
            {
                YYLiveStream stream = it.next();
                if((Long.parseLong(mMyStrUid, 10) == stream.speakerUid)) {
                    it.remove();
                }
            }

            ArrayList<YYLiveStream> addStreams = new ArrayList<YYLiveStream>();             // 需要增加订阅的流
            ArrayList<YYLiveStream> removeStreams = new ArrayList<YYLiveStream>();          // 需要退订的流

            ArrayList<YYLiveStream> oldStreamsInChannel = channelStreamsList.get(streamInfo.getChannelId());
            if (oldStreamsInChannel != null) {
                // 对比查找需要增加订阅的流
                for (YYLiveStream newStream : curChannelStreams) {
                    boolean isFind = false;
                    for (YYLiveStream oldStream : oldStreamsInChannel) {
                        if (newStream.streamName.equals(oldStream.streamName)) {
                            isFind = true;
                        }
                    }
                    if (!isFind) {
                        addStreams.add(newStream);
                    }
                }
                // 对比查找需要退订的流
                for (YYLiveStream oldStream : oldStreamsInChannel) {
                    boolean isFind = false;
                    for (YYLiveStream newStream : curChannelStreams) {
                        if (newStream.streamName.equals(oldStream.streamName)) {
                            isFind = true;
                        }
                    }
                    if (!isFind) {
                        removeStreams.add(oldStream);
                        // 如果之前已经订阅，则删除
                        synchronized (streamLock) {
                            if (anchorStreams.contains(oldStream)) {
                                anchorStreams.remove(oldStream);
                            }
                        }
                    }
                }
            } else {
                addStreams.addAll(curChannelStreams);
            }

            // 去除黑名单音视频流
            it = addStreams.iterator();
            while (it.hasNext())
            {
                boolean isMute;
                YYLiveStream stream = it.next();
                if (stream.bVideo) {
                    isMute = isMuteVideoStreamWithUid(stream.speakerUid);
                } else {
                    isMute = isMuteAudioStreamWithUid(stream.speakerUid);
                }

                if (isMute) {
                    it.remove();
                } else if (stream.bVideo && remoteCanvas != null){
                    // 订阅前需要重新绑定 YRVideoCanvas（如果之前有设置的话）
                    for(YRVideoCanvas canvas : remoteCanvas) {
                        if((Long.parseLong(canvas.mUid, 10) == stream.speakerUid)) {
                            stream.toView = canvas.mView;
                            stream.scaleMode = canvas.mRenderMode;
                        }
                    }
                }
            }

            synchronized (streamLock) {
                wholeStreams.clear();
                channelStreamsList.put(streamInfo.getChannelId(), curChannelStreams);
                for (Map.Entry<String, ArrayList<YYLiveStream>> entry : channelStreamsList.entrySet()) {
                    wholeStreams.addAll(entry.getValue());
                }
                anchorStreams.addAll(addStreams);
            }

            if (removeStreams.size() > 0) {
                YYLiveAPI.sharedInstance().getPlayer().stopPlayStreams(removeStreams, null);
            }
            if (addStreams.size() > 0) {
                YYLiveAPI.sharedInstance().getPlayer().startPlayStreams(addStreams, null);
            }

            joinEnd = System.currentTimeMillis();

            if(!isJoinChannel && needNotify) {
                int elapsed = (int) (joinEnd - joinStart);
                isJoinChannel = true;
                needNotify = false;
                mRtcEventHandler.onJoinChannelSuccess(mChannelName, mMyStrUid, elapsed);
            }

            // Notify stream change
            if(isJoinChannel)
            {
                for (YYLiveStream stream : removeStreams) {
                    if (stream.bVideo) {
                        YYLiveLog.info(YYLiveLog.kLogTagRtcEngine,"didVideoMuted id:" + stream.speakerUid+ " isMute:" + true);
                        mRtcEventHandler.didVideoMuted(String.valueOf(stream.speakerUid), true);
                    } else {
                        YYLiveLog.info(YYLiveLog.kLogTagRtcEngine,"didAudioMuted id:" + stream.speakerUid+ " isMute:" + true);
                        mRtcEventHandler.didAudioMuted(String.valueOf(stream.speakerUid), true);
                    }
                }

                for (YYLiveStream stream : addStreams) {
                    if (stream.bVideo) {
                        YYLiveLog.info(YYLiveLog.kLogTagRtcEngine,"didVideoMute id:" + stream.speakerUid+ " isMute:" + false);
                        mRtcEventHandler.didVideoMuted(String.valueOf(stream.speakerUid), false);
                    } else {
                        YYLiveLog.info(YYLiveLog.kLogTagRtcEngine,"didAudioMuted id:" + stream.speakerUid+ " isMute:" + false);
                        mRtcEventHandler.didAudioMuted(String.valueOf(stream.speakerUid), false);
                    }
                }
            }
        }
    }

    /**
     * 创建RtcEngine对象
     * <br>仅支持一个实例
     * <br>在yylivesdk.yy.com上创建app后，系统会分配唯一appId，初始化后appId不能修改
     *
     * @param context Andoird APP 的上下文
     * @param appId 接入app的唯一标识
     * @sceneId 场景Id
     * @param handler YYLiveRtcEventHandler 是一个提供了缺省实现的抽象类，SDK 通过该抽象类向应用程序报告 SDK 运行时的各种事件
     * @loop 回调执行线程
     * @return YYLiveRtcEngine对象
     */
    public static synchronized YYLiveRtcEngine createWithLoop(Context context,
                                                              String appId,
                                                              long sceneId,
                                                              YYLiveRtcEventHandler handler,
                                                              Looper loop){
        YYLiveRtcEngine rtcEngine = createRtcEngine(context,appId,sceneId,handler);

        if (mHandler == null){
            mHandler = new NotificationHandler(rtcEngine, loop);
        }

        return rtcEngine;
    }

    /**
     * 销毁RtcEngine对象
     */
    public static synchronized void destroy(){
        // 如果已经被销毁，就不再卸载
        if (mIsInited) {
            SingleonHolder.INSTANCE.leaveChannel();
            YYLiveAPI.sharedInstance().deInit();
            mIsInited = false;
            SingleonHolder.INSTANCE.resetRtcEngine();
            SingleonHolder.INSTANCE = null;
        }
    }

    /**
     * sdk版本号
     * @return sdk版本号，非空
     */
    public static String getSdkVersion(){
        return YYLiveAPI.sharedInstance().getVersion();
    }


    /**
     * 设置日志文件路径（打开日志）
     * @param filePath 日志文件路径（路径为空表示关闭日志）
     * @return
     */
    public static int setLogFile(String filePath){
        mLogPath = filePath;
        if (filePath == null || filePath.isEmpty()) {
            YYLiveAPI.enableLog(false, mLogLevel, mLogPath, null);
        }else{
            YYLiveAPI.enableLog(true,mLogLevel,mLogPath,null);
        }
        return 0;
    }

    /**
     * 设置日志回调
     * @praam IYYLogCallback 日志回调(callback = null 表示关闭日志）
     *         设置了日志回调，则setLogFile无效；
     */
    public static int setLogCallback(IYYLogCallback callback){
        mYyLogCallback = callback;

        if (mYyLogCallback != null) {
            YYLiveAPI.enableLog(true, mLogLevel, "", mYyLogCallback);
        }
        else{
            YYLiveAPI.enableLog(false, mLogLevel, "", mYyLogCallback);
        }

        return 0;
    }

    /**
     * 设置日志级别
     * @param filter YYLiveRtcConstant.LogLevel
     * @return
     */
    public static int setLogFilter(int filter){
        mLogLevel = filter;
        return 0;
    }

    /**
     * 设置场景Id
     * @param sceneId 自定义场景Id
     */
    public void setSceneId(long sceneId) {
        sMySceneId = sceneId;
        YYLiveAPI.sharedInstance().setSceneId(sceneId);
    }

    /**
     * 功能1：进入频道前调用有效，可选择进入纯音频频道或者音视频频道；（默认为音视频） 功能2：设置频道属性；
     * @param profile 默认0：音视频模式 1：音视频模式 2：纯音频模式
     * @param channelProfile=YYLiveRtcConstant.ChannelProfile
     *               YR_ChannelProfile_Live = 直播模式（流畅）
     *               YR_ChannelProfile_Communication = 通话模式（延时低）
     *               YR_ChannelProfile_Game = 游戏（省流量、延时低）
     * @return 成功或失败
     */
    public  int setChannelProfile(int profile, int channelProfile) {
        YYLiveLog.release(YYLiveLog.kLogTagRtcEngine,"setChannelProfile: profile=%d channelProfile:%d", profile,channelProfile);

        if(isJoinChannel) {
            return -2;
        }

        if(profile == YR_PROFILE_ONLY_AUDIO){
            isThunder = true;
        }else {
            isThunder = false;
        }

        mChannelProfile = channelProfile;

        boolean bLowLatency = false;

        switch (mChannelProfile) {
            case YYLiveRtcConstant.ChannelProfile.YR_ChannelProfile_Live: {
                bLowLatency = false;
            }
            break;
            case YYLiveRtcConstant.ChannelProfile.YR_ChannelProfile_Communication:
            case YYLiveRtcConstant.ChannelProfile.YR_ChannelProfile_Game: {
                bLowLatency = true;
            }
            break;
            case YYLiveRtcConstant.ChannelProfile.YR_ChannelProfile_MultiAudioRoom: {
                bLowLatency = true;
            }
            break;
            default:
                break;
        }
        YYLiveAPI.sharedInstance().setChannelProfile(mChannelProfile);
        YYLiveAPI.sharedInstance().enableLowLatency(bLowLatency);
        return profile;
    }

    /**
     * 设置区域（国外用户必须调用此接口）
     * @param area 取值范围YYLiveRtcConstant.AreaType
     * @return
     */
    public int setArea(int area){
        YYLiveLog.release(YYLiveLog.kLogTagRtcEngine,"setArea: area=%d", area);

		int iResult = 0;
        int transSdkArea = YYConstant.YYAreaType.YYAREA_DEFAULT; //domestic;
        switch(area) {
            case YYLiveRtcConstant.AreaType.YR_AREA_DEFAULT:
                transSdkArea = YYConstant.YYAreaType.YYAREA_DEFAULT; //default-domestic;
                break;
            case YYLiveRtcConstant.AreaType.YR_AREA_FOREIGN:
                transSdkArea = YYConstant.YYAreaType.YYAREA_FOREIGN; //foreign;
                break;
			case YYLiveRtcConstant.AreaType.YR_AREA_RESERVED:
				transSdkArea = YYConstant.YYAreaType.YYAREA_RESERVED;
				break;
            default:
                iResult = -1;
				break;
        }

        YYLiveAPI.sharedInstance().setAreaType(transSdkArea);
        return iResult;
    }

    /**
     * 加入频道，在同一个频道内的用户可以互相通话，多个用户加入同一个频道，可以群聊。不同appId不互通
     *
     * @param token 参见renewToken
     * @param channelName 频道名称
     * @param info 对标参数，无意义，不会使用
     * @param uid 用户id，32 位无符号整数，需要保证唯一
     * @return 成功或失败
     */
    public int joinChannel(byte[] token,
                           String channelName,
                           String info,
                           String uid,
                           boolean is32bitUid){
        YYLiveLog.release(YYLiveLog.kLogTagRtcEngine,"joinChannel: channelName=%s, uid=%s, " +
                "is32bitUid=%b, token=%s, info=%s", getPrintString(channelName),
                getPrintString(uid), is32bitUid, getPrintString(token), getPrintString(info));


        if (!isValidChannelStream(channelName)) {
            return -1;
        }

        if (uid == null || uid.isEmpty()){
            return -2;
        }

        mMyStrUid = uid;
        mIs32bitUid = is32bitUid;
        if (mIs32bitUid){
            try {
                mMyUid = Long.parseLong(uid);
            } catch (NumberFormatException exception) {
                return -4;
            }
        }

        mChannelName = channelName;
        mChannelAppId = sMyAppId;

        if(isThunder) {
            //voice only sdk
            YYLiveNative.setVoiceOnlySdk(true);
        } else {
            YYLiveNative.setVoiceOnlySdk(false);
        }

        //register notification
        YYLiveAPI.sharedInstance().registerNotificationHandler(mHandler);

        //token
        YYLiveAPI.sharedInstance().updateToken(token);

        YYLiveNative.setChannelName(mChannelName);

        //join
        if (mIs32bitUid){
            YYLiveAPI.sharedInstance().joinMedia(mMyUid);
        }else{
            YYLiveAPI.sharedInstance().joinMedia(mMyStrUid, 0, 0);
        }

        //user role
        YYLiveAPI.sharedInstance().setUserRole(YYConstant.YYUserRole.YYUSER_ROLE_ANCHOR);

        //subscribe

        if(isThunder){
            joinChannelThunder();
        }else {
            joinChannelThunderBolt();
        }

        joinStart = System.currentTimeMillis();
        needNotify = true;
        return 0;
    }

    private boolean joinChannelThunder() {

        if (mBGroupSubscribe)
        {
            return false;
        }

        ArrayList<YYLiveGroup> audioGroup = new ArrayList<YYLiveGroup>(0);
        YYLiveGroup oneGroup = new YYLiveGroup();

        oneGroup.appId = mChannelAppId;
        oneGroup.groupName = "g_" + mChannelName;
        audioGroup.add(oneGroup);

        YYLiveAPI.sharedInstance().getPlayer().startPlayStreams(null,audioGroup);

        mBGroupSubscribe = true;
        needNotify = false;
        return true;

    }


    private boolean joinChannelThunderBolt() {
        boolean res = YYLiveAPI.sharedInstance().joinChannel(mChannelName,mMyStrUid,YYConstant.YYUserRole.YYUSER_ROLE_ANCHOR);
        if(res) {
            isBoltJoin = true;
        }

        return true;
    }
	
	    private boolean isValidChannelStream(String channelName) {
        if (channelName == null || channelName.isEmpty()) {
            return false;
        }

        int length = channelName.length();
        if (length > 64) {
            return false;
        }
        int codePoint;
        int validCharCount = 0;
        for (int i = 0; i < length; i++) {
            codePoint = Character.codePointAt(channelName, i);
            if (codePoint == 45 || codePoint == 95         // - _
                    || (codePoint >= 48 && codePoint <= 57)    // [0,9]
                    || (codePoint >= 65 && codePoint <= 90)    // [A,Z]
                    || (codePoint >= 97 && codePoint <= 122))  // [a,z]
            {
                validCharCount += 1;
            }
        }
        if (validCharCount == length) {
            return true;
        }
        YYLiveLog.error(YYLiveLog.kLogTagRtcEngine, "found invalid char in channelname!");
        return false;
    }


    /**
     * 离开频道
     * @return
     */
    public int leaveChannel(){
        //unregisterNotificationHandler会导致收不到离开频道消息
        //unregister notification
        //YYLiveAPI.sharedInstance().unregisterNotificationHandler(mHandler);

        YYLiveLog.release(YYLiveLog.kLogTagRtcEngine,"leaveChannel");

        if(isThunder){
            leaveChannelThunder();
        }else {

            if(!isJoinChannel) {
                return -2;
            }
            leaveChannelThunderBolt();
            //Todo remove views
            remoteCanvas.clear();
        }

        //clear uids
        removeAllUid2String();

        accompanyType = -1;
        isJoinChannel = false;

        isEnableAudio =true;
        isEnableVideo = true;
        isMuteAllVideo = false;
        isMuteAllAudio = false;
        isMuteLocalVideo = false;

        synchronized (streamLock) {
            wholeStreams.clear();
            anchorStreams.clear();
            channelStreamsList.clear();
        }
        uidMuteVideoList.clear();
        uidMuteAudioList.clear();

        return 0;
    }

    private int leaveChannelThunder() {
        if(!mBGroupSubscribe){
            return -1;
        }

        tryStopPublish();
        tryStopSubscribe();
        YYLiveAPI.sharedInstance().leaveMedia();
        mBGroupSubscribe = false;
        return 0;
    }

    private int leaveChannelThunderBolt() {

        tryStopPublish();
        tryStopSubscribe();

        tryStopVideoSubscribe();
        tryStopVideoPublish();
        tryStopVideoPreview();

        YYLiveAPI.sharedInstance().leaveChannel();

        YYLiveRtcEventHandler.RtcStats status = new YYLiveRtcEventHandler.RtcStats();
        mRtcEventHandler.onLeaveChannel(status);
        return 0;
    }

    /**
     * 更新token，用于appid和业务功能鉴权
     * <br> token 格式
     * <br> -------------------------------------------------------------------------------------------------
     * <br> | TokenLen(uint16)    | AppId(uint32)        | uid (uint64)          | Timestamp(uint64)(ms)    |
     * <br> -------------------------------------------------------------------------------------------------
     * <br> | ValidTime(uint32)(s)| BizExtInfoLen(uint16)| BizExtInfoData(nBytes)| DigitalSignature(20Bytes)|
     * <br> -------------------------------------------------------------------------------------------------
     * <br> 1. 多字节整数使用网络字节序
     * <br> 2. TokenLen：整个token长度，包括自身2字节和摘要
     * <br> 3. 过期时间=Timestamp+ValidTime*1000, UTC时间距离1970的毫秒数
     * <br> 4. BizExtInfoData: 业务鉴权可能需要的扩展信息，透传
     * <br> 5. DigitalSignature：采用hmac-sha1算法对DigitalSignature前的所有数据运算得出[TokenLen,BizExtInfoData], 秘钥使用申请appId时分配的appSecret
     * <br> 6. 整个token 进行 url安全的 base64编码
     *
     * @param token 业务服务器生成的token，需要url base64编码
     *
     * 通过监听通知 kYYLiveAPINotification_BizAuthRes, kYYLiveAPINotification_SdkAuthRes获取鉴权结果
     * {@link YYLiveNotification#kYYLiveAPINotification_BizAuthRes}
     * {@link YYLiveNotification#kYYLiveAPINotification_SdkAuthRes}
     */
    public int renewToken(byte[] token){
        YYLiveLog.release(YYLiveLog.kLogTagRtcEngine,"renewToken: %s ", getPrintString(token));

        YYLiveAPI.sharedInstance().updateToken(token);
        return 0;
    }

    /**
     * 打开音频采集，并开播到频道
     * @return
     */
    public int enableAudio(){
        YYLiveLog.release(YYLiveLog.kLogTagRtcEngine,"enableAudio isThunder:" + isThunder);

//        if(isEnableAudio) {
//            return -2;
//        }

        isEnableAudio = true;

        if(isThunder) {
            //必须在joinChannel之后调用
            if (!mBGroupSubscribe) {
                return -1;
            }

            if (mBAudioPublish) {
                return -2;
            }

            mStringName = "a_" + mMyUid + "_" + mChannelName;
            String groupName = "g_" + mChannelName;

            ArrayList<String> groupList = new ArrayList<String>();
            groupList.add(groupName);
            YYPublishAudioConfig config = new YYPublishAudioConfig(YYPublishAudioConfig.YYPUBLISH_AUDIO_MODE_LOWDELAY_NORMALFLOW_MEDIUMQUALITY_VOIP);
            config.bUseAudioProfile = true;
            config.channelProfile = mChannelProfile;
            config.audioProfile = mAudioProfile;
            config.commutMode = mCommutMode;
            config.scenarioMode = mScenarioMode;

            mBAudioPublish = true;


            YYLiveAPI.sharedInstance().getPublisher().startPublishAudio(mStringName, groupList, config);
        } else {
            if(mBAudioPublish){
                return -2;
            }

            if (isJoinChannel) {
                // 重新订阅音频流
                ArrayList<YYLiveStream> startStreams = new ArrayList<YYLiveStream>(0);
                synchronized (streamLock) {
                    for (YYLiveStream oneStream : wholeStreams) {
                        boolean isMute;
                        if (!oneStream.bVideo && !anchorStreams.contains(oneStream)) {
                            isMute = isMuteAudioStreamWithUid(oneStream.speakerUid);
                            if (!isMute) {
                                startStreams.add(oneStream);
                                anchorStreams.add(oneStream);
                            }
                        }
                    }
                }
                if (startStreams.size() > 0) {
                    YYLiveAPI.sharedInstance().getPlayer().startPlayStreams(startStreams, null);
                }

                // 重新开播音频
                if(!mBAudioPublish) {
                    YYLiveAPI.sharedInstance().getPublishChannel().updateProfile(mChannelProfile,
                            mAudioProfile, mCommutMode, mScenarioMode);
                    YYLiveAPI.sharedInstance().getPublishChannel().setAudioEnable(true);
                    if(accompanyType>=0) {
                        YYLiveAPI.sharedInstance().getPublisher().setAudioSourceType(accompanyType);
                    }
                    mBAudioPublish = true;
                }
            }
        }

        return 0;
    }

    /**
     * 关闭音频采集，停止开播到频道
     * @return
     */
    public int disableAudio(){
        YYLiveLog.release(YYLiveLog.kLogTagRtcEngine,"disableAudio isThunder:" + isThunder);
        if(isThunder) {
            tryStopPublish();
        } else {
            if(isEnableAudio) {
                ArrayList<YYLiveStream> stopStreams = new ArrayList<YYLiveStream>(0);
                synchronized (streamLock) {
                    for (YYLiveStream oneStream : anchorStreams) {
                        if (!oneStream.bVideo) {
                            stopStreams.add(oneStream);
                        }
                    }
                }
                YYLiveAPI.sharedInstance().getPlayer().stopPlayStreams(stopStreams, null);
                tryStopPublish();

                ArrayList<YYLiveStream> audioStreams = new ArrayList<YYLiveStream>(0);
                synchronized (streamLock) {
                    for(YYLiveStream oneStream: anchorStreams) {
                        if(!oneStream.bVideo) {
                            audioStreams.add(oneStream);
                        }
                    }
                    for(YYLiveStream oneStream: audioStreams) {
                        anchorStreams.remove(oneStream);
                    }
                }
                audioStreams.clear();
                isEnableAudio = false;
            }
        }
        return 0;
    }

    /**
     * 设置音频属性，参数待定
     * @param profile YYLiveRtcConstant.AudioProfile
     * @param commutMode YYLiveRtcConstant.CommutMode
     * @param scenarioMode YYLiveRtcConstant.ScenarioMode
     * @return
     */
    public int setAudioProfile(int profile,
                               int commutMode,
                               int scenarioMode){
        YYLiveLog.release(YYLiveLog.kLogTagRtcEngine,"setAudioProfile: profile=%d, commutMode=%d, " +
                "scenarioMode=%d", profile, commutMode, scenarioMode);

        mAudioProfile = profile;
        mCommutMode = commutMode;
        mScenarioMode = scenarioMode;
        return 0;
    }

    /**
     * 设置是否外放
     * @param enabled
     * @return
     */
    public int setEnableSpeakerphone(boolean enabled){
        YYLiveLog.release(YYLiveLog.kLogTagRtcEngine,"setEnableSpeakerphone: %b", enabled);

        YYLiveAPI.sharedInstance().getPlayer().enableLoudSpeaker(enabled);
        return 0;
    }

    /**
     * 是否是扬声器状态
     * @return
     */
    public boolean isSpeakerphoneEnabled(){
        return YYLiveAPI.sharedInstance().getPlayer().getLoudSpeakerEnabled();
    }

    /**
     * 打开用户音量回调
     * @param interval <=0: 禁用音量提示功能 >0: 回调间隔，单位为毫秒
     * @param moreThanThd 从<moreThanThd到>=moreThanThd，立即回调一次 <=0无效
     * @param lessThanThd 从>=lessThanThd到<lessThanThd，立即回调一次 <=0无效
     * @param smooth 平滑系数，未实现
     * @return
     */
    public int enableAudioVolumeIndication(int interval,
                                           int moreThanThd,
                                           int lessThanThd,
                                           int smooth) {
        YYLiveLog.release(YYLiveLog.kLogTagRtcEngine,"enableAudioVolumeIndication: interval=%d," +
                "moreThanThd=%d, lessThanThd=%d, smooth=%d", interval, moreThanThd, lessThanThd, smooth);

        YYLiveAPI.sharedInstance().setPlayVolumeInterval(interval, moreThanThd, lessThanThd);
        return 0;
    }

    /**
     * 打开采集音量回调
     * @param interval <=0: 禁用音量提示功能 >0: 回调间隔，单位为毫秒
     * @param moreThanThd 从<moreThanThd到>=moreThanThd，立即回调一次 <=0无效
     * @param lessThanThd 从>=lessThanThd到<lessThanThd，立即回调一次 <=0无效
     * @param smooth 未实现
     * @return
     */
    public int enableCaptureVolumeIndication(int interval,
                                             int moreThanThd,
                                             int lessThanThd,
                                             int smooth){
        YYLiveLog.release(YYLiveLog.kLogTagRtcEngine,"enableCaptureVolumeIndication: interval=%d," +
                "moreThanThd=%d, lessThanThd=%d, smooth=%d", interval, moreThanThd, lessThanThd, smooth);

        YYLiveAPI.sharedInstance().setCaptureVolumeInterval(interval, moreThanThd, lessThanThd);
        return 0;
    }
	
    /**
     *开始将音频数据保存成aac格式的文件
     *
     *@param fileName 文件保存路径,必须是完整路径，包括文件名，文件名的后缀必须是.aac。其中保存文件的文件夹必须是已经创建好的，该接口不提供创建文件夹的功能。例如：/sdcard/helloworld.aac
     *@param saverMode  =YYLiveRtcConstant.AudioSaverMode.
     *                    YR_AUDIO_SAVER_ONLY_CAPTURE = 只保存频道内所有的上行的音频数据。上行的音频数据指的是：无论是主播的音频数据还是是伴奏的音频数据，只有被设置成上行，才被保存
     *                     YR_AUDIO_SAVER_ONLY_RENDER = 保存频道内除主播以外的音频数据，例如：伴奏的音频数据和观众端的音频数据
     *                     YR_AUDIO_SAVER_BOTH = 保存频道内所有的音频数据
     *@param fileMode  = YYLiveRtcConstant.AudioSaverWfMode.
     *                   YR_AUDIO_SAVER_FILE_APPEND = 追加打开一个文本文件，并在文件末尾写数据
     *                   YR_AUDIO_SAVER_FILE_OVERRIDE = 打开一个文本文件，写入的数据会覆盖文件本身的内容
     *@return true:成功 false:失败
     */
    public boolean startAudioSaver(String fileName, int saverMode, int fileMode){
        YYLiveLog.release(YYLiveLog.kLogTagRtcEngine,"startAudioSaver: fileName=%s," +
                "saverMode=%d, fileMode=%d", getPrintString(fileName), saverMode, fileMode);

        if (fileName.isEmpty()){
            return false;
        }
        return YYLiveAPI.sharedInstance().startAudioSaver(fileName, saverMode, fileMode);
    }

    /**
     *停止将音频数据保存成aac格式的文件
     *
     * @return true:成功 false:失败
     */
    public boolean stopAudioSaver(){
        YYLiveLog.release(YYLiveLog.kLogTagRtcEngine,"stopAudioSaver");

        return YYLiveAPI.sharedInstance().stopAudioSaver();
    }

    /**
     *设置不同的音效模式
     *
     *@param mode  =YYLiveRtcConstant.SoundEffectMode.
     *                     YR_SOUND_EFFECT_MODE_NONE               = 关闭模式
     *                     YR_SOUND_EFFECT_MODE_VALLEY              = VALLEY模式
     *                     YR_SOUND_EFFECT_MODE_RANDB               = R&B模式
     *                     YR_SOUND_EFFECT_MODE_KTV                 = KTV模式
     *                     YR_SOUND_EFFECT_MODE_CHARMING           = CHARMING模式
     *
     */
    public void setSoundEffect(int mode) {
        YYLiveLog.release(YYLiveLog.kLogTagRtcEngine, "YYLiveRtcEngine::setSoundEffect %d", mode);

        YYLiveAPI.sharedInstance().getPublisher().setSoundEffect(mode);
    }

    /**
     * 是否静音自己
     * @param muted
     * @return
     */
    public int muteLocalAudioStream(boolean muted){
        YYLiveLog.release(YYLiveLog.kLogTagRtcEngine,"muteLocalAudioStream: %b isThunder:%b", muted,isThunder);

        if(isThunder) {
            int volume = 80;
            if (muted) {
                volume = 0;
            }
            YYLiveAPI.sharedInstance().getPublisher().setMicVolume(volume);
        }else {

            //Todo isJoinchannel
            if(muted) {
                if(mBAudioPublish) {
                    YYLiveAPI.sharedInstance().getPublishChannel().setAudioEnable(false);
                    mBAudioPublish = false;
                }
            }else {
                if(!mBAudioPublish && isJoinChannel){
                    YYLiveAPI.sharedInstance().getPublishChannel().setAudioEnable(true);
                    if(accompanyType>=0) {
                        YYLiveAPI.sharedInstance().getPublisher().setAudioSourceType(accompanyType);
                    }
                    mBAudioPublish = true;
                }
            }
        }

        return 0;
    }

    /**
     * 是否静音所有播放声音
     * @param muted
     * @return
     */
    public int muteAllRemoteAudioStreams(boolean muted){
        if (isMuteAllAudio == muted) {
            return 0;
        }

        YYLiveLog.release(YYLiveLog.kLogTagRtcEngine,"muteAllRemoteAudioStreams: %b isThunder:%b isEnableAudio:%b isJoinChannel:%b", muted,isThunder,isEnableAudio,isJoinChannel);
        if(!isEnableAudio) {
            return -2;
        }

        //Todo isenableAudio
        if(isThunder) {
            YYLiveAPI.sharedInstance().getPlayer().enableAllMute(muted);
        }else {

            isMuteAllAudio = muted;
            uidMuteAudioList.clear();

            if(muted) {
                ArrayList<YYLiveStream> stopStreams = new ArrayList<YYLiveStream>(0);
                synchronized (streamLock) {
                    for (YYLiveStream oneStream : anchorStreams) {
                        if (!oneStream.bVideo) {
                            stopStreams.add(oneStream);
//                        anchorStreams.remove(oneStream);
                        }
                    }
                    for(YYLiveStream oneStream : stopStreams) {
                        anchorStreams.remove(oneStream);
                    }
                }
                if(isJoinChannel) {
                    YYLiveAPI.sharedInstance().getPlayer().stopPlayStreams(stopStreams, null);
                }
            }else {
                ArrayList<YYLiveStream> startStreams = new ArrayList<YYLiveStream>(0);
                synchronized (streamLock) {
                    for (YYLiveStream oneStream : wholeStreams) {
                        boolean isPlaying =false;
                        if (!oneStream.bVideo) {
                            for(YYLiveStream anStream: anchorStreams) {
                                if(anStream.speakerUid == oneStream.speakerUid && !anStream.bVideo){
                                    isPlaying = true;
                                    break;
                                }
                            }
                            if(isPlaying) {
                                continue;
                            }

                            startStreams.add(oneStream);
                            anchorStreams.add(oneStream);
                        }
                    }
                }
                if(isJoinChannel) {
                    YYLiveAPI.sharedInstance().getPlayer().startPlayStreams(startStreams, null);
                }
            }
        }
        return 0;
    }

    public int setDefaultMuteAllRemoteAudioStreams(boolean defaultMute){
        if (!isEnableAudio) {
            return -1;
        }

        return muteAllRemoteAudioStreams(defaultMute);
    }

    /**
     * 是否静音某个用户的声音
     * @param uid
     * @param muted
     * @return
     */
    public int muteRemoteAudioStream(String uid, boolean muted){
        YYLiveLog.release(YYLiveLog.kLogTagRtcEngine,"muteRemoteAudioStream: uid=%s, %b isThunder:%b isEnableAudio:%b isJoinChannel:%b", getPrintString(uid),muted,isThunder,isEnableAudio,isJoinChannel);

        if(isThunder) {
            YYLiveStream stream = new YYLiveStream();
            if (mIs32bitUid) {
                try {
                    stream.speakerUid = Long.parseLong(uid);
                } catch (NumberFormatException exception) {
                    return -1;
                }
            } else {
                if (uid == null) {
                    return -2;
                }
                YYLiveAPI.sharedInstance().getPlayer().enableMute(muted, uid);
                stream.speakerUid = getIntUid(uid);
                if (stream.speakerUid == 0) {
                    return 0;
                }
            }
            YYLiveAPI.sharedInstance().getPlayer().enableMute(muted, stream);
        }else {
            if(!isEnableAudio){
                return -2;
            }

            uidMuteAudioList.put(uid, muted);

            if(muted) {
                ArrayList<YYLiveStream> stopStreams = new ArrayList<YYLiveStream>(0);
                synchronized (streamLock) {
                    for (YYLiveStream oneStream : anchorStreams) {
                        if ( (Long.parseLong(uid, 10) == oneStream.speakerUid) && !oneStream.bVideo) {
                            stopStreams.add(oneStream);
//                        anchorStreams.remove(oneStream);
                        }
                    }
                    for(YYLiveStream oneStream : stopStreams) {
                        anchorStreams.remove(oneStream);
                    }
                }

                if(isJoinChannel) {
                    YYLiveAPI.sharedInstance().getPlayer().stopPlayStreams(stopStreams, null);
                }
            } else {
                ArrayList<YYLiveStream> startStreams = new ArrayList<YYLiveStream>(0);
                YYLiveStream newStream = null;
                boolean alreadyPlay = false;

                synchronized (streamLock) {
                    for(YYLiveStream oneStream : wholeStreams) {
                        if((Long.parseLong(uid, 10) == oneStream.speakerUid) && !oneStream.bVideo){
                            newStream = oneStream;
                            break;
                        }
                    }

                    if(newStream == null) {
                        return 0;
                    }

                    for (YYLiveStream oneStream : anchorStreams) {
                        if ( (Long.parseLong(uid, 10) == oneStream.speakerUid) && !oneStream.bVideo) {
                            alreadyPlay = true;
                            break;
                        }
                    }

                    if(!alreadyPlay) {
                        startStreams.add(newStream);
                        anchorStreams.add(newStream);
                    }
                }

                if(isJoinChannel) {
                    YYLiveAPI.sharedInstance().getPlayer().startPlayStreams(startStreams, null);
                }
            }
        }
        return 0;
    }

    /**
     * 该方法设定外放(扬声器)音量。
     * @param volume
     * @return
     */
    public int setSpeakerphoneVolume(int volume){
        YYLiveLog.release(YYLiveLog.kLogTagRtcEngine,"setSpeakerphoneVolume: %d", volume);

        boolean bResult = YYLiveAPI.sharedInstance().getPlayer().setSpeakerVolume(volume);

        if (bResult){
            return 0;
        }else{
            return -1;
        }
    }

    /**
     * 设置麦克风音量
     * @param volume
     * @return
     */
    public int setMicVolume(int volume){
        YYLiveLog.release(YYLiveLog.kLogTagRtcEngine,"setMicVolume: %d", volume);

        boolean bResult = YYLiveAPI.sharedInstance().getPublisher().setMicVolume(volume);
        if (bResult){
            return 0;
        }else {
            return -1;
        }
    }

    /**
     *
     * @param uid
     * @param volume
     * @return
     */
    public int setRemoteAudioStreamsVolume(String uid, int volume) {
        YYLiveLog.release(YYLiveLog.kLogTagRtcEngine,"setRemoteAudioStreamsVolume: uid=%s, volume=%d",
                getPrintString(uid), volume);

        if(isThunder) {
            if (!mBGroupSubscribe) {
                return -1;
            }
        }

        YYLiveStream stream = new YYLiveStream();
        if (mIs32bitUid){
            try {
                stream.speakerUid = Long.parseLong(uid);
            } catch (NumberFormatException exception) {
                return -1;
            }
        }else{
            stream.speakerUid = getIntUid(uid);
            if (stream.speakerUid == 0){
                if (isNumeric(uid)) {
                    try {
                        stream.speakerUid = Long.parseLong(uid);
                    } catch (NumberFormatException exception) {
                return -2;
            }
                }else{
                    return -3;
        }
            }
        }
        if (YYLiveAPI.sharedInstance().getPlayer().setPlayVolume(volume, stream)) {
            return 0;
        }
        return -4;

    }



    /**
     * 创建文件播放对象
     * @return 播放器对象
     */
    public YYLiveAudioFilePlayer createAudioFilePlayer() {
        YYLiveLog.release(YYLiveLog.kLogTagRtcEngine,"createAudioFilePlayer");

        YYLiveAudioFilePlayer audioFilePlayer = new YYLiveAudioFilePlayer();
        mAudioFilePlayerSet.add(audioFilePlayer);
        return audioFilePlayer;
    }

    /**
     *  销毁文件播放对象
     * @param audioFilePlayer
     */
    public void destroyAudioFilePlayer(YYLiveAudioFilePlayer audioFilePlayer) {
        YYLiveLog.release(YYLiveLog.kLogTagRtcEngine,"destroyAudioFilePlayer: %s", getPrintString(audioFilePlayer));

        if (audioFilePlayer == null) {
            return;
        }
        audioFilePlayer.destroyAudioFilePlayer();
        mAudioFilePlayerSet.remove(audioFilePlayer);
    }

    /**
     * 使能均衡器
     * @param enabled
     * @return
     */
    public int setEnableEqualizer(boolean enabled) {
        mBEnableEqualizer = enabled;
        YYLiveAPI.sharedInstance().getPublisher().EnableEqualizer(enabled);
        return 0;
    }

    /**
     * 设置均衡器参数
     * @param gains  -12 <= gains[i] <= 12, 0<=i<=10
     * @return
     */
    public int setEqGains(final int [] gains) {
        if (gains == null) {
            return -1;
        }

        if (gains.length < 11) {
            return -2;
        }

        for (int i = 0; i <= 10; ++ i) {
            if (gains[i] < -12 || gains[i] > 12) {
                return -3;
            }
        }

        mEqGains = gains;
        YYLiveAPI.sharedInstance().getPublisher().SetGqGains(gains);
        return 0;
    }

    /**
     * 使能混响
     * @param enabled
     * @return
     */
    public int setEnableReverb(boolean enabled) {
        mBEnableReverbEx = enabled;
        YYLiveAPI.sharedInstance().getPublisher().EnableReverb(enabled);
        return 0;
    }

    /**
     * 设置混响参数
     * @param param
     * @see ReverbExParameter
     * @return
     */
    public int setReverbExParameter(ReverbExParameter param) {
        if (param == null) {
            return -1;
        }

        if (    (param.mRoomSize < 0.0 || param.mRoomSize >100.0) ||
                (param.mPreDelay < 0.0 || param.mPreDelay > 200.0) ||
                (param.mReverberance < 0.0 || param.mReverberance > 100.0) ||
                (param.mHfDamping < 0.0 || param.mHfDamping > 100.0) ||
                (param.mToneLow < 0.0 || param.mToneLow > 100.0) ||
                (param.mToneHigh < 0.0 || param.mToneHigh > 100.0) ||
                (param.mWetGain < -20.0 || param.mWetGain > 10.0) ||
                (param.mDryGain < -20.0 || param.mDryGain > 10.0) ||
                (param.mStereoWidth < 0.0 || param.mStereoWidth > 100.0)
                ) {
            return -2;
        }

        mReverbExGains = param;
        YYLiveAPI.sharedInstance().getPublisher().setReverbExParameter(
                param.mRoomSize,
                param.mPreDelay,
                param.mReverberance,
                param.mHfDamping,
                param.mToneLow,
                param.mToneHigh,
                param.mWetGain,
                param.mDryGain,
                param.mStereoWidth);
        return 0;
    }

    /**
     * 使能压缩器
     * @param enabled
     * @return
     */
    public int setEnableCompressor(boolean enabled) {
        mBEnableCompressor = enabled;
        YYLiveAPI.sharedInstance().getPublisher().EnableCompressor(enabled);
        return 0;
    }

    /**
     * 设置压缩器参数
     * @param param
     * @see CompressorParam
     * @return
     */
    public int setCompressorParam(CompressorParam param) {
        if (param == null) {
            return -1;
        }

        if (    (param.mThreshold < -40 || param.mThreshold > 0) ||
                (param.mReleaseTime <= 0) || (param.mAttackTime <= 0)) {
            return -2;
        }

        mCompressorGains = param;
        YYLiveAPI.sharedInstance().getPublisher().SetCompressorParam(
                param.mThreshold,
                param.mMakeupGain,
                param.mRatio,
                param.mKnee,
                param.mReleaseTime,
                param.mAttackTime);
        return 0;
    }

    /**
     * 使能压限器
     * @param enabled
     * @return
     */
    public int setEnableLimiter(boolean enabled) {
        mBEnableLimiter = enabled;
        YYLiveAPI.sharedInstance().getPublisher().EnableLimiter(enabled);
        return 0;
    }

    /**
     * 设置压限器参数
     * @param param
     * @see LimterParam
     * @return
     */
    public int setLimiterParam(LimterParam param) {
        if (param == null) {
            return -1;
        }

        mLimiterGins = param;
        YYLiveAPI.sharedInstance().getPublisher().SetLimiterParam(
                param.fCeiling,
                param.fThreshold,
                param.fPreGain,
                param.fRelease,
                param.fAttack,
                param.fLookahead,
                param.fLookaheadRatio,
                param.fRMS,
                param.fStLink);
        return 0;
    }

    /**
	 * 设置外部音频处理器
	 * @param eap, eap是个C 函数指针数组，长度为6，每个函数的类型为：
	    typedef void (*OnCaptureStartFun)(void*obj);
		typedef void (*OnCaptureDataFun)(void*obj, void* pData, uint32_t len, uint32_t sampleRate, uint32_t channelCount, uint32_t bitPerSample);
		typedef void (*OnCaptureStopFun)(void*obj);
		typedef void (*OnRenderStartFun)(void*obj);
		typedef void (*OnRenderDataFun)(void*obj, void* pData, uint32_t len, uint32_t sampleRate, uint32_t channelCount, uint32_t bitPerSample);
		typedef void (*OnRenderStopFun)(void*obj);
	 */
	public void setExternalAudioProcessor(long eap) {
		YYLiveAPI.sharedInstance().setExternalAudioProcessor(eap);
	}

	/**
     * 打开关闭音频播放频谱数据回调
     * 如果打开了，会收到{@link YYLiveRtcEventHandler#onAudioPlaySpectrumData} 回调
     */
	public void enableAudioPlaySpectrum(boolean enable) {
		YYLiveAPI.sharedInstance().enableAudioPlaySpectrum(enable);
	}

	/**
     * 设置音频播放频谱数据回调信息
     * @param spectrumLen 频谱数据的长度 [12 - 256]，默认是256
     * @param notifyIntervalMS 频谱回调的间隔，必须是10的倍数，默认是30MS
     */
	public void setAudioPlaySpectrumInfo(int spectrumLen, int notifyIntervalMS) {
		YYLiveAPI.sharedInstance().setAudioPlaySpectrumInfo(spectrumLen, notifyIntervalMS);
	}

	/**
    * 用户发送透传消息
    * @param msgData  发送的消息
    * <br> 调用此接口条件:
    *   1、用户在频道内
    *   2、开麦成功后调用(纯观众和开播鉴权失败都不能发)
    *   3、调用该接口的频率每秒不能超过2次,msgData的大小不能超过200Byte
    * <br> 不满足以上条件msg都会被丢弃
    * <br> 通过监听YYLiveRtcEventHandler中的onRecvUserAppMsgData接收其他透传的消息
    * <br> 通过监听YYLiveRtcEventHandler中的onSendAppMsgDataFailedStatus获得发送该msg发送失败的原因
    */
	public int sendUserAppMsgData(byte[] msgData)
    {
        YYLiveAPI.sharedInstance().sendUserAppMsgData(msgData);
        return 0;
    }

    /**
     * 打开关闭音频数据回调
     * @param enablePlay 打开播放数据回调
     */
    public void enableAudioDataIndication(boolean enablePlay){
        mBEnablePlayDataIndication = enablePlay;

        YYLiveAPI.sharedInstance().enableAudioDataIndication(enablePlay);
    }

    /**
     * 打开关闭音频采集回调
     * @param enable 打开采集数据回调
     * @param sampleRate 设置需要回调数据的采样率，取值范围[-1,8000,16000,44100,48000]
     * @param channel 设置需要回调数据的声道数，取值范围[-1,1,2]
     * <br> 只要sampleRate和channel其中一个参数的取值为-1，回调的数据是没有经过重采样的原始数据
     */
    public void enableCapturePcmDataCallBack(boolean enable, int sampleRate, int channel){
        YYLiveAPI.sharedInstance().enableCapturePcmDataCallBack(enable, sampleRate, channel);
    }

    /**
     * 打开关闭渲染音频数据回调
     * @param enable 打开渲染音频数据回调
     * @param sampleRate 设置需要回调数据的采样率，取值范围[-1,8000,16000,44100,48000]
     * @param channel 设置需要回调数据的声道数，取值范围[-1,1,2]
     * <br> 只要sampleRate和channel其中一个参数的取值为-1，回调的数据是没有经过重采样的原始数据
     */
    public boolean enableRenderPcmDataCallBack(boolean enable, int sampleRate, int channel){
        YYLiveLog.release(YYLiveLog.kLogTagRtcEngine,"enableRenderPcmDataCallBack enable = %b sampleRate: %d, channel = %d ", enable, sampleRate, channel);

        return YYLiveAPI.sharedInstance().enableRenderPcmDataCallBack(enable, sampleRate, channel);

    }

    /**
     * 是否将当前播放的文件作为直播伴奏使用(可替代enablePublish)
     * <br>
     * @param mode YYLiveRtcConstant.PublishMode
     *   YR_PUBLISH_MODE_MIC   = 0; //麦克风
     *   YR_PUBLISH_MODE_FILE  = 1; //文件
     *   YR_PUBLISH_MODE_MIX   = 2; //文件+麦克风
     *   YR_PUBLISH_MODE_NONE  = 10, //停止所有音频数据上行
     */
    public void publishByMode(int mode) {
        YYLiveLog.release(YYLiveLog.kLogTagCall,"publishByMode: mode=%d", mode);

        YYLiveAPI.sharedInstance().getPublisher().setAudioSourceType(mode);
        accompanyType = mode;
    }

    /**
     * 打开关闭耳返
     * @param enable true=打开，false=关闭；默认为关闭状态
     * @return
     */
    public int setEnableInEarMonitor (boolean enable) {
        YYLiveLog.release(YYLiveLog.kLogTagCall, "setEnableInEarMonitor: %b", enable);

        if (YYLiveAPI.sharedInstance().getPublisher().enableInEarMonitor(enable)) {
            return 0;
        } else {
            return -1;
        }
    }

    public Object CreateRendererView(Context context, int type) {
        Object view = null;
        switch (type) {
            case YYConstant.YYVideoViewType.YYVIDEO_VIEW_PLAYVIEW:
                view = new YYLivePlayerView(context);
                break;
            case YYConstant.YYVideoViewType.YYVIDEO_VIEW_PREVIEW:
                view = new YYLivePreviewView(context);
                break;
        }
        return view;
    }

    /**
     * joinChannel之前调用：设置视频开，不触发任何实际操作；
     * joinChannel之后调用：前置条件满足的情况下，开播视频；
     */
    public int enableVideo(){

        if(isThunder) {
            return -2;
        }

        isEnableVideo = true;

//        if(isEnableVideo) {
//            return -1;
//        }

        YYLiveLog.release(YYLiveLog.kLogTagRtcEngine,"enableVideo " + "," + isOtherSource);

//        //Todo judge start preview
//        if(localCanvas != null) {
//            startPreview();
//        }
        // 重新订阅视频流
        if (isJoinChannel) {
            synchronized (streamLock) {
                ArrayList<YYLiveStream> startStreams = new ArrayList<YYLiveStream>(0);
                for (YYLiveStream stream : wholeStreams) {
                    if (stream.bVideo && !anchorStreams.contains(stream)) {
                        boolean isMute = isMuteVideoStreamWithUid(stream.speakerUid);
                        if (!isMute) {
                            // 订阅前需要重新绑定 YRVideoCanvas（如果之前有设置的话）
                            for (YRVideoCanvas canvas : remoteCanvas) {
                                if ((Long.parseLong(canvas.mUid, 10) == stream.speakerUid)) {
                                    stream.toView = canvas.mView;
                                    stream.scaleMode = canvas.mRenderMode;
                                }
                            }
                            startStreams.add(stream);
                            anchorStreams.add(stream);
                        }
                    }
                }
                if (startStreams.size() > 0) {
                    YYLiveAPI.sharedInstance().getPlayer().startPlayStreams(startStreams, null);
                }
            }
        }

        if(isJoinChannel && (isPreview || isOtherSource) && !mBVideoPublish) {
            YYLiveAPI.sharedInstance().getPublishChannel().setVideoEnable(true);
            mBVideoPublish = true;
        }

        return 0;
    }

    /**
     * 流程1：
     * disableVideo:设置视频关；如果打开预览，则关闭预览；
     * joinChannelByToken: 加入频道，但是不自动订阅频道内的视频流；
     * 流程2：
     * JoinChannel：加入频道，自动订阅频道内的视频流；
     * disableVideo：退订频道内的视频流；如果打开预览，则关闭预览；
     * 流程3：
     * JoinChannel：加入频道，自动订阅频道内的视频流；
     * enableVideo：（参见enableVideo）
     * disableVideo：退订频道内的视频流；如果打开预览，则关闭预览；如果已开播，则停播；
     */
    public int disableVideo(){
        YYLiveLog.release(YYLiveLog.kLogTagRtcEngine,"disable Video ");
        if(!isEnableVideo || isThunder){
            return -1;
        }

        tryStopVideoSubscribe();
        tryStopVideoPublish();
        tryStopVideoPreview();

        //Todo remove views
//        remoteCanvas.clear();

        isEnableVideo = false;
        isOtherSource = false;

        return 0;
    };

    /**
     * 根据参数从Argo获取视频开播参数；
     * 如果已经预览，则在预览中生效；
     * 如果已经开播，则更新开播参数，本地预览和远端订阅会看到变化后的效果；
     */
    public int setVideoEncoderConfiguration(YYVideoEncoderConfiguration yyVideoConfig){
        YYLiveLog.info(YYLiveLog.kLogTagRtcEngine,"setVideoEncoderConfiguration playtype:" + yyVideoConfig.playType + " publishmode:" + yyVideoConfig.publishMode + " isEnableVideo:" + isEnableVideo);
        if(isEnableVideo && !isThunder) {
            mYYVideoEncoderConfiguration = yyVideoConfig;

//            if (mBVideoPublish) {
            YYLiveAPI.sharedInstance().getPublishChannel().updatePlayTypeAndPublishMode(yyVideoConfig.playType,yyVideoConfig.publishMode);
//            }
        } else {
            return -2;
        }
        return 0;
    }

    /**
     * 功能：设置本地视图，即预览的窗口；
     */
    public int setupLocalVideo(YRVideoCanvas local){
        YYLiveLog.info(YYLiveLog.kLogTagRtcEngine,"setupLocalVideo view:" + local.mView + " isEnableVideo:" + isEnableVideo + " isPreview:"+ isPreview);
        if(isEnableVideo && !isThunder) {
//            localCanvas = local;
//            YYLivePreviewView previewView = (YYLivePreviewView) localCanvas.mView;
//            previewView.clearViews();
//            previewView.addViews((SurfaceView) previewView.getSurfaceView());

            if(isPreview) {
                boolean isRemoveFromParent = false;
                if (localCanvas != null && localCanvas.mView != null) {
                    if (local != null && local.mView != localCanvas.mView) {
                        ((ViewGroup) localCanvas.mView).removeAllViews();
                        isRemoveFromParent = true;
                    }
                } else {
                    isRemoveFromParent = true;
                }

                if (local != null) {
                    if (local.mView != null && isRemoveFromParent) {
                        ViewGroup viewGroup = (ViewGroup) local.mView;
                        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);

                        staticYYLivePreview.setLayoutParams(params);
                        viewGroup.addView(staticYYLivePreview);
                    }

                    if (localCanvas != null && localCanvas.mRenderMode != local.mRenderMode) {
                        // update render mode
                    }
                }
            }
            localCanvas = local;

        }
        return 0;
    }

    /**
     * 功能：设置远端用户视图
     * 不设置此窗口，也可以订阅；
     * 设置此窗口，则可以看到远端订阅的对应uid的流的画面；
     */
    public int setupRemoteVideo(YRVideoCanvas remote){
        YYLiveLog.info(YYLiveLog.kLogTagRtcEngine,"setupRemoteVideo view:" + remote.mView + "uid:" + remote.mUid + " isEnableVideo:" + isEnableVideo);
        if(!isEnableVideo || isThunder) {
            return -2;
        }

        if(remote == null){
            return -1;
        }

        ArrayList<YYLiveStream> startStreams = new ArrayList<YYLiveStream>(0);

//        remoteCanvas.add(remote);

        if(remote.mView != null) {

            if(remoteCanvas.size()>0) {
                //first check view & uid
                for (YRVideoCanvas oneCanvas : remoteCanvas) {
                    if (oneCanvas.mView == remote.mView && !oneCanvas.mUid.equals(remote.mUid)) {
                        ArrayList<YYLiveStream> stopStreams = new ArrayList<YYLiveStream>(0);

                        synchronized (streamLock) {
                            for (YYLiveStream oneStream : anchorStreams) {
                                if (oneStream.bVideo && (Long.parseLong(oneCanvas.mUid, 10) == oneStream.speakerUid)) {
                                    oneStream.toView = null;
                                    oneStream.scaleMode = 1;
                                    stopStreams.add(oneStream);
//                                anchorStreams.remove(oneStream);
                                    YYLiveLog.info(YYLiveLog.kLogTagRtcEngine,"setupRemoteVideo view:" + oneCanvas.mView + "uid:" + oneStream.speakerUid + " anchorStreams restart" );
                                    YYLiveAPI.sharedInstance().getPlayer().stopPlayStreams(stopStreams, null);
                                    YYLiveAPI.sharedInstance().getPlayer().startPlayStreams(stopStreams,null);
                                    break;
                                }
                            }

                            for (YYLiveStream oneStream : wholeStreams) {
                                if (oneStream.bVideo && (Long.parseLong(oneCanvas.mUid, 10) == oneStream.speakerUid)) {
                                    YYLiveLog.info(YYLiveLog.kLogTagRtcEngine,"setupRemoteVideo view:" + oneCanvas.mView + "uid:" + oneStream.speakerUid + " wholeStreams" );
                                    oneStream.toView = null;
                                    oneStream.scaleMode = 1;
                                }
                            }
                        }

                        remoteCanvas.remove(oneCanvas);
                        remoteCanvas.add(remote);
                        break;
                    } else if (oneCanvas.mView == remote.mView && oneCanvas.mUid.equals(remote.mUid)) {
                        return 0;
                    } else {
                        remoteCanvas.add(remote);
                        break;
                    }

                }
            } else {
                remoteCanvas.add(remote);
            }

            synchronized (streamLock) {
                for (YYLiveStream oneStream : anchorStreams) {
                    if (oneStream.bVideo && (Long.parseLong(remote.mUid, 10) == oneStream.speakerUid) ) {
                        oneStream.toView = remote.mView;
                        oneStream.scaleMode = remote.mRenderMode;
                        YYLiveLog.info(YYLiveLog.kLogTagRtcEngine,"setupRemoteVideo view:" + remote.mView + "uid:" + oneStream.speakerUid + " startStreams restart" );
                        startStreams.add(oneStream);
                    }
                }
                if(startStreams.size()>0) {
                    YYLiveAPI.sharedInstance().getPlayer().stopPlayStreams(startStreams,null);
                    YYLiveAPI.sharedInstance().getPlayer().startPlayStreams(startStreams, null);
                    startStreams.clear();
                }

                for(YYLiveStream oneStream : wholeStreams) {
                    if(oneStream.bVideo && (Long.parseLong(remote.mUid, 10) == oneStream.speakerUid) ) {
                        oneStream.toView = remote.mView;
                        oneStream.scaleMode = remote.mRenderMode;
                    }
                }
            }
        }
        return 0;
    }

    /**
     * 设置本地视图显示模式
     * YR_RENDER_MODE_FILL(0)：铺满窗口，如果比例不适应的，会拉伸以铺满窗口；
     * YR_RENDER_MODE_ASPECT_FIT(1)：适应窗口，如果比例不适应，会留黑边；
     * YR_RENDER_MODE_CLIP_TO_BOUNDS(2)：铺满窗口，如果比例不适应，会截取;
     */
    public int setLocalRenderMode(int mode){
        YYLiveLog.info(YYLiveLog.kLogTagRtcEngine,"setLocalRenderMode mode:" + mode + " isEnableVideo:" + isEnableVideo);
        if(!isEnableVideo || isThunder) {
            return -2;
        }

        YYLiveAPI.sharedInstance().setPreviewRenderMode(mode);
        return 0;
    }

    /**
     * 设置远端视图显示模式
     * YR_RENDER_MODE_FILL(0)：铺满窗口，如果比例不适应的，会拉伸以铺满窗口；
     * YR_RENDER_MODE_ASPECT_FIT(1)：适应窗口，如果比例不适应，会留黑边；
     * YR_RENDER_MODE_CLIP_TO_BOUNDS(2)：铺满窗口，如果比例不适应，会截取;
     */
    public int setRemoteRenderMode(String uid,int mode){
        YYLiveLog.info(YYLiveLog.kLogTagRtcEngine,"setRemoteRenderMode Uid:" + uid + " mode:" + mode + " isEnableVideo:" + isEnableVideo + " isThunder " +isThunder);
        if(!isEnableVideo || isThunder) {
            return -2;
        }

        for(YRVideoCanvas oneCanvas : remoteCanvas) {
            if( uid.equals(oneCanvas.mUid) ){
                YYLivePlayerView remote = (YYLivePlayerView) oneCanvas.mView;
                oneCanvas.mRenderMode = mode;
//                remote.setScaleMode(mode);
                YYLiveNative.setPlayViewScaleMode(remote,mode);
            }
        }

        return 0;
    }

    /**
     * 开启视频预览
     * @return
     */
    public int startPreview(){
        YYLiveLog.info(YYLiveLog.kLogTagRtcEngine,"startPreview local view:" + localCanvas + ",isEnableVideo:" + isEnableVideo + ",isThunder" + isThunder +
                ",isMuteLocalVideo " + isMuteLocalVideo + ",isPreview " + isPreview + ",mBVideoPublish " + mBVideoPublish + " mBOnlyReleaseCamera:" + mBOnlyReleaseCamera);
        if(!isEnableVideo || isThunder || isMuteLocalVideo) {
            return -2;
        }

//        if(localCanvas != null && !isPreview) {
//            YYLiveLog.release(YYLiveLog.kLogTagRtcEngine,"start preview view: " + localCanvas.mView + " plaType:" + mYYVideoEncoderConfiguration.playType + " publishMode:" + mYYVideoEncoderConfiguration.publishMode);
//            YYLiveAPI.sharedInstance().getPublishChannel().startPreview(localCanvas.mView,mYYVideoEncoderConfiguration.playType,mYYVideoEncoderConfiguration.publishMode);
//            isPreview = true;
//        } else if( !isPreview) {
//            YYLivePreviewView yPreviewView = new YYLivePreviewView(appContext);
//            localCanvas = new YRVideoCanvas(yPreviewView,1,mMyStrUid);
//            YYLiveAPI.sharedInstance().getPublishChannel().startPreview(localCanvas.mView,mYYVideoEncoderConfiguration.playType,mYYVideoEncoderConfiguration.publishMode);
//            isPreview = true;

        if (isPreview)
        {
            return 0;
        }
        //可能开始是录屏开播，之后选择源为camera，这样未开启预览，但是(mBVideoPublish && !isOtherSource) == true;
        if(mBVideoPublish && !isOtherSource && mBOnlyReleaseCamera) {
            YYLiveNative.stopAndRecoverVideoEncode(false);
            mBOnlyReleaseCamera = false;
        } else {

            YYLiveAPI.sharedInstance().getPublishChannel().startPreview(staticYYLivePreview, mYYVideoEncoderConfiguration.playType, mYYVideoEncoderConfiguration.publishMode);
//            if (localCanvas != null && localCanvas.mView != null) {
//                ViewGroup viewGroup = (ViewGroup) localCanvas.mView;
//                ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
//                staticYYLivePreview.setLayoutParams(params);
//                viewGroup.addView(staticYYLivePreview);
//            }
        }
        if (localCanvas != null && localCanvas.mView != null) {
            ViewGroup viewGroup = (ViewGroup) localCanvas.mView;
            ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
            staticYYLivePreview.setLayoutParams(params);
            viewGroup.addView(staticYYLivePreview);
        }
        isPreview = true;
//        }

        return 0;
    }

    /**
     * 停止视频预览
     * @return
     */
    public int stopPreview(){
        YYLiveLog.info(YYLiveLog.kLogTagRtcEngine,"stopPreview local view:" + localCanvas + " isEnableVideo:" + isEnableVideo +" isPreview " +isPreview
                + " mBVideoPublish " + mBVideoPublish );
        if(!isEnableVideo || isThunder) {
            return -2;
        }

        if(isPreview) {
            if(mBVideoPublish && !isOtherSource && !mBOnlyReleaseCamera){
                YYLiveNative.stopAndRecoverVideoEncode(true);
                mBOnlyReleaseCamera = true;
            } else {
                YYLiveAPI.sharedInstance().getPublishChannel().stopPreview();

            }
            if (localCanvas != null && localCanvas.mView != null) {
                ((ViewGroup) localCanvas.mView).removeAllViews();
                isPreview = false;
            }
        }

        return 0;
    }

    /**
     * 开关本地视频采集
     * @return
     */
    public int enableLocalVideo(boolean enable){
        YYLiveLog.info(YYLiveLog.kLogTagRtcEngine,"enableLocalVideo localCanvas:" + localCanvas + " isEnableVideo:" + isEnableVideo + " isThunder " + isThunder +":"+enable);
        if(!isEnableVideo || isThunder) {
            return -2;
        }

        if(enable == false){
            tryStopVideoPublish();
            tryStopVideoPreview();
            isMuteLocalVideo = true;
        } else {
            isMuteLocalVideo = false;
        }

//        if(localCanvas != null) {
//            if(enable && !isPreview) {
//                YYLiveLog.release(YYLiveLog.kLogTagRtcEngine, "enableLocalVideo view: " + localCanvas.mView + " plaType:" + mYYVideoEncoderConfiguration.playType + " publishMode:" + mYYVideoEncoderConfiguration.publishMode);
//                YYLiveAPI.sharedInstance().getPublishChannel().startPreview(localCanvas.mView, mYYVideoEncoderConfiguration.playType, mYYVideoEncoderConfiguration.publishMode);
//                isPreview = true;
//            }
//
//            if(!enable && isPreview) {
//                YYLiveAPI.sharedInstance().getPublishChannel().stopPreview();
//                isPreview = false;
//            }
//        }



        return 0;
    }

    /**
     * 开关本地视频发送
     * @return
     */
    public int muteLocalVideoStream(boolean mute){
        YYLiveLog.info(YYLiveLog.kLogTagRtcEngine," muteLocalVideoStream:" + mute + " isEnableVideo:" + isEnableVideo + ",isOtherSource" + isOtherSource
                +" isMuteLocalVideo " + isMuteLocalVideo  + " isPreview " + isPreview);
        if(!isEnableVideo || isThunder || isMuteLocalVideo) {
            return -2;
        }

        if(mute){
            if (mBVideoPublish) {
                YYLiveAPI.sharedInstance().getPublishChannel().setVideoEnable(false);
                mBVideoPublish = false;
                mVideoStringName = "";
            }
        }else {
            if (isJoinChannel && !mBVideoPublish && (isPreview || isOtherSource)) {
                YYLiveAPI.sharedInstance().getPublishChannel().setVideoEnable(true);
                mBVideoPublish = true;
            }

        }
        return 0;
    }

    /**
     * 接收/停止接收指定视频流
     * @return
     */
    public int muteRemoteVideoStream(String uid, boolean mute){
        YYLiveLog.info(YYLiveLog.kLogTagRtcEngine,"muteRemoteVideoStream Uid:" + uid + " mute:" + mute + " isEnableVideo:" + isEnableVideo);
        if(!isEnableVideo || isThunder) {
            return -2;
        }

        uidMuteVideoList.put(uid, mute);

        if(mute) {
            ArrayList<YYLiveStream> stopStreams = new ArrayList<YYLiveStream>(0);
            for (YYLiveStream oneStream : anchorStreams) {
                if ( (Long.parseLong(uid, 10) == oneStream.speakerUid) && oneStream.bVideo) {
                    stopStreams.add(oneStream);
                }
            }

            synchronized (streamLock) {
                for(YYLiveStream oneStream : stopStreams) {
                    anchorStreams.remove(oneStream);
                }
            }

            if(isJoinChannel) {
                YYLiveAPI.sharedInstance().getPlayer().stopPlayStreams(stopStreams, null);
            }
        }else {
            ArrayList<YYLiveStream> startStreams = new ArrayList<YYLiveStream>(0);
            YYLiveStream newStream = null;
            boolean alreadyPlay = false;

            synchronized (streamLock) {
                for(YYLiveStream oneStream : wholeStreams) {
                    if((Long.parseLong(uid, 10) == oneStream.speakerUid) && oneStream.bVideo){
                        newStream = oneStream;
                        break;
                    }
                }
                //可以在进频道前设置
                if(newStream == null) {
                    return 0;
                }

                for (YYLiveStream oneStream : anchorStreams) {
                    if ( (Long.parseLong(uid, 10) == oneStream.speakerUid) && oneStream.bVideo) {
                        alreadyPlay = true;
                        break;
                    }
                }

                if(!alreadyPlay) {
                    if (remoteCanvas != null) {
                        for(YRVideoCanvas oneCanvas : remoteCanvas) {
                            if( (Long.parseLong(oneCanvas.mUid, 10) == newStream.speakerUid) ) {
                                newStream.toView = oneCanvas.mView;
                                newStream.scaleMode = oneCanvas.mRenderMode;
                            }
                        }
                    }
                    startStreams.add(newStream);
                    anchorStreams.add(newStream);
                }
            }

            if(isJoinChannel) {
                YYLiveAPI.sharedInstance().getPlayer().startPlayStreams(startStreams, null);
            }
        }

        return 0;
    }

    /**
     * 接收/停止接收所有视频流
     * @return
     */
    public int muteAllRemoteVideoStreams(boolean mute){
        if (isMuteAllVideo == mute)
            return 0;

        YYLiveLog.info(YYLiveLog.kLogTagRtcEngine,"muteAllRemoteVideoStream  mute:" + mute + " isEnableVideo:" + isEnableVideo);
        if(!isEnableVideo || isThunder) {
            return -2;
        }

        isMuteAllVideo = mute;
        uidMuteVideoList.clear();

        //Todo need to add a var ismuteall video
        if(mute) {
            ArrayList<YYLiveStream> stopStreams = new ArrayList<YYLiveStream>(0);
            synchronized (streamLock) {
                for (YYLiveStream oneStream : anchorStreams) {
                    if (oneStream.bVideo) {
                        stopStreams.add(oneStream);
                    }
                }
                for (YYLiveStream oneStream : stopStreams) {
                    anchorStreams.remove(oneStream);
                }
            }
            if(isJoinChannel) {
                YYLiveAPI.sharedInstance().getPlayer().stopPlayStreams(stopStreams, null);
            }
        }else {
            ArrayList<YYLiveStream> startStreams = new ArrayList<YYLiveStream>(0);
            synchronized (streamLock) {
                for (YYLiveStream oneStream : wholeStreams) {
                    boolean isPlaying = false;
                    if (oneStream.bVideo) {

                        for(YYLiveStream anStream: anchorStreams) {
                            if(anStream.speakerUid == oneStream.speakerUid && anStream.bVideo) {
                                isPlaying = true;
                                break;
                            }
                        }
                        if(isPlaying) {
                            continue;
                        }

                        if (remoteCanvas != null) {
                            for(YRVideoCanvas oneCanvas : remoteCanvas) {
                                if( (Long.parseLong(oneCanvas.mUid, 10) == oneStream.speakerUid) ) {
                                    oneStream.toView = oneCanvas.mView;
                                    oneStream.scaleMode = oneCanvas.mRenderMode;
                                }
                            }
                        }

                        startStreams.add(oneStream);
                        anchorStreams.add(oneStream);
                    }
                }
            }
            if(isJoinChannel) {
                YYLiveAPI.sharedInstance().getPlayer().startPlayStreams(startStreams, null);
            }
        }

        return 0;
    }

    /**
     * 设置是否默认接收视频流
     * @return
     */
    public int setDefaultMuteAllRemoteVideoStreams(boolean defaultMute){
        if (isThunder || !isEnableVideo) {
            return -1;
        }

        return muteAllRemoteVideoStreams(defaultMute);
    }

	/**
     * {@link IAudioFrameObserver} 接口对象实例；如果传入 null，则取消注册
     * @param observer
     * @return
     */
    public int registerAudioFrameObserver(IAudioFrameObserver observer) {

        return YYLiveAPI.sharedInstance().registerAudioFrameObserver(observer);
    }

    /**
     * 设置回调采集数据的格式
     * @param sampleRate 指定 onRecordFrame 中返回数据的采样率，可设置为 8000，16000，32000，44100 或 48000
     * @param channel 指定 onRecordFrame 中返回数据的通道数，可设置为 1（单声道） 或 2（双声道）
     * @param mode 指定 onRecordFrame 的使用模式:{@link YYLiveRtcConstant.YYLiveAudioRawFrameOperationMode}
     * @param samplesPerCall 指定 onRecordFrame 中返回数据的采样点数，如 RTMP 推流应用中通常为 1024。
     * @return
     */
    public int setRecordingAudioFrameParameters (int sampleRate, int channel, int mode, int samplesPerCall) {

        return YYLiveAPI.sharedInstance().setRecordingAudioFrameParameters(sampleRate, channel, mode, samplesPerCall);
    }

    /**
     * 设置回调播放数据的格式
     * @param sampleRate 指定 onPlaybackFrame 中返回数据的采样率，可设置为 8000，16000，32000，44100 或 48000
     * @param channel 指定 onPlaybackFrame 中返回数据的通道数，可设置为 1（单声道） 或 2（双声道）
     * @param mode 指定 onPlaybackFrame 的使用模式:{@link YYLiveRtcConstant.YYLiveAudioRawFrameOperationMode}
     * @param samplesPerCall 指定 onPlaybackFrame 中返回数据的采样点数，如 RTMP 推流应用中通常为 1024。
     * @return
     */
    public int setPlaybackAudioFrameParameters (int sampleRate, int channel, int mode, int samplesPerCall) {
        return YYLiveAPI.sharedInstance().setPlaybackAudioFrameParameters(sampleRate, channel, mode, samplesPerCall);
    }

    /**
     * 设置自定义视频源
     * @param videoSource 自定义视频源 用户需要实现{@link IVideoSource}接口，监听相应的方法，通过onInitialize
     *                    获得外部推流{@link IVideoFrameConsumer}接口对象，然后通过consumeByteArrayFrame方法进行推流
     * @return 0：方法调用成功  < 0：方法调用失败
     */
    public int setVideoSource(IVideoSource videoSource) {
        YYLiveLog.info(YYLiveLog.kLogTagRtcEngine,"setVideoSource  isThunder:" + isThunder + " isEnableVideo:" + isEnableVideo +
                "videoSource == null ?" + (videoSource == null ? true : false));
        if(!isEnableVideo || isThunder) {
            return -2;
        }

        if(videoSource == null){
            YYLiveAPI.sharedInstance().getPublishChannel().attachVideoCapture(null);
            isOtherSource = false;
        }else if(videoSource instanceof ScreenRecordSource){
            YYLiveAPI.sharedInstance().getPublishChannel().attachVideoCapture(((ScreenRecordSource)videoSource).mScreenCapture);
            isOtherSource = true;
        }else {
            ExternalVideoSource externalVideoSource = new ExternalVideoSource(videoSource);
            YYLiveAPI.sharedInstance().getPublishChannel().attachVideoCapture(externalVideoSource);
            isOtherSource = true;
        }
        return 0;
    }
    public boolean getIsThunder() {
        return isThunder;
    }

    private void tryStopPublish(){
        if(isThunder) {
            if (mBAudioPublish) {
                YYLiveAPI.sharedInstance().getPublisher().stopPublishAudio();
                mBAudioPublish = false;
                mStringName = "";
            }
        }else {
            if (mBAudioPublish) {
                YYLiveAPI.sharedInstance().getPublishChannel().setAudioEnable(false);
                mBAudioPublish = false;
                mStringName = "";
            }
        }
    }

    private void tryStopVideoPublish() {
        if (mBVideoPublish) {
            YYLiveAPI.sharedInstance().getPublishChannel().setVideoEnable(false);
            mBVideoPublish = false;
            mVideoStringName = "";
        }
    }

	private boolean isNumeric(String strNum) {
        
        Pattern pattern = Pattern.compile("^\\d+$");
        String bigStr;
        try {
            bigStr = new BigDecimal(strNum).toString();
        } catch (Exception e) {
            return false;
        }

        Matcher isNum = pattern.matcher(bigStr); 
        if (!isNum.matches()) {
            return false;
        }
        return true;
    }

    private void tryStopSubscribe(){
        if(isThunder) {
            if (mBGroupSubscribe) {
                ArrayList<YYLiveGroup> audioGroup = new ArrayList<YYLiveGroup>(0);
                YYLiveGroup oneGroup = new YYLiveGroup();
                oneGroup.appId = mChannelAppId;
                oneGroup.groupName = "g_" + mChannelName;
                audioGroup.add(oneGroup);
                YYLiveAPI.sharedInstance().getPlayer().stopPlayStreams(null, audioGroup);
                mBGroupSubscribe = false;
            }
        }else {
            ArrayList<YYLiveStream> stopSteams = new ArrayList<YYLiveStream>(0);
            for(YYLiveStream oneStream : anchorStreams) {
                if(!oneStream.bVideo){
                    stopSteams.add(oneStream);
                }
            }
            if(stopSteams.size() > 0) {
                for(YYLiveStream oneStream : stopSteams) {
                    anchorStreams.remove(oneStream.streamName);
                }
                YYLiveAPI.sharedInstance().getPlayer().stopPlayStreams(stopSteams,null);
            }
        }
    }

    private void tryStopVideoSubscribe() {
//        ArrayList<YYLiveStream> streamList = new ArrayList<YYLiveStream>(0);
//        YYLiveStream vStream = new YYLiveStream();
//        vStream.appId = sMyAppId;
//        vStream.streamName = mVideoStringName;
//        vStream.bVideo = true;
//        streamList.add(vStream);
//        YYLiveAPI.sharedInstance().getPlayer().stopPlayStreams(streamList,null);

        ArrayList<YYLiveStream> stopStreams = new ArrayList<YYLiveStream>(0);
        synchronized (streamLock) {
            for(YYLiveStream oneStream : anchorStreams) {
                if(oneStream.bVideo){
                    stopStreams.add(oneStream);
//                anchorStreams.remove(oneStream);
                }
            }
            YYLiveAPI.sharedInstance().getPlayer().stopPlayStreams(stopStreams,null);
            for(YYLiveStream oneStream : stopStreams) {
                anchorStreams.remove(oneStream);
            }
        }
    }

    private void tryStopVideoPreview() {
//        YYLiveAPI.sharedInstance().getPublisher().stopPreview();
        if(isPreview || mBOnlyReleaseCamera == true) {
//            YYLiveAPI.sharedInstance().getPublishChannel().stopPreview();
            stopPreview();
            isPreview = false;
            mBOnlyReleaseCamera = false;
        }
    }

    private void addUid2String(int iUid, String strUid){
        removeUid2String(strUid);
        synchronized (this){
            mUidToStringMap.put(iUid, strUid);
        }
    }

    private String getStringUid(int iUid){
        synchronized (this){
            return mUidToStringMap.get(iUid);
        }
    }

    private int getIntUid(String strUid){
        int iUid = 0;
        synchronized (this){
            if (strUid != null && strUid.length() != 0){
                Iterator<Integer> iter = mUidToStringMap.keySet().iterator();
                Integer key;
                while(iter.hasNext()){
                    key = iter.next();
                    if (strUid.equals(mUidToStringMap.get(key))){
                        iUid = key;
                        break;
                    }
                }
            }
        }
        return iUid;
    }

    private void removeUid2String(int iUid){
        synchronized (this){
            mUidToStringMap.remove(iUid);
        }
    }

    private void removeUid2String(String strUid){
        synchronized (this){
            if (strUid != null && strUid.length() != 0){
                Iterator<Integer> iter = mUidToStringMap.keySet().iterator();
                Integer key;
                while(iter.hasNext()){
                    key = iter.next();
                    if (strUid.equals(mUidToStringMap.get(key))){
                        mUidToStringMap.remove(key);
                        break;
                    }
                }
            }
        }
    }

    private void removeAllUid2String(){
        synchronized (this){
            mUidToStringMap.clear();
        }
    }

    private void resetRtcEngine() {
        //static info
        mHandler = null;
        sMyAppId = 0;
        sMySceneId = 0;

        mRtcEventHandler = null;
		mHttpsRequestHandler = null;

        //my info
        mMyUid = 0;
        mIs32bitUid = false;
        mMyStrUid = "";
        //uid info
        mUidToStringMap = new HashMap<Integer, String>();

        //log info
        mLogLevel = YYLiveRtcConstant.LogLevel.YR_LOG_LEVEL_TRACE;
        mLogPath = "";
        mYyLogCallback = null;

        //audio srbscribe
        mBGroupSubscribe = false;
        mBAudioPublish = false;

        //channel info
        mChannelAppId = 0;
        mChannelName = "";

        //channel profile
        mChannelProfile = YYLiveRtcConstant.ChannelProfile.YR_ChannelProfile_Live;
        //audio profile
        mAudioProfile = YYLiveRtcConstant.AudioProfile.YR_AUDIO_PROFILE_DEFAULT;
        mCommutMode = YYLiveRtcConstant.CommutMode.YR_COMMUT_MODE_DEFAULT;
        mScenarioMode = YYLiveRtcConstant.ScenarioMode.YR_SCENARIO_MODE_DEFAULT;

        //switch
        s_playVolumeNotifyCount = 0;
        s_playDataNotifyCount = 0;
        mBEnablePlayDataIndication = false;

        // Equalizer
        mEqGains = new int [11];
        mBEnableEqualizer = false;
        mBEnableCompressor = false;
        mBEnableLimiter = false;
        mBEnableReverbEx = false;
        mReverbExGains = new ReverbExParameter();
        mCompressorGains = new CompressorParam();
        mLimiterGins = new LimterParam();

        // audioFilePlayer
        for (YYLiveAudioFilePlayer audioFilePlayer : mAudioFilePlayerSet) {
            audioFilePlayer.destroyAudioFilePlayer();
        }
        mAudioFilePlayerSet.clear();
        accompanyType = -1;
    }

    private String getPrintString(String str){
        String result = "";
        if (str != null){
            result = str;
        }

        return result;
    }

    private String getPrintString(byte[] data){
        String result = "";
        if (data != null){
            result = data.toString();
        }

        return result;
    }

    private String getPrintString(Object obj) {
        String result = "";
        if (obj != null) {
            result = obj.toString();
        }
        return result;
    }

    /**
     * 1. 如果视频模块总开关是关闭状态，则不能订阅任何流，需要取消订阅所有流；
     * 2. 如果视频模块总开关是开启的，则先根据用户设置黑白名单mutelist来决定是否可以进行订阅操作，
     *    false表示需要订阅，true表示取消订阅；其中mutelist列表只可以通过用户调用moteRemote接
     *    口设置，内部不可以修改；
     * 3. 如果视频模块总开关是开启的，但是uid不在用户设置的黑白名单mutelist里，则根据用户设置的默
     *    认值muteAll执行，true false表示需要订阅，true表示取消订阅；
     * @param uid
     * @return
     */
    private boolean isMuteVideoStreamWithUid(long uid) {
        if (!isEnableVideo)
            return true;

        Boolean result = uidMuteVideoList.get(String.valueOf(uid));
        if (result != null) {
            return result;
        }

        return isMuteAllVideo;
    }

    /**
     * 同isMuteVideoStreamWithUid
     * @param uid
     * @return
     */
    private boolean isMuteAudioStreamWithUid(long uid) {
        if (!isEnableAudio)
            return true;

        Boolean result = uidMuteAudioList.get(String.valueOf(uid));
        if (result != null) {
            return result;
        }

        return isMuteAllAudio;
    }
}

