package com.yy.yylivesdk4cloud;

import android.content.Context;
import android.util.AttributeSet;
import android.view.SurfaceView;
import android.widget.FrameLayout;

/**
 * Created by xiaojun on 2018/4/17.
 * Copyright (c) 2017 YY Inc. All rights reserved.
 */
public class YYLivePreviewView extends FrameLayout {

	private SurfaceView mSurfaceView;

	public YYLivePreviewView(Context context) {
		super(context);
		mSurfaceView = new SurfaceView(context);
		LayoutParams params = new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT);
		mSurfaceView.setLayoutParams(params);
		addView(mSurfaceView);
	}

	public YYLivePreviewView(Context context, AttributeSet attrs) {
		super(context, attrs);
		mSurfaceView = new SurfaceView(context, attrs);
		LayoutParams params = new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT);
		mSurfaceView.setLayoutParams(params);
		addView(mSurfaceView);
	}

	public YYLivePreviewView(Context context, AttributeSet attrs, int defStyleAttr) {
		super(context, attrs, defStyleAttr);
		mSurfaceView = new SurfaceView(context, attrs);
		LayoutParams params = new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT);
		mSurfaceView.setLayoutParams(params);
		addView(mSurfaceView);
	}

	public SurfaceView getSurfaceView() {
		if (mSurfaceView == null) {
			mSurfaceView = new SurfaceView(this.getContext());
			LayoutParams params = new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT);
			mSurfaceView.setLayoutParams(params);
			this.addView(mSurfaceView);
		}
		return mSurfaceView;
	}

	public void clearViews(){
		this.removeAllViews();
	}
	public void addViews(SurfaceView newView) {
		LayoutParams params = new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT);
		newView.setLayoutParams(params);
		this.addView(newView);
	}
}
