package com.yy.yylivesdk4cloud;

import com.yy.videoplayer.utils.YMFLog;
import com.yy.yylivesdk4cloud.helper.YYLiveLog;
import com.yy.yylivesdk4cloud.video.YYVideoLogCallback;
import com.yy.yylivesdk4cloud.helper.YYLiveNative;

import java.util.ArrayList;

/**
 * Created by xiongxiong on 2017/10/30.
 */

public class YYLivePlayer {

	public ArrayList<YYLiveStream> subscribeStreams = null;

	YYLivePlayer() {
		if (BuildConfig.__YY_VIDEO_SUPPORT__) {
			YMFLog.registerLogger(YYVideoLogCallback.sharedInstance());
		}
		subscribeStreams = new ArrayList<YYLiveStream>(0);
	}

	/**
	 * 播放流
	 * <p>
	 * <br>拉流播放前使用API {@link YYLiveAPI#setUserRole(int)} 设置用户角色
	 * <br>拉流播放状态通过监听通知{@link YYLiveNotification#kYYLiveAPINotification_PlayStatus}获取
	 * <br>播放实时信息通过监听通知{@link YYLiveNotification#kYYLiveAPINotification_PlayRunTimeInfo}获取
	 * <br>1. 填入跟自己角色匹配的流，例如：纯观众播放混画/转码的流，主播可以播放多条独立原流。
	 * <br>2. 可以同时播放streamList和groupList里面的所有流
	 * <br>3. 每个群组里的所有流都会被播放
	 * <br>4. 相同speakerUid的音频和视频配对进行同步
	 * </p>
	 *
	 * @param streamList 播放的流列表
	 * @param groupList  播放的群组列表
	 * @return 0：成功；<0：error
	 */
	public int startPlayStreams(ArrayList<YYLiveStream> streamList, ArrayList<YYLiveGroup> groupList) {
		if (streamList == null) {
			streamList = new ArrayList<YYLiveStream>(0);
		}
		if (groupList == null) {
			groupList = new ArrayList<YYLiveGroup>(0);
		}

		if (streamList.size() == 0 && groupList.size() == 0) {
			YYLiveLog.warn(YYLiveLog.kLogTagCall,
					"startPlayStreams both stream list and group list is empty");
			return -1;
		}

		for(YYLiveStream oneStream : streamList) {
			if(oneStream.bVideo) {
				oneStream.startSubscribeTime = System.currentTimeMillis();
				subscribeStreams.add(oneStream);
			}
		}

		YYLiveLog.release(YYLiveLog.kLogTagCall, "startPlayStreams list size: %d %d",
				streamList.size(), groupList.size());
		return YYLiveNative.startPlayStreams(streamList, groupList);
	}

	/**
	 * 停止播放流
	 * streamList，groupList 里的所有流都会被停止，不需要跟YYUserRole匹配
	 *
	 * @param streamList 流列表
	 * @param groupList  群组列表
	 * @return 0：成功；<0：error
	 */
	public int stopPlayStreams(ArrayList<YYLiveStream> streamList, ArrayList<YYLiveGroup> groupList) {
		if (streamList == null) {
			streamList = new ArrayList<YYLiveStream>(0);
		}
		if (groupList == null) {
			groupList = new ArrayList<YYLiveGroup>(0);
		}

		if (streamList.size() == 0 && groupList.size() == 0) {
			YYLiveLog.warn(YYLiveLog.kLogTagCall,
					"stopPlayStreams both stream list and group list is empty");
			return -1;
		}

        for(YYLiveStream oneStream : streamList) {
            if(oneStream.bVideo) {
                for(YYLiveStream rmStream : subscribeStreams) {
                    if(rmStream.bVideo && rmStream.speakerUid == oneStream.speakerUid) {
                        subscribeStreams.remove(rmStream);
                        break;
                    }
                }
            }
        }

		YYLiveLog.release(YYLiveLog.kLogTagCall, "stopPlayStreams list size: %d %d",
				streamList.size(), groupList.size());
		return YYLiveNative.stopPlayStreams(streamList, groupList);
	}

	/**
	 * 是否使用硬解，播放视频之前调用
	 *
	 * @param enable 开启or关闭，默认开启
	 * @return 成功or失败
	 */
	public boolean enableHardwareDecoder(boolean enable) {
		YYLiveLog.release(YYLiveLog.kLogTagCall, "enableHardwareDecoder:%b", enable);
		return YYLiveNative.enableHardwareDecoder(enable, YYConstant.YYVideoEncodeType.YYVIDEO_ENCODE_TYPE_H264);
	}

//  更新渲染模式使用接口 YYLivePlayerView.setScaleMode
//	/**
//	 * 设置视频流显示模式, 一般在全屏切换等流尺寸可能变化的场合时调用
//	 * @param view      播放视频的view
//	 * @param scaleMode 显示模式
//	 * @param stream    视频流, 这个接口只取流名称、appId和主播uid
//	 * @return 成功or失败
//	 */
//	public boolean updatePlayVideoView(Object view, int scaleMode, YYLiveStream stream) {
//		if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
//			return false;
//		}
//		if (stream == null || view == null) {
//			return false;
//		}
//
//		YYLiveLog.release(YYLiveLog.kLogTagCall, "updatePlayVideoView scale mode %d for stream %s",
//				scaleMode, stream.streamName);
//
//		return YYLiveNative.updatePlayVideoView(view, scaleMode, stream);
//	}

	/**
	 * 开启静音
	 *
	 * @param enable 开启or关闭，默认关闭
	 * @param stream 音频流
	 * @return 成功or失败
	 */
	public boolean enableMute(boolean enable, YYLiveStream stream) {
		if (!BuildConfig.__YY_AUDIO_SUPPORT__) {
			return false;
		}

		if (stream == null) {
			return false;
		}

		YYLiveLog.release(YYLiveLog.kLogTagCall,
				"enableMute %b for stream %s", enable, stream.streamName);

		return YYLiveNative.enableMuteStream(enable, stream);
	}

	/**
	 * 开启静音
	 *
	 * @param enable 开启or关闭，默认关闭
	 * @param uid string型uid
	 * @return 成功or失败
	 */
	public boolean enableMute(boolean enable, String uid) {
		if (!BuildConfig.__YY_AUDIO_SUPPORT__) {
			return false;
		}

		YYLiveLog.release(YYLiveLog.kLogTagCall,
				"enableMute %b for %s", enable, uid);

		return YYLiveNative.enableMuteStringUid(enable, uid);
	}

	/**
	 * 全部静音
	 */
	public boolean enableAllMute(boolean enable){
		if (!BuildConfig.__YY_AUDIO_SUPPORT__) {
			return false;
		}

		YYLiveLog.release(YYLiveLog.kLogTagCall,
				"enableAllMute %b", enable);

		YYLiveNative.enableAllMute(enable);

		return true;
	}

	/**
	 * 设置播放音量， 实际播放的音量通过监听通知{@link YYLiveNotification#kYYLiveAPINotification_AudioPlayVolume}获取
	 *
	 * @param volume 音量值，取值范围[0,100]
	 * @param stream 音频流
	 * @return 成功or失败
	 */
	public boolean setPlayVolume(int volume, YYLiveStream stream) {
		if (!BuildConfig.__YY_AUDIO_SUPPORT__) {
			return false;
		}
		if (stream == null) {
			return false;
		}

		if (volume < 0) {
			volume  = 0;
		} else if (volume > 100) {
			volume = 100;
		}

		YYLiveLog.release(YYLiveLog.kLogTagCall,
				"setPlayVolume %d for stream %s", volume, stream.streamName);

		return YYLiveNative.setStreamPlayVolume(volume, stream);
	}

	/**
	 * 设置扬声器音量
	 * @param volume
	 * @return
	 */
	public boolean setSpeakerVolume(int volume){
		if (!BuildConfig.__YY_AUDIO_SUPPORT__) {
			return false;
		}

		if (volume < 0) {
			volume  = 0;
		} else if (volume > 100) {
			volume = 100;
		}

		YYLiveLog.release(YYLiveLog.kLogTagCall, "setSpeakerVolume %d", volume);

		return YYLiveNative.setSpeakerVolume(volume);
	}

	/**
	 * 切换扬声器模式和听筒模式，SDK默认为扬声器模式，此接口不影响耳机的使用，插入耳机时，声音均通过耳机播放
	 *
	 * @param enable true - 扬声器模式; false - 听筒模式
	 */
	public void enableLoudSpeaker(boolean enable) {
		YYLiveLog.release(YYLiveLog.kLogTagCall, "enableLoudSpeaker %b", enable);
		YYLiveNative.enableLoudSpeaker(enable);
	}

	/**
	 * 获取扬声器状态
	 * @return
	 */
	public boolean getLoudSpeakerEnabled(){
		YYLiveLog.release(YYLiveLog.kLogTagCall, "getLoudSpeakerEnabled");
		return YYLiveNative.getLoudSpeakerEnabled();
	}


	public boolean isSupportPlayH265(){
		return YYLiveNative.isSupportPlayH265();
	}

	public void setSubscribeStreamWHByUid(long uid, int _width, int _height) {
		for (YYLiveStream oneStream : subscribeStreams) {
			if(oneStream.bVideo && oneStream.speakerUid == uid) {
				oneStream.width = _width;
				oneStream.height = _height;
			}
		}
	}

	public YYLiveStream getSubscribeStreamByUid(long uid) {
		for (YYLiveStream oneStream : subscribeStreams) {
			if(oneStream.bVideo && oneStream.speakerUid == uid) {
				return oneStream;
			}
		}
		return null;
	}

	public void removeSubscribeStreamByUid(long uid) {
		YYLiveStream findStream = null;
		for (YYLiveStream oneStream : subscribeStreams) {
			if(oneStream.bVideo && oneStream.speakerUid == uid) {
				findStream = oneStream;
			}
		}
		if(findStream != null) {
			subscribeStreams.remove(findStream);
		}
	}
}
