package com.yy.yylivesdk4cloud;

import android.view.MotionEvent;

import com.yy.yylivesdk4cloud.helper.YYLiveLog;

/**
 * Created by xiaojun on 2018/4/10.
 * Copyright (c) 2017 YY Inc. All rights reserved.
 */
public class YYLiveDefaultCamera extends YYLiveVideoCapture {
	/**
	 * 摄像头采集回调
	 */
	public interface IYYLiveDefaultCameraDataCallback {
		/**
		 * 纹理回调，外部对纹理处理不能切换线程，注意处理耗时
		 * @param textureId 纹理ID
		 * @param width 图形宽
		 * @param height 图形高
		 * @return 返回经过第三方处理后的问题ID
		 */
		int onTextureCallback(int textureId, int width, int height);
	}

	private YYPreviewConfig mCaptureConfig;
	private IYYLiveDefaultCameraDataCallback mCameraDataCallback;

	/**
	 * 禁止从外部创建摄像头对象，通过接口获取 {@link YYLivePublisher#getDefaluteCamera()}
	 */
	YYLiveDefaultCamera() {
		mCaptureConfig = new YYPreviewConfig(YYPreviewConfig.YYPREVIEW_MODE_NORMAL);
		mCameraDataCallback = null;
	}

	public void setCaptureConfig(YYPreviewConfig config) {
		if (config == null) {
			config = new YYPreviewConfig(YYPreviewConfig.YYPREVIEW_MODE_NORMAL);
		}
		YYLiveLog.release(YYLiveLog.kLogTagCall, "setCaptureConfig config:%s", config.toString());
		mCaptureConfig = config;

	}

	public void setCameraDataCallback(IYYLiveDefaultCameraDataCallback callback) {
		synchronized (this) {
			mCameraDataCallback = callback;
		}
	}

	public IYYLiveDefaultCameraDataCallback getCameraDataCallback() {
		synchronized (this) {
			return mCameraDataCallback;
		}
	}

	/**
	 * 判断当前打开的摄像头是否支持zoom功能
	 * @return
	 */
	public boolean isCameraZoomSupport() {
		return YYLiveBridgeLib.getInstance().isCameraZoomSupport();
	}

	/**
	 * 获取当前打开摄像头的最大zoom参数
	 * @return
	 */
	public int getCameraMaxZoom() {
		return YYLiveBridgeLib.getInstance().getCameraMaxZoom();
	}


	/**
	 * 设置当前摄像头的zoom参数
	 * @param zoom 目标zoom参数
	 * @return 设置后 实际的zoom参数
	 */
	public float setCameraZoom(final int zoom) {

		return YYLiveBridgeLib.getInstance().setCameraZoom(zoom);
	}

	/**
	 * 聚焦以及测光
	 * @param event
	 */
	public void handleFocusMetering(final MotionEvent event) {
		YYLiveBridgeLib.getInstance().handleFocusMetering(event);
	}

	@Override
	public void startCapture(YYLivePublisher.IVideoPublisher publisher) {

	}

	@Override
	public void stopCapture() {

	}

	@Override
	public YYVideoCaptureConfig getCaptureConfig() {
		return mCaptureConfig;
	}
}
