package com.yy.yylivesdk4cloud;

import android.util.Log;
import java.util.HashMap;
import com.yy.yylivesdk4cloud.helper.YYLiveNative;

public class TransConfigManager implements ITransConfigCallbackInterface {
    private final static String TAG = "cfg_TransConfigManage";
    private final static String ARGO_CONFIG_KEY_COMMON_CONFIG = "TransCommonConfig";
    public final static String[] ARGO_CONFIG_KEYS = {
            ARGO_CONFIG_KEY_COMMON_CONFIG,
    };
    private ITransJsonParseInterface mTransJsonParseImp;

    private TransConfigManager() {
        mTransJsonParseImp = new TransJsonParseImp(this);
    }

    private static class SingletonHolder {
        private static final TransConfigManager INSTANCE = new TransConfigManager();
    }

    public static TransConfigManager instance() {
        return SingletonHolder.INSTANCE;
    }

    public void onConfig(String key, String config) {
        if (key == null || config == null || config.isEmpty()) {
            return;
        }
        Log.d(TAG, " onConfig " + key + " : " + config);
        switch (key) {
            case ARGO_CONFIG_KEY_COMMON_CONFIG:
                mTransJsonParseImp.parseCommonConfig(config);
                break;
            default:
                break;
        }
    }

    @Override
    public void notifyCommonConfigResult(HashMap<Integer, Integer> result) {
        if (result == null || result.isEmpty()) {
            return;
        }
        YYLiveNative.setArgoConfig(result);
    }

}
