package com.yy.yylivesdk4cloud;

import com.yy.yylivesdk4cloud.helper.YYLiveLog;

public class ExternalVideoSource extends YYLiveVideoCapture {

    IVideoSource mVideoSource = null;
    YYLivePublisher.IVideoPublisher mPublisher = null;

    public ExternalVideoSource(IVideoSource videoSource) {
        mVideoSource = videoSource;
    }


    @Override
    public void startCapture(YYLivePublisher.IVideoPublisher proxy) {
        mPublisher = proxy;
        if (mVideoSource != null) {

            mVideoSource.onInitialize(new IVideoFrameConsumer() {
                @Override
                public void consumeByteArrayFrame(byte[] data, int format, int width, int height, int rotation, long timestamp) {
                    if (mPublisher != null) {
                        mPublisher.pushVideoData(data, format, width, height, rotation, timestamp);
                    }
                }
            });

            mVideoSource.onStart();
        } else {
            YYLiveLog.info(YYLiveLog.kLogTagRtcEngine, "warning,  need set videoSource...");
        }
    }

    @Override
    public void stopCapture() {
        if (mVideoSource != null) {
            mVideoSource.onStop();
            mVideoSource.onDispose();
        } else {
            YYLiveLog.info(YYLiveLog.kLogTagRtcEngine, "warning,  need set videoSource...");
        }
    }

    @Override
    public YYVideoCaptureConfig getCaptureConfig() {
        return null;
    }
}
