/*
 * Decompiled with CFR 0.152.
 */
package com.yy.udbauth.log;

import android.os.Process;
import android.util.Log;
import com.yy.udbauth.log.LogHelper;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.IllegalFormatException;

public class ALog {
    public static final String TAG = "udbauthJ";
    public static final int LOG_LEVEL_VERBOSE = 6;
    public static final int LOG_LEVEL_DEBUG = 5;
    public static final int LOG_LEVEL_INFO = 4;
    public static final int LOG_LEVEL_WARM = 3;
    public static final int LOG_LEVEL_ERROR = 2;
    public static final int LOG_LEVEL_ASSERT = 1;
    private static final boolean OUTPUT_TO_LOGCAT = true;
    private static final boolean OUTPUT_TO_FILE = true;

    public static void v(Object obj, String format, Object ... args) {
        try {
            String msg = String.format(format, args);
            int line = ALog.getCallerLineNumber();
            String filename = ALog.getCallerFilename();
            String methodname = ALog.getCallerMethodName();
            String logText = ALog.getMsgForTextLog(obj, methodname, filename, line, msg);
            Log.v((String)TAG, (String)logText);
            ALog.writeToFile(6, logText);
        }
        catch (IllegalFormatException e) {
            e.printStackTrace();
        }
    }

    public static void d(Object obj, String format, Object ... args) {
        try {
            String msg = String.format(format, args);
            int line = ALog.getCallerLineNumber();
            String filename = ALog.getCallerFilename();
            String methodname = ALog.getCallerMethodName();
            String logText = ALog.getMsgForTextLog(obj, methodname, filename, line, msg);
            Log.d((String)TAG, (String)logText);
        }
        catch (IllegalFormatException e) {
            e.printStackTrace();
        }
    }

    public static void i(Object obj, String format, Object ... args) {
        try {
            String msg = String.format(format, args);
            int line = ALog.getCallerLineNumber();
            String filename = ALog.getCallerFilename();
            String methodname = ALog.getCallerMethodName();
            String logText = ALog.getMsgForTextLog(obj, methodname, filename, line, msg);
            Log.i((String)TAG, (String)logText);
            ALog.writeToFile(4, logText);
        }
        catch (IllegalFormatException e) {
            e.printStackTrace();
        }
    }

    public static void i(Object obj, String msg) {
        try {
            int line = ALog.getCallerLineNumber();
            String filename = ALog.getCallerFilename();
            String methodname = ALog.getCallerMethodName();
            String logText = ALog.getMsgForTextLog(obj, methodname, filename, line, msg);
            Log.i((String)TAG, (String)logText);
            ALog.writeToFile(4, logText);
        }
        catch (IllegalFormatException e) {
            e.printStackTrace();
        }
    }

    public static void w(Object obj, String format, Object ... args) {
        try {
            String msg = String.format(format, args);
            int line = ALog.getCallerLineNumber();
            String filename = ALog.getCallerFilename();
            String methodname = ALog.getCallerMethodName();
            String logText = ALog.getMsgForTextLog(obj, methodname, filename, line, msg);
            Log.w((String)TAG, (String)logText);
            ALog.writeToFile(3, logText);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void w(Object obj, String msg) {
        try {
            int line = ALog.getCallerLineNumber();
            String filename = ALog.getCallerFilename();
            String methodname = ALog.getCallerMethodName();
            String logText = ALog.getMsgForTextLog(obj, methodname, filename, line, msg);
            Log.w((String)TAG, (String)logText);
            ALog.writeToFile(3, logText);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void e(Object obj, String format, Object ... args) {
        try {
            String msg = String.format(format, args);
            int line = ALog.getCallerLineNumber();
            String filename = ALog.getCallerFilename();
            String methodname = ALog.getCallerMethodName();
            String logText = ALog.getMsgForTextLog(obj, methodname, filename, line, msg);
            Log.e((String)TAG, (String)logText);
            ALog.writeToFile(2, logText);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void e(Object obj, String msg) {
        try {
            int line = ALog.getCallerLineNumber();
            String filename = ALog.getCallerFilename();
            String methodname = ALog.getCallerMethodName();
            String logText = ALog.getMsgForTextLog(obj, methodname, filename, line, msg);
            Log.e((String)TAG, (String)logText);
            ALog.writeToFile(2, logText);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void e(Object obj, Throwable t) {
        try {
            int line = ALog.getCallerLineNumber();
            String filename = ALog.getCallerFilename();
            String methodname = ALog.getCallerMethodName();
            String logText = ALog.getMsgForException(obj, methodname, filename, line);
            Log.e((String)TAG, (String)logText, (Throwable)t);
            ALog.writeToFile(2, logText);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String stackTraceOf(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    public static String threadStack() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        for (StackTraceElement e : Thread.currentThread().getStackTrace()) {
            pw.println(e.toString());
        }
        return sw.toString();
    }

    private static String objClassName(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return obj.getClass().getSimpleName();
    }

    private static String getMsgForException(Object obj, String methodname, String filename, int line) {
        StringBuilder sb = new StringBuilder();
        sb.append(" Exception occurs at ");
        sb.append("(P/T:");
        sb.append(Process.myPid());
        sb.append("/");
        sb.append(Thread.currentThread().getId());
        sb.append(",");
        sb.append(ALog.objClassName(obj));
        sb.append(",");
        sb.append(filename);
        sb.append(":");
        sb.append(line);
        sb.append(",");
        sb.append(methodname);
        sb.append("())");
        return sb.toString();
    }

    private static String getMsgForTextLog(Object obj, String methodname, String filename, int line, String msg) {
        StringBuilder sb = new StringBuilder();
        sb.append(msg);
        sb.append("\t(P/T:");
        sb.append(Process.myPid());
        sb.append("/");
        sb.append(Thread.currentThread().getId());
        sb.append(",");
        sb.append(ALog.objClassName(obj));
        sb.append(",");
        sb.append(filename);
        sb.append(":");
        sb.append(line);
        sb.append(",");
        sb.append(methodname);
        sb.append("())");
        return sb.toString();
    }

    private static void writeToFile(int level, String logText) {
        LogHelper.getInstance().logToFile(logText);
    }

    private static int getCallerLineNumber() {
        return Thread.currentThread().getStackTrace()[4].getLineNumber();
    }

    private static String getCallerFilename() {
        return Thread.currentThread().getStackTrace()[4].getFileName();
    }

    private static String getCallerMethodName() {
        return Thread.currentThread().getStackTrace()[4].getMethodName();
    }

    public static String convertLevelInt2String(int logLevel) {
        if (2 == logLevel) {
            return "E";
        }
        if (3 == logLevel) {
            return "W";
        }
        if (4 == logLevel) {
            return "I";
        }
        if (5 == logLevel) {
            return "D";
        }
        if (6 == logLevel) {
            return "V";
        }
        if (1 == logLevel) {
            return "A";
        }
        return "";
    }
}

