/*
 * Decompiled with CFR 0.152.
 */
package com.yy.udbauth;

import android.content.Context;
import com.yy.udbauth.AuthJNI;
import com.yy.udbauth.AuthSDK;
import com.yy.udbauth.IUdbAuthCallback;

public class UdbAuthSDKProxy {
    public boolean init(Context context, String appId, String appKey) {
        boolean success = AuthSDK.init(context, appId, appKey, "0", false, "0");
        if (success) {
            success = AuthJNI.instance().initLibrary(1, 1, "".getBytes());
        }
        return success;
    }

    public void setIUdbAuthCallback(IUdbAuthCallback callback) {
        AuthJNI.instance().setIUdbAuthCallback(callback);
    }

    public IUdbAuthCallback getIUdbAuthCallback() {
        return AuthJNI.instance().getIUdbAuthCallback();
    }

    public boolean sendRequestToAuth(byte[] json) {
        try {
            if (AuthJNI.instance().initSuccess()) {
                AuthJNI.sendRequest(json);
                return true;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean handleResponseByAuth(byte[] data) {
        try {
            if (AuthJNI.instance().initSuccess()) {
                AuthJNI.handleResponse(data);
                return true;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return false;
    }

    public void setNetStatus(int netState) {
        try {
            if (AuthJNI.instance().initSuccess()) {
                AuthJNI.setNetStatus(netState);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void syncServerTime(int serverTime) {
        try {
            if (AuthJNI.instance().initSuccess()) {
                AuthJNI.syncServerTime(serverTime);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void reAuth() {
        try {
            if (AuthJNI.instance().initSuccess()) {
                AuthJNI.reAuth();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void logout() {
        try {
            if (AuthJNI.instance().initSuccess()) {
                AuthJNI.logout();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AuthNetState {
        UDBAUTH_NETSTATUS_UNKNOW,
        UDBAUTH_NETSTATUS_CLOSE,
        UDBAUTH_NETSTATUS_CONNECTING,
        UDBAUTH_NETSTATUS_READY,
        UDBAUTH_NETSTATUS_RECONNECTING,
        UDBAUTH_NETSTATUS_ERROR;

    }
}

