/*
 * Decompiled with CFR 0.152.
 */
package com.yy.udbauth;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Base64;
import com.yy.udbauth.AuthRequest;
import com.yy.udbauth.Global;
import com.yy.udbauth.log.ALog;
import com.yy.udbauth.log.LogHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AuthEvent {
    private static final int json_err_code = -11501;
    private static final String json_err_desc = "\u89e3\u6790\u6570\u636e\u5931\u8d25";
    private static final int timeout_err_code = -99;
    static boolean useSeparateTimeoutEvent = true;

    protected static AuthBaseEvent toAuthEvent(byte[] authData) {
        int length;
        AuthBaseEvent base = new AuthBaseEvent();
        base.unmarshall(authData);
        if (base.opCmd() == 6) {
            TimeoutEvent et = new TimeoutEvent();
            et.unmarshall(authData);
            if (useSeparateTimeoutEvent) {
                return et;
            }
            return AuthEvent.switchTimeoutEvent(et);
        }
        switch (base.opCmd()) {
            case 1: {
                LoginEvent et = new LoginEvent();
                et.unmarshall(authData);
                return et;
            }
            case 2: {
                SendSmsEvent et = new SendSmsEvent();
                et.unmarshall(authData);
                return et;
            }
            case 3: {
                RefreshPicEvent et = new RefreshPicEvent();
                et.unmarshall(authData);
                return et;
            }
            case 4: {
                QueryEvent et = new QueryEvent();
                et.unmarshall(authData);
                return et;
            }
            case 5: {
                AnonymousEvent et = new AnonymousEvent();
                et.unmarshall(authData);
                return et;
            }
            case 6: {
                TimeoutEvent et = new TimeoutEvent();
                et.unmarshall(authData);
                return et;
            }
            case 7: {
                CreditRenewEvent et = new CreditRenewEvent();
                et.unmarshall(authData);
                return et;
            }
            case 8: {
                VerifySmsCodeEvent et = new VerifySmsCodeEvent();
                et.unmarshall(authData);
                return et;
            }
            case 9: {
                RegisterEvent et = new RegisterEvent();
                et.unmarshall(authData);
                return et;
            }
            case 10: {
                CheckModPwdEvent et = new CheckModPwdEvent();
                et.unmarshall(authData);
                return et;
            }
            case 11: {
                SmsModPwdEvent et = new SmsModPwdEvent();
                et.unmarshall(authData);
                return et;
            }
            case 12: {
                CheckRegisterEvent et = new CheckRegisterEvent();
                et.unmarshall(authData);
                return et;
            }
            case 14: {
                QRCodeCheckEvent et = new QRCodeCheckEvent();
                et.unmarshall(authData);
                return et;
            }
            case 15: {
                QRCodeConfirmEvent et = new QRCodeConfirmEvent();
                et.unmarshall(authData);
                return et;
            }
            case 16: {
                QRCodeCancelEvent et = new QRCodeCancelEvent();
                et.unmarshall(authData);
                return et;
            }
            case 100: {
                OpenCheckAppEvent et = new OpenCheckAppEvent();
                et.unmarshall(authData);
                return et;
            }
            case 101: {
                OpenLoginEvent et = new OpenLoginEvent();
                et.unmarshall(authData);
                return et;
            }
            case 18: {
                GetMultiOnlineListEvent et = new GetMultiOnlineListEvent();
                et.unmarshall(authData);
                return et;
            }
        }
        int n = length = authData == null ? -1 : authData.length;
        if (length > 0) {
            ALog.e(AuthEvent.class, "authsdk toAuthEvent failed with content:%s", new String(authData));
        }
        return null;
    }

    private static AuthBaseEvent switchTimeoutEvent(TimeoutEvent timeoutEvent) {
        int reqOpCmd = -1;
        String context = timeoutEvent.context;
        try {
            reqOpCmd = Integer.parseInt(timeoutEvent.op_cmd);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        switch (reqOpCmd) {
            case 1: 
            case 2: 
            case 3: 
            case 11: 
            case 13: 
            case 14: {
                LoginEvent et = new LoginEvent();
                et.errCode = -99;
                et.description = timeoutEvent.description;
                et.uiAction = 1;
                et.context = context;
                return et;
            }
            case 4: {
                SendSmsEvent et = new SendSmsEvent();
                et.errCode = -99;
                et.description = timeoutEvent.description;
                et.uiAction = 1;
                et.context = context;
                return et;
            }
            case 7: {
                RefreshPicEvent et = new RefreshPicEvent();
                et.errCode = -99;
                et.description = timeoutEvent.description;
                et.uiAction = 1;
                et.context = context;
                return et;
            }
            case 8: {
                QueryEvent et = new QueryEvent();
                et.errCode = -99;
                et.description = timeoutEvent.description;
                et.context = context;
                return et;
            }
            case 19: {
                AnonymousEvent et = new AnonymousEvent();
                et.errCode = -99;
                et.description = timeoutEvent.description;
                et.uiAction = 1;
                et.context = context;
                return et;
            }
            case 12: {
                VerifySmsCodeEvent et = new VerifySmsCodeEvent();
                et.errCode = -99;
                et.description = timeoutEvent.description;
                et.uiAction = 1;
                et.context = context;
                return et;
            }
            case 5: {
                if (AuthRequest.RegisterReq.isRegisterReq(timeoutEvent.detail)) {
                    RegisterEvent et = new RegisterEvent();
                    et.errCode = -99;
                    et.description = timeoutEvent.description;
                    et.uiAction = 1;
                    et.context = context;
                    return et;
                }
                if (AuthRequest.SmsRegloginReq.isSmsRegloginReq(timeoutEvent.detail)) {
                    LoginEvent et = new LoginEvent();
                    et.errCode = -99;
                    et.description = timeoutEvent.description;
                    et.uiAction = 1;
                    et.context = context;
                    return et;
                }
            }
            case 16: {
                CheckModPwdEvent et = new CheckModPwdEvent();
                et.errCode = -99;
                et.description = timeoutEvent.description;
                et.uiAction = 1;
                et.context = context;
                return et;
            }
            case 6: 
            case 9: {
                SmsModPwdEvent et = new SmsModPwdEvent();
                et.errCode = -99;
                et.description = timeoutEvent.description;
                et.uiAction = 1;
                et.context = context;
                return et;
            }
            case 17: {
                CheckRegisterEvent et = new CheckRegisterEvent();
                et.errCode = -99;
                et.description = timeoutEvent.description;
                et.uiAction = 1;
                et.context = context;
                return et;
            }
            case 20: {
                QRCodeCheckEvent et = new QRCodeCheckEvent();
                et.errCode = -99;
                et.description = timeoutEvent.description;
                et.uiAction = 1;
                et.context = context;
                return et;
            }
            case 21: {
                QRCodeConfirmEvent et = new QRCodeConfirmEvent();
                et.errCode = -99;
                et.description = timeoutEvent.description;
                et.uiAction = 1;
                et.context = context;
                return et;
            }
            case 22: {
                QRCodeCancelEvent et = new QRCodeCancelEvent();
                et.errCode = -99;
                et.description = timeoutEvent.description;
                et.uiAction = 1;
                et.context = context;
                return et;
            }
            case 100: {
                OpenCheckAppEvent et = new OpenCheckAppEvent();
                et.errCode = -99;
                et.description = timeoutEvent.description;
                et.uiAction = 1;
                et.context = context;
                return et;
            }
            case 101: 
            case 102: {
                OpenLoginEvent et = new OpenLoginEvent();
                et.errCode = -99;
                et.description = timeoutEvent.description;
                et.uiAction = 1;
                et.context = context;
                return et;
            }
            case 25: {
                GetMultiOnlineListEvent et = new GetMultiOnlineListEvent();
                et.errCode = -99;
                et.context = context;
                return et;
            }
        }
        return null;
    }

    public static class GetMultiOnlineListEvent
    extends AuthBaseEvent {
        private static final long serialVersionUID = 63241791231344323L;
        public static final int OP_CMD = 18;
        public int errCode;
        public String context;
        public ArrayList<OnlineItem> onlineItems = null;

        public int opCmd() {
            return 18;
        }

        public void unmarshall(byte[] buf) {
            JSONObject son;
            super.unmarshall(buf);
            JSONObject parent = this.getParentJsonObject();
            JSONObject jSONObject = son = parent == null ? null : parent.optJSONObject("get_multi_login_res");
            if (parent == null || son == null) {
                this.errCode = -11501;
                return;
            }
            this.errCode = son.optInt("errcode");
            this.context = son.optString("context");
            this.onlineItems = new ArrayList();
            JSONArray jsonOnlineitems = son.optJSONArray("onlineitem");
            if (jsonOnlineitems != null) {
                for (int i = 0; i < jsonOnlineitems.length(); ++i) {
                    JSONObject temp = jsonOnlineitems.optJSONObject(i);
                    if (temp == null) continue;
                    OnlineItem nv = new OnlineItem();
                    nv.yyuid = temp.optString("yyuid");
                    nv.serverid = temp.optString("serverid");
                    nv.uptime = temp.optInt("uptime");
                    nv.ip = temp.optInt("ip");
                    nv.deviceInfo = temp.optString("deviceinfo");
                    nv.clientapp = temp.optString("clientapp");
                    nv.clientver = temp.optString("clientver");
                    this.onlineItems.add(nv);
                }
            }
        }
    }

    public static class OnlineItem
    implements Serializable {
        public String yyuid;
        public String serverid;
        public int uptime;
        public int ip;
        public String deviceInfo;
        public String clientapp;
        public String clientver;
    }

    public static class OpenLoginEvent
    extends AuthBaseEvent {
        private static final long serialVersionUID = -5793167123773932482L;
        public static final int OP_CMD = 101;
        public int errCode;
        public String description;
        public String user;
        public String uid;
        public String yyid;
        public String passport;
        public String mobileMask;
        public String emailMask;
        public String credit;
        public boolean isNewUser = false;
        public boolean needModifyPassword = false;
        public int appType;
        public String openid;
        public String accessCode;
        public String thirdPartyCredit;
        public ArrayList<NextVerify> nextVerifies = null;
        public int uiAction;
        public String context;

        public int opCmd() {
            return 101;
        }

        public String getContext() {
            return this.context;
        }

        public String getUid() {
            return this.uid;
        }

        public String getUser() {
            return this.user;
        }

        public Bitmap getPictureCodeBitmap() {
            if (this.nextVerifies == null) {
                return null;
            }
            for (NextVerify nv : this.nextVerifies) {
                if (nv.strategy != 1) continue;
                return nv.getPictureCodeBitmap();
            }
            return null;
        }

        public void unmarshall(byte[] buf) {
            JSONObject son;
            super.unmarshall(buf);
            JSONObject parent = this.getParentJsonObject();
            JSONObject jSONObject = son = parent == null ? null : parent.optJSONObject("login_res_auth");
            if (parent == null || son == null || !son.has("uiaction")) {
                this.errCode = -11501;
                this.description = AuthEvent.json_err_desc;
                this.uiAction = 1;
                this.uid = null;
                this.yyid = null;
                this.passport = null;
                this.mobileMask = null;
                this.credit = null;
                this.context = null;
                this.nextVerifies = null;
                this.accessCode = null;
                this.thirdPartyCredit = null;
                return;
            }
            this.errCode = son.optInt("errcode");
            this.description = son.optString("description");
            this.uiAction = son.optInt("uiaction");
            this.uid = son.optString("uid");
            this.yyid = son.optString("yyid");
            this.passport = son.optString("passport");
            this.mobileMask = son.optString("mobile_mask");
            this.emailMask = son.optString("email_mask");
            this.credit = son.optString("credit");
            this.isNewUser = "1".equals(son.optString("new_user"));
            this.needModifyPassword = "1".equals(son.optString("need_modpwd"));
            this.thirdPartyCredit = son.optString("3rd_credit");
            this.appType = son.optInt("app_type");
            this.openid = son.optString("openid");
            this.accessCode = son.optString("access_code");
            this.context = son.optString("context");
            this.nextVerifies = new ArrayList();
            JSONArray next_verify = son.optJSONArray("next_verify");
            if (next_verify != null) {
                for (int i = 0; i < next_verify.length(); ++i) {
                    JSONObject temp = next_verify.optJSONObject(i);
                    if (temp == null) continue;
                    NextVerify nv = new NextVerify();
                    nv.strategy = temp.optInt("strategy");
                    nv.selectTitle = temp.optString("select_title");
                    nv.promptTitle = temp.optString("prompt_title");
                    nv.promptContent = temp.optString("prompt_content");
                    nv.dataType = temp.optInt("data_type");
                    nv.data = temp.optString("data");
                    this.nextVerifies.add(nv);
                }
            }
        }
    }

    public static class OpenCheckAppEvent
    extends AuthBaseEvent {
        private static final long serialVersionUID = 63241791231674323L;
        public static final int OP_CMD = 100;
        public int errCode;
        public String description;
        public int uiAction;
        public String appName;
        public String appIcon;
        public boolean hasAuth;
        public int appType;
        public String context;

        public int opCmd() {
            return 100;
        }

        public void unmarshall(byte[] buf) {
            JSONObject son;
            super.unmarshall(buf);
            JSONObject parent = this.getParentJsonObject();
            JSONObject jSONObject = son = parent == null ? null : parent.optJSONObject("app_check_res");
            if (parent == null || son == null) {
                this.errCode = -11501;
                this.description = AuthEvent.json_err_desc;
                this.uiAction = 1;
                return;
            }
            this.errCode = son.optInt("errcode");
            this.description = son.optString("description");
            this.uiAction = son.optInt("uiaction");
            this.appName = son.optString("app_name");
            this.appIcon = son.optString("app_icon");
            this.hasAuth = "1".equals(son.optString("app_authed"));
            this.appType = son.optInt("app_type");
            this.context = son.optString("context");
        }
    }

    public static class TimeoutEvent
    extends AuthBaseEvent {
        private static final long serialVersionUID = -5840156307025829903L;
        public static final int OP_CMD = 6;
        public String context;
        public int uiAction;
        private String op_cmd;
        public String detail;
        public String description;

        public int opCmd() {
            return 6;
        }

        public String getContext() {
            return this.context;
        }

        public void unmarshall(byte[] buf) {
            JSONObject son;
            super.unmarshall(buf);
            JSONObject parent = this.getParentJsonObject();
            JSONObject jSONObject = son = parent == null ? null : parent.optJSONObject("timeout");
            if (parent == null || son == null) {
                this.context = null;
                return;
            }
            this.uiAction = son.optInt("uiaction");
            this.description = son.optString("description");
            this.detail = son.optString("detail");
            this.context = son.optString("context");
            this.op_cmd = son.optString("op_cmd");
            String detailMsg = String.format(Locale.getDefault(), "timeout desc:%s, detail:%s", this.description, this.detail);
            LogHelper.getInstance().logToDBForCommon("lg_client_log", 3, Global.getAppId(), "", "", this.op_cmd, null, this.context, "0", detailMsg);
        }
    }

    public static class AnonymousEvent
    extends AuthBaseEvent {
        private static final long serialVersionUID = -7783307654193055887L;
        public static final int OP_CMD = 5;
        public int errCode;
        public String description;
        public String uid;
        public String yyid;
        public String passport;
        public String passwdSha1;
        public String picData;
        public int uiAction;
        public String context;

        public int opCmd() {
            return 5;
        }

        public String getUid() {
            return this.uid;
        }

        public Bitmap getPictureCodeBitmap() {
            if (this.picData == null) {
                return null;
            }
            Bitmap bitmap = null;
            try {
                byte[] pic_data = Base64.decode((String)this.picData, (int)0);
                bitmap = BitmapFactory.decodeByteArray((byte[])pic_data, (int)0, (int)pic_data.length);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return bitmap;
        }

        public void unmarshall(byte[] buf) {
            JSONObject son;
            super.unmarshall(buf);
            JSONObject parent = this.getParentJsonObject();
            JSONObject jSONObject = son = parent == null ? null : parent.optJSONObject("anonymous_res");
            if (parent == null || son == null || !son.has("uiaction")) {
                this.errCode = -11501;
                this.description = AuthEvent.json_err_desc;
                this.uiAction = 1;
                this.uid = null;
                this.yyid = null;
                this.passport = null;
                return;
            }
            this.errCode = son.optInt("errcode");
            this.description = son.optString("description");
            this.uiAction = son.optInt("uiaction");
            this.uid = son.optString("uid");
            this.yyid = son.optString("yyid");
            this.passport = son.optString("passport");
            this.passwdSha1 = son.optString("password");
            this.picData = son.optString("pic");
            this.context = son.optString("context");
        }
    }

    public static class QRCodeCancelEvent
    extends AuthBaseEvent {
        private static final long serialVersionUID = 12435363254668L;
        public static final int OP_CMD = 16;
        public int errCode;
        public String description;
        public int uiAction;
        public String context;

        public int opCmd() {
            return 16;
        }

        public void unmarshall(byte[] buf) {
            JSONObject son;
            super.unmarshall(buf);
            JSONObject parent = this.getParentJsonObject();
            JSONObject jSONObject = son = parent == null ? null : parent.optJSONObject("qrcode_cancel_res");
            if (parent == null || son == null) {
                this.errCode = -11501;
                this.description = AuthEvent.json_err_desc;
                this.uiAction = 1;
                return;
            }
            this.errCode = son.optInt("errcode");
            this.description = son.optString("description");
            this.uiAction = son.optInt("uiaction");
            this.context = son.optString("context");
        }
    }

    public static class QRCodeConfirmEvent
    extends AuthBaseEvent {
        private static final long serialVersionUID = 2134567860141668L;
        public static final int OP_CMD = 15;
        public int errCode;
        public String description;
        public int uiAction;
        public String context;

        public int opCmd() {
            return 15;
        }

        public void unmarshall(byte[] buf) {
            JSONObject son;
            super.unmarshall(buf);
            JSONObject parent = this.getParentJsonObject();
            JSONObject jSONObject = son = parent == null ? null : parent.optJSONObject("qrcode_confirm_res");
            if (parent == null || son == null) {
                this.errCode = -11501;
                this.description = AuthEvent.json_err_desc;
                this.uiAction = 1;
                return;
            }
            this.errCode = son.optInt("errcode");
            this.description = son.optString("description");
            this.uiAction = son.optInt("uiaction");
            this.context = son.optString("context");
        }
    }

    public static class QRCodeCheckEvent
    extends AuthBaseEvent {
        private static final long serialVersionUID = 328843360141668L;
        public static final int OP_CMD = 14;
        public int errCode;
        public String description;
        public int uiAction;
        public String authAppId;
        public String authAppInfo;
        public String pcContext;
        public String passport;
        public String context;

        public int opCmd() {
            return 14;
        }

        public void unmarshall(byte[] buf) {
            JSONObject son;
            super.unmarshall(buf);
            JSONObject parent = this.getParentJsonObject();
            JSONObject jSONObject = son = parent == null ? null : parent.optJSONObject("qrcode_check_res");
            if (parent == null || son == null) {
                this.errCode = -11501;
                this.description = AuthEvent.json_err_desc;
                this.uiAction = 1;
                this.authAppId = null;
                this.authAppInfo = null;
                this.pcContext = null;
                this.passport = null;
                this.context = null;
                return;
            }
            this.errCode = son.optInt("errcode");
            this.description = son.optString("description");
            this.uiAction = son.optInt("uiaction");
            this.authAppId = son.optString("appid_auth");
            this.authAppInfo = son.optString("appinfo_auth");
            this.pcContext = son.optString("pc_context");
            this.passport = son.optString("passort");
            this.context = son.optString("context");
        }
    }

    @Deprecated
    public static class CreditRenewEvent
    extends AuthBaseEvent {
        private static final long serialVersionUID = 7288254494360141668L;
        public static final int OP_CMD = 7;
        public String uid;
        public String yyid;
        public String passport;
        public String credit;

        public int opCmd() {
            return 7;
        }

        public String getUid() {
            return this.uid;
        }

        public void unmarshall(byte[] buf) {
            JSONObject son;
            super.unmarshall(buf);
            JSONObject parent = this.getParentJsonObject();
            JSONObject jSONObject = son = parent == null ? null : parent.optJSONObject("credit_renew");
            if (parent == null || son == null) {
                this.uid = null;
                this.yyid = null;
                this.passport = null;
                this.credit = null;
                return;
            }
            this.uid = son.optString("uid");
            this.yyid = son.optString("yyid");
            this.passport = son.optString("passport");
            this.credit = son.optString("credit");
        }
    }

    public static class QueryEvent
    extends AuthBaseEvent {
        private static final long serialVersionUID = 8986369062898690362L;
        public static final int OP_CMD = 4;
        public int errCode;
        public String description;
        public String errMsg;
        public String appid;
        public String token;
        public String otp;
        public String context;

        public int opCmd() {
            return 4;
        }

        public String getContext() {
            return this.context;
        }

        public void unmarshall(byte[] buf) {
            JSONObject son;
            super.unmarshall(buf);
            JSONObject parent = this.getParentJsonObject();
            JSONObject jSONObject = son = parent == null ? null : parent.optJSONObject("query_res");
            if (parent == null || son == null) {
                this.errCode = -11501;
                this.description = AuthEvent.json_err_desc;
                this.appid = null;
                this.token = null;
                this.otp = null;
                this.context = null;
                return;
            }
            this.errCode = son.optInt("errcode");
            this.description = son.optString("description");
            this.errMsg = son.optString("errmsg");
            this.appid = son.optString("appid");
            this.token = son.optString("token");
            this.otp = son.optString("otp");
            this.context = son.optString("context");
        }
    }

    public static class RefreshPicEvent
    extends AuthBaseEvent {
        private static final long serialVersionUID = 6944767824313949482L;
        public static final int OP_CMD = 3;
        public int errCode;
        public String description;
        public String pic;
        public int uiAction;
        public String context;

        public int opCmd() {
            return 3;
        }

        public String getContext() {
            return this.context;
        }

        public Bitmap getPictureCodeBitmap() {
            Bitmap bitmap = null;
            try {
                byte[] pic_data = Base64.decode((String)this.pic, (int)0);
                bitmap = BitmapFactory.decodeByteArray((byte[])pic_data, (int)0, (int)pic_data.length);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return bitmap;
        }

        public void unmarshall(byte[] buf) {
            JSONObject son;
            super.unmarshall(buf);
            JSONObject parent = this.getParentJsonObject();
            JSONObject jSONObject = son = parent == null ? null : parent.optJSONObject("refreshpic_res");
            if (parent == null || son == null || !son.has("uiaction")) {
                this.errCode = -11501;
                this.description = AuthEvent.json_err_desc;
                this.uiAction = 1;
                this.pic = null;
                this.context = null;
                return;
            }
            this.errCode = son.optInt("errcode");
            this.description = son.optString("description");
            this.uiAction = son.optInt("uiaction");
            this.pic = son.optString("pic");
            this.context = son.optString("context");
        }
    }

    public static class CheckRegisterEvent
    extends AuthBaseEvent {
        private static final long serialVersionUID = 1435840643431877558L;
        public static final int OP_CMD = 12;
        public int errCode;
        public String description;
        public int uiAction;
        public String context;

        public int opCmd() {
            return 12;
        }

        public String getContext() {
            return this.context;
        }

        public void unmarshall(byte[] buf) {
            JSONObject son;
            super.unmarshall(buf);
            JSONObject parent = this.getParentJsonObject();
            JSONObject jSONObject = son = parent == null ? null : parent.optJSONObject("check_reg_res");
            if (parent == null || son == null || !son.has("uiaction")) {
                this.errCode = -11501;
                this.description = AuthEvent.json_err_desc;
                this.uiAction = 1;
                this.context = null;
                return;
            }
            this.errCode = son.optInt("errcode");
            this.description = son.optString("description");
            this.uiAction = son.optInt("uiaction");
            this.context = son.optString("context");
        }
    }

    public static class CheckModPwdEvent
    extends AuthBaseEvent {
        private static final long serialVersionUID = 1435840643431856670L;
        public static final int OP_CMD = 10;
        public int errCode;
        public String description;
        public int uiAction;
        public String mobileMask;
        public String emailMask;
        public String url;
        public boolean isLoginMobile = false;
        public String context;

        public int opCmd() {
            return 10;
        }

        public String getContext() {
            return this.context;
        }

        public void unmarshall(byte[] buf) {
            JSONObject son;
            super.unmarshall(buf);
            JSONObject parent = this.getParentJsonObject();
            JSONObject jSONObject = son = parent == null ? null : parent.optJSONObject("check_modpwd_res");
            if (parent == null || son == null || !son.has("uiaction")) {
                this.errCode = -11501;
                this.description = AuthEvent.json_err_desc;
                this.uiAction = 1;
                this.context = null;
                this.mobileMask = null;
                this.emailMask = null;
                this.url = null;
                this.isLoginMobile = false;
                return;
            }
            this.errCode = son.optInt("errcode");
            this.description = son.optString("description");
            this.mobileMask = son.optString("mobile_mask");
            this.emailMask = son.optString("email_mask");
            this.url = son.optString("url");
            this.isLoginMobile = "1".equals(son.optString("is_login_mobile"));
            this.uiAction = son.optInt("uiaction");
            this.context = son.optString("context");
        }
    }

    public static class RegisterEvent
    extends AuthBaseEvent {
        private static final long serialVersionUID = 3860264007062893452L;
        public static final int OP_CMD = 9;
        public int errCode;
        public String description;
        public int uiAction;
        public String user;
        public String uid;
        public String yyid;
        public String passport;
        public String context;

        public int opCmd() {
            return 9;
        }

        public String getContext() {
            return this.context;
        }

        public String getUid() {
            return this.uid;
        }

        public String getUser() {
            return this.user;
        }

        public void unmarshall(byte[] buf) {
            JSONObject son;
            super.unmarshall(buf);
            JSONObject parent = this.getParentJsonObject();
            JSONObject jSONObject = son = parent == null ? null : parent.optJSONObject("register_res");
            if (parent == null || son == null || !son.has("uiaction")) {
                this.errCode = -11501;
                this.description = AuthEvent.json_err_desc;
                this.uiAction = 1;
                this.context = null;
                this.uid = null;
                this.yyid = null;
                this.passport = null;
                return;
            }
            this.errCode = son.optInt("errcode");
            this.description = son.optString("description");
            this.uid = son.optString("uid");
            this.yyid = son.optString("yyid");
            this.passport = son.optString("passport");
            this.uiAction = son.optInt("uiaction");
            this.context = son.optString("context");
        }
    }

    public static class VerifySmsCodeEvent
    extends AuthBaseEvent {
        private static final long serialVersionUID = 2349204824162301847L;
        public static final int OP_CMD = 8;
        public int errCode;
        public String description;
        public int uiAction;
        public String context;

        public int opCmd() {
            return 8;
        }

        public String getContext() {
            return this.context;
        }

        public void unmarshall(byte[] buf) {
            JSONObject son;
            super.unmarshall(buf);
            JSONObject parent = this.getParentJsonObject();
            JSONObject jSONObject = son = parent == null ? null : parent.optJSONObject("verify_smscode_res");
            if (parent == null || son == null || !son.has("uiaction")) {
                this.errCode = -11501;
                this.description = AuthEvent.json_err_desc;
                this.uiAction = 1;
                this.context = null;
                return;
            }
            this.errCode = son.optInt("errcode");
            this.description = son.optString("description");
            this.uiAction = son.optInt("uiaction");
            this.context = son.optString("context");
        }
    }

    public static class SendSmsEvent
    extends AuthBaseEvent {
        private static final long serialVersionUID = -5490440308837193652L;
        public static final int OP_CMD = 2;
        public int errCode;
        public String description;
        public ArrayList<NextVerify> nextVerifies = null;
        public boolean isUserExist = true;
        public int uiAction;
        public String context;

        public int opCmd() {
            return 2;
        }

        public String getContext() {
            return this.context;
        }

        public Bitmap getPictureCodeBitmap() {
            if (this.nextVerifies == null) {
                return null;
            }
            for (NextVerify nv : this.nextVerifies) {
                if (nv.strategy != 1) continue;
                return nv.getPictureCodeBitmap();
            }
            return null;
        }

        public void unmarshall(byte[] buf) {
            JSONObject son;
            super.unmarshall(buf);
            JSONObject parent = this.getParentJsonObject();
            JSONObject jSONObject = son = parent == null ? null : parent.optJSONObject("sendsms_res");
            if (parent == null || son == null || !son.has("uiaction")) {
                this.errCode = -11501;
                this.description = AuthEvent.json_err_desc;
                this.uiAction = 1;
                this.context = null;
                this.nextVerifies = null;
                return;
            }
            this.errCode = son.optInt("errcode");
            this.description = son.optString("description");
            this.uiAction = son.optInt("uiaction");
            this.isUserExist = 0 != son.optInt("is_user_exist", 999);
            this.context = son.optString("context");
            this.nextVerifies = new ArrayList();
            JSONArray next_verify = son.optJSONArray("next_verify");
            if (next_verify != null) {
                for (int i = 0; i < next_verify.length(); ++i) {
                    JSONObject temp = next_verify.optJSONObject(i);
                    if (temp == null) continue;
                    NextVerify nv = new NextVerify();
                    nv.strategy = temp.optInt("strategy");
                    nv.selectTitle = temp.optString("select_title");
                    nv.promptTitle = temp.optString("prompt_title");
                    nv.promptContent = temp.optString("prompt_content");
                    nv.dataType = temp.optInt("data_type");
                    nv.data = temp.optString("data");
                    this.nextVerifies.add(nv);
                }
            }
        }
    }

    public static class SmsModPwdEvent
    extends AuthBaseEvent {
        private static final long serialVersionUID = -496199085361871679L;
        public static final int OP_CMD = 11;
        public int errCode;
        public String description;
        public String user;
        public String uid;
        public String yyid;
        public String passport;
        public String mobileMask;
        public String emailMask;
        public String credit;
        public int uiAction;
        public String context;

        public int opCmd() {
            return 11;
        }

        public String getContext() {
            return this.context;
        }

        public String getUid() {
            return this.uid;
        }

        public String getUser() {
            return this.user;
        }

        public LoginEvent toLoginEvent() {
            LoginEvent et = new LoginEvent();
            et.errCode = this.errCode;
            et.description = this.description;
            et.user = this.user;
            et.uid = this.uid;
            et.yyid = this.yyid;
            et.passport = this.passport;
            et.mobileMask = this.mobileMask;
            et.emailMask = this.emailMask;
            et.credit = this.credit;
            et.isNewUser = false;
            et.needModifyPassword = false;
            et.nextVerifies = null;
            et.thirdPartyInfo = null;
            et.uiAction = this.uiAction;
            et.context = this.context;
            return et;
        }

        public void unmarshall(byte[] buf) {
            JSONObject son;
            super.unmarshall(buf);
            JSONObject parent = this.getParentJsonObject();
            JSONObject jSONObject = son = parent == null ? null : parent.optJSONObject("modpwd_res");
            if (parent == null || son == null || !son.has("uiaction")) {
                this.errCode = -11501;
                this.description = AuthEvent.json_err_desc;
                this.uiAction = 1;
                this.uid = null;
                this.yyid = null;
                this.passport = null;
                this.mobileMask = null;
                this.credit = null;
                this.context = null;
                return;
            }
            this.errCode = son.optInt("errcode");
            this.description = son.optString("description");
            this.uiAction = son.optInt("uiaction");
            this.uid = son.optString("uid");
            this.yyid = son.optString("yyid");
            this.passport = son.optString("passport");
            this.mobileMask = son.optString("mobile_mask");
            this.emailMask = son.optString("email_mask");
            this.credit = son.optString("credit");
            this.context = son.optString("context");
        }
    }

    public static class LoginEvent
    extends AuthBaseEvent {
        private static final long serialVersionUID = -5793167123773932482L;
        public static final int OP_CMD = 1;
        public int errCode;
        public String description;
        public String user;
        public String uid;
        public String yyid;
        public String passport;
        public String mobileMask;
        public String emailMask;
        public String credit;
        public boolean isNewUser = false;
        public boolean needModifyPassword = false;
        public ArrayList<NextVerify> nextVerifies = null;
        public ThirdPartyInfo thirdPartyInfo;
        public int uiAction;
        public String context;

        public int opCmd() {
            return 1;
        }

        public String getContext() {
            return this.context;
        }

        public String getUid() {
            return this.uid;
        }

        public String getUser() {
            return this.user;
        }

        public Bitmap getPictureCodeBitmap() {
            if (this.nextVerifies == null) {
                return null;
            }
            for (NextVerify nv : this.nextVerifies) {
                if (nv.strategy != 1) continue;
                return nv.getPictureCodeBitmap();
            }
            return null;
        }

        public void unmarshall(byte[] buf) {
            JSONObject third;
            JSONObject son;
            super.unmarshall(buf);
            JSONObject parent = this.getParentJsonObject();
            JSONObject jSONObject = son = parent == null ? null : parent.optJSONObject("login_res");
            if (parent == null || son == null || !son.has("uiaction")) {
                this.errCode = -11501;
                this.description = AuthEvent.json_err_desc;
                this.uiAction = 1;
                this.uid = null;
                this.yyid = null;
                this.passport = null;
                this.mobileMask = null;
                this.credit = null;
                this.context = null;
                this.nextVerifies = null;
                this.thirdPartyInfo = null;
                return;
            }
            this.errCode = son.optInt("errcode");
            this.description = son.optString("description");
            this.uiAction = son.optInt("uiaction");
            this.uid = son.optString("uid");
            this.yyid = son.optString("yyid");
            this.passport = son.optString("passport");
            this.mobileMask = son.optString("mobile_mask");
            this.emailMask = son.optString("email_mask");
            this.credit = son.optString("credit");
            this.isNewUser = "1".equals(son.optString("new_user"));
            this.needModifyPassword = "1".equals(son.optString("need_modpwd"));
            this.context = son.optString("context");
            this.nextVerifies = new ArrayList();
            JSONArray next_verify = son.optJSONArray("next_verify");
            if (next_verify != null) {
                for (int i = 0; i < next_verify.length(); ++i) {
                    JSONObject temp = next_verify.optJSONObject(i);
                    if (temp == null) continue;
                    NextVerify nv = new NextVerify();
                    nv.strategy = temp.optInt("strategy");
                    nv.selectTitle = temp.optString("select_title");
                    nv.promptTitle = temp.optString("prompt_title");
                    nv.promptContent = temp.optString("prompt_content");
                    nv.dataType = temp.optInt("data_type");
                    nv.data = temp.optString("data");
                    this.nextVerifies.add(nv);
                }
            }
            if ((third = son.optJSONObject("3rd")) != null) {
                this.thirdPartyInfo = new ThirdPartyInfo();
                this.thirdPartyInfo.uid = third.optString("3rd_uid");
                this.thirdPartyInfo.nickname = third.optString("3rd_nickname");
                this.thirdPartyInfo.imageUrl = third.optString("3rd_img");
                this.thirdPartyInfo.gender = third.optString("3rd_gen");
                this.thirdPartyInfo.unionId = third.optString("3rd_unionid");
                this.thirdPartyInfo.openidYYuid = third.optString("busiYyuid");
                this.thirdPartyInfo.accessToken = third.optString("accessToken");
                this.thirdPartyInfo.accessExpires = third.optString("accessExpires");
                this.thirdPartyInfo.refreshToken = third.optString("refreshToken");
                this.thirdPartyInfo.reserve1 = third.optString("reserve1");
                this.thirdPartyInfo.reserve2 = third.optString("reserve2");
                this.thirdPartyInfo.reserve3 = third.optString("reserve3");
            }
        }
    }

    public static class AuthBaseEvent
    implements Serializable {
        private static final long serialVersionUID = 1428443204340701L;
        protected int OP_CMD = -1;
        protected int json_ver = 0;
        protected String json = "{}";
        private transient JSONObject mRootJsonObject = new JSONObject();

        protected JSONObject getParentJsonObject() {
            return this.mRootJsonObject;
        }

        protected int opCmd() {
            return this.OP_CMD;
        }

        public String getContext() {
            return null;
        }

        public String getUser() {
            return null;
        }

        public String getUid() {
            return null;
        }

        protected int getJsonVer() {
            return this.json_ver;
        }

        public void unmarshall(byte[] buf) {
            block2: {
                try {
                    this.json = new String(buf);
                    this.mRootJsonObject = new JSONObject(this.json);
                    this.OP_CMD = this.mRootJsonObject.optInt("op_cmd");
                    this.json_ver = this.mRootJsonObject.optInt("json_ver");
                }
                catch (JSONException e) {
                    int length;
                    e.printStackTrace();
                    this.OP_CMD = -1;
                    this.mRootJsonObject = null;
                    int n = length = buf == null ? -1 : buf.length;
                    if (length <= 0) break block2;
                    ALog.i(this, "AuthEvent unmarshall, json error with content: %s", new String(buf));
                }
            }
        }
    }

    public static class ThirdPartyInfo
    implements Serializable {
        private static final long serialVersionUID = 14111082204340701L;
        public String uid;
        public String nickname;
        public String imageUrl;
        public String gender;
        public String unionId;
        public String openidYYuid;
        public String accessToken;
        public String accessExpires;
        public String refreshToken;
        public String reserve1;
        public String reserve2;
        public String reserve3;
    }

    public static class NextVerify
    implements Serializable {
        private static final long serialVersionUID = 14282082204340701L;
        public int strategy = 0;
        public String selectTitle = "";
        public String promptTitle = "";
        public String promptContent = "";
        public String data;
        public int dataType;

        public Bitmap getPictureCodeBitmap() {
            Bitmap bitmap = null;
            try {
                byte[] pic_data = Base64.decode((String)this.data, (int)0);
                bitmap = BitmapFactory.decodeByteArray((byte[])pic_data, (int)0, (int)pic_data.length);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return bitmap;
        }

        public String getJSContent() {
            try {
                return new String(Base64.decode((String)this.data, (int)0));
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    public static interface UIAction {
        public static final int SUCCESS = 0;
        public static final int FAILED = 1;
        public static final int NEXT_VERIFY = 2;
        public static final int CREDIT_INVALID = 3;
        public static final int VERIFY_FAILED = 4;
        public static final int SERVER_HAS_NOT_RECEIVED_SMS = 5;
        public static final int OPEN_URL = 6;
    }

    public static interface OpCmd {
        public static final int OP_INVALID_EVENT = -1;
        public static final int OP_LOGIN_EVENT = 1;
        public static final int OP_SEND_SMS_EVENT = 2;
        public static final int OP_REFRESH_PIC_EVENT = 3;
        public static final int OP_QUERY_EVENT = 4;
        public static final int OP_ANONYMOUS_EVENT = 5;
        public static final int OP_TIME_OUT = 6;
        public static final int OP_CREDIT_RENEW = 7;
        public static final int OP_VERIFY_SMSCODE = 8;
        public static final int OP_REGISTER = 9;
        public static final int OP_CHECK_MOD_PWD = 10;
        public static final int OP_SMS_MOD_PWD = 11;
        public static final int OP_CHECK_REGISTER = 12;
        public static final int OP_CHECK_USER = 13;
        public static final int OP_QRCODE_CHECK = 14;
        public static final int OP_QRCODE_CONFIRM = 15;
        public static final int OP_QRCODE_CANCEL = 16;
        public static final int OP_GET_ONLINE_LIST = 18;
        public static final int OP_OPEN_APP_CHECK = 100;
        public static final int OP_OPEN_LOGIN = 101;
    }
}

