/*
 * Decompiled with CFR 0.152.
 */
package com.yy.open.agent;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.Signature;
import android.os.Build;
import android.os.Bundle;
import com.yy.open.agent.DeviceUtils;
import com.yy.open.agent.InnerUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.Locale;

public class OpenUtils {
    static final String DEFAULT_WEB_URL = "https://thirdlogin.yy.com/open_platform/guide.do";
    static final String DEFAULT_DOWNLOAD_URL = "http://www.yy.com/download";
    private static final String AGENT_ACTIVITY = "com.yy.udbauth.open.activity.AgentActivity";
    private static final String[][] mSupportAuthLoginApp = new String[][]{{"com.duowan.mobile", "7.10.0"}};
    static final String OpenAuthorizeUrl = "https://thirdlogin.yy.com/open/oauth/authorize.do";

    static String getDefaultWebUrl(Context context, String appid) {
        return String.format(Locale.getDefault(), "%s?platform=android&version=%s&sdkversion=%s&yyversion=%s&appid=%s", DEFAULT_WEB_URL, Build.VERSION.RELEASE, "1.0.0", OpenUtils.getTargetAppVersion(context), appid);
    }

    static String getTokenUrl(Context context, String appid, String token) {
        String appSign = OpenUtils.getAppSign(context);
        String authUrl = String.format(Locale.getDefault(), "%sappId=%s&appSign=%s&codeType=1&code=%s", "https://thirdlogin.yy.com/open/access_token.do?", appid, appSign, token);
        return authUrl;
    }

    static String getAuthorizeWebUrl(Context context, String appid, String state, boolean onlyWeb) {
        String appSign = OpenUtils.getAppSign(context);
        String appDeviceId = DeviceUtils.getDeviceId(context);
        String authUrl = String.format(Locale.getDefault(), "%s?appId=%s&appType=android&appSign=%s&appDeviceid=%s&grantType=code&callbackType=uri&redirectUri=%s&state=%s", OpenAuthorizeUrl, appid, appSign, appDeviceId, OpenUtils.getOpenAuthWebCallbackUrl(onlyWeb), state);
        return authUrl;
    }

    public static String getOpenAuthWebCallbackUrl(boolean onlyWeb) {
        if (onlyWeb) {
            return "http://raqweb.yy.com/";
        }
        return "http://raq.yy.com/";
    }

    static String getResultCodeReason(int resultCode) {
        switch (resultCode) {
            case 444111001: {
                return "\u6210\u529f";
            }
            case 444222000: {
                return "\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5";
            }
            case 444222001: {
                return "\u8bf7\u6c42\u64cd\u4f5c\u7c7b\u578b\u9519\u8bef";
            }
            case 444222002: {
                return "\u8bf7\u6c42\u64cd\u4f5c\u9644\u5e26\u53c2\u6570\u4e3a\u7a7a";
            }
            case 444222003: {
                return "\u8bf7\u6c42\u64cd\u4f5c\u9644\u5e26\u53c2\u6570\u9519\u8bef";
            }
            case 444222104: {
                return "\u6388\u6743APP\u8fd4\u56de\u7684\u8bf7\u6c42\u7801\u51fa\u9519";
            }
            case 444222105: {
                return "Json\u683c\u5f0f\u9519\u8bef";
            }
        }
        return "\u672a\u77e5\u9519\u8bef";
    }

    static Bundle getBundleForAuthLogin(Context context, String appid) {
        Bundle bundle = new Bundle();
        bundle.putString("appid", appid);
        bundle.putString("appname", InnerUtils.getAppName(context, context.getPackageName()));
        bundle.putString("appver", InnerUtils.getPackageAndVersion(context));
        bundle.putString("appdeviceid", DeviceUtils.getDeviceId(context));
        bundle.putString("appdeviceinfo", DeviceUtils.getDeviceInfo(context));
        bundle.putString("sdkver", "1.0.0");
        return bundle;
    }

    static Intent getIntentForAuthLogin(Context context) {
        for (String[] app : mSupportAuthLoginApp) {
            String packageName = app[0];
            Intent intent = new Intent();
            intent.setClassName(packageName, AGENT_ACTIVITY);
            if (!InnerUtils.isActivityExist(context, intent)) continue;
            return intent;
        }
        return null;
    }

    public static int checkAppForAuthLogin(Context context) {
        try {
            boolean targetAppExist = false;
            for (String[] app : mSupportAuthLoginApp) {
                if (app.length <= 1) continue;
                String packageName = app[0];
                String version = app[1];
                try {
                    PackageInfo info = context.getPackageManager().getPackageInfo(packageName, 1);
                    targetAppExist = true;
                    if (InnerUtils.compareVersion(info.versionName, version) < 0) continue;
                    Intent intent = new Intent();
                    intent.setClassName(packageName, AGENT_ACTIVITY);
                    if (!InnerUtils.isActivityExist(context, intent)) continue;
                    return 0;
                }
                catch (Exception ignore) {
                    targetAppExist = false;
                }
            }
            return targetAppExist ? 2 : 1;
        }
        catch (Exception e) {
            return 1;
        }
    }

    static String getTargetAppVersion(Context context) {
        for (String[] app : mSupportAuthLoginApp) {
            if (app.length <= 1) continue;
            String packageName = app[0];
            try {
                PackageInfo info = context.getPackageManager().getPackageInfo(packageName, 1);
                return info.versionName;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAppSign(Context context) {
        ByteArrayOutputStream bos = null;
        try {
            Signature[] signs = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)64).signatures;
            bos = new ByteArrayOutputStream();
            for (Signature s : signs) {
                if (s == null) continue;
                bos.write(s.toByteArray());
            }
            bos.flush();
            String string = OpenUtils.getMD5(bos.toByteArray());
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException iOException) {}
            }
        }
        return "";
    }

    private static String getMD5(byte[] data) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        String result = "";
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(data);
            byte[] md = digest.digest();
            int j = md.length;
            char[] str = new char[j * 2];
            int k = 0;
            for (byte byte0 : md) {
                str[k++] = hexDigits[byte0 >>> 4 & 0xF];
                str[k++] = hexDigits[byte0 & 0xF];
            }
            result = new String(str);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

