/*
 * Decompiled with CFR 0.152.
 */
package com.yy.udbauth.open.activity;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import com.yy.udbauth.log.ALog;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;

public class AgentActivity
extends Activity {
    private static final String FLAG_RESTART = "isRestart";

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        if (this.getIntent() == null) {
            this.setResult(444222000);
            this.finish();
            return;
        }
        ALog.d((Object)this, "onCreate", new Object[0]);
        if (savedInstanceState == null || !savedInstanceState.getBoolean(FLAG_RESTART)) {
            String action = this.getIntent().getStringExtra("action");
            int resultCode = this.getIntent().getIntExtra("request_code", 0);
            Bundle bundle = this.getIntent().getBundleExtra("bundle");
            if ("action_login".equals(action)) {
                this.handleLoginRequest(bundle, resultCode);
            } else {
                this.setResult(444222001);
                this.finish();
            }
        }
    }

    private void handleLoginRequest(Bundle bundle, int requestCode) {
        String packageName = this.getCallingPackage();
        String appSign = this.getAppSignatureMD5(packageName);
        bundle.putString("calling_package", packageName);
        bundle.putString("calling_sign", appSign);
        ComponentName cn = this.getTargetComponent();
        if (cn != null) {
            Intent intent = new Intent();
            intent.setComponent(this.getTargetComponent());
            intent.putExtra("bundle", bundle);
            this.startActivityForResult(intent, requestCode);
        } else {
            this.setResult(444222104);
            this.finish();
        }
    }

    private ComponentName getTargetComponent() {
        try {
            ActivityInfo info = this.getPackageManager().getActivityInfo(this.getComponentName(), 128);
            if (info.metaData != null) {
                String activityName = info.metaData.getString("target");
                return new ComponentName(this.getPackageName(), activityName);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        ALog.d((Object)this, "onActivityResult", new Object[0]);
        this.setResult(resultCode, data);
        this.finish();
    }

    public void onBackPressed() {
        this.setResult(444111002);
        super.onBackPressed();
        ALog.d((Object)this, "onBackPressed", new Object[0]);
    }

    protected void onSaveInstanceState(Bundle outState) {
        outState.putBoolean(FLAG_RESTART, true);
        super.onSaveInstanceState(outState);
        ALog.d((Object)this, "onSaveInstanceState", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAppSignatureMD5(String packageName) {
        ByteArrayOutputStream bos = null;
        try {
            Signature[] signs = this.getPackageManager().getPackageInfo((String)packageName, (int)64).signatures;
            bos = new ByteArrayOutputStream();
            for (Signature s : signs) {
                if (s == null) continue;
                bos.write(s.toByteArray());
            }
            bos.flush();
            String result = this.getMD5(bos.toByteArray());
            bos.close();
            String string = result;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException iOException) {}
            }
        }
        return "";
    }

    private String getMD5(byte[] data) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        String result = "";
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(data);
            byte[] md = digest.digest();
            int j = md.length;
            char[] str = new char[j * 2];
            int k = 0;
            for (byte byte0 : md) {
                str[k++] = hexDigits[byte0 >>> 4 & 0xF];
                str[k++] = hexDigits[byte0 & 0xF];
            }
            result = new String(str);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

