/*
 * Decompiled with CFR 0.152.
 */
package com.yy.udbauth.log;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.util.Log;
import com.yy.udbauth.AUtils;
import com.yy.udbauth.Global;
import com.yy.udbauth.log.ALog;
import com.yy.udbauth.log.DBLogManager;
import com.yy.udbauth.log.HttpLoader;
import com.yy.udbauth.log.MyHandler;
import com.yy.udbauth.rsa.RSAFactory;
import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONObject;

public class LogHelper {
    private static final String TAG = LogHelper.class.getSimpleName();
    public static final int LEVEL_INFO = 1;
    public static final int LEVEL_WARN = 2;
    public static final int LEVEL_ERROR = 3;
    public static final String LOG_TYPE_REG = "req_log";
    public static final String LOG_TYPE_CLIENT = "lg_client_log";
    public static final String LOG_TYPE_UI = "ui_log";
    private static String LOG_PATH = "/yysdk/";
    private static String LOG_FILE = "udbauth.txt";
    private static long MAX_LOG_FILE_SIZE = 0x100000L;
    private static LogHelper sLogHelper;
    private Handler mHandler;
    private SimpleDateFormat mDataFormat;
    private SimpleDateFormat mDataFormatForUpload;
    private File mLogFile;
    private DBLogManager mDBLogHelper;
    private Context mContext = null;
    private MyBroadcastReceiver mMyBroadcastReceiver;
    private volatile boolean isUploading = false;
    private MyHandler.OnHandlerListener mOnHandlerListener = new MyHandler.OnHandlerListener(){

        public void onInit() {
            try {
                File sdfile = Environment.getExternalStorageDirectory();
                String path = sdfile.getAbsolutePath() + LOG_PATH;
                boolean mounted = Environment.getExternalStorageState().equals("mounted");
                if (mounted) {
                    File dir = new File(path);
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    LogHelper.this.mLogFile = new File(path, LOG_FILE);
                    if (!LogHelper.this.mLogFile.exists()) {
                        LogHelper.this.mLogFile.createNewFile();
                    }
                } else {
                    LogHelper.this.mLogFile = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                LogHelper.this.mLogFile = null;
            }
        }

        public void onWriteToFile(Object text) {
            try {
                if (LogHelper.this.mLogFile == null) {
                    this.onInit();
                }
                if (LogHelper.this.mLogFile == null) {
                    return;
                }
                boolean append = LogHelper.this.mLogFile.length() < MAX_LOG_FILE_SIZE;
                FileWriter writer = new FileWriter(LogHelper.this.mLogFile, append);
                writer.append(LogHelper.this.mDataFormat.format(new Date()));
                writer.append(" ").append((String)text).append("\n");
                writer.flush();
                writer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void onWriteToDB(Object obj) {
            if (LogHelper.this.mDBLogHelper == null) {
                return;
            }
            if (obj instanceof JSONObject) {
                try {
                    JSONObject json = (JSONObject)obj;
                    JSONArray ja = new JSONArray();
                    ja.put((Object)json);
                    String mpubkey = "305C300D06092A864886F70D0101010500034B0030480241";
                    mpubkey = mpubkey + "00BA807F87C5B24465683959A43AEDDD7DE1D784800E8944";
                    mpubkey = mpubkey + "4E4B5C51D4946AEA8334560CDBB7BD610FC1085FC9C6F992";
                    mpubkey = mpubkey + "47A7F3BC5B172FEF3F353D24B2FF63E4E10203010001";
                    String cipherText = RSAFactory.getRSAForPublicKey(mpubkey).encode(ja.toString());
                    boolean success = false;
                    if (AUtils.isNetworkAvailable(LogHelper.this.mContext)) {
                        success = LogHelper.this.uploadLog(cipherText);
                        Log.d((String)TAG, (String)("upload:" + success));
                        if (!success) {
                            json.put("carrier_type", 1);
                            cipherText = RSAFactory.getRSAForPublicKey(mpubkey).encode(ja.toString());
                        }
                    }
                    if (!success) {
                        LogHelper.this.mDBLogHelper.insert(cipherText);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public void onUploadDB() {
            if (LogHelper.this.mDBLogHelper == null || LogHelper.this.isUploading || !AUtils.isNetworkAvailable(LogHelper.this.mContext)) {
                return;
            }
            final DBLogManager helper = LogHelper.this.mDBLogHelper;
            final List<DBLogManager.DataInfo> infos = helper.queryAll();
            if (infos == null || infos.size() <= 0) {
                return;
            }
            new Thread(new Runnable(){

                public void run() {
                    if (LogHelper.this.isUploading) {
                        return;
                    }
                    LogHelper.this.isUploading = true;
                    for (DBLogManager.DataInfo dataInfo : infos) {
                        try {
                            boolean success = LogHelper.this.uploadLog(dataInfo.data);
                            if (success) {
                                helper.delete(dataInfo.id);
                                continue;
                            }
                            helper.increaseAttemptTimes(dataInfo.id);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    LogHelper.this.isUploading = false;
                }
            }).start();
        }
    };

    private LogHelper() {
        HandlerThread ht = new HandlerThread("log_manager");
        ht.start();
        this.mHandler = new MyHandler(ht.getLooper(), this.mOnHandlerListener);
        this.mDataFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.getDefault());
        this.mDataFormatForUpload = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.getDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LogHelper getInstance() {
        if (sLogHelper != null) return sLogHelper;
        Class<LogHelper> clazz = LogHelper.class;
        synchronized (LogHelper.class) {
            sLogHelper = new LogHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sLogHelper;
        }
    }

    public void init(Context context) {
        this.mContext = context.getApplicationContext();
        if (this.mDBLogHelper == null) {
            this.mDBLogHelper = new DBLogManager(this.mContext);
        }
        if (this.mMyBroadcastReceiver == null) {
            this.mMyBroadcastReceiver = new MyBroadcastReceiver();
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
            this.mContext.registerReceiver((BroadcastReceiver)this.mMyBroadcastReceiver, filter);
        }
    }

    public void quit() {
        try {
            if (this.mHandler != null && this.mHandler.getLooper() != null) {
                this.mHandler.getLooper().quit();
            }
            if (this.mContext != null && this.mMyBroadcastReceiver != null) {
                this.mContext.unregisterReceiver((BroadcastReceiver)this.mMyBroadcastReceiver);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void uploadDB() {
        if (this.mHandler != null) {
            Message msg = Message.obtain();
            msg.what = 3;
            this.mHandler.sendMessage(msg);
        }
    }

    public void logToFile(String text) {
        if (this.mHandler != null) {
            Message msg = Message.obtain();
            msg.obj = text;
            msg.what = 1;
            this.mHandler.sendMessage(msg);
        }
    }

    public void logToDBOnError(String appid, String detail) {
        this.logToDB(3, appid, "", "", "", detail);
    }

    public void logToDB(int level, String appid, String user, String uid, String context, String detail) {
        this.logToDBWithDeviceError(level, AUtils.getDeviceId(this.mContext), appid, user, uid, context, detail);
    }

    public void logToDBWithDeviceError(int level, String device_id, String appid, String user, String uid, String context, String detail) {
        if (this.mDBLogHelper == null) {
            return;
        }
        try {
            JSONObject json = new JSONObject();
            json.put("type", (Object)LOG_TYPE_CLIENT);
            json.put("json_ver", (Object)"1");
            json.put("sys", (Object)"1");
            json.put("local_time", (Object)this.mDataFormatForUpload.format(new Date()));
            json.put("device_id", (Object)device_id);
            json.put("level", (Object)Integer.toString(level));
            json.put("appid", (Object)appid);
            json.put("user", (Object)user);
            json.put("user_type", AUtils.getType(user));
            json.put("uid", (Object)uid);
            json.put("context", (Object)context);
            json.put("detail", (Object)detail);
            json.put("app_ver", (Object)AUtils.getPackageAndVersion(Global.getContext()));
            json.put("carrier_type", AUtils.getCarrierType(Global.getContext()));
            json.put("auth_ver", (Object)Global.getVersion());
            Message msg = Message.obtain();
            msg.what = 2;
            msg.obj = json;
            this.mHandler.sendMessage(msg);
        }
        catch (Exception e) {
            e.printStackTrace();
            ALog.e((Object)this, TAG + " log to db error " + e.getMessage());
        }
    }

    public void logToDBForCommon(String type, int level, String appid, String user, String uid, String context, String rsp_time, String detail) {
        this.logToDBForCommon(type, level, appid, user, AUtils.getType(user), uid, null, null, context, rsp_time, detail);
    }

    public void logToDBForCommon(String type, int level, String appid, String user, String uid, String op_cmd, String strategy, String context, String rsp_time, String detail) {
        this.logToDBForCommon(type, level, appid, user, AUtils.getType(user), uid, op_cmd, strategy, context, rsp_time, detail);
    }

    public void logToDBForCommon(String type, int level, String appid, String user, int user_type, String uid, String op_cmd, String strategy, String context, String rsp_time, String detail) {
        if (this.mDBLogHelper == null) {
            return;
        }
        try {
            JSONObject json = new JSONObject();
            json.put("type", (Object)type);
            json.put("json_ver", (Object)"1");
            json.put("sys", (Object)"1");
            json.put("local_time", (Object)this.mDataFormatForUpload.format(new Date()));
            json.put("device_id", (Object)AUtils.getDeviceId(this.mContext));
            json.put("level", (Object)Integer.toString(level));
            json.put("appid", (Object)appid);
            json.put("user", (Object)user);
            json.put("user_type", (Object)Integer.toString(user_type));
            json.put("uid", (Object)uid);
            json.put("strategy", (Object)strategy);
            json.put("op_cmd", (Object)op_cmd);
            json.put("context", (Object)context);
            json.put("rsp_time", (Object)rsp_time);
            json.put("detail", (Object)detail);
            json.put("app_ver", (Object)AUtils.getPackageAndVersion(Global.getContext()));
            json.put("carrier_type", AUtils.getCarrierType(Global.getContext()));
            json.put("auth_ver", (Object)Global.getVersion());
            Message msg = Message.obtain();
            msg.what = 2;
            msg.obj = json;
            this.mHandler.sendMessage(msg);
        }
        catch (Exception e) {
            e.printStackTrace();
            ALog.e((Object)this, TAG + " log to db error " + e.getMessage());
        }
    }

    public void logToDBForCommon(int level, String appid, String user, int user_type, String uid, String op_cmd, String rsp_time, int rescode, String detail) {
        try {
            JSONObject json = new JSONObject();
            json.put("type", (Object)"open_log");
            json.put("json_ver", (Object)"1");
            json.put("sys", (Object)"1");
            json.put("local_time", (Object)this.mDataFormatForUpload.format(new Date()));
            json.put("device_id", (Object)AUtils.getDeviceId(this.mContext));
            json.put("level", (Object)Integer.toString(level));
            json.put("appid", (Object)appid);
            json.put("user", (Object)user);
            json.put("user_type", AUtils.getType(user));
            json.put("uid", (Object)uid);
            json.put("strategy", 0);
            json.put("op_cmd", (Object)op_cmd);
            json.put("context", (Object)"");
            json.put("rsp_time", (Object)rsp_time);
            json.put("rescode", rescode);
            json.put("detail", (Object)detail);
            json.put("app_ver", (Object)AUtils.getPackageAndVersion(this.mContext));
            json.put("carrier_type", AUtils.getCarrierType(this.mContext));
            json.put("auth_ver", (Object)"2.7.6-snapshot.3_d94ed947aaef8db06b8419f6728e5489f718b62a");
            Message msg = Message.obtain();
            msg.what = 2;
            msg.obj = json;
            this.mHandler.sendMessage(msg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean uploadLog(String data) {
        try {
            String url = "https://rpt.yy.com/report.do";
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("act", "webudbauthsdk");
            params.put("p", data);
            String result = HttpLoader.postData(url + "?act=webudbauthsdk", params);
            return new JSONObject(result).getBoolean("isSuccess");
        }
        catch (Exception e) {
            ALog.d(TAG, "uploadlog failed " + e.getMessage(), new Object[0]);
            return false;
        }
    }

    class MyBroadcastReceiver
    extends BroadcastReceiver {
        MyBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if ("android.net.conn.CONNECTIVITY_CHANGE".equals(intent.getAction()) && AUtils.isNetworkAvailable(LogHelper.this.mContext)) {
                LogHelper.this.mHandler.sendEmptyMessage(3);
            }
        }
    }
}

