/*
 * Decompiled with CFR 0.152.
 */
package com.yy.udbauth.rsa;

import com.yy.udbauth.rsa.RSAException;
import java.io.ByteArrayOutputStream;
import java.util.Locale;
import javax.crypto.Cipher;

public class RSAUtil {
    private static int m_nKeyBitsLen = 512;

    public static byte[] hex2byte(String strhex) {
        if (strhex == null) {
            return null;
        }
        int l = strhex.length();
        if (l % 2 != 0) {
            return null;
        }
        byte[] b = new byte[l / 2];
        for (int i = 0; i != l / 2; ++i) {
            b[i] = (byte)Integer.parseInt(strhex.substring(i * 2, i * 2 + 2), 16);
        }
        return b;
    }

    public static String byte2hex(byte[] b) {
        StringBuilder sb = new StringBuilder();
        for (byte aB : b) {
            String stmp = Integer.toHexString(aB & 0xFF);
            if (stmp.length() == 1) {
                sb.append("0");
            }
            sb.append(stmp);
        }
        return sb.toString().toUpperCase(Locale.getDefault());
    }

    public static String encrypt(byte[] aData) {
        return RSAUtil.byte2hex(aData);
    }

    public static byte[] decrypt(String sData) {
        return RSAUtil.hex2byte(sData);
    }

    public static byte[] chunkEncryptBlock(Cipher oCipher, byte[] aData) throws RSAException {
        int nBlockLen = 53;
        switch (RSAUtil.getKeyBitsLen()) {
            case 512: {
                nBlockLen = 53;
                break;
            }
            case 1024: {
                nBlockLen = 117;
            }
        }
        return RSAUtil.chunkBlock(oCipher, aData, nBlockLen);
    }

    public static byte[] chunkDecryptBlock(Cipher oCipher, byte[] aData) throws RSAException {
        int nBlockLen = 64;
        switch (RSAUtil.getKeyBitsLen()) {
            case 512: {
                nBlockLen = 64;
                break;
            }
            case 1024: {
                nBlockLen = 128;
            }
        }
        return RSAUtil.chunkBlock(oCipher, aData, nBlockLen);
    }

    private static byte[] chunkBlock(Cipher oCipher, byte[] aData, int nBlockLen) throws RSAException {
        try {
            int nDataLen = aData.length;
            ByteArrayOutputStream oOut = new ByteArrayOutputStream();
            int nOffSet = 0;
            int i = 0;
            while (nDataLen - nOffSet > 0) {
                byte[] aCache = nDataLen - nOffSet > nBlockLen ? oCipher.doFinal(aData, nOffSet, nBlockLen) : oCipher.doFinal(aData, nOffSet, nDataLen - nOffSet);
                oOut.write(aCache, 0, aCache.length);
                nOffSet = ++i * nBlockLen;
            }
            aData = oOut.toByteArray();
            oOut.close();
            return aData;
        }
        catch (Exception e) {
            throw new RSAException(e);
        }
    }

    public static int getKeyBitsLen() {
        return m_nKeyBitsLen;
    }
}

