/*
 * Decompiled with CFR 0.152.
 */
package com.yy.udbauth;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import com.yy.udbauth.AUtils;
import com.yy.udbauth.AuthEvent;
import com.yy.udbauth.AuthJNI;
import com.yy.udbauth.Global;
import com.yy.udbauth.log.LogHelper;
import java.io.File;
import org.json.JSONException;
import org.json.JSONObject;

public class AuthSDK {
    private static final byte[] slock = new byte[0];
    private static int sCounter = 0;
    private static volatile boolean sInitOK = false;
    private static MyBroadcastReceiver mMyBroadcastReceiver = null;

    public static boolean init(Context context, String appId, String appKey, String terminalType, boolean enableAnonymousLogin, String uid) {
        if (AuthSDK.initOK()) {
            return true;
        }
        String deviceId = null;
        try {
            Global.setContext(context.getApplicationContext());
            Global.setAppId(appId);
            Global.setAppKey(appKey);
            LogHelper.getInstance().init(context);
            if (mMyBroadcastReceiver == null) {
                mMyBroadcastReceiver = new MyBroadcastReceiver();
                IntentFilter filter = new IntentFilter();
                filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
                context.registerReceiver((BroadcastReceiver)mMyBroadcastReceiver, filter);
            }
            deviceId = AUtils.getDeviceId(context);
            File file = context.getDir("auth", 0);
            JSONObject json = new JSONObject();
            json.put("appid", (Object)appId);
            json.put("appkey", (Object)appKey);
            json.put("appver", (Object)AUtils.getPackageAndVersion(context));
            json.put("deviceid", (Object)deviceId);
            json.put("sdkver", (Object)"2.0.2");
            json.put("deviceinfo", (Object)AUtils.getDeviceInfo(context));
            json.put("devicename", (Object)(AUtils.getDeviceManufacturer() + " " + AUtils.getDeviceModel()));
            json.put("imei", (Object)AUtils.getIMEI(context));
            json.put("mac", (Object)AUtils.getMacAddress(context));
            json.put("platform", (Object)"0");
            json.put("lcid", (Object)"2052");
            json.put("mnc", (Object)AUtils.getMNC(context));
            json.put("mcc", (Object)AUtils.getMCC(context));
            json.put("systemver", (Object)AUtils.getOSVersionName());
            json.put("enableAnony", enableAnonymousLogin);
            json.put("terminaltype", (Object)terminalType);
            json.put("filepath", (Object)file.getAbsolutePath());
            json.put("uid", (Object)uid);
            if (deviceId == null) {
                json.put("libs", (Object)AUtils.getLibList(context));
                String msg = String.format("device_error:%s", json.toString());
                LogHelper.getInstance().logToDBWithDeviceError(3, "", appId, "", "", "", msg);
            }
            AuthJNI.instance().loadLibrary();
            sInitOK = AuthJNI.setUdbInfo(json.toString().getBytes());
            AuthJNI.instance();
            AuthJNI.insertVerifyAppid("yyim".getBytes());
            return sInitOK;
        }
        catch (JSONException e) {
            e.printStackTrace();
            LogHelper.getInstance().logToDBWithDeviceError(3, deviceId, appId, "", "", "", "auth_init_failed_by_json_err: " + e.getMessage() + ", libs:" + AUtils.getLibList(context));
        }
        catch (Throwable e) {
            e.printStackTrace();
            LogHelper.getInstance().logToDBWithDeviceError(3, deviceId, appId, "", "", "", "auth_init_failed_by_unknown_err : " + e.getMessage() + ", libs:" + AUtils.getLibList(context));
        }
        sInitOK = false;
        return false;
    }

    public static boolean initOK() {
        return sInitOK;
    }

    public static void setTimeoutMode(Mode mode) {
        if (mode == Mode.Separate) {
            AuthEvent.useSeparateTimeoutEvent = true;
        }
        if (mode == Mode.Merge) {
            AuthEvent.useSeparateTimeoutEvent = false;
        }
    }

    public static AuthEvent.AuthBaseEvent toAuthEvent(byte[] authData) {
        return AuthEvent.toAuthEvent(authData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateContext() {
        byte[] byArray = slock;
        synchronized (slock) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return Global.getAppId() + System.currentTimeMillis() + "_" + ++sCounter;
        }
    }

    public static String getPasswdSha1(String password) {
        return AUtils.getPasswdSha1(password);
    }

    public static String getQRLoginURL(String appid, String clientType, String cbkType, boolean encrypt) {
        try {
            byte[] temp;
            StringBuilder sb = new StringBuilder("https://lgn.yy.com/open/qrcode/init.do?");
            sb.append("encryptType=").append(encrypt ? 1 : 0);
            if (appid != null) {
                sb.append("&appid=").append(appid);
            }
            if (clientType != null) {
                sb.append("&clientType=").append(clientType);
            }
            if (cbkType != null) {
                sb.append("&cbkType=").append(cbkType);
            }
            if ((temp = AuthJNI.getDeviceData()) != null) {
                sb.append("&devmsg=").append(new String(temp));
            }
            return sb.toString();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getDeviceData() {
        try {
            return new String(AuthJNI.getDeviceData());
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String decodeQRLoginData(String loginData) {
        try {
            return new String(AuthJNI.decodeQRLoginData(loginData.getBytes()));
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getCredit(String uid) {
        try {
            return new String(AuthJNI.getCredit(uid.getBytes()));
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void clearCredit(String uid) {
        try {
            AuthJNI.clearCredit(uid.getBytes());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    public static byte[] getToken(String appid, int encode) {
        try {
            return AuthJNI.getToken(appid.getBytes(), encode);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getTokenByPassport(String passport, String appid) {
        try {
            return new String(AuthJNI.getTokenByPassport(passport.getBytes(), appid.getBytes(), 2));
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] getTokenByPassportB(String passport, String appid) {
        try {
            return AuthJNI.getTokenByPassport(passport.getBytes(), appid.getBytes(), 0);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getToken(String appid) {
        try {
            return new String(AuthJNI.getToken(appid.getBytes(), 2));
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] getTokenB(String appid) {
        try {
            return AuthJNI.getToken(appid.getBytes(), 0);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getToken2(String appid, String productid) {
        try {
            return new String(AuthJNI.getToken2(appid.getBytes(), 2, productid.getBytes()));
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] getTokenB2(String appid, String productid) {
        try {
            return AuthJNI.getToken2(appid.getBytes(), 0, productid.getBytes());
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getWebToken() {
        try {
            return new String(AuthJNI.getWebToken());
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getOTP(String appid) {
        try {
            return new String(AuthJNI.getOTP(appid.getBytes()));
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getOTP(String appid, String uid) {
        try {
            return new String(AuthJNI.getOTPByUid(appid.getBytes(), uid.getBytes()));
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] getYYCookies() {
        try {
            return AuthJNI.getYYCookies();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void insertVerifyAppid(String appid) {
        try {
            AuthJNI.insertVerifyAppid(appid.getBytes());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static String getSrvNameByUri(String uri) {
        try {
            return new String(AuthJNI.getSerNameApp(uri.getBytes()));
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    static class MyBroadcastReceiver
    extends BroadcastReceiver {
        MyBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            try {
                AuthJNI.setCarrierType(AUtils.getCarrierType(Global.getContext()));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        Merge,
        Separate;

    }
}

