/*
 * Decompiled with CFR 0.152.
 */
package com.yy.open.activity;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.DownloadListener;
import android.webkit.JavascriptInterface;
import android.webkit.SslErrorHandler;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.yy.open.agent.OpenUtils;
import org.json.JSONException;
import org.json.JSONObject;

public final class AssistActivity
extends Activity {
    public static final String TYPE_WEB = "type_web";
    public static final String EXTRA_TYPE = "type";
    public static final String EXTRA_URL = "url";
    FrameLayout mFrameLayout;
    WebView mWebView;
    TextView mTextView;
    MyProgressView mProgressView;
    String mURL;
    WebViewClient webviewClient = new WebViewClient(){

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            super.onPageStarted(view, url, favicon);
            AssistActivity.this.mProgressView.setVisibility(0);
            AssistActivity.this.mWebView.setVisibility(0);
            AssistActivity.this.mTextView.setVisibility(8);
        }

        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            AssistActivity.this.mProgressView.setVisibility(8);
        }

        public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
            super.onReceivedSslError(view, handler, error);
            handler.proceed();
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            if (AssistActivity.this.mURL.equals(failingUrl)) {
                AssistActivity.this.mTextView.setVisibility(0);
                AssistActivity.this.mWebView.setVisibility(4);
            }
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            if (url.startsWith(OpenUtils.getOpenAuthWebCallbackUrl(false))) {
                try {
                    Intent resultData = new Intent();
                    String resCode = Uri.parse((String)url).getQueryParameter("resCode");
                    String resMsg = Uri.parse((String)url).getQueryParameter("resMsg");
                    String appType = Uri.parse((String)url).getQueryParameter("appType");
                    if ("1".equals(appType)) {
                        String credit = Uri.parse((String)url).getQueryParameter("credit");
                        String uid = Uri.parse((String)url).getQueryParameter("uid");
                        JSONObject resultJson = new JSONObject();
                        resultJson.put("appType", (Object)appType);
                        resultJson.put("credit", (Object)credit);
                        resultJson.put("uid", (Object)uid);
                        resultJson.put("resCode", (Object)resCode);
                        resultJson.put("resMsg", (Object)resMsg);
                        resultData.putExtra("resjson", resultJson.toString());
                        if ("0".equals(resCode)) {
                            AssistActivity.this.setResult(444111001, resultData);
                        } else {
                            AssistActivity.this.setResult(444222104, resultData);
                        }
                    } else {
                        String accesscode = Uri.parse((String)url).getQueryParameter("access_code");
                        String openid = Uri.parse((String)url).getQueryParameter("openid");
                        JSONObject resultJson = new JSONObject();
                        resultJson.put("appType", (Object)appType);
                        resultJson.put("access_code", (Object)accesscode);
                        resultJson.put("openid", (Object)openid);
                        resultJson.put("resCode", (Object)resCode);
                        resultJson.put("resMsg", (Object)resMsg);
                        resultData.putExtra("resjson", resultJson.toString());
                        if ("0".equals(resCode)) {
                            AssistActivity.this.setResult(444111001, resultData);
                        } else {
                            AssistActivity.this.setResult(444222104, resultData);
                        }
                    }
                    AssistActivity.this.finish();
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                return true;
            }
            if (url.startsWith(OpenUtils.getOpenAuthWebCallbackUrl(true))) {
                try {
                    Intent resultData = new Intent();
                    String resCode = Uri.parse((String)url).getQueryParameter("resCode");
                    String resMsg = Uri.parse((String)url).getQueryParameter("resMsg");
                    String appType = Uri.parse((String)url).getQueryParameter("appType");
                    if ("1".equals(appType)) {
                        String credit = Uri.parse((String)url).getQueryParameter("token");
                        String uid = Uri.parse((String)url).getQueryParameter("yyuid");
                        JSONObject resultJson = new JSONObject();
                        resultJson.put("appType", (Object)appType);
                        resultJson.put("credit", (Object)credit);
                        resultJson.put("uid", (Object)uid);
                        resultJson.put("resCode", (Object)resCode);
                        resultJson.put("resMsg", (Object)resMsg);
                        resultData.putExtra("resjson", resultJson.toString());
                        if ("0".equals(resCode)) {
                            AssistActivity.this.setResult(444111003, resultData);
                        } else {
                            AssistActivity.this.setResult(444222106, resultData);
                        }
                    } else if ("2".equals(appType)) {
                        String token = Uri.parse((String)url).getQueryParameter("token");
                        JSONObject resultJson = new JSONObject();
                        resultJson.put("appType", (Object)appType);
                        resultJson.put("resCode", (Object)resCode);
                        resultJson.put("resMsg", (Object)resMsg);
                        resultJson.put("token", (Object)token);
                        resultData.putExtra("resjson", resultJson.toString());
                        if ("0".equals(resCode)) {
                            AssistActivity.this.setResult(444222108, resultData);
                        } else {
                            AssistActivity.this.setResult(444222110, resultData);
                        }
                    } else {
                        String accesscode = Uri.parse((String)url).getQueryParameter("access_code");
                        String openid = Uri.parse((String)url).getQueryParameter("openid");
                        JSONObject resultJson = new JSONObject();
                        resultJson.put("appType", (Object)appType);
                        resultJson.put("access_code", (Object)accesscode);
                        resultJson.put("openid", (Object)openid);
                        resultJson.put("resCode", (Object)resCode);
                        resultJson.put("resMsg", (Object)resMsg);
                        resultData.putExtra("resjson", resultJson.toString());
                        if ("0".equals(resCode)) {
                            AssistActivity.this.setResult(444111003, resultData);
                        } else {
                            AssistActivity.this.setResult(444222106, resultData);
                        }
                    }
                    AssistActivity.this.finish();
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                return true;
            }
            return false;
        }
    };
    WebChromeClient chromeClient = new WebChromeClient(){

        public void onProgressChanged(WebView view, int newProgress) {
            super.onProgressChanged(view, newProgress);
            AssistActivity.this.mProgressView.setProgress(newProgress);
        }
    };
    DownloadListener downloadListener = new DownloadListener(){

        public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimetype, long contentLength) {
            try {
                AssistActivity.this.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)url)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        this.requestWindowFeature(1);
        super.onCreate(savedInstanceState);
        this.mURL = this.getIntent().getStringExtra(EXTRA_URL);
        if (this.mURL == null) {
            Log.e((String)"YYOpenSdk", (String)"URL Cannot Be NULL");
            this.finish();
            return;
        }
        this.initView();
        this.initWebView();
    }

    private void initView() {
        this.mFrameLayout = new FrameLayout((Context)this);
        this.mFrameLayout.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.mProgressView = new MyProgressView((Context)this);
        this.mProgressView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, (int)(4.0 * (double)this.getResources().getDisplayMetrics().density), 48));
        this.mProgressView.setProgress(50);
        int padding = (int)(5.0 * (double)this.getResources().getDisplayMetrics().density);
        this.mTextView = new TextView((Context)this);
        this.mTextView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 17));
        this.mTextView.setPadding(padding * 2, padding * 3, padding * 2, padding * 3);
        this.mTextView.setBackgroundColor(-1728053248);
        this.mTextView.setTextColor(-1);
        this.mTextView.setText((CharSequence)"\u65e0\u6cd5\u8bbf\u95ee\uff0c\u8bf7\u7a0d\u5019\u91cd\u8bd5");
        this.mTextView.setVisibility(8);
        this.mTextView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AssistActivity.this.mWebView.loadUrl(AssistActivity.this.mURL);
            }
        });
        this.mWebView = new WebView((Context)this);
        this.mWebView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.mFrameLayout.addView((View)this.mWebView);
        this.mFrameLayout.addView((View)this.mProgressView);
        this.mFrameLayout.addView((View)this.mTextView);
        this.setContentView((View)this.mFrameLayout);
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void initWebView() {
        WebSettings settings = this.mWebView.getSettings();
        settings.setJavaScriptEnabled(true);
        settings.setSupportZoom(true);
        settings.setLoadWithOverviewMode(true);
        settings.setUseWideViewPort(true);
        settings.setBuiltInZoomControls(true);
        this.mWebView.setWebChromeClient(this.chromeClient);
        this.mWebView.setWebViewClient(this.webviewClient);
        this.mWebView.setDownloadListener(this.downloadListener);
        this.mWebView.addJavascriptInterface((Object)new WebBridge(), "WebBridge");
        this.mWebView.loadUrl(this.mURL);
    }

    public void onBackPressed() {
        Intent resultData = new Intent();
        this.setResult(0, resultData);
        super.onBackPressed();
    }

    class MyProgressView
    extends View {
        final int backgroundColor = -5657689;
        final int progressColor = -731575;
        int progress;
        Paint paint;

        public MyProgressView(Context context) {
            super(context);
            this.backgroundColor = -5657689;
            this.progressColor = -731575;
            this.paint = new Paint();
            this.paint.setColor(-731575);
            this.paint.setAntiAlias(true);
            this.paint.setStyle(Paint.Style.FILL);
        }

        protected void onSizeChanged(int w, int h, int oldw, int oldh) {
            super.onSizeChanged(w, h, oldw, oldh);
            this.invalidate();
        }

        protected void onDraw(Canvas canvas) {
            canvas.drawColor(-5657689);
            canvas.drawRect(0.0f, 0.0f, (float)this.progress / 100.0f * (float)this.getWidth(), (float)this.getHeight(), this.paint);
            super.onDraw(canvas);
        }

        public void setProgress(int progress) {
            this.progress = progress > 100 ? 100 : (progress < 0 ? 0 : progress);
            this.invalidate();
        }
    }

    class WebBridge {
        WebBridge() {
        }

        @JavascriptInterface
        public String toString() {
            return super.toString();
        }
    }
}

