/*
 * Decompiled with CFR 0.152.
 */
package com.yy.udbauth.log;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DBLogManager
extends SQLiteOpenHelper {
    private static final int DB_VERSION = 1;
    private static final String DB_NAME = "udbauthlooog";
    private static final String TABLE_NAME = "looog";
    private static final String F_ID = "id";
    private static final String F_DATA = "dd";
    private static final String F_TIME = "time";
    private static final int MAX_ATTEMPT_TIMES = 3;

    public DBLogManager(Context context) {
        this(context, DB_NAME, null, 1);
    }

    private DBLogManager(Context context, String name, SQLiteDatabase.CursorFactory factory, int version) {
        super(context, name, factory, version);
    }

    public void onCreate(SQLiteDatabase db) {
        this.createTable(db);
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        this.createTable(db);
    }

    private void createTable(SQLiteDatabase db) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("CREATE TABLE ").append(TABLE_NAME).append(" (");
            sb.append(F_ID).append(" INTEGER PRIMARY KEY AUTOINCREMENT, ");
            sb.append(F_DATA).append(" TEXT, ");
            sb.append(F_TIME).append(" INTEGER ) ");
            db.execSQL(sb.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void insert(String data) {
        try {
            if (data == null || data.length() <= 0) {
                return;
            }
            ContentValues values = new ContentValues();
            values.put(F_DATA, data);
            values.put(F_TIME, Integer.valueOf(0));
            this.getWritableDatabase().insert(TABLE_NAME, null, values);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void delete(int id) {
        try {
            this.getWritableDatabase().delete(TABLE_NAME, String.format(Locale.getDefault(), "%s=%d", F_ID, id), null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void increaseAttemptTimes(int id) {
        try {
            String sql = String.format(Locale.getDefault(), "select %s from %s where %s=%d", F_TIME, TABLE_NAME, F_ID, id);
            Cursor cursor = this.getWritableDatabase().rawQuery(sql, new String[0]);
            int times = -1;
            if (cursor.moveToFirst()) {
                times = cursor.getInt(cursor.getColumnIndex(F_TIME));
            }
            cursor.close();
            if (times == -1) {
                return;
            }
            if (times >= 3) {
                this.delete(id);
                return;
            }
            sql = String.format(Locale.getDefault(), "update %s set %s=%s+1 where %s=%d", TABLE_NAME, F_TIME, F_TIME, F_ID, id);
            this.getWritableDatabase().execSQL(sql);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<DataInfo> queryAll() {
        try {
            String sql = String.format("select * from %s ", TABLE_NAME);
            Cursor cursor = this.getReadableDatabase().rawQuery(sql, new String[0]);
            ArrayList<DataInfo> results = new ArrayList<DataInfo>();
            while (cursor.moveToNext()) {
                DataInfo i = new DataInfo();
                i.id = cursor.getInt(cursor.getColumnIndex(F_ID));
                i.data = cursor.getString(cursor.getColumnIndex(F_DATA));
                results.add(i);
            }
            cursor.close();
            return results;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<DataInfo>();
        }
    }

    public static class DataInfo {
        public int id;
        public String data;
    }
}

