/*
 * Decompiled with CFR 0.152.
 */
package com.yy.open.agent;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.util.SparseArray;
import com.yy.open.OnAuthorizeGoproListener;
import com.yy.open.OnUIListener;
import com.yy.open.UIError;
import com.yy.open.activity.AssistActivity;
import com.yy.open.activity.BridgeActivity;
import com.yy.open.agent.InnerUtils;
import com.yy.open.agent.OpenUtils;
import com.yy.open.utility.ThreadManager;
import com.yy.open.utility.YYOpenLog;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.json.JSONObject;

public final class AuthAgent {
    private SparseArray<Req> mUIListenerCache;
    private Handler mHandler;
    private Context mContext;
    private String mAppId;
    private final int MAX_RETRY_TIME = 2;
    private YYOpenLog mLog = YYOpenLog.sharedYYOpenLog();

    public AuthAgent(Context context, String appId) {
        this.mContext = context;
        this.mAppId = appId;
        this.mUIListenerCache = new SparseArray();
        this.mHandler = new Handler(Looper.getMainLooper());
    }

    @Deprecated
    public final void authorize(Activity activity, OnUIListener listener) {
        if (!InnerUtils.isActivityDeclared((Context)activity, BridgeActivity.class) || !InnerUtils.isActivityDeclared((Context)activity, AssistActivity.class)) {
            this.handleError(new UIError(3), listener);
            return;
        }
        int checkResult = OpenUtils.checkAppForAuthLogin((Context)activity);
        if (checkResult != 0) {
            try {
                String url;
                if (checkResult == 2) {
                    int resCode = 3;
                    url = OpenUtils.getDefaultWebUrl(this.mContext, this.mAppId);
                } else {
                    int resCode = 2;
                    url = "http://www.yy.com/download";
                }
                Intent intent = new Intent((Context)activity, AssistActivity.class);
                intent.putExtra("type", "type_web");
                intent.putExtra("url", url);
                activity.startActivity(intent);
            }
            catch (Exception ignore) {
                this.handleError(new UIError(checkResult), listener);
            }
            return;
        }
        Intent authIntent = OpenUtils.getIntentForAuthLogin((Context)activity);
        this.mUIListenerCache.put(62345, (Object)new Req(listener));
        Bundle bundle = OpenUtils.getBundleForAuthLogin((Context)activity, this.mAppId);
        authIntent.putExtra("action", "action_login");
        authIntent.putExtra("bundle", bundle);
        this.startBridgeActivity(activity, authIntent, 62345);
    }

    public final void authorize(Activity activity, String state, OnUIListener listener) {
        if (!InnerUtils.isActivityDeclared((Context)activity, BridgeActivity.class) || !InnerUtils.isActivityDeclared((Context)activity, AssistActivity.class)) {
            this.handleError(new UIError(3), listener);
            return;
        }
        int checkResult = OpenUtils.checkAppForAuthLogin((Context)activity);
        if (checkResult != 0) {
            try {
                if (checkResult == 2) {
                    int resCode = 3;
                } else {
                    int resCode = 2;
                }
                this.mUIListenerCache.put(62345, (Object)new Req(listener));
                String authUrl = OpenUtils.getAuthorizeWebUrl(this.mContext, this.mAppId, state, true);
                Intent intent = new Intent((Context)activity, AssistActivity.class);
                intent.putExtra("type", "type_web");
                intent.putExtra("url", authUrl);
                activity.startActivityForResult(intent, 62345);
            }
            catch (Exception ignore) {
                this.handleError(new UIError(checkResult), listener);
            }
            return;
        }
        Intent authIntent = OpenUtils.getIntentForAuthLogin((Context)activity);
        this.mUIListenerCache.put(62345, (Object)new Req(listener));
        Bundle bundle = OpenUtils.getBundleForAuthLogin((Context)activity, this.mAppId);
        authIntent.putExtra("action", "action_login");
        authIntent.putExtra("bundle", bundle);
        this.startBridgeActivity(activity, authIntent, 62345);
    }

    public final void authorizeWeb(Activity activity, String state, OnUIListener listener) {
        if (!InnerUtils.isActivityDeclared((Context)activity, BridgeActivity.class) || !InnerUtils.isActivityDeclared((Context)activity, AssistActivity.class)) {
            this.handleError(new UIError(3), listener);
            return;
        }
        int resCode = 1;
        try {
            this.mUIListenerCache.put(62345, (Object)new Req(listener));
            String authUrl = OpenUtils.getAuthorizeWebUrl(this.mContext, this.mAppId, state, true);
            Intent intent = new Intent((Context)activity, AssistActivity.class);
            intent.putExtra("type", "type_web");
            intent.putExtra("url", authUrl);
            activity.startActivityForResult(intent, 62345);
        }
        catch (Exception ignore) {
            this.handleError(new UIError(resCode), listener);
        }
    }

    public final void authorizeGopro(Activity activity, String state, OnUIListener listener) {
        if (!InnerUtils.isActivityDeclared((Context)activity, BridgeActivity.class) || !InnerUtils.isActivityDeclared((Context)activity, AssistActivity.class)) {
            this.handleError(new UIError(3), listener);
            return;
        }
        int resCode = 1;
        try {
            this.mUIListenerCache.put(62345, (Object)new Req(listener));
            String authUrl = OpenUtils.getAuthorizeWebUrl(this.mContext, this.mAppId, state, true);
            Intent intent = new Intent((Context)activity, AssistActivity.class);
            intent.putExtra("type", "type_web");
            intent.putExtra("url", authUrl);
            activity.startActivityForResult(intent, 62345);
        }
        catch (Exception ignore) {
            this.handleError(new UIError(resCode), listener);
        }
    }

    public void getTokenByCode(String token, int retryTime, final OnAuthorizeGoproListener listener) {
        if (retryTime > 2) {
            listener.onError(new UIError(99));
            return;
        }
        final String httpUrl = OpenUtils.getTokenUrl(this.mContext, this.mAppId, token);
        final int retryTime2 = retryTime;
        final String token2 = token;
        Runnable httpRunable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                HttpURLConnection conn = null;
                try {
                    URL url = new URL(new String(httpUrl));
                    conn = (HttpURLConnection)url.openConnection();
                    conn.setRequestMethod("GET");
                    conn.setConnectTimeout(5000);
                    conn.setReadTimeout(5000);
                    int responseCode = conn.getResponseCode();
                    if (responseCode == 200) {
                        InputStream inStream = conn.getInputStream();
                        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                        byte[] buffer = new byte[1024];
                        int len = 0;
                        while (-1 != (len = inStream.read(buffer))) {
                            outStream.write(buffer, 0, len);
                        }
                        AuthAgent.this.onGetTokenByCode(outStream.toString("utf-8"), listener);
                    } else {
                        AuthAgent.this.getTokenByCode(token2, retryTime2 + 1, listener);
                    }
                }
                catch (Exception e) {
                    AuthAgent.this.getTokenByCode(token2, retryTime2 + 1, listener);
                }
                finally {
                    conn.disconnect();
                }
            }
        };
        ThreadManager.executeOnNetWorkThread(httpRunable);
    }

    private void onGetTokenByCode(String result, OnAuthorizeGoproListener listener) {
        String token = "";
        int expires = 0;
        try {
            JSONObject jo = new JSONObject(result);
            if ("0".equals(jo.optString("code"))) {
                JSONObject jo2 = jo.getJSONObject("data");
                token = jo2.getString("accesstoken");
                expires = jo2.getInt("expires");
                listener.onComplete(token, expires);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            listener.onError(new UIError(99));
        }
    }

    public final void share(Activity activity, String shareJson, OnUIListener listener, String appid) {
        if (!InnerUtils.isActivityDeclared((Context)activity, BridgeActivity.class)) {
            this.handleError(new UIError(3), listener);
            return;
        }
        Intent targetIntent = OpenUtils.getIntentForAuthLogin((Context)activity);
        if (targetIntent == null) {
            this.handleError(new UIError(1), listener);
            return;
        }
        this.mUIListenerCache.put(62345, (Object)new Req(listener));
        Bundle bundle = OpenUtils.getBundleForAuthLogin((Context)activity, appid);
        targetIntent.putExtra("action", "action_popup_token");
        targetIntent.putExtra("bundle", bundle);
        bundle.putString("share_json", shareJson);
        this.startBridgeActivity(activity, targetIntent, 62345);
    }

    private void startBridgeActivity(Activity activity, Intent targetIntent, int resultCode) {
        targetIntent.putExtra("request_code", resultCode);
        Intent intent = new Intent(activity.getApplicationContext(), BridgeActivity.class);
        intent.putExtra("intent", (Parcelable)targetIntent);
        activity.startActivityForResult(intent, resultCode);
    }

    public final boolean handleActivityResult(int requestCode, int resultCode, Intent data, OnUIListener listener) {
        OnUIListener reqListener;
        long reqTime;
        if (requestCode != 62345 && requestCode != 62347) {
            return false;
        }
        Req req = (Req)this.mUIListenerCache.get(requestCode);
        if (req != null) {
            reqTime = req.dateTime;
            reqListener = req.listener;
            this.mUIListenerCache.remove(requestCode);
        } else {
            reqTime = System.currentTimeMillis();
            reqListener = listener;
        }
        if (requestCode == 62345) {
            this.handleAuthLoginResult(resultCode, data, reqListener, reqTime);
            return true;
        }
        if (requestCode == 62347) {
            this.handleShareResult(resultCode, data, reqListener, reqTime);
            return true;
        }
        return false;
    }

    private void handleAuthLoginResult(final int resultCode, final Intent data, final OnUIListener reqListener, long reqTime) {
        this.mHandler.postDelayed(new Runnable(){

            public void run() {
                String user = null;
                String uid = null;
                int resCode = resultCode;
                switch (resultCode) {
                    case 444111001: {
                        try {
                            String json = data.getStringExtra("resjson");
                            AuthAgent.this.mLog.info(json);
                            JSONObject jo = new JSONObject(json);
                            user = jo.optString("openid");
                            uid = jo.optString("uid");
                            reqListener.onComplete(jo);
                        }
                        catch (Exception e) {
                            reqListener.onError(new UIError(444222105, OpenUtils.getResultCodeReason(444222105)));
                        }
                        resCode = 0;
                        break;
                    }
                    case 0: 
                    case 444111002: {
                        reqListener.onCancel();
                        resCode = 1;
                        break;
                    }
                    case 444111003: {
                        try {
                            String json = data.getStringExtra("resjson");
                            JSONObject jo = new JSONObject(json);
                            String appType = jo.optString("appType");
                            if ("1".equals(appType)) {
                                uid = jo.optString("uid");
                            } else {
                                user = jo.optString("openid");
                            }
                            reqListener.onComplete(jo);
                        }
                        catch (Exception e) {
                            reqListener.onError(new UIError(444222105, OpenUtils.getResultCodeReason(444222105)));
                        }
                        resCode = 0;
                        break;
                    }
                    case 444222106: {
                        try {
                            String json = data.getStringExtra("resjson");
                            JSONObject jo = new JSONObject(json);
                            String resMsg = jo.optString("resMsg");
                            reqListener.onError(new UIError(444222106, resMsg));
                        }
                        catch (Exception e) {
                            reqListener.onError(new UIError(444222105, OpenUtils.getResultCodeReason(444222105)));
                        }
                        break;
                    }
                    case 444222108: {
                        try {
                            String json = data.getStringExtra("resjson");
                            JSONObject jo = new JSONObject(json);
                            reqListener.onComplete(jo);
                        }
                        catch (Exception e) {
                            reqListener.onError(new UIError(444222105, OpenUtils.getResultCodeReason(444222105)));
                        }
                        break;
                    }
                    case 444222110: {
                        try {
                            String json = data.getStringExtra("resjson");
                            JSONObject jo = new JSONObject(json);
                            String resMsg = jo.optString("resMsg");
                            reqListener.onError(new UIError(444222110, resMsg));
                        }
                        catch (Exception e) {
                            reqListener.onError(new UIError(444222105, OpenUtils.getResultCodeReason(444222105)));
                        }
                        break;
                    }
                    default: {
                        reqListener.onError(new UIError(resultCode, OpenUtils.getResultCodeReason(resultCode)));
                    }
                }
            }
        }, 10L);
    }

    private void handleShareResult(int resultCode, Intent data, OnUIListener reqListener, long reqTime) {
    }

    private void handleError(final UIError error, final OnUIListener listener) {
        if (listener != null) {
            this.mHandler.postDelayed(new Runnable(){

                public void run() {
                    listener.onError(error);
                }
            }, 50L);
        }
    }

    public int checkAppForAuthLogin() {
        return OpenUtils.checkAppForAuthLogin(this.mContext);
    }

    public String getAppSign() {
        return OpenUtils.getAppSign(this.mContext);
    }

    private final class Req {
        OnUIListener listener;
        long dateTime;

        Req(OnUIListener listener) {
            this.listener = listener;
            this.dateTime = System.currentTimeMillis();
        }
    }
}

