/*
 * Decompiled with CFR 0.152.
 */
package com.yy.udbauth;

import com.yy.udbauth.AUtils;
import com.yy.udbauth.AuthSDK;
import com.yy.udbauth.Global;
import com.yy.udbauth.log.LogHelper;
import java.io.Serializable;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AuthRequest {
    protected static void put(JSONObject jo, String name, String value) {
        try {
            jo.put(name, (Object)value);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    protected static void put(JSONObject jo, String name, JSONObject value) {
        try {
            jo.put(name, (Object)value);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    protected static void put(JSONObject jo, String name, JSONArray value) {
        try {
            jo.put(name, (Object)value);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GetMultiLoginListReq
    extends AuthBaseReq {
        public static final int OP_CMD = 25;
        public String context;
        public String uid;
        public List<String> appIds;

        public GetMultiLoginListReq(String context, String uid, List<String> appIds) {
            this.context = context;
            this.uid = uid;
            this.appIds = appIds;
        }

        @Override
        public int opCmd() {
            return 25;
        }

        @Override
        public String getContext() {
            return this.context;
        }

        @Override
        public byte[] marshall() {
            JSONObject son = new JSONObject();
            AuthRequest.put(son, "uid", this.uid);
            AuthRequest.put(son, "context", this.context);
            if (this.appIds != null && this.appIds.size() > 0) {
                JSONArray jsonAppIds = new JSONArray();
                for (String appId : this.appIds) {
                    jsonAppIds.put((Object)appId);
                }
                AuthRequest.put(son, "appIds", jsonAppIds);
            }
            AuthRequest.put(this.getParentJsonObject(), "getmultiLogin", son);
            return super.marshall();
        }
    }

    public static class OpenCreditLoginReq
    extends AuthBaseReq {
        private static final long serialVersionUID = -3798767449279087L;
        public static final int OP_CMD = 102;
        public String uid;
        public String credit;
        public int strategy = 0;
        public String strategyToken;
        public String appid;
        public String appSign;
        public String deviceId;
        public String context;

        public OpenCreditLoginReq(String uid, String credit, int strategy, String strategyToken, String appid, String appSign, String deviceId, String context) {
            this.uid = uid;
            this.credit = credit;
            this.strategy = strategy;
            this.strategyToken = strategyToken;
            this.appid = appid;
            this.appSign = appSign;
            this.deviceId = deviceId;
            this.context = context;
        }

        public int opCmd() {
            return 102;
        }

        public String getContext() {
            return this.context;
        }

        public byte[] marshall() {
            JSONObject son = new JSONObject();
            AuthRequest.put(son, "uid", this.uid);
            AuthRequest.put(son, "credit", this.credit);
            AuthRequest.put(son, "strategy", Integer.toString(this.strategy));
            AuthRequest.put(son, "stra_token", this.strategyToken);
            AuthRequest.put(son, "appid", this.appid);
            AuthRequest.put(son, "appsign", this.appSign);
            AuthRequest.put(son, "device_id", this.deviceId);
            AuthRequest.put(son, "context", this.context);
            AuthRequest.put(this.getParentJsonObject(), "credit_login_auth", son);
            LogHelper.getInstance().logToDBForCommon("req_log", 1, Global.getAppId(), this.uid, "0", Integer.toString(102), Integer.toString(this.strategy), this.context, "0", null);
            return super.marshall();
        }
    }

    public static class OpenPwdLoginReq
    extends AuthBaseReq {
        private static final long serialVersionUID = -345124578579279087L;
        public static final int OP_CMD = 101;
        public String user;
        public String passwordSha1;
        public int strategy = 0;
        public String strategyToken;
        public String appid;
        public String appSign;
        public String deviceId;
        public String context;

        public OpenPwdLoginReq(String user, String passwordSha1, int strategy, String strategyToken, String appid, String appSign, String deviceId, String context) {
            this.user = user;
            this.passwordSha1 = passwordSha1;
            this.strategy = strategy;
            this.strategyToken = strategyToken;
            this.appid = appid;
            this.appSign = appSign;
            this.deviceId = deviceId;
            this.context = context;
        }

        public int opCmd() {
            return 101;
        }

        public String getContext() {
            return this.context;
        }

        public byte[] marshall() {
            JSONObject son = new JSONObject();
            AuthRequest.put(son, "user", this.user);
            AuthRequest.put(son, "password", this.passwordSha1);
            AuthRequest.put(son, "strategy", Integer.toString(this.strategy));
            AuthRequest.put(son, "stra_token", this.strategyToken);
            AuthRequest.put(son, "appid", this.appid);
            AuthRequest.put(son, "appsign", this.appSign);
            AuthRequest.put(son, "device_id", this.deviceId);
            AuthRequest.put(son, "context", this.context);
            AuthRequest.put(this.getParentJsonObject(), "pwd_login_auth", son);
            LogHelper.getInstance().logToDBForCommon("req_log", 1, Global.getAppId(), this.user, "0", Integer.toString(101), Integer.toString(this.strategy), this.context, "0", null);
            return super.marshall();
        }
    }

    public static class OpenCheckAppReq
    extends AuthBaseReq {
        private static final long serialVersionUID = 5494653124928456L;
        public static final int OP_CMD = 100;
        public String appid;
        public String appSign;
        public String deviceId;
        public String uid;
        public String context;

        public OpenCheckAppReq(String appid, String appSign, String deviceId, String uid, String context) {
            this.appid = appid;
            this.appSign = appSign;
            this.deviceId = deviceId;
            this.uid = uid;
            this.context = context;
        }

        public int opCmd() {
            return 100;
        }

        public String getContext() {
            return this.context;
        }

        public byte[] marshall() {
            JSONObject son = new JSONObject();
            AuthRequest.put(son, "appid", this.appid);
            AuthRequest.put(son, "appsign", this.appSign);
            AuthRequest.put(son, "device_id", this.deviceId);
            AuthRequest.put(son, "uid", this.uid);
            AuthRequest.put(son, "context", this.context);
            AuthRequest.put(this.getParentJsonObject(), "app_check_req", son);
            return super.marshall();
        }
    }

    public static class QueryReq
    extends AuthBaseReq {
        private static final long serialVersionUID = -1688327466240443212L;
        public static final int OP_CMD = 8;
        public static final int TYPE_QUERY_TICKET = 1;
        public static final int TYPE_QUERY_WEBCOOKIE = 2;
        public static final int TYPE_QUERY_OTP = 3;
        public int queryType;
        public String uid;
        public String appid;
        public String productId;
        public String context;

        public QueryReq(String uid, String appid, int type, String context) {
            this.queryType = type;
            this.uid = uid;
            this.appid = appid;
            this.context = context;
        }

        public int opCmd() {
            return 8;
        }

        public String getContext() {
            return this.context;
        }

        public byte[] marshall() {
            JSONObject son = new JSONObject();
            AuthRequest.put(son, "type", Integer.toString(this.queryType));
            AuthRequest.put(son, "uid", this.uid);
            AuthRequest.put(son, "appid", this.appid);
            AuthRequest.put(son, "product_id", this.productId);
            AuthRequest.put(son, "context", this.context);
            AuthRequest.put(this.getParentJsonObject(), "query", son);
            return super.marshall();
        }
    }

    protected static class ClientLogReq
    extends AuthBaseReq {
        private static final long serialVersionUID = -2565519774640032425L;
        public static final int OP_CMD = 10;
        public String user;
        public int level;
        public String localtime;
        public String detail;
        public String context;

        public ClientLogReq(String user, int level, String detail) {
            this.user = user;
            this.level = level;
            this.localtime = AUtils.getSystemTime();
            this.context = Long.toString(System.currentTimeMillis());
            this.detail = detail;
        }

        public int opCmd() {
            return 10;
        }

        public String getContext() {
            return this.context;
        }

        public byte[] marshall() {
            JSONObject son = new JSONObject();
            AuthRequest.put(son, "user", this.user);
            AuthRequest.put(son, "level", Integer.toString(this.level));
            AuthRequest.put(son, "local_time", this.localtime);
            AuthRequest.put(son, "detail", this.detail);
            AuthRequest.put(son, "context", this.context);
            AuthRequest.put(this.getParentJsonObject(), "client_log", son);
            return super.marshall();
        }
    }

    public static class AnonymousReq
    extends AuthBaseReq {
        private static final long serialVersionUID = -780986970448978975L;
        public static final int OP_CMD = 19;
        public String picCode;
        public String context;

        public AnonymousReq(String context, String picCode) {
            this.context = context;
            this.picCode = picCode;
        }

        public int opCmd() {
            return 19;
        }

        public String getContext() {
            return this.context;
        }

        public byte[] marshall() {
            JSONObject son = new JSONObject();
            AuthRequest.put(son, "piccode", this.picCode);
            AuthRequest.put(son, "context", this.context);
            AuthRequest.put(this.getParentJsonObject(), "anonymous_login", son);
            return super.marshall();
        }
    }

    public static class CancelReq
    extends AuthBaseReq {
        private static final long serialVersionUID = -7809869704419138693L;
        public static final int OP_CMD = 15;
        public String context;

        public CancelReq(String context) {
            this.context = context;
        }

        public int opCmd() {
            return 15;
        }

        public String getContext() {
            return this.context;
        }

        public byte[] marshall() {
            JSONObject son = new JSONObject();
            AuthRequest.put(son, "context", this.context);
            AuthRequest.put(this.getParentJsonObject(), "cancel_req", son);
            return super.marshall();
        }
    }

    public static class QRCodeLoginReq
    extends AuthBaseReq {
        private static final long serialVersionUID = 693451564546136L;
        public static final int OP_CMD = 14;
        public String loginData;
        public int strategy = 0;
        public String strategyToken;
        public String context;

        public QRCodeLoginReq(String loginData, int strategy, String strategyToken, String context) {
            this.loginData = loginData;
            this.strategy = strategy;
            this.strategyToken = strategyToken;
            this.context = context;
        }

        public int opCmd() {
            return 14;
        }

        public String getContext() {
            return this.context;
        }

        public byte[] marshall() {
            JSONObject son = new JSONObject();
            AuthRequest.put(son, "login_data", this.loginData);
            AuthRequest.put(son, "strategy", Integer.toString(this.strategy));
            AuthRequest.put(son, "stra_token", this.strategyToken);
            AuthRequest.put(son, "context", this.context);
            AuthRequest.put(this.getParentJsonObject(), "qrcode_login", son);
            return super.marshall();
        }
    }

    public static class QRCodeCancelReq
    extends AuthBaseReq {
        private static final long serialVersionUID = 69345154326532964L;
        public static final int OP_CMD = 22;
        public String qrId;
        public String mobContext;
        public String context;

        public QRCodeCancelReq(String qrId, String context) {
            this(qrId, null, context);
        }

        public QRCodeCancelReq(String qrId, String mobContext, String context) {
            this.qrId = qrId;
            this.mobContext = mobContext;
            this.context = context;
        }

        public int opCmd() {
            return 22;
        }

        public String getContext() {
            return this.context;
        }

        public byte[] marshall() {
            JSONObject son = new JSONObject();
            AuthRequest.put(son, "qrid", this.qrId);
            AuthRequest.put(son, "mob_context", this.mobContext);
            AuthRequest.put(son, "context", this.context);
            AuthRequest.put(this.getParentJsonObject(), "qrcode_cancel", son);
            return super.marshall();
        }
    }

    public static class QRCodeConfirmReq
    extends AuthBaseReq {
        private static final long serialVersionUID = 69345120099296736L;
        public static final int OP_CMD = 21;
        public String qrId;
        public String mobContext;
        public String context;

        public QRCodeConfirmReq(String qrId, String context) {
            this(qrId, null, context);
        }

        public QRCodeConfirmReq(String qrId, String mobContext, String context) {
            this.qrId = qrId;
            this.mobContext = mobContext;
            this.context = context;
        }

        public int opCmd() {
            return 21;
        }

        public String getContext() {
            return this.context;
        }

        public byte[] marshall() {
            JSONObject son = new JSONObject();
            AuthRequest.put(son, "qrid", this.qrId);
            AuthRequest.put(son, "mob_context", this.mobContext);
            AuthRequest.put(son, "context", this.context);
            AuthRequest.put(this.getParentJsonObject(), "qrcode_confirm", son);
            return super.marshall();
        }
    }

    public static class QRCodeCheckReq
    extends AuthBaseReq {
        private static final long serialVersionUID = 694602094009928456L;
        public static final int OP_CMD = 20;
        public String qrId;
        public String mobContext;
        public String context;

        public QRCodeCheckReq(String qrId, String mobContext, String context) {
            this.qrId = qrId;
            this.mobContext = mobContext;
            this.context = context;
        }

        public int opCmd() {
            return 20;
        }

        public String getContext() {
            return this.context;
        }

        public byte[] marshall() {
            JSONObject son = new JSONObject();
            AuthRequest.put(son, "qrid", this.qrId);
            AuthRequest.put(son, "mob_context", this.mobContext);
            AuthRequest.put(son, "context", this.context);
            AuthRequest.put(this.getParentJsonObject(), "qrcode_check", son);
            return super.marshall();
        }
    }

    public static class RefreshPicReq
    extends AuthBaseReq {
        private static final long serialVersionUID = 6946020940099296736L;
        public static final int OP_CMD = 7;
        public String user;
        public String context;

        public RefreshPicReq(String user, String context) {
            this.user = user;
            this.context = context;
        }

        public int opCmd() {
            return 7;
        }

        public String getContext() {
            return this.context;
        }

        public byte[] marshall() {
            JSONObject son = new JSONObject();
            AuthRequest.put(son, "user", this.user);
            AuthRequest.put(son, "context", this.context);
            AuthRequest.put(this.getParentJsonObject(), "refresh_pic", son);
            return super.marshall();
        }
    }

    public static class VerifySmsCodeReq
    extends AuthBaseReq {
        private static final long serialVersionUID = -5620158068709905833L;
        public static final int OP_CMD = 12;
        public String user;
        public String smsCode = "";
        public String context;

        public VerifySmsCodeReq(String user, String smscode, String context) {
            this.user = user;
            this.smsCode = smscode;
            this.context = context;
        }

        public int opCmd() {
            return 12;
        }

        public String getContext() {
            return this.context;
        }

        public byte[] marshall() {
            JSONObject son = new JSONObject();
            AuthRequest.put(son, "user", this.user);
            AuthRequest.put(son, "smscode", this.smsCode);
            AuthRequest.put(son, "context", this.context);
            AuthRequest.put(this.getParentJsonObject(), "verify_smscode", son);
            return super.marshall();
        }
    }

    public static class CheckModPwdReq
    extends AuthBaseReq {
        private static final long serialVersionUID = -1732455313478844972L;
        public static final int OP_CMD = 16;
        public String user;
        public String context;

        public CheckModPwdReq(String user, String context) {
            this.user = user;
            this.context = context;
        }

        public int opCmd() {
            return 16;
        }

        public String getContext() {
            return this.context;
        }

        public byte[] marshall() {
            JSONObject son = new JSONObject();
            AuthRequest.put(son, "user", this.user);
            AuthRequest.put(son, "context", this.context);
            AuthRequest.put(this.getParentJsonObject(), "check_modpwd", son);
            return super.marshall();
        }
    }

    public static class CheckRegisterReq
    extends AuthBaseReq {
        private static final long serialVersionUID = -1732455313478789789L;
        public static final int OP_CMD = 17;
        public String user;
        public String context;

        public CheckRegisterReq(String user, String context) {
            this.user = user;
            this.context = context;
        }

        public int opCmd() {
            return 17;
        }

        public String getContext() {
            return this.context;
        }

        public byte[] marshall() {
            JSONObject son = new JSONObject();
            AuthRequest.put(son, "user", this.user);
            AuthRequest.put(son, "context", this.context);
            AuthRequest.put(this.getParentJsonObject(), "check_reg", son);
            return super.marshall();
        }
    }

    public static class CheckSmsUpReq
    extends AuthBaseReq {
        private static final long serialVersionUID = 5900893581401115351L;
        public static final int OP_CMD = 11;
        public String user;
        public String passwordSha1 = "";
        public long timeout;
        public String context;

        public CheckSmsUpReq(String user, String passwordSha1, String context) {
            this.user = user;
            this.passwordSha1 = passwordSha1;
            this.context = context;
        }

        public CheckSmsUpReq(String user, String passwordSha1, int timeout, String context) {
            this.user = user;
            this.passwordSha1 = passwordSha1;
            this.timeout = timeout;
            this.context = context;
        }

        public int opCmd() {
            return 11;
        }

        public String getContext() {
            return this.context;
        }

        public byte[] marshall() {
            JSONObject son = new JSONObject();
            AuthRequest.put(son, "user", this.user);
            AuthRequest.put(son, "password", this.passwordSha1);
            AuthRequest.put(son, "retry_time", this.timeout > 0L ? this.timeout + "" : null);
            AuthRequest.put(son, "context", this.context);
            AuthRequest.put(this.getParentJsonObject(), "check_smsup", son);
            LogHelper.getInstance().logToDBForCommon("req_log", 1, Global.getAppId(), this.user, "0", Integer.toString(11), null, this.context, "0", null);
            return super.marshall();
        }
    }

    public static class SendSmsReq
    extends AuthBaseReq {
        private static final long serialVersionUID = 2263399049883589649L;
        public static final int OP_CMD = 4;
        public static final int SMS_TYPE_REGISTER_OR_LOGIN = 1;
        public static final int SMS_TYPE_LOGIN_OR_MODPWD = 2;
        private final String USER_TYPE_USERNAME = "0";
        private final String USER_TYPE_UID = "1";
        public String user;
        public String secMobile;
        public boolean isUid;
        public int smsType = 1;
        public int strategy = 0;
        public String strategyToken;
        public String context;

        public SendSmsReq(String uid, int strategy, String strategyToken, String context) {
            this(uid, null, true, 2, strategy, strategyToken, context);
        }

        public SendSmsReq(String loginMobile, int smsType, int strategy, String strategyToken, String context) {
            this(loginMobile, null, false, smsType, strategy, strategyToken, context);
        }

        public SendSmsReq(String user, String secMobile, int strategy, String strategyToken, String context) {
            this(user, secMobile, false, 2, strategy, strategyToken, context);
        }

        protected SendSmsReq(String user, String secMobile, boolean isUid, int smsType, int strategy, String strategyToken, String context) {
            this.user = user;
            this.secMobile = secMobile;
            this.isUid = isUid;
            this.smsType = smsType;
            this.strategy = strategy;
            this.strategyToken = strategyToken;
            this.context = context;
        }

        public int opCmd() {
            return 4;
        }

        public String getContext() {
            return this.context;
        }

        public byte[] marshall() {
            JSONObject son = new JSONObject();
            AuthRequest.put(son, "user", this.user);
            AuthRequest.put(son, "sec_mobile", this.secMobile);
            AuthRequest.put(son, "user_type", this.isUid ? "1" : "0");
            AuthRequest.put(son, "type", Integer.toString(this.smsType));
            AuthRequest.put(son, "strategy", Integer.toString(this.strategy));
            AuthRequest.put(son, "stra_token", this.strategyToken);
            AuthRequest.put(son, "context", this.context);
            AuthRequest.put(this.getParentJsonObject(), "send_sms", son);
            return super.marshall();
        }
    }

    public static class QuickModPwdReq
    extends AuthBaseReq {
        private static final long serialVersionUID = 4136757518833473988L;
        public static final int OP_CMD = 9;
        public String user;
        public String passwordSha1;
        public String context;

        public QuickModPwdReq(String user, String passwordSha1, String context) {
            this.user = user;
            this.passwordSha1 = passwordSha1;
            this.context = context;
        }

        public int opCmd() {
            return 9;
        }

        public String getContext() {
            return this.context;
        }

        public byte[] marshall() {
            JSONObject son = new JSONObject();
            AuthRequest.put(son, "user", this.user);
            AuthRequest.put(son, "pwd", this.passwordSha1);
            AuthRequest.put(son, "context", this.context);
            AuthRequest.put(this.getParentJsonObject(), "quick_modpwd", son);
            LogHelper.getInstance().logToDBForCommon("req_log", 1, Global.getAppId(), this.user, "0", Integer.toString(9), null, this.context, "0", null);
            return super.marshall();
        }
    }

    public static class SmsModPwdReq
    extends AuthBaseReq {
        private static final long serialVersionUID = 5177176641334949964L;
        public static final int OP_CMD = 6;
        public String user;
        public String loginMobile;
        public String secMobile;
        public String smsCode;
        public String passwordSha1;
        public String context;

        public SmsModPwdReq(String loginMobile, String passwordSha1, String smsCode, String context) {
            this.loginMobile = loginMobile;
            this.user = null;
            this.passwordSha1 = passwordSha1;
            this.smsCode = smsCode;
            this.context = context;
        }

        public SmsModPwdReq(String user, String secMobile, String passwordSha1, String smsCode, String context) {
            this.user = user;
            this.secMobile = secMobile;
            this.passwordSha1 = passwordSha1;
            this.smsCode = smsCode;
            this.context = context;
        }

        public int opCmd() {
            return 6;
        }

        public String getContext() {
            return this.context;
        }

        public byte[] marshall() {
            JSONObject son = new JSONObject();
            AuthRequest.put(son, "mobile", this.user == null ? this.loginMobile : this.secMobile);
            AuthRequest.put(son, "user", this.user);
            AuthRequest.put(son, "sms_code", this.smsCode);
            AuthRequest.put(son, "pwd", this.passwordSha1);
            AuthRequest.put(son, "context", this.context);
            AuthRequest.put(this.getParentJsonObject(), "sms_modpawd", son);
            LogHelper.getInstance().logToDBForCommon("req_log", 1, Global.getAppId(), this.user == null ? this.loginMobile : this.user, "0", Integer.toString(6), null, this.context, "0", null);
            return super.marshall();
        }
    }

    public static class RegisterReq
    extends AuthBaseReq {
        private static final long serialVersionUID = -1754640489764223067L;
        public static final int OP_CMD = 5;
        protected static final int TYPE_REGISTER_AND_LOGIN = 0;
        protected static final int TYPE_REGISTER_ONLY = 1;
        public String mobile;
        public String smsCode;
        public String passwordSha1 = null;
        public String context;

        public RegisterReq(String mobile, String smscode, String passwordSha1, String context) {
            this.mobile = mobile;
            this.smsCode = smscode;
            this.passwordSha1 = passwordSha1;
            this.context = context;
        }

        public int opCmd() {
            return 5;
        }

        public String getContext() {
            return this.context;
        }

        public static boolean isRegisterReq(String json) {
            try {
                JSONObject son = new JSONObject(json).getJSONObject("sms_reglogin");
                return son.getInt("type") == 1;
            }
            catch (JSONException e) {
                return false;
            }
        }

        public byte[] marshall() {
            JSONObject son = new JSONObject();
            AuthRequest.put(son, "mobile", this.mobile);
            AuthRequest.put(son, "sms_code", this.smsCode);
            AuthRequest.put(son, "password", this.passwordSha1);
            AuthRequest.put(son, "type", Integer.toString(1));
            AuthRequest.put(son, "context", this.context);
            AuthRequest.put(this.getParentJsonObject(), "sms_reglogin", son);
            LogHelper.getInstance().logToDBForCommon("req_log", 1, Global.getAppId(), this.mobile, "0", Integer.toString(5), null, this.context, "0", null);
            return super.marshall();
        }
    }

    public static class SmsRegloginReq
    extends AuthBaseReq {
        private static final long serialVersionUID = -5185074958697095217L;
        public static final int OP_CMD = 5;
        protected static final int TYPE_REGISTER_AND_LOGIN = 0;
        protected static final int TYPE_REGISTER_ONLY = 1;
        public String mobile;
        public String smsCode;
        public String passwordSha1 = null;
        public String context;

        public SmsRegloginReq(String mobile, String smscode, String context) {
            this.mobile = mobile;
            this.smsCode = smscode;
            this.passwordSha1 = null;
            this.context = context;
        }

        public SmsRegloginReq(String mobile, String smscode, String passwordSha1, String context) {
            this.mobile = mobile;
            this.smsCode = smscode;
            this.passwordSha1 = passwordSha1;
            this.context = context;
        }

        public int opCmd() {
            return 5;
        }

        public String getContext() {
            return this.context;
        }

        public static boolean isSmsRegloginReq(String json) {
            try {
                JSONObject son = new JSONObject(json).getJSONObject("sms_reglogin");
                return son.getInt("type") == 0;
            }
            catch (JSONException e) {
                return false;
            }
        }

        public byte[] marshall() {
            JSONObject son = new JSONObject();
            AuthRequest.put(son, "mobile", this.mobile);
            AuthRequest.put(son, "sms_code", this.smsCode);
            AuthRequest.put(son, "password", this.passwordSha1);
            AuthRequest.put(son, "type", Integer.toString(0));
            AuthRequest.put(son, "context", this.context);
            AuthRequest.put(this.getParentJsonObject(), "sms_reglogin", son);
            LogHelper.getInstance().logToDBForCommon("req_log", 1, Global.getAppId(), this.mobile, "0", Integer.toString(5), null, this.context, "0", null);
            return super.marshall();
        }
    }

    public static class ThirdPartyLoginReq
    extends AuthBaseReq {
        private static final long serialVersionUID = -8544219987024705511L;
        public static final int OP_CMD = 13;
        public String source;
        public String thirdSubSystem;
        public String requestType;
        public String tokenId;
        public boolean bindMobile;
        public String thirdAppkey;
        public String partnerUid;
        public String tokenSecret;
        public String oauthUrl;
        public String channel;
        public String oauthType;
        public String flowId;
        public String reserve1;
        public String reserve2;
        public String reserve3;
        public String loginType;
        public String strategy;
        public String stra_token;
        public String context;

        public ThirdPartyLoginReq() {
        }

        public ThirdPartyLoginReq(String source, String third_sub_sys, String request_type, String tokenid, String context) {
            this.source = source;
            this.thirdSubSystem = third_sub_sys;
            this.requestType = request_type;
            this.tokenId = tokenid;
            this.context = context;
        }

        public int opCmd() {
            return 13;
        }

        public String getContext() {
            return this.context;
        }

        public byte[] marshall() {
            JSONObject son = new JSONObject();
            AuthRequest.put(son, "source", this.source);
            AuthRequest.put(son, "third_sub_sys", this.thirdSubSystem);
            AuthRequest.put(son, "request_type", this.requestType);
            AuthRequest.put(son, "tokenid", this.tokenId);
            AuthRequest.put(son, "third_appkey", this.thirdAppkey);
            AuthRequest.put(son, "partner_uid", this.partnerUid);
            AuthRequest.put(son, "token_secret", this.tokenSecret);
            AuthRequest.put(son, "oauth_url", this.oauthUrl);
            AuthRequest.put(son, "channel", this.channel);
            AuthRequest.put(son, "oauth_type", this.oauthType);
            AuthRequest.put(son, "flowid", this.flowId);
            AuthRequest.put(son, "reserve1", this.reserve1);
            AuthRequest.put(son, "reserve2", this.reserve2);
            AuthRequest.put(son, "reserve3", this.reserve3);
            AuthRequest.put(son, "context", this.context);
            AuthRequest.put(son, "third_login_type", this.loginType);
            AuthRequest.put(son, "stra_token", this.stra_token);
            AuthRequest.put(son, "strategy", this.strategy);
            String sBind = "true";
            if (!this.bindMobile) {
                sBind = "false";
            }
            AuthRequest.put(son, "bind_mobile", sBind);
            AuthRequest.put(this.getParentJsonObject(), "3rdtoken_login", son);
            LogHelper.getInstance().logToDBForCommon("req_log", 1, Global.getAppId(), this.source + "_" + this.partnerUid, 10, "", Integer.toString(13), null, this.context, "0", null);
            return super.marshall();
        }
    }

    public static class TicketLoginReq
    extends AuthBaseReq {
        private static final long serialVersionUID = -523781001157606608L;
        public static final int OP_CMD = 3;
        public String uid;
        public String ticket;
        public String ticketAppId;
        public String context;

        public TicketLoginReq(String uid, String ticket, String ticketAppId, String context) {
            this.uid = uid;
            this.ticket = ticket;
            this.context = context;
            this.ticketAppId = ticketAppId;
        }

        public int opCmd() {
            return 3;
        }

        public String getContext() {
            return this.context;
        }

        public byte[] marshall() {
            JSONObject son = new JSONObject();
            AuthRequest.put(son, "uid", this.uid);
            AuthRequest.put(son, "ticket", this.ticket);
            AuthRequest.put(son, "appid", this.ticketAppId);
            AuthRequest.put(son, "context", this.context);
            AuthRequest.put(this.getParentJsonObject(), "ticket_login", son);
            LogHelper.getInstance().logToDBForCommon("req_log", 1, Global.getAppId(), "", this.uid, Integer.toString(3), null, this.context, "0", null);
            return super.marshall();
        }
    }

    public static class CreditLoginReq
    extends AuthBaseReq {
        private static final long serialVersionUID = 7733784382956730164L;
        public static final int OP_CMD = 2;
        public String uid;
        public String credit;
        public int strategy = 0;
        public String strategyToken;
        public String context;

        public CreditLoginReq(String uid, String credit, int strategy, String strategyToken, String context) {
            this.uid = uid;
            this.credit = credit;
            this.strategy = strategy;
            this.strategyToken = strategyToken;
            this.context = context;
        }

        public CreditLoginReq(String uid, int strategy, String strategyToken, String context) {
            this.uid = uid;
            this.credit = AuthSDK.getCredit(uid);
            this.strategy = strategy;
            this.strategyToken = strategyToken;
            this.context = context;
        }

        public int opCmd() {
            return 2;
        }

        public String getContext() {
            return this.context;
        }

        public byte[] marshall() {
            JSONObject son = new JSONObject();
            AuthRequest.put(son, "uid", this.uid);
            AuthRequest.put(son, "credit", this.credit);
            AuthRequest.put(son, "strategy", Integer.toString(this.strategy));
            AuthRequest.put(son, "stra_token", this.strategyToken);
            AuthRequest.put(son, "context", this.context);
            AuthRequest.put(this.getParentJsonObject(), "credit_login", son);
            LogHelper.getInstance().logToDBForCommon("req_log", 1, Global.getAppId(), "", this.uid, Integer.toString(2), Integer.toString(this.strategy), this.context, "0", null);
            return super.marshall();
        }
    }

    public static class LoginReq
    extends AuthBaseReq {
        private static final long serialVersionUID = -4229409087135379087L;
        public static final int OP_CMD = 1;
        public String user;
        public String passwordSha1;
        public int strategy = 0;
        public String strategyToken;
        public String context;

        public LoginReq(String user, String passwordSha1, int strategy, String strategyToken, String context) {
            this.user = user;
            this.passwordSha1 = passwordSha1;
            this.strategy = strategy;
            this.strategyToken = strategyToken;
            this.context = context;
        }

        public int opCmd() {
            return 1;
        }

        public String getContext() {
            return this.context;
        }

        public byte[] marshall() {
            JSONObject son = new JSONObject();
            AuthRequest.put(son, "user", this.user);
            AuthRequest.put(son, "password", this.passwordSha1);
            AuthRequest.put(son, "strategy", Integer.toString(this.strategy));
            AuthRequest.put(son, "stra_token", this.strategyToken);
            AuthRequest.put(son, "context", this.context);
            AuthRequest.put(this.getParentJsonObject(), "pwd_login", son);
            LogHelper.getInstance().logToDBForCommon("req_log", 1, Global.getAppId(), this.user, "0", Integer.toString(1), Integer.toString(this.strategy), this.context, "0", null);
            return super.marshall();
        }
    }

    public static class AuthBaseReq
    implements Serializable {
        private static final long serialVersionUID = -2155227490328940982L;
        protected String json = "{}";
        private transient JSONObject mRootJsonObject = new JSONObject();

        protected JSONObject getParentJsonObject() {
            return this.mRootJsonObject;
        }

        protected int opCmd() {
            return -1;
        }

        public String getContext() {
            return null;
        }

        protected int getJsonVer() {
            return 0;
        }

        public byte[] marshall() {
            AuthRequest.put(this.mRootJsonObject, "op_cmd", Integer.toString(this.opCmd()));
            AuthRequest.put(this.mRootJsonObject, "json_ver", Integer.toString(this.getJsonVer()));
            this.json = this.mRootJsonObject.toString();
            return this.json.getBytes();
        }
    }

    public static interface STRATEGY {
        public static final int NONE = 0;
        public static final int PICCODE = 1;
        public static final int MOBTOKEN = 2;
        public static final int HWTOKEN = 4;
        public static final int SMSCODE = 8;
        public static final int SLIDE = 16;
        public static final int SMS_UP = 32;
    }

    public static interface OpCmd {
        public static final int OP_INVALID_REQ = -1;
        public static final int OP_PASSWORD_LOGIN = 1;
        public static final int OP_CREDIT_LOGIN = 2;
        public static final int OP_TICKET_LOGIN = 3;
        public static final int OP_SEND_SMS = 4;
        public static final int OP_SMS_REG_LOGIN = 5;
        public static final int OP_SMS_MOD_PWD = 6;
        public static final int OP_REFRESH_PIC = 7;
        public static final int OP_QUERY = 8;
        public static final int OP_QUICK_MOD_PWD = 9;
        public static final int OP_LOG_REPORT = 10;
        public static final int OP_CHECK_SMS_UP = 11;
        public static final int OP_VERIFY_SMSCODE = 12;
        public static final int OP_THIRD_LOGIN = 13;
        public static final int OP_QRCODE_LOGIN = 14;
        public static final int OP_CANCEL = 15;
        public static final int OP_CHECK_MOD_PWD = 16;
        public static final int OP_CHECK_REGISTER = 17;
        public static final int OP_CHECK_USER_EXIST = 18;
        public static final int OP_ANONYMOUS_LOGIN = 19;
        public static final int OP_QRCODE_CHECK = 20;
        public static final int OP_QRCODE_CONFIRM = 21;
        public static final int OP_QRCODE_CANCEL = 22;
        public static final int OP_GETMULTILOGIN_LIST = 25;
        public static final int OP_OPEN_APP_CHECK = 100;
        public static final int OP_OPEN_PWD_LOGIN = 101;
        public static final int OP_OPEN_CREDIT_LOGIN = 102;
    }
}

