/*
 * Decompiled with CFR 0.152.
 */
package com.yy.udbauth;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.yy.secure.deviceidentifiertest.VirtualDevice;
import java.io.File;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AUtils {
    private static String sDeviceId;
    private static String sDeviceInfo;

    public static String getPasswdSha1(String password) {
        try {
            MessageDigest digester = MessageDigest.getInstance("sha-1");
            byte[] bytes = password.getBytes();
            int byteCount = password.getBytes().length;
            if (byteCount > 0) {
                digester.update(bytes, 0, byteCount);
            }
            byte[] digest = digester.digest();
            String hexString = "0123456789abcdef";
            byte[] HEX_CHARS = hexString.getBytes();
            byte[] digest_char = new byte[40];
            for (int i = 0; i < 20; ++i) {
                digest_char[2 * i] = HEX_CHARS[(digest[i] & 0xF0) >> 4];
                digest_char[2 * i + 1] = HEX_CHARS[digest[i] & 0xF];
            }
            return new String(digest_char);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getType(String user) {
        if (user == null || user.length() <= 0) {
            return 9;
        }
        if (TextUtils.isDigitsOnly((CharSequence)user) && user.length() == 11 && user.startsWith("1")) {
            return 3;
        }
        if (TextUtils.isDigitsOnly((CharSequence)user) && user.startsWith("00")) {
            return 3;
        }
        if (TextUtils.isDigitsOnly((CharSequence)user)) {
            return 2;
        }
        if (user.contains("@")) {
            return 1;
        }
        if (user.length() >= 1) {
            return 0;
        }
        return 9;
    }

    public static boolean isActivityDeclared(Context context, Class<? extends Activity> activity) {
        if (context == null || activity == null) {
            return false;
        }
        try {
            PackageManager pm = context.getPackageManager();
            ComponentName cn = new ComponentName(context.getPackageName(), activity.getName());
            pm.getActivityInfo(cn, 0);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isActivityExist(Context context, Intent intent) {
        if (context == null || intent == null) {
            return false;
        }
        try {
            PackageManager pm = context.getPackageManager();
            List localList = pm.queryIntentActivities(intent, 0);
            return localList.size() != 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getSystemTime() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault()).format(new Date());
    }

    public static String getDeviceId(Context context) {
        try {
            if (sDeviceId == null) {
                sDeviceId = new VirtualDevice().getDeviceID(context);
            }
            return sDeviceId;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getDeviceInfo(Context context) {
        try {
            if (sDeviceInfo == null) {
                sDeviceInfo = new VirtualDevice().getDeviceInfo(context);
            }
            return sDeviceInfo;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getIMEI(Context context) {
        if (context == null) {
            return "";
        }
        return "";
    }

    public static String getMacAddress(Context context) {
        if (context == null) {
            return "";
        }
        return "";
    }

    public static boolean isNetworkAvailable(Context context) {
        if (context == null) {
            return false;
        }
        try {
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo ni = cm.getActiveNetworkInfo();
            return ni != null && (ni.isConnected() || ni.isAvailable() && ni.isConnectedOrConnecting());
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static boolean isWIFIConnected(Context context) {
        if (context == null) {
            return false;
        }
        try {
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo networkInfo = cm.getActiveNetworkInfo();
            return networkInfo != null && networkInfo.getType() == 1;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static boolean isMobileConnected(Context context) {
        if (context == null) {
            return false;
        }
        try {
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo networkInfo = cm.getActiveNetworkInfo();
            return networkInfo != null && networkInfo.getType() == 0;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static boolean isGpsEnabled(Context context) {
        if (context == null) {
            return false;
        }
        try {
            LocationManager lm = (LocationManager)context.getSystemService("location");
            List accessibleProviders = lm.getProviders(true);
            for (String name : accessibleProviders) {
                if (!"gps".equalsIgnoreCase(name)) continue;
                return true;
            }
            return false;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static String getNetworkType(Context context) {
        try {
            ConnectivityManager connectMgr = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo info = connectMgr.getActiveNetworkInfo();
            return info.getType() + "|" + info.getTypeName();
        }
        catch (Throwable e) {
            return "-1|error";
        }
    }

    public static String getMCC(Context context) {
        try {
            return Integer.toString(context.getResources().getConfiguration().mcc);
        }
        catch (Throwable e) {
            return "-1";
        }
    }

    public static String getMNC(Context context) {
        try {
            return Integer.toString(context.getResources().getConfiguration().mnc);
        }
        catch (Throwable e) {
            return "-1";
        }
    }

    public static int getCarrierType(Context context) {
        if (context == null) {
            return 2;
        }
        try {
            if (!AUtils.isNetworkAvailable(context)) {
                return 1;
            }
            WifiManager wm = (WifiManager)context.getApplicationContext().getSystemService("wifi");
            if (wm != null && wm.getWifiState() == 3) {
                return 4;
            }
            ConnectivityManager connectMgr = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo info = connectMgr.getActiveNetworkInfo();
            if (info.getType() == 9) {
                return 3;
            }
            TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
            String op = tm.getSimOperator();
            int state = tm.getSimState();
            if (state == 5) {
                if (op.equals("46000") || op.equals("46002") || op.equals("46007") || op.equals("46020")) {
                    int type = AUtils.getNetSpeedType(connectMgr);
                    if (type == 1) {
                        return 8;
                    }
                    if (type == 2) {
                        return 9;
                    }
                    if (type == 3) {
                        return 10;
                    }
                    return 2;
                }
                if (op.equals("46001") || op.equals("46006")) {
                    int type = AUtils.getNetSpeedType(connectMgr);
                    if (type == 1) {
                        return 5;
                    }
                    if (type == 2) {
                        return 6;
                    }
                    if (type == 3) {
                        return 7;
                    }
                    return 2;
                }
                if (op.equals("46003") || op.equals("46005")) {
                    int type = AUtils.getNetSpeedType(connectMgr);
                    if (type == 1) {
                        return 11;
                    }
                    if (type == 2) {
                        return 12;
                    }
                    if (type == 3) {
                        return 13;
                    }
                    return 2;
                }
            }
            return 2;
        }
        catch (Exception e) {
            return 2;
        }
    }

    private static int getNetSpeedType(ConnectivityManager connManager) {
        try {
            NetworkInfo activeNetInfo = connManager.getActiveNetworkInfo();
            NetworkInfo networkInfo = connManager.getNetworkInfo(0);
            if (null == networkInfo) {
                return 0;
            }
            NetworkInfo.State state = networkInfo.getState();
            String strSubTypeName = networkInfo.getSubtypeName();
            if (null == state) {
                return 0;
            }
            if (state == NetworkInfo.State.CONNECTED || state == NetworkInfo.State.CONNECTING) {
                switch (activeNetInfo.getSubtype()) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: {
                        return 1;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: {
                        return 2;
                    }
                    case 13: {
                        return 3;
                    }
                }
                if (strSubTypeName.equalsIgnoreCase("TD-SCDMA") || strSubTypeName.equalsIgnoreCase("WCDMA") || strSubTypeName.equalsIgnoreCase("CDMA2000")) {
                    return 2;
                }
                return 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
        return 0;
    }

    public static String getLibList(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            ApplicationInfo appInfo = packageManager.getApplicationInfo(context.getPackageName(), 1024);
            String filepath = appInfo.nativeLibraryDir;
            File[] files = new File(filepath).listFiles();
            StringBuilder sb = new StringBuilder();
            for (File file : files) {
                sb.append(file.getName()).append(",");
            }
            return sb.toString();
        }
        catch (Throwable e) {
            return "";
        }
    }

    public static String getPackageAndVersion(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            return packInfo.packageName + "(" + packInfo.versionName + ")";
        }
        catch (Throwable e) {
            return "";
        }
    }

    public static String getAppName(Context context, String packageName) {
        if (context == null || packageName == null) {
            return "";
        }
        try {
            PackageManager pm = context.getPackageManager();
            CharSequence appname = pm.getApplicationLabel(pm.getApplicationInfo(packageName, 128));
            return appname.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getAppVersionName(Context context, String packageName) {
        if (context == null || packageName == null) {
            return "";
        }
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo info = pm.getPackageInfo(packageName, 0);
            return info.versionName;
        }
        catch (Exception e) {
            return "";
        }
    }

    public static int compareVersion(String versionName1, String versionName2) {
        if (versionName1 == null && versionName2 == null) {
            return 0;
        }
        if (versionName1 != null && versionName2 == null) {
            return 1;
        }
        if (versionName1 == null) {
            return -1;
        }
        if (versionName1.equals(versionName2)) {
            return 0;
        }
        try {
            int i;
            String[] arr1 = versionName1.split("\\.");
            String[] arr2 = versionName2.split("\\.");
            for (i = 0; i < arr1.length && i < arr2.length; ++i) {
                int v2;
                int v1 = Integer.parseInt(arr1[i]);
                if (v1 > (v2 = Integer.parseInt(arr2[i]))) {
                    return 1;
                }
                if (v1 >= v2) continue;
                return -1;
            }
            if (arr1.length > i) {
                return 1;
            }
            if (arr2.length > i) {
                return -1;
            }
            return 0;
        }
        catch (NumberFormatException numberFormatException) {
            return versionName1.compareTo(versionName2);
        }
    }

    public static String getScreenSize(Context context) {
        if (context == null) {
            return "unknown";
        }
        int w = context.getResources().getDisplayMetrics().widthPixels;
        int h = context.getResources().getDisplayMetrics().heightPixels;
        return String.format(Locale.getDefault(), "%dx%d", w, h);
    }

    public static int getOSVersion() {
        return Build.VERSION.SDK_INT;
    }

    public static String getOSVersionName() {
        return Build.VERSION.RELEASE;
    }

    public static String getDeviceModel() {
        return Build.MODEL;
    }

    public static String getDeviceProduct() {
        return Build.PRODUCT;
    }

    public static String getDeviceManufacturer() {
        return Build.MANUFACTURER;
    }

    public static String getDeviceHardware() {
        return Build.HARDWARE;
    }

    public static String getDeviceBoard() {
        return Build.BOARD;
    }

    public static String getBootloader() {
        return Build.BOOTLOADER;
    }

    public static interface CarrierType {
        public static final int NET_CLOSE = 1;
        public static final int NET_UNKNOW = 2;
        public static final int NET_LAN = 3;
        public static final int NET_WIFI = 4;
        public static final int NET_UNION_2G = 5;
        public static final int NET_UNION_3G = 6;
        public static final int NET_UNION_4G = 7;
        public static final int NET_MOBILE_2G = 8;
        public static final int NET_MOBILE_3G = 9;
        public static final int NET_MOBILE_4G = 10;
        public static final int NET_TELECOM_2G = 11;
        public static final int NET_TELECOM_3G = 12;
        public static final int NET_TELECOM_4G = 13;
    }
}

