/*
 * Decompiled with CFR 0.152.
 */
package com.yy.open.utility;

import android.os.AsyncTask;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import java.lang.reflect.Field;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class ThreadManager {
    private static Handler mManinHandler;
    private static Object mMainHandlerLock;
    public static final boolean DEBUG_THREAD = false;
    public static final Executor NETWORK_EXECUTOR;
    private static Handler SUB_THREAD_HANDLER;
    private static HandlerThread SUB_THREAD;
    private static Handler FILE_THREAD_HANDLER;
    private static HandlerThread FILE_THREAD;

    private static Executor initNetworkExecutor() {
        Executor result = null;
        if (Build.VERSION.SDK_INT >= 11) {
            result = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        } else {
            Executor tmp = null;
            try {
                Field field = AsyncTask.class.getDeclaredField("sExecutor");
                field.setAccessible(true);
                tmp = (Executor)field.get(null);
            }
            catch (Exception e) {
                tmp = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
            }
            result = tmp;
        }
        if (result instanceof ThreadPoolExecutor) {
            result.setCorePoolSize(3);
        }
        return result;
    }

    public static void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Handler getMainHandler() {
        if (mManinHandler == null) {
            Object object = mMainHandlerLock;
            synchronized (object) {
                if (mManinHandler == null) {
                    mManinHandler = new Handler(Looper.getMainLooper());
                }
            }
        }
        return mManinHandler;
    }

    public static void executeOnNetWorkThread(Runnable run) {
        try {
            NETWORK_EXECUTOR.execute(run);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Handler getFileThreadHandler() {
        if (FILE_THREAD_HANDLER != null) return FILE_THREAD_HANDLER;
        Class<ThreadManager> clazz = ThreadManager.class;
        synchronized (ThreadManager.class) {
            FILE_THREAD = new HandlerThread("QQ_FILE_RW");
            FILE_THREAD.start();
            FILE_THREAD_HANDLER = new Handler(FILE_THREAD.getLooper());
            // ** MonitorExit[var0] (shouldn't be in output)
            return FILE_THREAD_HANDLER;
        }
    }

    public static Looper getFileThreadLooper() {
        return ThreadManager.getFileThreadHandler().getLooper();
    }

    public static Thread getSubThread() {
        if (SUB_THREAD == null) {
            ThreadManager.getSubThreadHandler();
        }
        return SUB_THREAD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Handler getSubThreadHandler() {
        if (SUB_THREAD_HANDLER != null) return SUB_THREAD_HANDLER;
        Class<ThreadManager> clazz = ThreadManager.class;
        synchronized (ThreadManager.class) {
            SUB_THREAD = new HandlerThread("QQ_SUB");
            SUB_THREAD.start();
            SUB_THREAD_HANDLER = new Handler(SUB_THREAD.getLooper());
            // ** MonitorExit[var0] (shouldn't be in output)
            return SUB_THREAD_HANDLER;
        }
    }

    public static Looper getSubThreadLooper() {
        return ThreadManager.getSubThreadHandler().getLooper();
    }

    public static void executeOnSubThread(Runnable run) {
        ThreadManager.getSubThreadHandler().post(run);
    }

    static {
        mMainHandlerLock = new Object();
        NETWORK_EXECUTOR = ThreadManager.initNetworkExecutor();
    }
}

