/*
 * Decompiled with CFR 0.152.
 */
package com.yy.open.agent;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class InnerUtils {
    InnerUtils() {
    }

    static int compareVersion(String versionName1, String versionName2) {
        String[] arr2;
        if (versionName1 == null && versionName2 == null) {
            return 0;
        }
        if (versionName1 != null && versionName2 == null) {
            return 1;
        }
        if (versionName1 == null) {
            return -1;
        }
        if (versionName1.equals(versionName2)) {
            return 0;
        }
        if (versionName1.startsWith(versionName2)) {
            return 1;
        }
        if (versionName2.startsWith(versionName1)) {
            return -1;
        }
        String[] arr1 = versionName1.split("\\.|-");
        int length = arr1.length <= (arr2 = versionName2.split("\\.|-")).length ? arr1.length : arr2.length;
        for (int i = 0; i < length; ++i) {
            try {
                int v1 = Integer.parseInt(arr1[i]);
                int v2 = Integer.parseInt(arr2[i]);
                int s1 = Integer.parseInt(arr1[i]);
                int s2 = Integer.parseInt(arr2[i]);
                if (v1 > v2) {
                    return 1;
                }
                if (v1 >= v2) continue;
                return -1;
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                break;
            }
        }
        if (arr1.length > length) {
            return 1;
        }
        if (arr2.length > length) {
            return -1;
        }
        return versionName1.compareTo(versionName2);
    }

    static boolean isActivityDeclared(Context context, Class<? extends Activity> activity) {
        if (context == null || activity == null) {
            return false;
        }
        try {
            PackageManager pm = context.getPackageManager();
            ComponentName cn = new ComponentName(context.getPackageName(), activity.getName());
            pm.getActivityInfo(cn, 0);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    static boolean isActivityExist(Context context, Intent intent) {
        if (context == null || intent == null) {
            return false;
        }
        try {
            PackageManager pm = context.getPackageManager();
            List localList = pm.queryIntentActivities(intent, 0);
            return localList.size() > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    static String getAppName(Context context, String packageName) {
        if (context == null || packageName == null) {
            return "";
        }
        try {
            PackageManager pm = context.getPackageManager();
            CharSequence appname = pm.getApplicationLabel(pm.getApplicationInfo(packageName, 128));
            return appname.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    static String getPackageAndVersion(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            String version = "";
            PackageInfo packInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            version = packInfo.packageName + "(" + packInfo.versionName + ")";
            return version;
        }
        catch (Throwable e) {
            return "";
        }
    }
}

