/*
 * Decompiled with CFR 0.152.
 */
package com.yy.open;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import com.yy.open.IYYOpenLog;
import com.yy.open.OnAuthorizeGoproListener;
import com.yy.open.OnUIListener;
import com.yy.open.agent.AuthAgent;
import com.yy.open.agent.OpenUtils;
import com.yy.open.utility.YYOpenLog;
import java.lang.ref.SoftReference;

public final class YYOpenSDK {
    public static final String TAG = "YYOpenSdk";
    private static SoftReference<YYOpenSDK> sReference = null;
    private YYOpenLog mLog = YYOpenLog.sharedYYOpenLog();
    private AuthAgent mAuthAgent;
    private String mAppId;
    private Context mContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static YYOpenSDK createInstance(Context context, String appId) {
        YYOpenSDK sdk;
        if (context == null || appId == null) {
            throw new IllegalArgumentException("YYOpenSDK createInstance failed, Make sure context or appid is not null!");
        }
        YYOpenSDK yYOpenSDK = sdk = sReference == null ? null : sReference.get();
        if (sdk != null && appId.equals(sdk.mAppId)) return sdk;
        Class<YYOpenSDK> clazz = YYOpenSDK.class;
        synchronized (YYOpenSDK.class) {
            sdk = new YYOpenSDK(context, appId);
            sReference = new SoftReference<YYOpenSDK>(sdk);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return sdk;
        }
    }

    private YYOpenSDK(Context context, String appId) {
        this.mAuthAgent = new AuthAgent(context, appId);
        this.mAppId = appId;
        this.mContext = context;
    }

    public void setLogDelegate(IYYOpenLog log) {
        this.mLog.setLogDelegate(log);
    }

    public final String getAppId() {
        return this.mAppId;
    }

    public final String getAppSign() {
        return this.mAuthAgent.getAppSign();
    }

    public int checkAppForAuthorize() {
        int ret = OpenUtils.checkAppForAuthLogin(this.mContext);
        return ret;
    }

    public final void authorize(Activity activity, OnUIListener listener) {
        this.mAuthAgent.authorize(activity, "123", listener);
    }

    public final void handleActivityResult(int requestCode, int resultCode, Intent data, OnUIListener listener) {
        this.mAuthAgent.handleActivityResult(requestCode, resultCode, data, listener);
    }

    public final void authorizeGopro(Activity activity, OnUIListener listener) {
        this.mAuthAgent.authorizeGopro(activity, "", listener);
    }

    public final void getTokenByCode(String code, OnAuthorizeGoproListener listener) {
        this.mAuthAgent.getTokenByCode(code, 0, listener);
    }
}

