/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.utils;

import com.yy.mediaframework.utils.CommonUtil;
import com.yy.mediaframework.utils.YMFLog;
import java.util.ArrayList;
import java.util.List;

public class VideoStatisticTool {
    public static final int TIME = 60;
    private int mCounter = 0;
    private long mCurrentTime = 0L;
    private int max = -1;
    private int min = -1;
    private int sum = 0;
    private long mLastTime = 0L;
    private boolean isDebug = false;
    private boolean isStallingMode = false;
    private long mCurSample = 0L;
    private long mLastSample = 0L;
    private List<Integer> mCountList = new ArrayList<Integer>();
    private List<Integer> mAverageList = new ArrayList<Integer>();
    private List<Integer> mMaxList = new ArrayList<Integer>();
    private List<Integer> mMinList = new ArrayList<Integer>();
    private List<Integer> mSumList = new ArrayList<Integer>();
    private VideoStatisticResult mResult = new VideoStatisticResult();

    public synchronized void triggerStatistic(int deal) {
        if (this.min == -1 && this.max == -1) {
            this.min = deal;
            this.max = deal;
        }
        ++this.mCounter;
        this.max = this.max < deal ? deal : this.max;
        this.min = this.min < deal ? this.min : deal;
        this.sum += deal;
    }

    public synchronized void triggerStatistic() {
        this.mCurrentTime = System.currentTimeMillis();
        this.mCurSample = System.currentTimeMillis();
        if (this.mLastTime == 0L || this.mLastSample == 0L) {
            this.mLastSample = System.currentTimeMillis();
            this.mLastTime = System.currentTimeMillis();
            return;
        }
        int deal = (int)(this.mCurSample - this.mLastSample);
        if (this.min == -1 && this.max == -1) {
            this.min = deal;
            this.max = deal;
        }
        ++this.mCounter;
        this.max = this.max < deal ? deal : this.max;
        this.min = this.min < deal ? this.min : deal;
        this.sum += deal;
        if (this.mCurrentTime - this.mLastTime >= 1000L) {
            this.mCountList.add(this.mCounter);
            this.mAverageList.add(this.sum / this.mCounter);
            this.mMaxList.add(this.max);
            this.mMinList.add(this.min);
            this.mSumList.add(this.sum);
            this.mLastTime = this.mCurrentTime;
            this.mLastSample = this.mCurSample;
            this.mCounter = 0;
            this.max = -1;
            this.sum = 0;
            this.min = -1;
            return;
        }
        this.mLastSample = this.mCurSample;
    }

    public synchronized void triggerStatisticCalcBySecond(int deal) {
        this.mCurrentTime = System.currentTimeMillis();
        if (this.mLastTime == 0L) {
            this.mLastTime = System.currentTimeMillis();
            return;
        }
        if (this.min == -1 && this.max == -1) {
            this.min = deal;
            this.max = deal;
        }
        ++this.mCounter;
        this.max = this.max < deal ? deal : this.max;
        this.min = this.min < deal ? this.min : deal;
        this.sum += deal;
        if (this.mCurrentTime - this.mLastTime >= 1000L) {
            this.mCountList.add(this.mCounter);
            this.mAverageList.add(this.sum / this.mCounter);
            this.mMaxList.add(this.max);
            this.mMinList.add(this.min);
            this.mSumList.add(this.sum);
            this.mCounter = 0;
            this.mLastTime = this.mCurrentTime;
            this.max = -1;
            this.sum = 0;
            this.min = -1;
        }
    }

    public synchronized void triggerStatisticCalcStalling(int deal) {
        this.isStallingMode = true;
        this.mCurrentTime = System.currentTimeMillis();
        if (this.mLastTime == 0L) {
            this.mLastTime = System.currentTimeMillis();
            return;
        }
        if (this.min == -1 && this.max == -1) {
            this.min = deal;
            this.max = deal;
        }
        ++this.mCounter;
        this.max = this.max < deal ? deal : this.max;
        this.min = this.min < deal ? this.min : deal;
        this.sum += deal;
        if (this.mCurrentTime - this.mLastTime >= 1000L) {
            this.mCountList.add(this.mCounter);
            this.mAverageList.add(this.sum / this.mCounter);
            this.mMaxList.add(this.max);
            this.mMinList.add(this.min);
            this.mSumList.add(this.sum);
            this.mCounter = 0;
            this.mLastTime = this.mCurrentTime;
            this.max = -1;
            this.sum = 0;
            this.min = -1;
        }
    }

    public synchronized VideoStatisticResult getStatisticResult() {
        return this.mResult;
    }

    private void printListInfo(List<Integer> list, List<Integer> list2, List<Integer> list3, List<Integer> list4) {
        if (null == list) {
            return;
        }
        String str = " ";
        for (int i = 0; i < list.size(); ++i) {
            str = str + list.get(i) + ":" + list2.get(i) + ":" + list3.get(i) + ":" + list4.get(i) + ", ";
        }
        YMFLog.info(this, "[CCapture]", "listInfo:[" + str + "]");
    }

    public synchronized void flush() {
        this.mResult.meanDeal = -1;
        this.mResult.maxDeal = this.max;
        this.mResult.minDeal = this.min;
        this.mResult.meanCount = this.mCounter;
        if (this.mCounter > 0) {
            this.mResult.meanDeal = this.sum / this.mCounter;
        }
        this.max = -1;
        this.min = -1;
        this.sum = 0;
        this.mCounter = 0;
        if (this.mAverageList != null && this.mAverageList.size() > 0) {
            this.mResult.meanDeal = CommonUtil.calcListMean(this.mAverageList);
            this.mAverageList.clear();
        }
        if (this.mMaxList != null && this.mMaxList.size() > 0) {
            this.mResult.maxDeal = CommonUtil.calcListMax(this.mMaxList);
            if (this.isStallingMode) {
                this.mResult.other = StallingModel.calcStallingRate(this.mMaxList);
                if (this.mResult.other > 0) {
                    YMFLog.info(this, "[CCapture]", "mResult.other:" + this.mResult.other + "MaxListInfo:" + this.mMaxList);
                }
            }
            this.mMaxList.clear();
        }
        if (this.mMinList != null && this.mMinList.size() > 0) {
            this.mResult.minDeal = CommonUtil.calcListMin(this.mMinList);
            this.mMinList.clear();
        }
        if (this.mCountList != null && this.mCountList.size() > 0) {
            this.mResult.meanCount = CommonUtil.calcListMean(this.mCountList);
            this.mCountList.clear();
        }
        if (this.mSumList != null && this.mSumList.size() > 0) {
            this.mResult.sumDeal = CommonUtil.calcListSum(this.mSumList);
            this.mSumList.clear();
        }
    }

    public static class StallingModel {
        private static final int threshold = 500;
        private static final float alpha = 0.999f;
        private static final float k = 3.5E-4f;

        public static int maxOut(int data, int threshold) {
            if (data >= threshold) {
                return data;
            }
            return 0;
        }

        public static int sum(List<Integer> list) {
            int sum = 0;
            for (int i : list) {
                sum += i;
            }
            return sum;
        }

        public static void filterGte1sData(List<Integer> in, List<Integer> out) {
            for (int i : in) {
                if (StallingModel.maxOut(i, 1000) <= 0) continue;
                out.add(i);
            }
        }

        public static void filterStallingData(List<Integer> in, List<Integer> out) {
            for (int i : in) {
                if (StallingModel.maxOut(i, 500) <= 0) continue;
                out.add(i);
            }
        }

        public static int calcStallingRate(List<Integer> inList) {
            if (inList != null && inList.size() > 0) {
                ArrayList<Integer> stallingList = new ArrayList<Integer>();
                ArrayList<Integer> gte1sStallingList = new ArrayList<Integer>();
                double stallingDuration = 0.0;
                double observerDuration = 0.0;
                double stallingCount = 0.0;
                double stallingLength = inList.size();
                StallingModel.filterStallingData(inList, stallingList);
                StallingModel.filterGte1sData(inList, gte1sStallingList);
                stallingDuration = StallingModel.sum(stallingList);
                stallingCount = stallingList.size();
                if (gte1sStallingList != null) {
                    observerDuration = (stallingLength - (double)gte1sStallingList.size()) * 1000.0 + (double)StallingModel.sum(gte1sStallingList);
                }
                return (int)(100.0 * (1.0 - Math.exp((double)-3.5E-4f * stallingCount * stallingDuration * ((double)0.999f * stallingDuration / observerDuration + 9.999871253967285E-4 * stallingCount / stallingLength))));
            }
            return 0;
        }
    }

    public class VideoStatisticResult {
        public boolean isValid = false;
        public int minDeal = -1;
        public int maxDeal = -1;
        public int meanDeal = -1;
        public int meanCount = 0;
        public int sumDeal = 0;
        public int other = -1;
    }
}

