/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.screenlive;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.RectF;
import com.yy.mediaframework.AbstractLiveSession;
import com.yy.mediaframework.YYVideoSDK;
import com.yy.mediaframework.filters.ClipFilter;
import com.yy.mediaframework.filters.GlLoadImageFilter;
import com.yy.mediaframework.filters.ImageCaptureFilter;
import com.yy.mediaframework.filters.ScreenCaptureFilter;
import com.yy.mediaframework.filters.VideoEndPointFilter;
import com.yy.mediaframework.screenlive.ScreenSurfaceCallback;
import com.yy.mediaframework.screenshot.ScreenShot;
import com.yy.mediaframework.screenshot.ScreenShotCallback;
import com.yy.mediaframework.utils.YMFLog;
import java.nio.ByteBuffer;

public class ScreenLiveSession
extends AbstractLiveSession {
    private ScreenCaptureFilter mScreenCaptureFilter = null;
    protected ImageCaptureFilter mImageCaptureFilter = null;
    private ClipFilter mCliperFilter = null;
    private GlLoadImageFilter mGlLoadImageFilter = null;
    private VideoEndPointFilter mEndPointFilter = null;

    public ScreenLiveSession(Context context) {
        super(context);
        YMFLog.info(this, "[Procedur]", " new ScreenLiveSession...");
        this.mFilterContext.setScreenShot(new ScreenShot(context, this.mFilterContext));
        this.mScreenCaptureFilter = new ScreenCaptureFilter(this.mFilterContext, context.getApplicationContext());
        this.mCliperFilter = new ClipFilter();
        this.mGlLoadImageFilter = new GlLoadImageFilter();
        this.mImageCaptureFilter = new ImageCaptureFilter(this.mFilterContext, 3);
        this.mEndPointFilter = new VideoEndPointFilter(this.mFilterContext);
        this.mPreprocessFilter.addDownStream(this.mCliperFilter.addDownStream(this.mEncoderGroupFilter));
        this.mScreenCaptureFilter.addDownStream(this.mPreprocessFilter).addDownStream(this.mEndPointFilter);
        this.mImageCaptureFilter.addDownStream(this.mGlLoadImageFilter.addDownStream(this.mCliperFilter));
        this.mFilterContext.getGlManager().registerFilter(this.mScreenCaptureFilter);
        this.mFilterContext.getGlManager().registerFilter(this.mImageCaptureFilter);
        this.mFilterContext.getGlManager().registerFilter(this.mGlLoadImageFilter);
        this.mFilterContext.getGlManager().registerFilter(this.mPreprocessFilter);
        this.mFilterContext.getGlManager().registerFilter(this.mCliperFilter);
        this.mFilterContext.getGlManager().registerFilter(this.mEncoderGroupFilter);
        this.mFilterContext.getGlManager().registerFilter(this.mEndPointFilter);
    }

    public void startScreenCapture() {
        YMFLog.info(this, "[SCapture]", "startScreenCapture....");
        this.mScreenCaptureFilter.init();
        this.mImageCaptureFilter.init();
    }

    @Override
    public void stopAndRelease() {
        super.stopAndRelease();
        YMFLog.info(this, "[SCapture]", "ScreenLiveSession stopAndRelease======#######$$$$$$$");
    }

    public void setCaptureResolution(final int width, final int height) {
        YMFLog.info(this, "[SCapture]", "setCaptureResolution, width:" + width + " ,height:" + height);
        this.mFilterContext.getGlManager().post(new Runnable(){

            @Override
            public void run() {
                ScreenLiveSession.this.mFilterContext.getScreenRecordConfig().setScreenSize(width, height);
            }
        });
    }

    public void addScreenSurfaceCallback(final ScreenSurfaceCallback callback) {
        YMFLog.info(this, "[SCapture]", "addScreenSurfaceCallback:" + callback);
        this.mFilterContext.getGlManager().post(new Runnable(){

            @Override
            public void run() {
                if (ScreenLiveSession.this.mScreenCaptureFilter != null) {
                    ScreenLiveSession.this.mScreenCaptureFilter.addScreenSurfaceCallback(callback);
                }
            }
        });
    }

    public void imageFrameAvailable(ByteBuffer buffer, int width, int height, int imageFormat) {
        if (this.mImageCaptureFilter != null) {
            buffer.position(0);
            this.mImageCaptureFilter.onImageAvailable(buffer, width, height, imageFormat);
        }
    }

    @Override
    public void takeScreenShot(ScreenShotCallback callback) {
        this.mFilterContext.getScreenShot().setCallback(callback);
    }

    public void setPrivacyMote(boolean isPrivacyMote) {
        YMFLog.info(this, "[SCapture]", "ScreenLiveSession isPrivacyMote:" + isPrivacyMote);
        if (!isPrivacyMote) {
            this.mScreenCaptureFilter.startCapture();
        } else {
            this.mScreenCaptureFilter.stopCapture();
        }
    }

    public void setScreenCropArea(RectF rectF) {
        YMFLog.info(this, "[SCapture]", "ScreenLiveSession setScreenCropArea...rectF:" + rectF + " ,mScreenCaptureFilter:" + this.mScreenCaptureFilter);
        if (this.mScreenCaptureFilter != null) {
            this.mScreenCaptureFilter.setScreenCropArea(rectF);
        }
    }

    public void setDeltaYYPtsMillions(final long deltaPtsDts) {
        YMFLog.info(this, "[Encoder ]", "ScreenLiveSession setDeltaYYPtsMillions:" + deltaPtsDts);
        this.mFilterContext.getGlManager().post(new Runnable(){

            @Override
            public void run() {
                YYVideoSDK.getInstance().setDeltaYYPtsMillions(deltaPtsDts);
            }
        });
    }

    @Override
    public void setWaterMark(Bitmap bitmap, int offsetX, int offsetY) {
    }
}

