/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.opengles;

import android.opengl.GLES20;
import com.yy.mediaframework.utils.YMFLog;

public class YMFShader {
    private static final String TAG = "YMFShader";
    private int mVertexHandle;
    private int mFragmentHandle;
    private boolean mReady;

    public YMFShader(String vs, String fs) {
        this.mVertexHandle = this.loadShader(35633, vs);
        this.mFragmentHandle = this.loadShader(35632, fs);
        if (this.mVertexHandle > 0 && this.mFragmentHandle > 0) {
            this.mReady = true;
        }
    }

    public boolean ready() {
        return this.mReady;
    }

    public int getVertexHandle() {
        return this.mVertexHandle;
    }

    public int getFragmentHandle() {
        return this.mFragmentHandle;
    }

    public void release() {
        if (this.mVertexHandle != -1) {
            GLES20.glDeleteShader((int)this.mVertexHandle);
            this.mVertexHandle = -1;
        }
        if (this.mFragmentHandle != -1) {
            GLES20.glDeleteShader((int)this.mFragmentHandle);
            this.mFragmentHandle = -1;
        }
    }

    private int loadShader(int shaderType, String source) {
        int shader = GLES20.glCreateShader((int)shaderType);
        if (shader != 0) {
            GLES20.glShaderSource((int)shader, (String)source);
            GLES20.glCompileShader((int)shader);
            int[] compiled = new int[1];
            GLES20.glGetShaderiv((int)shader, (int)35713, (int[])compiled, (int)0);
            if (compiled[0] == 0) {
                String error = GLES20.glGetShaderInfoLog((int)shader);
                GLES20.glDeleteShader((int)shader);
                YMFLog.error((Object)this, "[Util    ]", "Compile shader error:" + error);
                return -1;
            }
        } else {
            YMFLog.error((Object)this, "[Util    ]", "glCreateShader shader error.");
            return -1;
        }
        return shader;
    }
}

